/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.api.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.SortedList;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PUBLIC)
public class AuthorNodeUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthorNodeUtil.class.getName());
    public static final String ATTRIBUTE_VALUE_MARKER = "MARKER_ATTR_VALUE";

    public static List<AuthorNode> minimizeAuthorCollection(Collection<? extends AuthorNode> collection) {
        SortedList sortedList = new SortedList((Comparator)new Comparator<AuthorNode>(){

            @Override
            public int compare(AuthorNode authorNode, AuthorNode authorNode2) {
                return authorNode.getStartOffset() - authorNode2.getStartOffset();
            }
        });
        Object object = collection.iterator();
        while (object.hasNext()) {
            AuthorNode authorNode = object.next();
            if (authorNode == null) continue;
            if (authorNode.getOwnerDocument() == null) {
                object.remove();
                continue;
            }
            sortedList.add(authorNode);
        }
        object = new ArrayList();
        for (int i2 = 0; i2 < sortedList.size(); ++i2) {
            AuthorNode authorNode;
            AuthorNode authorNode2 = (AuthorNode)sortedList.get(i2);
            AuthorNode authorNode3 = authorNode = object.isEmpty() ? null : (AuthorNode)object.get(object.size() - 1);
            if (authorNode != null && authorNode.getStartOffset() <= authorNode2.getStartOffset() && authorNode2.getEndOffset() <= authorNode.getEndOffset() && authorNode.getOwnerDocument() == authorNode2.getOwnerDocument()) continue;
            object.add(authorNode2);
        }
        return object;
    }

    public static AuthorNode getFirstLeaf(AuthorDocumentFragment authorDocumentFragment) {
        AuthorNode authorNode = null;
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list != null && list.size() > 0 && (authorNode = AuthorNodeUtil.getPossibleLeaf(list)) instanceof AuthorParentNode) {
            AuthorNode authorNode2;
            list = ((AuthorParentNode)authorNode).getContentNodes();
            while (!list.isEmpty() && (authorNode2 = AuthorNodeUtil.getPossibleLeaf(list)) instanceof AuthorParentNode) {
                authorNode = authorNode2;
                list = ((AuthorParentNode)authorNode).getContentNodes();
            }
        }
        return authorNode;
    }

    private static AuthorNode getPossibleLeaf(List<AuthorNode> list) {
        AuthorNode authorNode = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorNode authorNode2 = list.get(i2);
            try {
                if (authorNode2.getType() == 5 && authorNode2.getTextContent().equals("UNIQUE_CARET_MARKER_FOR_AUTHOR")) continue;
                authorNode = list.get(i2);
                break;
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return authorNode;
    }

    public static AuthorElement getFirstChildElement(AuthorParentNode authorParentNode) {
        AuthorElement authorElement = null;
        List<AuthorNode> list = authorParentNode.getContentNodes();
        for (AuthorNode authorNode : list) {
            if (authorNode.getType() != 0) continue;
            authorElement = (AuthorElement)authorNode;
            break;
        }
        return authorElement;
    }

    public static int getChildIndex(int n2, List<AuthorNode> list) {
        int n3 = -1;
        int n4 = list.size();
        if (n4 > 0) {
            int n5;
            AuthorParentNode authorParentNode;
            int n6;
            int n7 = 0;
            int n8 = n4 - 1;
            while (n7 <= n8 && n2 != (n6 = (authorParentNode = (AuthorParentNode)list.get(n5 = n7 + n8 >>> 1)).getStartOffset())) {
                if (n2 > n6 && n2 <= authorParentNode.getEndOffset()) {
                    n3 = n5;
                    break;
                }
                if (n2 < n6) {
                    n8 = n5 - 1;
                    continue;
                }
                n7 = n5 + 1;
            }
        }
        return n3;
    }
}

