/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dom.wrappers.mutable;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodePredicate;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.util.SteppingNavigator;
import net.sf.saxon.tree.util.SteppingNode;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.UType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.sync.basic.util.Equaler;
import ro.sync.ecss.dom.wrappers.mutable.DocumentWrapper;

public class DOMNodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode,
SteppingNode {
    protected Node node;
    protected short nodeKind;
    private DOMNodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;
    protected int span = 1;
    private NamespaceBinding[] localNamespaces = null;
    private NamespaceMap inScopeNamespaces = null;

    protected DOMNodeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        this.node = node;
        this.parent = dOMNodeWrapper;
        this.index = n2;
        this.docWrapper = documentWrapper;
    }

    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        if (node == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: Node must not be null");
        }
        if (documentWrapper == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: DocumentWrapper must not be null");
        }
        return this.makeWrapper(node, documentWrapper, null, -1);
    }

    protected DOMNodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, DOMNodeWrapper dOMNodeWrapper, int n2) {
        DOMNodeWrapper dOMNodeWrapper2;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                dOMNodeWrapper2 = (DOMNodeWrapper)documentWrapper.getRootNode();
                if (dOMNodeWrapper2 != null) break;
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)9;
                break;
            }
            case 1: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = 1;
                break;
            }
            case 2: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)2;
                break;
            }
            case 3: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 4: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 8: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)8;
                break;
            }
            case 7: {
                dOMNodeWrapper2 = new DOMNodeWrapper(node, documentWrapper, dOMNodeWrapper, n2);
                dOMNodeWrapper2.nodeKind = (short)7;
                break;
            }
            case 5: {
                throw new IllegalStateException("DOM contains entity reference nodes, which Saxon does not support. The DOM should be built using the expandEntityReferences() option");
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node);
            }
        }
        dOMNodeWrapper2.treeInfo = documentWrapper;
        return dOMNodeWrapper2;
    }

    public DocumentWrapper getTreeInfo() {
        return (DocumentWrapper)this.treeInfo;
    }

    public Node getUnderlyingNode() {
        return this.node;
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (!(object instanceof DOMNodeWrapper)) {
            return false;
        }
        if (this.docWrapper.domLevel3) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                return this.node.isSameNode(((DOMNodeWrapper)((Object)object)).node);
            }
        }
        DOMNodeWrapper dOMNodeWrapper = (DOMNodeWrapper)((Object)object);
        return this.getNodeKind() == dOMNodeWrapper.getNodeKind() && this.equalOrNull(this.getLocalPart(), dOMNodeWrapper.getLocalPart()) && this.getSiblingPosition() == dOMNodeWrapper.getSiblingPosition() && this.getParent().equals((Object)dOMNodeWrapper.getParent());
    }

    private boolean equalOrNull(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof DOMNodeWrapper && this.docWrapper.domLevel3) {
            if (this.equals(nodeInfo)) {
                return 0;
            }
            try {
                Node node = this.docWrapper.docNode;
                synchronized (node) {
                    short s2 = this.node.compareDocumentPosition(((DOMNodeWrapper)nodeInfo).node);
                    if ((s2 & 0xA) != 0) {
                        return 1;
                    }
                    if ((s2 & 0x14) != 0) {
                        return -1;
                    }
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (nodeInfo instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)nodeInfo));
        }
        return -nodeInfo.compareOrder((NodeInfo)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnicodeString getUnicodeStringValue() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            switch (this.nodeKind) {
                case 1: 
                case 9: {
                    NodeList nodeList = this.node.getChildNodes();
                    UnicodeBuilder unicodeBuilder = new UnicodeBuilder();
                    DOMNodeWrapper.expandStringValue(nodeList, unicodeBuilder);
                    return unicodeBuilder.toUnicodeString();
                }
                case 2: {
                    return DOMNodeWrapper.emptyIfNull(((Attr)this.node).getValue()).tidy();
                }
                case 3: {
                    if (this.span == 1) {
                        return DOMNodeWrapper.emptyIfNull(this.node.getNodeValue()).tidy();
                    }
                    UnicodeBuilder unicodeBuilder = new UnicodeBuilder();
                    Node node2 = this.node;
                    for (int i2 = 0; i2 < this.span; ++i2) {
                        unicodeBuilder.accept(DOMNodeWrapper.emptyIfNull(node2.getNodeValue()));
                        node2 = node2.getNextSibling();
                    }
                    return unicodeBuilder.toUnicodeString();
                }
                case 7: 
                case 8: {
                    return DOMNodeWrapper.emptyIfNull(this.node.getNodeValue()).tidy();
                }
            }
            return EmptyUnicodeString.getInstance();
        }
    }

    private static UnicodeString emptyIfNull(String string) {
        return string == null ? EmptyUnicodeString.getInstance() : StringView.of((String)string);
    }

    public static void expandStringValue(NodeList nodeList, UnicodeBuilder unicodeBuilder) {
        int n2 = nodeList.getLength();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            switch (node.getNodeType()) {
                case 1: {
                    DOMNodeWrapper.expandStringValue(node.getChildNodes(), unicodeBuilder);
                    continue block5;
                }
                case 7: 
                case 8: {
                    continue block5;
                }
                case 10: {
                    continue block5;
                }
                default: {
                    unicodeBuilder.accept(DOMNodeWrapper.emptyIfNull(node.getNodeValue()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocalPart() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            switch (this.getNodeKind()) {
                case 1: 
                case 2: {
                    return DOMNodeWrapper.getLocalName(this.node);
                }
                case 7: {
                    return this.node.getNodeName();
                }
            }
            return "";
        }
    }

    public static String getLocalName(Node node) {
        String string = node.getLocalName();
        if (string == null) {
            String string2 = node.getNodeName();
            int n2 = string2.indexOf(58);
            if (n2 >= 0) {
                return string2.substring(n2 + 1);
            }
            return string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceUri getNamespaceUri() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            if (this.nodeKind == 1) {
                return NamespaceUri.of((String)DOMNodeWrapper.getElementURI((Element)this.node));
            }
            if (this.nodeKind == 2) {
                return NamespaceUri.of((String)DOMNodeWrapper.getAttributeURI((Attr)this.node));
            }
            return NamespaceUri.NULL;
        }
    }

    private static String getElementURI(Element element) {
        String string;
        String string2 = element.getNamespaceURI();
        if (string2 != null) {
            return string2;
        }
        String string3 = element.getNodeName();
        int n2 = string3.indexOf(58);
        String string4 = string = n2 < 0 ? "xmlns" : "xmlns:" + string3.substring(0, n2);
        if (string.equals("xmlns:xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Node node = element;
        do {
            if (!node.hasAttribute(string)) continue;
            return node.getAttribute(string);
        } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
        if (n2 < 0) {
            return "";
        }
        throw new IllegalStateException("Undeclared namespace prefix in element name " + string3 + " in DOM input");
    }

    private static String getAttributeURI(Attr attr) {
        String string = attr.getNamespaceURI();
        if (string != null) {
            return string;
        }
        String string2 = attr.getNodeName();
        int n2 = string2.indexOf(58);
        if (n2 < 0) {
            return "";
        }
        String string3 = "xmlns:" + string2.substring(0, n2);
        if (string3.equals("xmlns:xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        Node node = attr.getOwnerElement();
        do {
            if (!node.hasAttribute(string3)) continue;
            return node.getAttribute(string3);
        } while ((node = node.getParentNode()) != null && node.getNodeType() == 1);
        throw new IllegalStateException("Undeclared namespace prefix in attribute name " + string2 + " in DOM input");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPrefix() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            int n2 = this.getNodeKind();
            if (n2 == 1 || n2 == 2) {
                String string = this.node.getNodeName();
                int n3 = string.indexOf(58);
                if (n3 < 0) {
                    return "";
                }
                return string.substring(0, n3);
            }
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                Node node = this.docWrapper.docNode;
                synchronized (node) {
                    return this.node.getNodeName();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getParent() {
        if (this.parent == null) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                switch (this.getNodeKind()) {
                    case 2: {
                        this.parent = this.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                        break;
                    }
                    default: {
                        Node node2 = this.node.getParentNode();
                        if (node2 == null) {
                            return null;
                        }
                        this.parent = this.makeWrapper(node2, this.docWrapper);
                    }
                }
            }
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSiblingPosition() {
        if (this.index == -1) {
            Node node = this.docWrapper.docNode;
            synchronized (node) {
                switch (this.nodeKind) {
                    case 1: 
                    case 3: 
                    case 7: 
                    case 8: {
                        int n2 = 0;
                        Node node2 = this.node;
                        while (true) {
                            if ((node2 = node2.getPreviousSibling()) == null) {
                                this.index = n2;
                                return n2;
                            }
                            ++n2;
                        }
                    }
                    case 2: {
                        int n3 = 0;
                        AxisIterator axisIterator = this.parent.iterateAxis(2);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || Navigator.haveSameName((NodeInfo)this, (NodeInfo)nodeInfo)) {
                                this.index = n3;
                                return n3;
                            }
                            ++n3;
                        }
                    }
                    case 13: {
                        int n4 = 0;
                        AxisIterator axisIterator = this.parent.iterateAxis(8);
                        while (true) {
                            NodeInfo nodeInfo;
                            if ((nodeInfo = axisIterator.next()) == null || Navigator.haveSameName((NodeInfo)this, (NodeInfo)nodeInfo)) {
                                this.index = n4;
                                return n4;
                            }
                            ++n4;
                        }
                    }
                }
                this.index = 0;
                return this.index;
            }
        }
        return this.index;
    }

    protected AxisIterator iterateAttributes(NodeTest nodeTest) {
        AttributeEnumeration attributeEnumeration = new AttributeEnumeration(this);
        if (nodeTest != AnyNodeTest.getInstance()) {
            attributeEnumeration = new Navigator.AxisFilter((AxisIterator)attributeEnumeration, (NodePredicate)nodeTest);
        }
        return attributeEnumeration;
    }

    private boolean isElementOnly(NodeTest nodeTest) {
        return nodeTest.getUType() == UType.ELEMENT;
    }

    protected AxisIterator iterateChildren(NodeTest nodeTest) {
        boolean bl = this.isElementOnly(nodeTest);
        Navigator.EmptyTextFilter emptyTextFilter = new Navigator.EmptyTextFilter((AxisIterator)new ChildEnumeration(this, true, true, bl));
        if (nodeTest != AnyNodeTest.getInstance()) {
            emptyTextFilter = new Navigator.AxisFilter((AxisIterator)emptyTextFilter, (NodePredicate)nodeTest);
        }
        return emptyTextFilter;
    }

    protected AxisIterator iterateSiblings(NodeTest nodeTest, boolean bl) {
        boolean bl2 = this.isElementOnly(nodeTest);
        Navigator.EmptyTextFilter emptyTextFilter = new Navigator.EmptyTextFilter((AxisIterator)new ChildEnumeration(this, false, bl, bl2));
        if (nodeTest != AnyNodeTest.getInstance()) {
            emptyTextFilter = new Navigator.AxisFilter((AxisIterator)emptyTextFilter, (NodePredicate)nodeTest);
        }
        return emptyTextFilter;
    }

    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean bl) {
        return new SteppingNavigator.DescendantAxisIterator((SteppingNode)this, bl, nodeTest);
    }

    public String getAttributeValue(NamespaceUri namespaceUri, String string) {
        NameTest nameTest = new NameTest(2, namespaceUri, string, this.getNamePool());
        AxisIterator axisIterator = this.iterateAxis(2, (NodePredicate)nameTest);
        NodeInfo nodeInfo = axisIterator.next();
        if (nodeInfo == null) {
            return null;
        }
        return nodeInfo.getStringValue();
    }

    public NodeInfo getRoot() {
        return this.docWrapper.getRootNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChildNodes() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            return this.node.getNodeType() != 2 && this.node.hasChildNodes();
        }
    }

    public void generateId(StringBuilder stringBuilder) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (StringBuilder)stringBuilder, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceBinding[] getDeclaredNamespaces(NamespaceBinding[] namespaceBindingArray) {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            if (this.node.getNodeType() == 1) {
                if (this.localNamespaces != null) {
                    return this.localNamespaces;
                }
                Element element = (Element)this.node;
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap == null) {
                    this.localNamespaces = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                int n2 = 0;
                int n3 = namedNodeMap.getLength();
                for (int i2 = 0; i2 < n3; ++i2) {
                    Attr attr = (Attr)namedNodeMap.item(i2);
                    String string = attr.getName();
                    if (string.equals("xmlns")) {
                        ++n2;
                        continue;
                    }
                    if (!string.startsWith("xmlns:")) continue;
                    ++n2;
                }
                if (n2 == 0) {
                    this.localNamespaces = NamespaceBinding.EMPTY_ARRAY;
                    return NamespaceBinding.EMPTY_ARRAY;
                }
                NamespaceBinding[] namespaceBindingArray2 = namespaceBindingArray == null || n2 > namespaceBindingArray.length ? new NamespaceBinding[n2] : namespaceBindingArray;
                int n4 = 0;
                for (int i3 = 0; i3 < n3; ++i3) {
                    String string;
                    String string2;
                    Attr attr = (Attr)namedNodeMap.item(i3);
                    String string3 = attr.getName();
                    if (string3.equals("xmlns")) {
                        string2 = "";
                        string = attr.getValue();
                        namespaceBindingArray2[n4++] = new NamespaceBinding(string2, NamespaceUri.of((String)string));
                        continue;
                    }
                    if (!string3.startsWith("xmlns:")) continue;
                    string2 = string3.substring(6);
                    string = attr.getValue();
                    namespaceBindingArray2[n4++] = new NamespaceBinding(string2, NamespaceUri.of((String)string));
                }
                if (n2 < namespaceBindingArray2.length) {
                    namespaceBindingArray2[n2] = null;
                }
                this.localNamespaces = Arrays.copyOf(namespaceBindingArray2, namespaceBindingArray2.length);
                return namespaceBindingArray2;
            }
            return null;
        }
    }

    public NamespaceMap getAllNamespaces() {
        if (this.getNodeKind() == 1) {
            if (this.inScopeNamespaces != null) {
                return this.inScopeNamespaces;
            }
            DOMNodeWrapper dOMNodeWrapper = this.getParent();
            NamespaceMap namespaceMap = dOMNodeWrapper != null && dOMNodeWrapper.getNodeKind() == 1 ? dOMNodeWrapper.getAllNamespaces() : NamespaceMap.emptyMap();
            Element element = (Element)this.node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap != null) {
                int n2 = namedNodeMap.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Attr attr = (Attr)namedNodeMap.item(i2);
                    String string = attr.getName();
                    if (!string.startsWith("xmlns")) continue;
                    if (string.length() == 5) {
                        namespaceMap = namespaceMap.bind("", NamespaceUri.of((String)attr.getValue()));
                        continue;
                    }
                    if (string.charAt(5) != ':') continue;
                    namespaceMap = namespaceMap.bind(string.substring(6), NamespaceUri.of((String)attr.getValue()));
                }
            }
            this.inScopeNamespaces = namespaceMap;
            return this.inScopeNamespaces;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isId() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            return this.node instanceof Attr && ((Attr)this.node).isId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getNextSibling() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            int n2;
            Node node2 = this.node;
            for (n2 = 0; n2 < this.span; ++n2) {
                node2 = node2.getNextSibling();
            }
            if (node2 != null) {
                n2 = node2.getNodeType();
                if (n2 == 10) {
                    node2 = node2.getNextSibling();
                } else if (n2 == 3 || n2 == 4) {
                    return this.spannedWrapper(node2);
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    private DOMNodeWrapper spannedWrapper(Node node) {
        Node node2 = node;
        int n2 = 1;
        while ((node2 = node2.getNextSibling()) != null && (node2.getNodeType() == 3 || node2.getNodeType() == 4)) {
            ++n2;
        }
        DOMNodeWrapper dOMNodeWrapper = this.makeWrapper(node, this.docWrapper);
        dOMNodeWrapper.span = n2;
        return dOMNodeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getFirstChild() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2 = this.node.getFirstChild();
            if (node2 != null) {
                if (node2.getNodeType() == 10) {
                    node2 = node2.getNextSibling();
                }
                if (node2.getNodeType() == 3 || node2.getNodeType() == 4) {
                    return this.spannedWrapper(node2);
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMNodeWrapper getPreviousSibling() {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2 = this.node.getPreviousSibling();
            if (node2 != null) {
                short s2 = node2.getNodeType();
                if (s2 == 10) {
                    return null;
                }
                if (s2 == 3 || s2 == 4) {
                    Object object;
                    int n2 = 1;
                    while ((object = node2.getPreviousSibling()) != null && (object.getNodeType() == 3 || object.getNodeType() == 4)) {
                        ++n2;
                        node2 = object;
                    }
                    object = this.makeWrapper(node2, this.docWrapper);
                    ((DOMNodeWrapper)((Object)object)).span = n2;
                    return object;
                }
                return this.makeWrapper(node2, this.docWrapper);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SteppingNode getSuccessorElement(SteppingNode steppingNode, NamespaceUri namespaceUri, String string) {
        Node node = this.docWrapper.docNode;
        synchronized (node) {
            Node node2 = steppingNode == null ? null : ((DOMNodeWrapper)steppingNode).node;
            Node node3 = this.node;
            while ((node3 = DOMNodeWrapper.getSuccessorNode(node3, node2)) != null && (node3.getNodeType() != 1 || string != null && !string.equals(DOMNodeWrapper.getLocalName(node3)) || namespaceUri != null && !Equaler.verifyEquals((Object)namespaceUri.toString(), (Object)DOMNodeWrapper.getElementURI((Element)node3)))) {
            }
            if (node3 == null) {
                return null;
            }
            return this.makeWrapper(node3, this.docWrapper);
        }
    }

    private static Node getSuccessorNode(Node node, Node node2) {
        if (node.hasChildNodes()) {
            return node.getFirstChild();
        }
        if (node2 != null && node.isSameNode(node2)) {
            return null;
        }
        Node node3 = node;
        do {
            Node node4;
            if ((node4 = node3.getNextSibling()) == null) continue;
            return node4;
        } while ((node3 = node3.getParentNode()) != null && (node2 == null || !node3.isSameNode(node2)));
        return null;
    }

    private final class AttributeEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private final ArrayList<Node> attList = new ArrayList(10);
        private int ix = 0;
        private final DOMNodeWrapper start;
        private DOMNodeWrapper current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeEnumeration(DOMNodeWrapper dOMNodeWrapper2) {
            Node node = dOMNodeWrapper2.docWrapper.docNode;
            synchronized (node) {
                this.start = dOMNodeWrapper2;
                NamedNodeMap namedNodeMap = dOMNodeWrapper2.node.getAttributes();
                if (namedNodeMap != null) {
                    int n2 = namedNodeMap.getLength();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string = namedNodeMap.item(i2).getNodeName();
                        if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                        this.attList.add(namedNodeMap.item(i2));
                    }
                }
                this.ix = 0;
            }
        }

        public boolean supportsHasNext() {
            return true;
        }

        public boolean hasNext() {
            return this.ix < this.attList.size();
        }

        public NodeInfo next() {
            if (this.ix >= this.attList.size()) {
                return null;
            }
            this.current = DOMNodeWrapper.this.makeWrapper(this.attList.get(this.ix), DOMNodeWrapper.this.docWrapper, this.start, this.ix);
            ++this.ix;
            return this.current;
        }
    }

    private final class ChildEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private final DOMNodeWrapper start;
        private final DOMNodeWrapper commonParent;
        private final boolean downwards;
        private final boolean forwards;
        private final boolean elementsOnly;
        NodeList childNodes;
        private final int childNodesLength;
        private int ix;
        private int currentSpan;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildEnumeration(DOMNodeWrapper dOMNodeWrapper2, boolean bl, boolean bl2, boolean bl3) {
            Node node = dOMNodeWrapper2.docWrapper.docNode;
            synchronized (node) {
                this.start = dOMNodeWrapper2;
                this.downwards = bl;
                this.forwards = bl2;
                this.elementsOnly = bl3;
                this.currentSpan = 1;
                this.commonParent = bl ? dOMNodeWrapper2 : dOMNodeWrapper2.getParent();
                this.childNodes = this.commonParent.node.getChildNodes();
                this.childNodesLength = this.childNodes.getLength();
                if (bl) {
                    this.currentSpan = 1;
                    this.ix = bl2 ? -1 : this.childNodesLength;
                } else {
                    this.ix = dOMNodeWrapper2.getSiblingPosition();
                    this.currentSpan = dOMNodeWrapper2.span;
                }
            }
        }

        private int skipPrecedingTextNodes() {
            Node node;
            short s2;
            int n2;
            for (n2 = 0; this.ix >= n2 && ((s2 = (node = this.childNodes.item(this.ix - n2)).getNodeType()) == 3 || s2 == 4); ++n2) {
            }
            return n2 == 0 ? 1 : n2;
        }

        private int skipFollowingTextNodes() {
            Node node;
            short s2;
            int n2 = 0;
            int n3 = this.ix;
            int n4 = this.childNodesLength;
            while (n3 < n4 && ((s2 = (node = this.childNodes.item(n3)).getNodeType()) == 3 || s2 == 4)) {
                ++n3;
                ++n2;
            }
            return n2 == 0 ? 1 : n2;
        }

        public boolean supportsHasNext() {
            return true;
        }

        public boolean hasNext() {
            if (this.forwards) {
                return this.ix + this.currentSpan < this.childNodesLength;
            }
            return this.ix > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NodeInfo next() {
            Node node = this.start.docWrapper.docNode;
            synchronized (node) {
                Node node2;
                block11: while (true) {
                    if (this.forwards) {
                        this.ix += this.currentSpan;
                        if (this.ix >= this.childNodesLength) {
                            return null;
                        }
                        this.currentSpan = this.skipFollowingTextNodes();
                        node2 = this.childNodes.item(this.ix);
                        switch (node2.getNodeType()) {
                            case 10: {
                                continue block11;
                            }
                            case 1: {
                                break;
                            }
                            default: {
                                if (this.elementsOnly) continue block11;
                            }
                        }
                        DOMNodeWrapper dOMNodeWrapper = DOMNodeWrapper.this.makeWrapper(node2, DOMNodeWrapper.this.docWrapper, this.commonParent, this.ix);
                        dOMNodeWrapper.span = this.currentSpan;
                        return dOMNodeWrapper;
                    }
                    --this.ix;
                    if (this.ix < 0) {
                        return null;
                    }
                    this.currentSpan = this.skipPrecedingTextNodes();
                    this.ix -= this.currentSpan - 1;
                    node2 = this.childNodes.item(this.ix);
                    switch (node2.getNodeType()) {
                        case 10: {
                            continue block11;
                        }
                        case 1: {
                            break block11;
                        }
                        default: {
                            if (!this.elementsOnly) break block11;
                            continue block11;
                        }
                    }
                    break;
                }
                DOMNodeWrapper dOMNodeWrapper = DOMNodeWrapper.this.makeWrapper(node2, DOMNodeWrapper.this.docWrapper, this.commonParent, this.ix);
                dOMNodeWrapper.span = this.currentSpan;
                return dOMNodeWrapper;
            }
        }
    }
}

