/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.ECTableColumnInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SATableColumnInsertionCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertColumnOperationBase
extends AbstractTableOperation {
    public static final String POSITION_ARGUMENT = "insertPosition";
    private static final String CUSTOM_COLUMN_INSERTION_ARGUMENT = "customColumnInsertion";
    public static final ArgumentDescriptor INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("customColumnInsertion", 3, "A boolean specifying if the custom column insertion has been requested or not. A custom insertion allows the user to choose the number of columns to be inserted and the position of insertion (before or after the current column).", new String[]{"true", "false"}, "false");
    public static final ArgumentDescriptor POSITION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the current column determined by the XPath expression.\nCan be: Before, After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"After", "Before"}, "After");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAMESPACE_ARGUMENT_DESCRIPTOR, POSITION_ARGUMENT_DESCRIPTOR, INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR};

    public InsertColumnOperationBase(AuthorTableHelper documentTypeHelper) {
        super(documentTypeHelper, true);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        String namespace = null;
        Object namespaceObj = args.getArgumentValue("namespace");
        if (namespaceObj instanceof String) {
            namespace = (String)namespaceObj;
        }
        String position = "After";
        Object posObj = args.getArgumentValue(POSITION_ARGUMENT);
        if (posObj instanceof String) {
            position = (String)posObj;
        }
        boolean customColumnInsertion = false;
        Object customColumnInsertionArgumentObj = args.getArgumentValue(CUSTOM_COLUMN_INSERTION_ARGUMENT);
        customColumnInsertion = "true".equals(customColumnInsertionArgumentObj);
        this.performInsertColumns(authorAccess, namespace, position, customColumnInsertion, null, null, false, null, null);
    }

    public void performInsertColumn(AuthorAccess authorAccess, String namespace, AuthorDocumentFragment[] fragments, TableColumnSpecificationInformation columnSpecification, boolean cellsFragments, InsertRowOperationBase insertRowOperation, InsertTableOperationBase insertTableOperation) throws AuthorOperationException {
        this.performInsertColumns(authorAccess, namespace, "After", false, fragments, columnSpecification, cellsFragments, insertRowOperation, insertTableOperation);
    }

    private void performInsertColumns(AuthorAccess authorAccess, String namespace, String insertPosition, boolean customColumnInsertion, AuthorDocumentFragment[] fragments, TableColumnSpecificationInformation columnSpecification, boolean cellsFragments, InsertRowOperationBase insertRowOperation, InsertTableOperationBase insertTableOperation) throws AuthorOperationException {
        try {
            AuthorNode fullySelectedNode;
            int noOfColumnsToBeInserted = 1;
            TableColumnsInfo tableColumnsInfo = null;
            if (customColumnInsertion) {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.STANDALONE == platform) {
                    tableColumnsInfo = SATableColumnInsertionCustomizerInvoker.getInstance().customizeTableColumnInsertion(authorAccess);
                } else if (Platform.ECLIPSE == platform) {
                    tableColumnsInfo = ECTableColumnInsertionCustomizerInvoker.getInstance().customizeTableColumnInsertion(authorAccess);
                }
                if (tableColumnsInfo != null) {
                    noOfColumnsToBeInserted = tableColumnsInfo.getColumnsNumber();
                    insertPosition = !tableColumnsInfo.isInsertAfter() ? "Before" : "After";
                } else {
                    throw new AuthorOperationStoppedByUserException("Cancelled by user");
                }
            }
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorElement tableElement = this.getElementAncestor(authorAccess.getDocumentController().getNodeAtOffset(caretOffset), 2);
            if (tableElement == null && (fullySelectedNode = authorAccess.getEditorAccess().getFullySelectedNode()) != null) {
                tableElement = this.getElementAncestor(fullySelectedNode, 2);
            }
            if (tableElement != null) {
                this.insertColumns(authorAccess, namespace, insertPosition, fragments, columnSpecification, cellsFragments, insertRowOperation, caretOffset, noOfColumnsToBeInserted, tableElement);
            } else {
                Platform platform = authorAccess.getWorkspaceAccess().getPlatform();
                if (Platform.WEBAPP == platform) {
                    AuthorOperationException exception = new AuthorOperationException("A column can only be inserted in an existing table.");
                    exception.setOperationRejectedOnPurpose(true);
                    throw exception;
                }
                if (insertTableOperation != null) {
                    insertTableOperation.insertTable(fragments, cellsFragments, authorAccess, namespace, this.tableHelper, null);
                }
            }
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    public void insertColumns(AuthorAccess authorAccess, AuthorElement tableElement, String namespace, String insertPosition, int caretOffset, int noOfColumnsToBeInserted) throws BadLocationException, AuthorOperationException {
        this.insertColumns(authorAccess, namespace, insertPosition, null, null, false, null, caretOffset, noOfColumnsToBeInserted, tableElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insertColumns(AuthorAccess authorAccess, String namespace, String insertPosition, AuthorDocumentFragment[] fragments, TableColumnSpecificationInformation columnSpecification, boolean cellsFragments, InsertRowOperationBase insertRowOperation, int caretOffset, int noOfColumnsToBeInserted, AuthorElement tableElement) throws BadLocationException, AuthorOperationException {
        AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
        int newColumnIndex = -1;
        AuthorTableCellSpanProvider tableSupport = this.tableHelper.getTableCellSpanProvider(tableElement);
        if (this.isTableElement(nodeAtCaret, 1)) {
            newColumnIndex = this.findColumnIndex(authorAccess, caretOffset + 1);
            if (newColumnIndex == -1) {
                newColumnIndex = this.findColumnIndex(authorAccess, caretOffset - 1);
                newColumnIndex = newColumnIndex != -1 ? ++newColumnIndex : 0;
            }
        } else {
            AuthorElement cell = this.getElementAncestor(nodeAtCaret, 0);
            if (cell == null) {
                int noCols = authorAccess.getTableAccess().getTableNumberOfColumns(tableElement);
                cell = authorAccess.getTableAccess().getTableCellAt(0, noCols - 1, tableElement);
            }
            if (cell == null) throw new AuthorOperationException("Cannot find a cell in the table at the current caret position.");
            int[] cellIndex = authorAccess.getTableAccess().getTableCellIndex(cell);
            if (cellIndex == null) throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + cell);
            Integer colSpan = tableSupport.getColSpan(cell);
            newColumnIndex = cellIndex[1] + ("After".equals(insertPosition) && colSpan != null ? colSpan : 1);
        }
        if ("Before".equals(insertPosition) && newColumnIndex > 0) {
            --newColumnIndex;
        }
        int numberOfColumns = authorAccess.getTableAccess().getTableNumberOfColumns(tableElement);
        try {
            authorAccess.getDocumentController().disableLayoutUpdate();
            if (numberOfColumns == 0 || tableSupport.hasColumnSpecifications(tableElement)) {
                this.updateColumnCellsSpan(authorAccess, tableSupport, tableElement, newColumnIndex, columnSpecification, namespace, noOfColumnsToBeInserted);
            }
            this.insertNewColumnsCells(authorAccess, tableElement, newColumnIndex, namespace, fragments, cellsFragments, insertRowOperation, noOfColumnsToBeInserted, numberOfColumns);
        }
        finally {
            authorAccess.getDocumentController().enableLayoutUpdate((AuthorNode)tableElement);
        }
        this.tableHelper.updateTableColumnNumber(authorAccess, tableElement, numberOfColumns + noOfColumnsToBeInserted);
    }

    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement tableElem, int newColumnIndex, TableColumnSpecificationInformation columnSpecification, String namespace, int noOfColumnsToBeInserted) throws AuthorOperationException {
        int rowCount = authorAccess.getTableAccess().getTableRowCount(tableElem);
        if (newColumnIndex > 0 && rowCount != -1) {
            AuthorElement prevCell = null;
            for (int i = rowCount - 1; i >= 0; --i) {
                AuthorElement cell = authorAccess.getTableAccess().getTableCellAt(i, newColumnIndex, tableElem);
                if (prevCell == cell) continue;
                prevCell = cell;
                if (cell == null) continue;
                int[] cellIndices = authorAccess.getTableAccess().getTableColSpanIndices(cell);
                int colSpanStart = cellIndices[0];
                int colSpanEnd = cellIndices[1];
                if (colSpanStart >= newColumnIndex || newColumnIndex > colSpanEnd) continue;
                this.tableHelper.updateTableColSpan(authorAccess, tableSupport, cell, colSpanStart + 1, colSpanEnd + 1 + noOfColumnsToBeInserted);
            }
        }
    }

    private void insertNewColumnsCells(AuthorAccess authorAccess, AuthorElement tableElement, int newColumnIndex, String namespace, AuthorDocumentFragment[] fragments, boolean cellsFragment, InsertRowOperationBase insertRowOperation, int noOfColumnsToBeInserted, int initialNumberOfColumns) throws AuthorOperationException {
        boolean incompatibilityWarnShown = false;
        int rowCount = authorAccess.getTableAccess().getTableRowCount(tableElement);
        if (rowCount != -1) {
            ArrayList<String> cellsElementNames = new ArrayList<String>();
            ArrayList<Integer> cellsInsertionOffsets = new ArrayList<Integer>();
            for (int i = 0; i < rowCount; ++i) {
                int insertionOffset;
                if (newColumnIndex > 0) {
                    AuthorElement cell = authorAccess.getTableAccess().getTableCellAt(i, newColumnIndex, tableElement);
                    if (cell != null) {
                        int[] cellIndices = authorAccess.getTableAccess().getTableColSpanIndices(cell);
                        int colSpanStart = cellIndices[0];
                        int colSpanEnd = cellIndices[1];
                        if (colSpanStart < newColumnIndex && newColumnIndex <= colSpanEnd) {
                            if (incompatibilityWarnShown) continue;
                            incompatibilityWarnShown = InsertColumnOperationBase.checkForCompatibility(authorAccess, fragments, i);
                            continue;
                        }
                    }
                    if ((cell = authorAccess.getTableAccess().getTableCellAt(i, newColumnIndex - 1, tableElement)) == null) {
                        if (incompatibilityWarnShown) continue;
                        incompatibilityWarnShown = InsertColumnOperationBase.checkForCompatibility(authorAccess, fragments, i);
                        continue;
                    }
                }
                if ((insertionOffset = this.findCellInsertionOffset(authorAccess, tableElement, i, newColumnIndex)) != -1) {
                    cellsInsertionOffsets.add(insertionOffset);
                    String cellElementName = this.getCellElementName(authorAccess.getTableAccess().getTableRow(i, tableElement), newColumnIndex);
                    cellsElementNames.add(cellElementName);
                    if (cellElementName != null) continue;
                    throw new AuthorOperationException("The table model does not accept new columns at the given position.");
                }
                if (incompatibilityWarnShown) continue;
                incompatibilityWarnShown = InsertColumnOperationBase.checkForCompatibility(authorAccess, fragments, i);
            }
            if (fragments == null) {
                String defaultContentForEmptyCells = this.getDefaultContentForEmptyCells();
                if (defaultContentForEmptyCells != null) {
                    AuthorDocumentFragment[] frags = new AuthorDocumentFragment[cellsInsertionOffsets.size()];
                    for (int i = cellsInsertionOffsets.size() - 1; i >= 0; --i) {
                        StringBuilder xmlFragment = new StringBuilder();
                        for (int j = 0; j < noOfColumnsToBeInserted; ++j) {
                            xmlFragment.append("<").append((String)cellsElementNames.get(i));
                            if (namespace != null) {
                                xmlFragment.append(" xmlns=\"").append(namespace).append("\"");
                            }
                            xmlFragment.append(">");
                            xmlFragment.append(defaultContentForEmptyCells);
                            xmlFragment.append("</").append((String)cellsElementNames.get(i)).append(">");
                        }
                        frags[i] = authorAccess.getDocumentController().createNewDocumentFragmentInContext(xmlFragment.toString(), ((Integer)cellsInsertionOffsets.get(i)).intValue());
                        fragments = frags;
                    }
                    int[] ints = new int[cellsInsertionOffsets.size()];
                    for (int i = 0; i < ints.length; ++i) {
                        ints[i] = (Integer)cellsInsertionOffsets.get(i);
                    }
                    authorAccess.getDocumentController().insertMultipleFragments(tableElement, fragments, ints);
                } else {
                    int index = 0;
                    int[] contentInsertOffsets = new int[cellsInsertionOffsets.size() * noOfColumnsToBeInserted];
                    String[] cellElementNamesToInsert = new String[cellsInsertionOffsets.size() * noOfColumnsToBeInserted];
                    for (int i = 0; i < cellsInsertionOffsets.size(); ++i) {
                        int offsetWhereToInsert = (Integer)cellsInsertionOffsets.get(i);
                        String nameToInsert = (String)cellsElementNames.get(i);
                        for (int j = 0; j < noOfColumnsToBeInserted; ++j) {
                            contentInsertOffsets[index] = offsetWhereToInsert;
                            cellElementNamesToInsert[index] = nameToInsert;
                            ++index;
                        }
                    }
                    authorAccess.getDocumentController().insertMultipleElements(tableElement, cellElementNamesToInsert, contentInsertOffsets, namespace);
                }
                authorAccess.getEditorAccess().setCaretPosition((Integer)cellsInsertionOffsets.get(0) + 1);
            } else {
                boolean multipleFragmentsInserted;
                int insertCellsCount = cellsInsertionOffsets.size();
                int[] contentInsertOffsets = new int[insertCellsCount];
                String[] xmlFragments = new String[insertCellsCount];
                for (int i = 0; i < insertCellsCount; ++i) {
                    contentInsertOffsets[i] = (Integer)cellsInsertionOffsets.get(i);
                    xmlFragments[i] = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragment, (String)cellsElementNames.get(i), i, namespace, this.tableHelper, new String[0]);
                }
                AuthorDocumentFragment[] fragmentsToInsert = authorAccess.getDocumentController().createNewDocumentFragmentsInContext(xmlFragments, contentInsertOffsets);
                boolean newRowsInserted = false;
                if (insertRowOperation != null && insertCellsCount <= fragments.length - 1) {
                    int tableRowCount = authorAccess.getTableAccess().getTableRowCount(tableElement);
                    AuthorElement lastTableRow = authorAccess.getTableAccess().getTableRow(tableRowCount - 1, tableElement);
                    if (lastTableRow == null) {
                        AuthorOperationException exception = new AuthorOperationException("The operation failed because the last table row could not be determined.");
                        exception.setOperationRejectedOnPurpose(true);
                        throw exception;
                    }
                    newRowsInserted = true;
                    StringBuilder rowsFragments = new StringBuilder();
                    String cellName = insertRowOperation.getCellElementName(tableElement, newColumnIndex);
                    for (int i = insertCellsCount; i < fragments.length; ++i) {
                        try {
                            String cellFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragment, cellName, i, namespace, this.tableHelper, new String[0]);
                            String rowXMLFragment = insertRowOperation.getRowXMLFragment(authorAccess, tableElement, namespace, cellFragment, newColumnIndex, initialNumberOfColumns);
                            if (rowXMLFragment == null) {
                                throw new AuthorOperationException("The column cannot be inserted.");
                            }
                            rowsFragments.append(rowXMLFragment);
                            continue;
                        }
                        catch (BadLocationException e) {
                            throw new AuthorOperationException("The column cannot be inserted.", (Throwable)e);
                        }
                    }
                    int insertRowsOffset = lastTableRow.getEndOffset() + 1;
                    fragmentsToInsert = Arrays.copyOf(fragmentsToInsert, fragmentsToInsert.length + 1);
                    fragmentsToInsert[fragmentsToInsert.length - 1] = authorAccess.getDocumentController().createNewDocumentFragmentInContext(rowsFragments.toString(), insertRowsOffset);
                    contentInsertOffsets = Arrays.copyOf(contentInsertOffsets, contentInsertOffsets.length + 1);
                    contentInsertOffsets[contentInsertOffsets.length - 1] = insertRowsOffset;
                }
                if (multipleFragmentsInserted = authorAccess.getDocumentController().insertMultipleFragments(tableElement, fragmentsToInsert, contentInsertOffsets)) {
                    int delta = 0;
                    authorAccess.getEditorAccess().setCaretPosition(contentInsertOffsets[0] + 1);
                    ArrayList<ContentInterval> toSelect = new ArrayList<ContentInterval>();
                    for (int i = 0; i < contentInsertOffsets.length; ++i) {
                        int currentOffset = contentInsertOffsets[i];
                        int length = fragmentsToInsert[i].getLength();
                        toSelect.add(new ContentInterval(currentOffset + delta, currentOffset + delta + length));
                        delta += length;
                    }
                    authorAccess.getEditorAccess().getAuthorSelectionModel().setSelectionIntervals(toSelect, false);
                    if (!newRowsInserted) {
                        authorAccess.getEditorAccess().getAuthorSelectionModel().setSelectionInterpretationMode(SelectionInterpretationMode.TABLE_COLUMN);
                    }
                }
            }
        } else {
            throw new AuthorOperationException("Could not obtain the number of rows. Table is invalid.");
        }
    }

    private static boolean checkForCompatibility(AuthorAccess authorAccess, AuthorDocumentFragment[] fragments, int rowIndex) throws AuthorOperationException {
        boolean messageShow = false;
        if (fragments != null && rowIndex < fragments.length) {
            int response = authorAccess.getWorkspaceAccess().showConfirmDialog(authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("handle.paste.column.warning"), new String[]{authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("cancel")}, new int[]{1, 0});
            if (response != 1) {
                throw new AuthorOperationStoppedByUserException("Cancelled by user");
            }
            messageShow = true;
        }
        return messageShow;
    }

    private int findColumnIndex(AuthorAccess authorAccess, int offset) throws BadLocationException, AuthorOperationException {
        int newColumnIndex = -1;
        AuthorNode relativeCell = authorAccess.getDocumentController().getNodeAtOffset(offset);
        if (this.isTableElement(relativeCell, 0)) {
            int[] cellIndex = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)relativeCell);
            if (cellIndex != null) {
                newColumnIndex = cellIndex[1];
            } else {
                throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + relativeCell);
            }
        }
        return newColumnIndex;
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a table column.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected String getDefaultContentForEmptyCells() {
        return null;
    }

    protected static ArgumentDescriptor[] removeMultipleInsertionDescriptor(ArgumentDescriptor[] superArguments) {
        ArrayList arguments = new ArrayList(superArguments.length);
        Collections.addAll(arguments, superArguments);
        arguments.remove(INSERT_MULTIPLE_COLUMNS_ARGUMENT_DESCRIPTOR);
        return arguments.toArray(new ArgumentDescriptor[0]);
    }
}

