/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorActionEventHandler;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class PromoteDemoteItemOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)PromoteDemoteItemOperation.class.getName());
    private static final String ARGUMENT_PROMOTE = "promote";
    private static final ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{new ArgumentDescriptor("promote", 3, "Should be true to promote the list item at the caret position, or false to demote it.", new String[]{"true", "false"}, "false")};

    public String getDescription() {
        return "Promotes or demotes a list item.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorActionEventHandler eventHandler = CommonAccess.getAuthorActionEventHandler((AuthorAccess)authorAccess);
        if (eventHandler != null) {
            boolean promote = "true".equals(args.getArgumentValue(ARGUMENT_PROMOTE));
            AuthorActionEventHandler.AuthorActionEventType eventType = promote ? AuthorActionEventHandler.AuthorActionEventType.SHIFT_TAB : AuthorActionEventHandler.AuthorActionEventType.TAB;
            boolean canHandleEvent = eventHandler.canHandleEvent(authorAccess, eventType);
            if (canHandleEvent) {
                eventHandler.handleEvent(authorAccess, eventType);
            }
        } else {
            logger.debug("No event handler set for the current framework.");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return arguments;
    }
}

