/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.InvalidEditException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.operations.MoveCaretUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertFragmentOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)InsertFragmentOperation.class.getName());
    public static final String ARGUMENT_FRAGMENT = "fragment";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_FRAGMENT = new ArgumentDescriptor("fragment", 1, "The fragment to be inserted");
    public static final String ARGUMENT_XPATH_LOCATION = "insertLocation";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_XPATH_LOCATION = new ArgumentDescriptor("insertLocation", 2, "An XPath expression indicating the insert location for the fragment.\nNote: If it is not defined then the insert location will be at the caret.");
    public static final String ARGUMENT_RELATIVE_LOCATION = "insertPosition";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the node determined by the XPath expression.\nCan be: Before, Inside as first child, Inside as last child or After.\nNote: If the XPath expression is not defined this argument is ignored", new String[]{"Before", "Inside as first child", "Inside as last child", "After"}, "Inside as first child");
    public static final String ARGUMENT_GO_TO_NEXT_EDITABLE_POSITION = "goToNextEditablePosition";
    protected static final ArgumentDescriptor ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION = new ArgumentDescriptor("goToNextEditablePosition", 3, "After inserting the fragment, the first editable position is detected and the caret is placed at that location. It handles any in-place editors used to edit attributes. It will be ignored if the fragment specifies a caret position using the caret editor variable.", new String[]{"true", "false"}, "true");
    public static final String ARGUMENT_INSERT_FRAG_EVEN_IF_INVALID = "insertEvenIfInvalid";
    protected static final ArgumentDescriptor ARGUMENT_DESCR_INSERT_FRAG_EVEN_IF_INVALID = new ArgumentDescriptor("insertEvenIfInvalid", 3, "True to insert the fragment even if invalid, when 'schemaAware' is set to 'true'.", new String[]{"true", "false"}, "true");
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[]{ARGUMENT_DESCRIPTOR_FRAGMENT, ARGUMENT_DESCRIPTOR_XPATH_LOCATION, ARGUMENT_DESCRIPTOR_RELATIVE_LOCATION, SCHEMA_AWARE_ARGUMENT_DESCRIPTOR, ARGUMENT_DESCR_INSERT_FRAG_EVEN_IF_INVALID, ARGUMENT_DESCRIPTOR_GO_TO_NEXT_EDITABLE_POSITION};

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object fragment = args.getArgumentValue(ARGUMENT_FRAGMENT);
        Object xpathLocation = args.getArgumentValue(ARGUMENT_XPATH_LOCATION);
        Object relativeLocation = args.getArgumentValue(ARGUMENT_RELATIVE_LOCATION);
        Object goToNextEditablePos = args.getArgumentValue(ARGUMENT_GO_TO_NEXT_EDITABLE_POSITION);
        if (goToNextEditablePos == null) {
            goToNextEditablePos = "true";
        }
        boolean goToFirstEditablePosition = "true".equals(goToNextEditablePos);
        Object schemaAwareArgumentValue = args.getArgumentValue("schemaAware");
        Object insertEvenIfInvalid = args.getArgumentValue(ARGUMENT_INSERT_FRAG_EVEN_IF_INVALID);
        if (insertEvenIfInvalid == null) {
            insertEvenIfInvalid = "true";
        }
        boolean isInsertEvenIfInvalid = "true".equals(insertEvenIfInvalid);
        this.doOperationInternal(authorAccess, fragment, xpathLocation, relativeLocation, goToFirstEditablePosition, schemaAwareArgumentValue, isInsertEvenIfInvalid);
    }

    protected void doOperationInternal(AuthorAccess authorAccess, Object fragment, Object xpathLocation, Object relativeLocation, boolean goToFirstEditablePosition, Object schemaAwareArgumentValue) throws AuthorOperationException {
        this.doOperationInternal(authorAccess, fragment, xpathLocation, relativeLocation, goToFirstEditablePosition, schemaAwareArgumentValue, true);
    }

    protected void doOperationInternal(AuthorAccess authorAccess, Object fragment, Object xpathLocation, Object relativeLocation, boolean goToFirstEditablePosition, Object schemaAwareArgumentValue, boolean isInsertEvenIfInvalid) throws AuthorOperationException {
        if (fragment instanceof String) {
            String xmlFragment = (String)fragment;
            boolean moveCaretToSpecifiedPosition = MoveCaretUtil.hasImposedEditorVariableCaretOffset(xmlFragment);
            int insertionOffset = authorAccess.getEditorAccess().getCaretOffset();
            if ("false".equals(schemaAwareArgumentValue)) {
                if ((moveCaretToSpecifiedPosition || goToFirstEditablePosition) && xpathLocation != null && ((String)xpathLocation).trim().length() > 0) {
                    insertionOffset = authorAccess.getDocumentController().getXPathLocationOffset((String)xpathLocation, (String)relativeLocation);
                }
                authorAccess.getDocumentController().insertXMLFragment(xmlFragment, (String)xpathLocation, (String)relativeLocation);
            } else {
                try {
                    Integer off;
                    SchemaAwareHandlerResult result = authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, (String)xpathLocation, (String)relativeLocation, isInsertEvenIfInvalid);
                    if (result != null && (off = (Integer)result.getResult("result.id.handle.insert.fragment.offset")) != null) {
                        insertionOffset = off;
                    }
                }
                catch (AuthorOperationException e) {
                    Throwable cause = e.getCause();
                    if (!isInsertEvenIfInvalid && cause instanceof InvalidEditException) {
                        throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("No_valid_insert_position_for_frag"));
                    }
                    throw e;
                }
            }
            if (moveCaretToSpecifiedPosition) {
                MoveCaretUtil.moveCaretToImposedEditorVariableOffset(authorAccess, insertionOffset);
            } else if (goToFirstEditablePosition) {
                try {
                    int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                    authorAccess.getEditorAccess().goToNextEditablePosition(insertionOffset, caretOffset);
                }
                catch (BadLocationException e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("The argument value was not defined, it is " + fragment);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Insert a document fragment.";
    }
}

