/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.imagemap;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.imagemap.SupportedFrameworks;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class EditImageMapCore {
    private static final Logger logger = LoggerFactory.getLogger((String)EditImageMapCore.class.getName());

    protected AuthorNode getFullySelectedNode(AuthorDocumentController ctrl, int selStart, int selEnd, boolean hasSelection) {
        AuthorNode toReturn = null;
        if (hasSelection) {
            try {
                AuthorNode node;
                OffsetInformation info = ctrl.getContentInformationAtOffset(selStart);
                if (info.getPositionType() == 1 && (node = ctrl.getNodeAtOffset(selStart + 1)).getStartOffset() == selStart && node.getEndOffset() == selEnd - 1) {
                    toReturn = node;
                }
            }
            catch (BadLocationException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return toReturn;
    }

    protected final AuthorNode findNodeOfInterest(AuthorAccess authorAccess, AuthorNode interestNode, String[] properties2Check) throws BadLocationException {
        AuthorDocumentController documentController = authorAccess.getDocumentController();
        AuthorEditorAccess editorAccess = authorAccess.getEditorAccess();
        AuthorNode nodeToEdit = interestNode;
        if (nodeToEdit == null) {
            nodeToEdit = this.getFullySelectedNode(documentController, editorAccess.getSelectionStart(), editorAccess.getSelectionEnd(), editorAccess.hasSelection());
        }
        if (nodeToEdit == null) {
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            nodeToEdit = documentController.getNodeAtOffset(caretOffset);
        }
        while (nodeToEdit != null && !this.isNodeOfInterest(nodeToEdit, properties2Check)) {
            nodeToEdit = nodeToEdit.getParent();
        }
        return nodeToEdit;
    }

    private boolean isNodeOfInterest(AuthorNode nodeToEdit, String[] properties2Check) {
        if (properties2Check != null && properties2Check.length > 0) {
            for (int i = 0; i < properties2Check.length; ++i) {
                if (!this.isNodeOfInterest(nodeToEdit, properties2Check[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isNodeOfInterest(AuthorNode nodeToEdit, String property2Check) {
        if (nodeToEdit.getType() == 0) {
            return property2Check.equals(((AuthorElement)nodeToEdit).getLocalName());
        }
        return false;
    }

    public abstract AuthorNode[] getNodesOfInterest(AuthorAccess var1, AuthorNode var2, boolean var3) throws BadLocationException, AuthorOperationException;

    public abstract SupportedFrameworks getSupportedFramework(String var1);
}

