/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.id;

import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.UniqueAttributesRecognizer;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class GenerateIDsOperation
implements AuthorOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GenerateIDsOperation.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        UniqueAttributesRecognizer attrsAssigner = this.getUniqueAttributesRecognizer();
        if (attrsAssigner != null) {
            attrsAssigner.activated(authorAccess);
            if (authorAccess.getEditorAccess().hasSelection()) {
                List selectionIntervals = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
                AuthorDocument parentOfChange = authorAccess.getDocumentController().getAuthorDocumentNode();
                int minOffset = -1;
                int maxOffset = -1;
                authorAccess.getDocumentController().disableLayoutUpdate();
                try {
                    for (ContentInterval contentInterval : selectionIntervals) {
                        int startSel = contentInterval.getStartOffset();
                        int endSel = contentInterval.getEndOffset();
                        minOffset = Math.min(startSel, minOffset);
                        maxOffset = Math.max(endSel, maxOffset);
                        GenerateIDsOperation.generateIDs(authorAccess, attrsAssigner, startSel, endSel);
                    }
                }
                finally {
                    if (maxOffset != -1 && minOffset != -1) {
                        try {
                            parentOfChange = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), minOffset, maxOffset);
                        }
                        catch (BadLocationException e) {
                            LOGGER.debug(e.getMessage(), (Throwable)e);
                        }
                    }
                    authorAccess.getDocumentController().enableLayoutUpdate((AuthorNode)parentOfChange);
                }
            }
            try {
                AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
                int startSel = nodeAtCaret.getStartOffset();
                int endSel = nodeAtCaret.getStartOffset();
                attrsAssigner.assignUniqueIDs(startSel, endSel, !authorAccess.getEditorAccess().hasSelection());
            }
            catch (BadLocationException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void generateIDs(AuthorAccess authorAccess, UniqueAttributesRecognizer attrsAssigner, int startSel, int endSel) {
        try {
            AuthorNode nodeAtEndSel = authorAccess.getDocumentController().getNodeAtOffset(endSel - 1);
            if (startSel == nodeAtEndSel.getStartOffset() && nodeAtEndSel.getEndOffset() == endSel - 1) {
                attrsAssigner.assignUniqueIDs(startSel, startSel, true);
            } else {
                int[] balancedSelection = authorAccess.getEditorAccess().getBalancedSelection(startSel, endSel);
                int start = balancedSelection[0];
                int end = balancedSelection[1];
                CharSequence contentCharSequence = authorAccess.getDocumentController().getContentCharSequence();
                for (int i = 0; i < end - start; ++i) {
                    boolean isSentinel;
                    char chr = contentCharSequence.charAt(start + i);
                    boolean bl = isSentinel = chr == '\u0000';
                    if (!isSentinel) continue;
                    int offsetInDoc = start + i;
                    AuthorNode nodeAtOffset = authorAccess.getDocumentController().getNodeAtOffset(offsetInDoc + 1);
                    if (nodeAtOffset.getStartOffset() != offsetInDoc) continue;
                    i += nodeAtOffset.getEndOffset() - nodeAtOffset.getStartOffset();
                    if (nodeAtOffset.getEndOffset() > end - 1) continue;
                    attrsAssigner.assignUniqueIDs(offsetInDoc, offsetInDoc, true);
                }
            }
            attrsAssigner.assignUniqueIDs(startSel, endSel - 1, false);
        }
        catch (BadLocationException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract UniqueAttributesRecognizer getUniqueAttributesRecognizer();

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Generate unique IDs on the selected content";
    }
}

