/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class AbstractDocumentTypeHelper
implements AuthorTableHelper {
    protected boolean isElement(AuthorNode node, String elemLocalName) {
        return node instanceof AuthorElement && elemLocalName.equals(((AuthorElement)node).getLocalName());
    }

    @Override
    public boolean isTableCell(AuthorNode node) {
        String[] rowElemNames = this.getTableCellElementNames();
        for (int i = 0; i < rowElemNames.length; ++i) {
            if (!this.isElement(node, rowElemNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTable(AuthorNode node) {
        String[] tableElemNames = this.getTableElementLocalName();
        for (int i = 0; i < tableElemNames.length; ++i) {
            if (!this.isElement(node, tableElemNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isTableRow(AuthorNode node) {
        String[] rowElemNames = this.getTableRowElementNames();
        for (int i = 0; i < rowElemNames.length; ++i) {
            if (!this.isElement(node, rowElemNames[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public AuthorNode getTableElementForDeletion(AuthorNode element) {
        AuthorNode tableElement = null;
        if (this.isTable(element)) {
            tableElement = element;
        } else {
            while (element.getParent() != null) {
                AuthorNode parentElement = element.getParent();
                if (!this.isTable(parentElement)) continue;
                tableElement = parentElement;
                break;
            }
        }
        return tableElement;
    }

    protected abstract String[] getTableCellElementNames();

    protected abstract String[] getTableRowElementNames();

    protected abstract String[] getTableElementLocalName();

    public String[] getAllowedCellAttributesToCopy() {
        return null;
    }

    public boolean isContentReference(AuthorNode node) {
        return false;
    }

    @Override
    public boolean isColspec(AuthorNode node) {
        return node instanceof AuthorElement && "colspec".equals(((AuthorElement)node).getLocalName());
    }
}

