/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.xerces;

import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.sax.SAX;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchemaReader;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.prop.xsd.XsdProperty;
import com.thaiopensource.validate.xerces.SAXXMLErrorHandler;
import com.thaiopensource.validate.xerces.SchemaImpl;
import com.thaiopensource.validate.xerces.ValidatorImpl;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.transform.sax.SAXSource;
import org.apache.xerces.parsers.CachingParserPool;
import org.apache.xerces.parsers.XMLGrammarPreparser;
import org.apache.xerces.util.EntityResolverWrapper;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.SynchronizedSymbolTable;
import org.apache.xerces.util.SynchronizedXMLGrammarPoolImpl;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.classloader.ClassLoaderUtil;

class SchemaReaderImpl
extends AbstractSchemaReader {
    private static final PropertyId<?>[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.ENTITY_RESOLVER, XsdProperty.XSD_VERSION, XsdProperty.FULL_XPATH};

    SchemaReaderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema createSchema(SAXSource source, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        ClassLoader oldCL = ClassLoaderUtil.installContextClassLoader();
        try {
            String xsdVersion;
            SymbolTable symbolTable = new SymbolTable();
            XMLGrammarPreparser preparser = new XMLGrammarPreparser(symbolTable);
            SynchronizedXMLGrammarPoolImpl grammarPool = new SynchronizedXMLGrammarPoolImpl();
            preparser.registerPreparser("http://www.w3.org/2001/XMLSchema", null);
            preparser.setGrammarPool((XMLGrammarPool)grammarPool);
            ErrorHandler eh = properties.get(ValidateProperty.ERROR_HANDLER);
            SAXXMLErrorHandler xeh = new SAXXMLErrorHandler(eh);
            preparser.setErrorHandler((XMLErrorHandler)xeh);
            Resolver resolver = ResolverFactory.createResolver(properties).getResolver();
            if (resolver != null) {
                preparser.setEntityResolver((XMLEntityResolver)new EntityResolverWrapper((EntityResolver)SAX.createEntityResolver(resolver)));
            }
            if ((xsdVersion = properties.get(XsdProperty.XSD_VERSION)) != null) {
                preparser.setProperty("http://apache.org/xml/properties/validation/schema/version", (Object)("http://www.w3.org/XML/XMLSchema/v" + xsdVersion));
            }
            if (properties.get(XsdProperty.FULL_XPATH) != null) {
                preparser.setFeature("http://apache.org/xml/features/validation/cta-full-xpath-checking", true);
            }
            try {
                preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", SchemaReaderImpl.toXMLInputSource(source.getInputSource()));
                Name attributeOwner = properties.get(WrapProperty.ATTRIBUTE_OWNER);
                if (attributeOwner != null) {
                    StringReader r = new StringReader(SchemaReaderImpl.createWrapper(attributeOwner));
                    preparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", new XMLInputSource(null, null, null, (Reader)r, null));
                }
            }
            catch (XNIException e) {
                throw ValidatorImpl.toSAXException(e);
            }
            if (xeh.getHadError()) {
                throw new IncorrectSchemaException();
            }
            SchemaImpl schemaImpl = new SchemaImpl((SymbolTable)new SynchronizedSymbolTable(symbolTable), (XMLGrammarPool)new CachingParserPool.SynchronizedGrammarPool((XMLGrammarPool)grammarPool), properties, supportedPropertyIds);
            return schemaImpl;
        }
        finally {
            ClassLoaderUtil.uninstallContextClassLoader((ClassLoader)oldCL);
        }
    }

    @Override
    public Option getOption(String uri) {
        return null;
    }

    private static String createWrapper(Name attributeOwner) {
        return "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"    targetNamespace=\"" + attributeOwner.getNamespaceUri() + "\">  <xs:element name=\"" + attributeOwner.getLocalName() + "\">    <xs:complexType><xs:anyAttribute processContents=\"strict\"/></xs:complexType>  </xs:element></xs:schema>";
    }

    private static XMLInputSource toXMLInputSource(InputSource in) {
        XMLInputSource xin = new XMLInputSource(in.getPublicId(), in.getSystemId(), null);
        xin.setByteStream(in.getByteStream());
        xin.setCharacterStream(in.getCharacterStream());
        xin.setEncoding(in.getEncoding());
        return xin;
    }
}

