/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Objects;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.JsonArray;
import org.everit.json.schema.loader.JsonObject;
import org.everit.json.schema.loader.JsonValue;
import org.everit.json.schema.loader.LoaderConfig;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;

class ArraySchemaLoader {
    private final LoadingState ls;
    private final LoaderConfig config;
    private final SchemaLoader defaultLoader;

    @Deprecated
    public ArraySchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this(ls, LoaderConfig.defaultV4Config(), defaultLoader);
    }

    ArraySchemaLoader(LoadingState ls, LoaderConfig config, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.config = Objects.requireNonNull(config, "config cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ArraySchema.Builder load() {
        ArraySchema.Builder builder = ArraySchema.builder();
        this.ls.schemaJson().maybe("minItems").map(JsonValue::requireInteger).ifPresent(builder::minItems);
        this.ls.schemaJson().maybe("maxItems").map(JsonValue::requireInteger).ifPresent(builder::maxItems);
        this.ls.schemaJson().maybe("uniqueItems").map(JsonValue::requireBoolean).ifPresent(builder::uniqueItems);
        this.ls.schemaJson().maybe("additionalItems").ifPresent(maybe -> maybe.canBe(Boolean.class, builder::additionalItems).or(JsonObject.class, obj -> builder.schemaOfAdditionalItems((Schema)this.defaultLoader.loadChild((JsonValue)obj).build())).requireAny());
        if (this.config.specVersion.isAtLeast(SpecificationVersion.DRAFT_2019_09)) {
            this.ls.schemaJson().maybe("unevaluatedItems").ifPresent(maybe -> maybe.canBe(Boolean.class, builder::unevaluatedItems).or(JsonObject.class, obj -> builder.schemaOfUnevaluatedItems((Schema)this.defaultLoader.loadChild((JsonValue)obj).build())).requireAny());
            this.ls.schemaJson().maybe("minContains").map(JsonValue::requireInteger).ifPresent(builder::minContains);
            this.ls.schemaJson().maybe("maxContains").map(JsonValue::requireInteger).ifPresent(builder::maxContains);
        }
        if (this.config.specVersion.isAtLeast(SpecificationVersion.DRAFT_2020_12)) {
            boolean prefixItems = this.ls.schemaJson().maybe("prefixItems").isPresent();
            this.ls.schemaJson().maybe("prefixItems").ifPresent(items -> items.canBe(JsonArray.class, arr -> this.buildTupleSchema(builder, (JsonArray)arr)).requireAny());
            if (prefixItems) {
                this.ls.schemaJson().maybe("items").ifPresent(maybe -> maybe.canBe(Boolean.class, builder::additionalItems).or(JsonObject.class, obj -> builder.schemaOfAdditionalItems((Schema)this.defaultLoader.loadChild((JsonValue)obj).build())).requireAny());
            } else {
                this.ls.schemaJson().maybe("items").ifPresent(items -> items.canBeSchema(itemSchema -> builder.allItemSchema((Schema)this.defaultLoader.loadChild((JsonValue)itemSchema).build())).requireAny());
            }
        } else {
            this.ls.schemaJson().maybe("items").ifPresent(items -> items.canBeSchema(itemSchema -> builder.allItemSchema((Schema)this.defaultLoader.loadChild((JsonValue)itemSchema).build())).or(JsonArray.class, arr -> this.buildTupleSchema(builder, (JsonArray)arr)).requireAny());
        }
        if (this.config.specVersion != SpecificationVersion.DRAFT_4) {
            this.ls.schemaJson().maybe("contains").ifPresent(containedRawSchema -> this.addContainedSchema(builder, (JsonValue)containedRawSchema));
        }
        return builder;
    }

    private void addContainedSchema(ArraySchema.Builder builder, JsonValue schemaJson) {
        builder.containsItemSchema((Schema)this.defaultLoader.loadChild(schemaJson).build());
    }

    private void buildTupleSchema(ArraySchema.Builder builder, JsonArray itemSchema) {
        itemSchema.forEach((i, subschema) -> builder.addItemSchema((Schema)this.defaultLoader.loadChild(subschema).build()));
    }
}

