/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidatingVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.loader.OrgJsonUtil;
import org.everit.json.schema.regexp.Regexp;
import org.json.JSONObject;

class ObjectSchemaValidatingVisitor
extends Visitor {
    private JSONObject objSubject;
    private ObjectSchema schema;
    private int objectSize;
    private final ValidatingVisitor owner;

    public ObjectSchemaValidatingVisitor(ValidatingVisitor owner) {
        this.owner = Objects.requireNonNull(owner, "owner cannot be null");
    }

    @Override
    void visitObjectSchema(ObjectSchema objectSchema) {
        this.owner.ifPassesTypeCheck(JSONObject.class, objectSchema.requiresObject(), objectSchema.isNullable(), objSubject -> {
            this.objSubject = objSubject;
            this.objectSize = objSubject.length();
            this.schema = objectSchema;
            Object failureState = this.owner.getFailureState();
            HashSet objSubjectKeys = null;
            if (objectSchema.hasDefaultProperty()) {
                objSubjectKeys = new HashSet(objSubject.keySet());
            }
            super.visitObjectSchema(objectSchema);
            if (this.owner.isFailureStateChanged(failureState) && objectSchema.hasDefaultProperty()) {
                objSubject.keySet().retainAll(objSubjectKeys);
            }
        });
    }

    @Override
    void visitRequiredPropertyName(String requiredPropName) {
        if (!this.objSubject.has(requiredPropName)) {
            this.owner.failure(String.format("required key [%s] not found", requiredPropName), "required");
        }
    }

    @Override
    void visitPropertyNameSchema(Schema propertyNameSchema) {
        if (propertyNameSchema != null) {
            String[] names = OrgJsonUtil.getNames(this.objSubject);
            if (names == null || names.length == 0) {
                return;
            }
            for (String name : names) {
                ValidationException failure = this.owner.getFailureOfSchema(propertyNameSchema, name);
                if (failure == null) continue;
                this.owner.failure(failure.prepend(name));
            }
        }
    }

    @Override
    void visitMinProperties(Integer minProperties) {
        if (minProperties != null && this.objectSize < minProperties) {
            this.owner.failure(String.format("minimum size: [%d], found: [%d]", minProperties, this.objectSize), "minProperties");
        }
    }

    @Override
    void visitMaxProperties(Integer maxProperties) {
        if (maxProperties != null && this.objectSize > maxProperties) {
            this.owner.failure(String.format("maximum size: [%d], found: [%d]", maxProperties, this.objectSize), "maxProperties");
        }
    }

    @Override
    void visitPropertyDependencies(String ifPresent, Set<String> allMustBePresent) {
        if (this.objSubject.has(ifPresent)) {
            for (String mustBePresent : allMustBePresent) {
                if (this.objSubject.has(mustBePresent)) continue;
                this.owner.failure(String.format("property [%s] is required", mustBePresent), "dependencies");
            }
        }
    }

    @Override
    void visitAdditionalProperties(Boolean permitsAdditionalProperties) {
        if (permitsAdditionalProperties != null && !permitsAdditionalProperties.booleanValue()) {
            List<String> additionalProperties = this.getAdditionalProperties();
            if (additionalProperties.isEmpty()) {
                return;
            }
            for (String additionalProperty : additionalProperties) {
                String message = String.format("extraneous key [%s] is not permitted", additionalProperty);
                ValidationException validationException = new ValidationException((Schema)this.schema, message, "additionalProperties", this.schema.getSchemaLocation());
                validationException.prepend(additionalProperty);
                this.owner.failure(validationException);
            }
        }
    }

    @Override
    void visitSchemaOfAdditionalProperties(Schema schemaOfAdditionalProperties) {
        if (schemaOfAdditionalProperties != null) {
            List<String> additionalPropNames = this.getAdditionalProperties();
            for (String propName : additionalPropNames) {
                Object propVal = this.objSubject.get(propName);
                ValidationException failure = this.owner.getFailureOfSchema(schemaOfAdditionalProperties, propVal);
                if (failure == null) continue;
                this.owner.failure(failure.prepend(propName, this.schema));
            }
        }
    }

    @Override
    void visitUnevaluatedProperties(Boolean permitsUnevaluatedProperties) {
        Boolean nestedPermits = this.nestedSchemasPermit();
        if (!(permitsUnevaluatedProperties == null || permitsUnevaluatedProperties.booleanValue() || nestedPermits != null && nestedPermits.booleanValue())) {
            List<String> unevaluatedProperties = this.getUnevaluatedProperties();
            if (unevaluatedProperties.isEmpty()) {
                return;
            }
            for (String unevaluatedProperty : unevaluatedProperties) {
                String message = String.format("extraneous key [%s] is not permitted", unevaluatedProperty);
                ValidationException validationException = new ValidationException((Schema)this.schema, message, "unevaluatedProperties", this.schema.getSchemaLocation());
                validationException.prepend(unevaluatedProperty);
                this.owner.failure(validationException);
            }
        }
    }

    @Override
    void visitSchemaOfUnevaluatedProperties(Schema schemaOfUnevaluatedProperties) {
        Boolean nestedPermits = this.nestedSchemasPermit();
        if (!(schemaOfUnevaluatedProperties == null || nestedPermits != null && nestedPermits.booleanValue())) {
            List<String> unevaluatedPropNames = this.getUnevaluatedProperties();
            for (String propName : unevaluatedPropNames) {
                Object propVal = this.objSubject.get(propName);
                ValidationException failure = this.owner.getFailureOfSchema(schemaOfUnevaluatedProperties, propVal);
                if (failure == null) continue;
                this.owner.failure(failure.prepend(propName, this.schema));
            }
            this.owner.setCombinedSchemaParentEvaluated();
        }
    }

    private List<String> getAdditionalProperties() {
        String[] names = OrgJsonUtil.getNames(this.objSubject);
        if (names == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if (this.schema.getPropertySchemas().containsKey(name) || this.matchesAnyPattern(name)) continue;
            namesList.add(name);
        }
        return namesList;
    }

    private List<String> getUnevaluatedProperties() {
        String[] names = OrgJsonUtil.getNames(this.objSubject);
        if (names == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> namesList = new ArrayList<String>();
        for (String name : names) {
            if ((this.schema.definesProperty(name) || this.matchesAnyPattern(name) || this.isNestedProperty(name) || this.matchesNestedPattern(name)) && !this.isDependencyButDependentPropertyNotFound(name)) continue;
            namesList.add(name);
        }
        this.owner.setConditionalSchemaSiblingEvaluated();
        return namesList;
    }

    private boolean isDependencyButDependentPropertyNotFound(String property) {
        for (Map.Entry<String, Schema> schemaDep : this.schema.getSchemaDependencies().entrySet()) {
            if (!schemaDep.getValue().definesProperty(property) || this.objSubject.has(schemaDep.getKey())) continue;
            return true;
        }
        return false;
    }

    private Boolean nestedSchemasPermit() {
        Boolean nestedSchemasPermit = null;
        if (this.owner.getCombinedSchemaParent() != null) {
            for (Schema subschema : this.owner.getCombinedSchemaParent().getSubschemas()) {
                if (subschema instanceof ObjectSchema) {
                    nestedSchemasPermit = this.getNestedPermits((ObjectSchema)subschema);
                    if (nestedSchemasPermit == null || nestedSchemasPermit.booleanValue()) continue;
                    break;
                }
                if (!(subschema instanceof CombinedSchema)) continue;
                for (Schema nestedSubschema : ((CombinedSchema)subschema).getSubschemas()) {
                    if (nestedSubschema instanceof ObjectSchema && (nestedSchemasPermit = this.getNestedPermits((ObjectSchema)nestedSubschema)) != null && !nestedSchemasPermit.booleanValue()) break;
                }
                if (nestedSchemasPermit == null) continue;
                break;
            }
        }
        return nestedSchemasPermit;
    }

    private Boolean getNestedPermits(ObjectSchema subschema) {
        if (subschema.permitsAdditionalProperties() != null) {
            return subschema.permitsAdditionalProperties();
        }
        if (subschema.permitsUnevaluatedProperties() != null) {
            return subschema.permitsUnevaluatedProperties();
        }
        return null;
    }

    private boolean isNestedProperty(String name) {
        if (this.owner.getCombinedSchemaParent() != null && this.owner.getCombinedSchemaParent().definesProperty(name)) {
            return true;
        }
        if (this.owner.getConditionalSchemaSibling() != null) {
            return this.owner.getConditionalSchemaSibling().definesProperty(name);
        }
        return false;
    }

    private boolean matchesNestedPattern(String name) {
        if (this.owner.getCombinedSchemaParent() != null) {
            for (Regexp pattern : this.owner.getCombinedSchemaParent().getNestedPatterns()) {
                if (pattern.patternMatchingFailure(name).isPresent()) continue;
                return true;
            }
        }
        if (this.owner.getConditionalSchemaSibling() != null) {
            for (Regexp pattern : this.owner.getConditionalSchemaSibling().getNestedPatterns()) {
                if (pattern.patternMatchingFailure(name).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesAnyPattern(String key) {
        for (Regexp pattern : this.schema.getRegexpPatternProperties().keySet()) {
            if (pattern.patternMatchingFailure(key).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    void visitPatternPropertySchema(Regexp propertyNamePattern, Schema schema) {
        String[] propNames = OrgJsonUtil.getNames(this.objSubject);
        if (propNames == null || propNames.length == 0) {
            return;
        }
        for (String propName : propNames) {
            ValidationException failure;
            if (propertyNamePattern.patternMatchingFailure(propName).isPresent() || (failure = this.owner.getFailureOfSchema(schema, this.objSubject.get(propName))) == null) continue;
            this.owner.failure(failure.prepend(propName));
        }
    }

    @Override
    void visitSchemaDependency(String propName, Schema schema) {
        ValidationException failure;
        if (this.objSubject.has(propName) && (failure = this.owner.getFailureOfSchema(schema, this.objSubject)) != null) {
            this.owner.failure(failure);
        }
    }

    @Override
    void visitPropertySchema(String properyName, Schema schema) {
        if (this.objSubject.has(properyName)) {
            ValidationException failure = this.owner.getFailureOfSchema(schema, this.objSubject.get(properyName));
            if (failure != null) {
                this.owner.failure(failure.prepend(properyName));
            }
        } else if (schema.hasDefaultValue()) {
            this.objSubject.put(properyName, schema.getDefaultValue());
        }
    }
}

