/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.TerminationException;
import com.icl.saxon.tree.AttributeCollection;
import java.io.OutputStreamWriter;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XSLMessageSaxon
extends StyleElement {
    boolean terminate = false;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainTemplateBody() {
        return true;
    }

    @Override
    public void prepareAttributes() throws TransformerConfigurationException {
        String terminateAtt = null;
        StandardNames sn = this.getStandardNames();
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            int f = nc & 0xFFFFF;
            if (f == sn.TERMINATE) {
                terminateAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (terminateAtt != null) {
            if (terminateAtt.equals("yes")) {
                this.terminate = true;
            } else if (terminateAtt.equals("no")) {
                this.terminate = false;
            } else {
                this.styleError("terminate must be \"yes\" or \"no\"");
            }
        }
    }

    @Override
    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    @Override
    public void process(Context context) throws TransformerException {
        Controller c = context.getController();
        Emitter emitter = c.getMessageEmitter();
        if (emitter == null) {
            emitter = c.makeMessageEmitter();
        }
        if (emitter.getWriter() == null) {
            emitter.setWriter(new OutputStreamWriter(System.err));
        }
        Outputter old = c.getOutputter();
        Properties props = new Properties();
        props.put("omit-xml-declaration", "yes");
        c.changeOutputDestination(props, emitter);
        this.processChildren(context);
        c.resetOutputDestination(old);
        if (this.terminate) {
            throw new TerminationException("Processing terminated by xsl:message at line " + this.getLineNumber());
        }
    }
}

