<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    version="2.0">
    
    <xd:doc scope="stylesheet" xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates author extensions, like CSS, toolbar configurations etc.</xd:p>
        </xd:desc>
    </xd:doc>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates associated CSSs.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="authorExtension/field[@name='cssDescriptors']/cssFile-array" mode="copy-target">
        <!--          
        <cssFile>
          <field name="href">
           <String>${framework}/css/edit/style-century.css</String>
          </field>
          <field name="title">
           <String>Century</String>
          </field>
          <field name="alternate">
           <Boolean>false</Boolean>
          </field>
         </cssFile>
        -->
        
        <xsl:variable name="container" select="$script/s:author/s:css"/>
        
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            
            <xsl:for-each select="$container/s:addCss[@position='before']">
                <xsl:sequence select="util:createCSSEntry(@path, @title, @alternate)"></xsl:sequence>
            </xsl:for-each>
            
            <xsl:variable name="skipped" select="util:replaceBaseWithFramework($container/s:removeCss/xs:string(@path))"/>
            <xsl:apply-templates mode="copy-target" select="*[not(util:isSkippedEntry(field[@name='href']/String/text(), $skipped))]"/>
            
            <xsl:for-each select="$container/s:addCss[not(@position) or @position='after']">
                <xsl:sequence select="util:createCSSEntry(@path, @title, @alternate)"></xsl:sequence>
            </xsl:for-each>  
        </xsl:copy>
    </xsl:template>
    
  <xsl:template match="authorExtension/field[@name='mergeCSSsFromDocument']/Boolean" mode="copy-target">
    <xsl:variable name="container" select="$script/s:author/s:css"/>
    
    <xsl:choose>
      <xsl:when test="$container/@mergeDocumentCSS">
       <xsl:copy>
         <xsl:value-of select="$container/@mergeDocumentCSS"/>
       </xsl:copy>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
  <xsl:template match="authorExtension/field[@name='multipleAlternateSelectionEnabled']/Boolean" mode="copy-target">
    <xsl:variable name="container" select="$script/s:author/s:css"/>
    
    <xsl:choose>
      <xsl:when test="$container/@selectMultipleAlternateCSS">
        <xsl:copy>
          <xsl:value-of select="$container/@selectMultipleAlternateCSS"/>
        </xsl:copy>
      </xsl:when>
      <xsl:otherwise>
        <xsl:copy-of select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
    
   
</xsl:stylesheet>