/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors.spc;

import java.util.Map;

/**
 * Same as :nth-last-child(1). The :last-child pseudo-class 
 * represents an element that is the last child of some other element. 
 * 
 * @see "http://www.w3.org/TR/css3-selectors/#last-child-pseudo"
 * @author dan
 */
public class LastOfTypeSPCCondition extends NthOfTypeSPCCondition {

  /**
   * Constructor.
   */
  public LastOfTypeSPCCondition() {
    super(0, 1);
  }
  
  
  /**
   * @see org.w3c.flute.parser.selectors.spc.NthLastChildSPCCondition#getType()
   */
  @Override
  public Type getType() {
    return Type.LAST_OF_TYPE;
  }
  
  
  /**
   * @see org.w3c.flute.parser.selectors.spc.NthChildSPCCondition#getSerialization(Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":last-of-type";
  }
}
