/* Parser.java */
/* Generated By:JavaCC: Do not edit this line. Parser.java */
package org.w3c.flute.parser;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.flute.css.sac.Condition;
import org.w3c.flute.css.sac.ConditionFactory;
import org.w3c.flute.css.sac.DocumentHandler;
import org.w3c.flute.css.sac.Selector;
import org.w3c.flute.css.sac.PageSelector;
import org.w3c.flute.css.sac.PageSelectorList;
import org.w3c.flute.css.sac.SelectorFactory;
import org.w3c.flute.css.sac.SelectorList;
import org.w3c.flute.css.sac.SimpleSelector;
import org.w3c.flute.css.sac.SubjectSelector;
import org.w3c.flute.parser.selectors.ConditionFactoryImpl;
import org.w3c.flute.parser.selectors.SelectorFactoryImpl;
import org.w3c.flute.parser.selectors.PageSelectorImpl;
import org.w3c.flute.parser.selectors.PageSelectorListImpl;
import org.w3c.flute.parser.MediaQuery.MediaQueryPrefix;
import org.w3c.flute.util.Encoding;

/**
 * A CSS2 parser
 *
 * @author Philippe Le H&eacute;garet
 * @version $Revision$
 */
public class Parser implements org.w3c.flute.css.sac.Parser, ParserConstants {

    // replaces all \t, \n, etc with this StringBuffer.
    static final StringBuilder SPACE = new StringBuilder(" ");

    // the document handler for the parser
    protected DocumentHandler documentHandler;

    // the error handler for the parser
    protected ErrorHandler errorHandler;
    // the input source for the parser
    protected InputSource source;

    protected ConditionFactory conditionFactory;
    protected SelectorFactory selectorFactory;

    // temporary place holder for pseudo-element ...
    protected String pseudoElt;

    /**
     * The proxy namespace mapping from the css. This builder collects here the proxy to NS mappings.
     * See http://www.w3.org/TR/css3-namespace/#css-qnames
     */
    private Map proxyNSMapping = new HashMap();



    /**
     * Creates a new Parser
     */
    public Parser() {
        this((CharStream) null);
    }

    /**
     * @return the proxy Namespace mapping built by this builder.
     */
    public Map getProxyNSMapping() {
      return this.proxyNSMapping;
    }

    /**
     * @exception CSSException Not yet implemented
     */
    public void setLocale(Locale locale) throws CSSException {
        throw new CSSException(CSSException.SAC_NOT_SUPPORTED_ERR);
    }

    /**
     * Set the document handler for this parser
     */
    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler = handler;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory = (SelectorFactory)selectorFactory;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
           this.conditionFactory = (ConditionFactory)conditionFactory;
    }

    /**
     * Set the error handler for this parser
     */
    public void setErrorHandler(ErrorHandler error) {
        this.errorHandler = error;
    }

    /**
     * Main parse methods
     *
     * @param source the source of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));
        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }

        parserUnit();
    }

    /**
     * Convenient method for URIs.
     *
     * @param systemId the fully resolved URI of the style sheet.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleSheet(String systemId)
            throws CSSException, IOException {
        parseStyleSheet(new InputSource(systemId));
    }

    /**
     * This method parses only one rule (style rule or at-rule, except @charset).
     *
     * @param source the source of the rule.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseRule();
    }

    /**
     * This method parses a style declaration (including the surrounding curly
     * braces).
     *
     * @param source the source of the style declaration.
     * @exception IOException the source can't be parsed.
     * @exception CSSException the source is not CSS valid.
     */
    public void parseStyleDeclaration(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseDeclarationBlock();
    }

    /**
     * This methods returns "http://www.w3.org/TR/REC-CSS2".
     * @return the string "http://www.w3.org/TR/REC-CSS2".
     */
    public String getParserVersion() {
        return "http://www.w3.org/TR/REC-CSS2";
    }

    /**
     * Parse methods used by DOM Level 2 implementation.
     */
    public void parseImportRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseImportRule();
    }

    public void parseMediaRule(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        _parseMediaRule();
    }

    public SelectorList parseSelectors(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        return _parseSelectors();
    }


    public String parseNamespaceToken(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        if (selectorFactory == null) {
            selectorFactory = new SelectorFactoryImpl();
        }
        if (conditionFactory == null) {
            conditionFactory = new ConditionFactoryImpl();
        }
        return _parseNamespaceToken();
    }

    public LexicalUnit parsePropertyValue(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return expr(null);
    }

    public boolean parsePriority(InputSource source)
            throws CSSException, IOException {
        this.source = source;
        ReInit(getCharStreamWithLurk(source));

        return prio();
    }

    /**
     * Convert the source into a Reader. Used only by DOM Level 2 parser methods.
     */
    private Reader getReader(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return source.getCharacterStream();
        } else if (source.getByteStream() != null) {
            // My DOM level 2 implementation doesn't use this case.
            if (source.getEncoding() == null) {
                // unknown encoding, use ASCII as default.
                return new InputStreamReader(source.getByteStream(), "ASCII");
            } else {
                return new InputStreamReader(source.getByteStream(),
                                             source.getEncoding());
            }
        } else {
            // systemId
            throw new CSSException("not yet implemented");
        }
    }

    /**
     * @return the last lexical unit from the list pointed by the head.
     */
    private LexicalUnitImpl last(LexicalUnit head) {
        LexicalUnit lu = head;
        LexicalUnit last = head;
        while (lu != null) {
                last = lu;
                lu = lu.getNextLexicalUnit();
        }
        return (LexicalUnitImpl)last;
    }

    /**
     * Convert the source into a CharStream with encoding informations.
     * The encoding can be found in the InputSource or in the CSS document.
     * Since this method marks the reader and make a reset after looking for
     * the charset declaration, you'll find the charset declaration into the
     * stream.  
     */
    private CharStream getCharStreamWithLurk(InputSource source)
            throws CSSException, IOException {

        // Oxygen Fix, files with query string were unparsable.
    source = fixForFileURIsWithQueryAndFragments(source);

        if (source.getCharacterStream() != null) {
            // all encoding are supposed to be resolved by the user
            // return the reader
            return new Generic_CharStream(source.getCharacterStream(), 1, 1);
        } else if (source.getByteStream() == null) {
            // @@CONTINUE ME. see also getReader() with systemId
            try {
                source.setByteStream(new URL(source.getURI()).openStream());
            } catch (Exception e) {
                try {
                    source.setByteStream(new FileInputStream(source.getURI()));
                } catch (IOException ex) {
                //Oxygen Fix: More explicit system ID
                    throw new CSSException(e);
                } catch ( AccessControlException ex) {
                         // WA-3668 - When Security is enabled and we try to open an URL as file, it will be rejected.
                         throw new CSSException(e);
                }
            }
        }
        String encoding = "ASCII";
        InputStream input = source.getByteStream();
        char c = ' ';

        if (!input.markSupported()) {
            input = new BufferedInputStream(input);
            source.setByteStream(input);
        }
        input.mark(100);
        c = (char) input.read();

        if (c == '@') {
            // hum, is it a charset ?
            int size   = 100;
            byte[] buf = new byte[size];
            input.read(buf, 0, 7);
            String keyword = new String(buf, 0, 7);
            //Oxygen patch, "charset" declaration is ignore case.
            if (keyword.toLowerCase().equals("charset")) {
                // Yes, this is the charset declaration !

                // here I don't use the right declaration : white space are ' '.
                while (true) {
                        c = (char) input.read();
                        //Oxygen patch, there are more whitespaces than ' '
                        if(Character.isWhitespace(c)){
                                //Go futher
                                continue;
                        } else{
                                break;
                        }
                  // find the first quote
                }
                char endChar = c;
                int i = 0;

                if ((endChar != '"') && (endChar != '\'')) {
                    // hum this is not a quote.
                //Oxygen Fix: More explicit system ID
                    throw new CSSException(source.getURI() + ": invalid charset declaration");
                }

                while ((c = (char) input.read()) != endChar) {
                    buf[i++] = (byte) c;
                    if (i == size) {
                        byte[] old = buf;
                        buf = new byte[size + 100];
                        System.arraycopy(old, 0, buf, 0, size);
                        size += 100;
                    }
                }
                while ((c = (char) input.read()) == ' ') {
                    // find the next relevant character
                }
                if (c != ';') {
                    // no semi colon at the end ?
                //Oxygen Fix: More explicit system ID
                    throw new CSSException(source.getURI() +": invalid charset declaration: "
                                           + "missing semi colon");
                }
                encoding = new String(buf, 0, i);
                if (source.getEncoding() != null) {
                    // compare the two encoding informations.
                    // For example, I don't accept to have ASCII and after UTF-8.
                    // Is it really good ? That is the question.
                    if (!encoding.equals(source.getEncoding())) {
                        //Oxygen Fix: More explicit system ID 
                        throw new CSSException(source.getURI() + ": invalid encoding information.");
                    }
                }
            } // else no charset declaration available
        }
        // ok set the real encoding of this source.
        source.setEncoding(encoding);
        // set the real reader of this source.
        source.setCharacterStream(new InputStreamReader(source.getByteStream(),
                                             Encoding.getJavaEncoding(encoding)));
        // reset the stream (leave the charset declaration in the stream).
        input.reset();

        return new Generic_CharStream(source.getCharacterStream(), 1, 1);
    }


          /**
	   * Removes the query and fragment from the input source.
	   * 
	   * @param is The input source.
	   * @return The input source with the filtered system id.
	   */
          private InputSource fixForFileURIsWithQueryAndFragments(InputSource is) {
            if (is.getURI() != null ) {
              URI uri;
              try {
                uri = new URI(is.getURI());
                if ("file".equals(uri.getScheme()) && uri.getQuery() != null) {
                  // A query string in the URI. This is not supported by our parser.
                  String uriStr = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null).toURL().toString();
                  InputSource nis = new InputSource(is.getCharacterStream());
                  nis.setByteStream(is.getByteStream());
                  nis.setEncoding(is.getEncoding());
                  nis.setMedia(is.getMedia());
                  nis.setTitle(is.getTitle());
                  nis.setURI(uriStr);
                  is = nis;
                }
              } catch (URISyntaxException e) {
                // Ignore, leave input source as it is.
              } catch (MalformedURLException e) {
                // Ignore, leave input source as it is.
              }

            }
            return is;
          }
    /**
     * A namespace declaration. This happens only from CSS Level 3, and above...
     * <br>
     * Not supported yet.
     *
     * @param prefix <code>null</code> if this is the default namespace
     * @param uri The URI for this namespace.
     * @exception CSSException Any CSS exception, possibly wrapping another
     *                         exception.     * 
     */
    private void namespaceDeclaration(String prefix, String uri) {
      if(proxyNSMapping.containsKey(prefix)) {
        String boundNS = (String) proxyNSMapping.get(prefix);
        if((boundNS == null && uri != null) || ! boundNS.equals(uri)) {
          //The same prefix was bound to another NS, this is illegal.
          //http://www.w3.org/1999/06/25/WD-css3-namespace-19990625/#q1
          throw new CSSParseException(
              "Attempt to rebind the prefix " + prefix + " from the namespace: " + boundNS + " to: " + uri,
              getLocator());
        }
      }
      proxyNSMapping.put(prefix, uri);
      this.documentHandler.namespaceDeclaration(prefix, uri);
    }

    private LocatorImpl currentLocator;
    private Locator getLocator() {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this);
            return currentLocator;
        }
        return currentLocator.reInit(this);
    }
    private LocatorImpl getLocator(Token save) {
        if (currentLocator == null) {
            currentLocator = new LocatorImpl(this, save);
            return currentLocator;
        }
        return currentLocator.reInit(this, save);
    }

    private void reportError(Locator l, Exception e) {
        if (errorHandler != null) {
            if (e instanceof ParseException) {
                // construct a clean error message.
                ParseException pe = (ParseException) e;
                if (pe.specialConstructor) {
                    StringBuffer errorM = new StringBuffer();
                    if (pe.currentToken != null) {
                        errorM.append("encountered \"")
                            .append(pe.currentToken.next);
                    }
                    errorM.append('"');
                    if (pe.expectedTokenSequences.length != 0) {
                        errorM.append(". Was expecting one of: ");
                        for (int i = 0; i < pe.expectedTokenSequences.length; i++) {
                            for (int j = 0; j < pe.expectedTokenSequences[i].length; j++) {
                                int kind = pe.expectedTokenSequences[i][j];
                                if (kind != S) {
                                    errorM.append(pe.tokenImage[kind]);
                                    errorM.append(' ');
                                }
                            }
                        }
                    }
                    errorHandler.error(new CSSParseException(errorM.toString(),
                                                             l, e));
                } else {
                    errorHandler.error(new CSSParseException(e.getMessage(),
                                                             l, e));
                }
            } else if (e == null) {
                errorHandler.error(new CSSParseException("error", l, null));
            } else {
                errorHandler.error(new CSSParseException(e.getMessage(), l, e));
            }
        }
    }

    private void reportWarningSkipText(Locator l, String text) {
        if (errorHandler != null && text  != null) {
            errorHandler.warning(new CSSParseException("Skipping: " + text, l));
        }
    }

/*
 * The grammar of CSS2
 */

/**
 * The main entry for the parser.
 *
 * @exception ParseException exception during the parse
 */
  final public void parserUnit() throws ParseException {
    try {
documentHandler.startDocument(source);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CHARSET_SYM:{
        charset();
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        ;
      }
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:
        case CDO:
        case CDC:
        case ATKEYWORD:{
          ;
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          break label_1;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          jj_consume_token(S);
          break;
          }
        case CDO:
        case CDC:
        case ATKEYWORD:{
          ignoreStatement();
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IMPORT_SYM:{
          ;
          break;
          }
        default:
          jj_la1[3] = jj_gen;
          break label_2;
        }
        importDeclaration();
        label_3:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CDO:
          case CDC:
          case ATKEYWORD:{
            ;
            break;
            }
          default:
            jj_la1[4] = jj_gen;
            break label_3;
          }
          ignoreStatement();
          label_4:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[5] = jj_gen;
              break label_4;
            }
            jj_consume_token(S);
          }
        }
      }
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAMESPACE_SYM:{
          ;
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          break label_5;
        }
        namespaceDeclaration();
        label_6:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case CDO:
          case CDC:
          case ATKEYWORD:{
            ;
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            break label_6;
          }
          ignoreStatement();
          label_7:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[8] = jj_gen;
              break label_7;
            }
            jj_consume_token(S);
          }
        }
      }
      afterImportDeclaration();
      jj_consume_token(0);
    } finally {
documentHandler.endDocument(source);
    }
  }

  final public void charset() throws ParseException {Token n;
    try {
      jj_consume_token(CHARSET_SYM);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          break label_8;
        }
        jj_consume_token(S);
      }
      n = jj_consume_token(STRING);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[10] = jj_gen;
          break label_9;
        }
        jj_consume_token(S);
      }
      jj_consume_token(SEMICOLON);
    } catch (ParseException e) {
reportError(getLocator(e.currentToken.next), e);
        skipStatement();
        // reportWarningSkipText(getLocator(), skipStatement());

    } catch (Exception e) {
reportError(getLocator(), e);
        skipStatement();
        // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

  final public void afterImportDeclaration() throws ParseException {String ret;
 Locator l;
    label_10:
    while (true) {
      ;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LBRACKET:
      case ANY:
      case DOT:
      case COLON:
      case IDENT:
      case NAMESPACE_IDENT:
      case HASH:{
        styleRule();
        break;
        }
      case MEDIA_SYM:{
        media();
        break;
        }
      case PAGE_SYM:{
        page();
        break;
        }
      case FONT_FACE_SYM:{
        fontFace();
        break;
        }
      default:
        jj_la1[11] = jj_gen;
l = getLocator();
        ret = skipStatement();
if ((ret == null) || (ret.length() == 0)) {
              {if ("" != null) return;}
          }
          reportWarningSkipText(l, ret);
          if (ret.charAt(0) == '@') {
              documentHandler.ignorableAtRule(ret);
          }
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CDO:
        case CDC:
        case ATKEYWORD:{
          ;
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          break label_11;
        }
        ignoreStatement();
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[13] = jj_gen;
            break label_12;
          }
          jj_consume_token(S);
        }
      }
    }
  }

  final public void ignoreStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CDO:{
      jj_consume_token(CDO);
      break;
      }
    case CDC:{
      jj_consume_token(CDC);
      break;
      }
    case ATKEYWORD:{
      atRuleDeclaration();
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * The import statement
 *
 * @exception ParseException exception during the parse
 */
  final public void importDeclaration() throws ParseException {Token n;
 String uri;
 //MediaListImpl ml = new MediaListImpl();
 MediaQueryList ml = new MediaQueryList();
    try {
      jj_consume_token(IMPORT_SYM);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          break label_13;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
uri = convertStringIndex(n.image, 1,
                                                        n.image.length() -1);
        break;
        }
      case URL:{
        n = jj_consume_token(URL);
uri = n.image.substring(4, n.image.length()-1).trim();
               if ((uri.charAt(0) == '"')
                   || (uri.charAt(0) == '\'')) {
                   uri = uri.substring(1, uri.length()-1);
               }
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[17] = jj_gen;
          break label_14;
        }
        jj_consume_token(S);
      }
      if (jj_2_1(1)) {
        mediaStatement(ml);
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[18] = jj_gen;
          break label_15;
        }
        jj_consume_token(S);
      }
if (ml.size() == 0) {
                   // see section 6.3 of the CSS2 recommandation.
                   ml.addMediaQuery(new MediaQuery("all", -1, -1));
               }
               documentHandler.importStyle(uri, ml, null);
    } catch (ParseException e) {
reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

/**
 * The namespace statement
 *
 * @exception ParseException exception during the parse
 */
  final public void namespaceDeclaration() throws ParseException {Token n;
 Token prefix = null;
 String uri;
    try {
      jj_consume_token(NAMESPACE_SYM);
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[19] = jj_gen;
          break label_16;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        prefix = jj_consume_token(IDENT);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[20] = jj_gen;
            break label_17;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case URL:{
        n = jj_consume_token(URL);
uri = n.image.substring(4, n.image.length()-1).trim();
              if ((uri.charAt(0) == '"') || (uri.charAt(0) == '\''))
              {
                uri = uri.substring(1, uri.length()-1);
              }
        break;
        }
      case STRING:{
        //Oxygen Fix: Both the url() function and the quoted url versions are accepted.
                   n = jj_consume_token(STRING);
uri = n.image.trim();
              if ((uri.charAt(0) == '"') || (uri.charAt(0) == '\''))
              {
                uri = uri.substring(1, uri.length()-1);
              }
        break;
        }
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(SEMICOLON);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          break label_18;
        }
        jj_consume_token(S);
      }
if (prefix == null)
             {
               namespaceDeclaration("", uri);
             }
             else
             {
               namespaceDeclaration(prefix.image, uri);
             }
    } catch (ParseException e) {
reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void media() throws ParseException {boolean start = false;
    String ret;
    //MediaListImpl ml = new MediaListImpl(); 
        MediaQueryList ml = new MediaQueryList();
    try {
      jj_consume_token(MEDIA_SYM);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          break label_19;
        }
        jj_consume_token(S);
      }
      mediaStatement(ml);
start = true; documentHandler.startMedia(ml);
      jj_consume_token(LBRACE);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[25] = jj_gen;
          break label_20;
        }
        jj_consume_token(S);
      }
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CDO:
        case LBRACE:
        case DASHMATCH:
        case INCLUDES:
        case PLUS:
        case MINUS:
        case COMMA:
        case SEMICOLON:
        case PRECEDES:
        case PRECEDES_GEN:
        case LBRACKET:
        case ANY:
        case DOT:
        case COLON:
        case NONASCII:
        case STRING:
        case NUMBER:
        case IDENT:
        case URL:
        case NAMESPACE_IDENT:
        case PERCENTAGE:
        case HASH:
        case IMPORT_SYM:
        case MEDIA_SYM:
        case CHARSET_SYM:
        case PAGE_SYM:
        case FONT_FACE_SYM:
        case ATKEYWORD:
        case IMPORTANT_SYM:
        case UNICODERANGE:
        case PSEUDO_NTH:
        case FUNCTION:
        case UNKNOWN:{
          ;
          break;
          }
        default:
          jj_la1[26] = jj_gen;
          break label_21;
        }
        if (jj_2_2(2)) {
          styleRule();
        } else if (jj_2_3(2)) {
          media();
        } else if (jj_2_4(2)) {
          page();
        } else if (jj_2_5(2)) {
          skipUnknownRule();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[27] = jj_gen;
          break label_22;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
if (start) {
          documentHandler.endMedia(ml);
     }
    }
  }

  final public void mediaStatement(MediaQueryList ml) throws ParseException {MediaQuery m;
    m = medium();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_23;
      }
      jj_consume_token(COMMA);
      label_24:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[29] = jj_gen;
          break label_24;
        }
        jj_consume_token(S);
      }
ml.addMediaQuery(m);
      m = medium();
    }
ml.addMediaQuery(m);
  }

/**
 * @exception ParseException exception during the parse
 */
  final public MediaQuery medium() throws ParseException {Token prefixToken;
        String mediaType = "";
        MediaFeatureExpression expression;
        MediaQuery toReturn;
        MediaQueryPrefix prefix = null;
    if (jj_2_8(1)) {
      if (getToken(1).image.toLowerCase().equals("not" )|| getToken(1).image.toLowerCase().equals("only" )) {
        prefixToken = jj_consume_token(IDENT);
        label_25:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[30] = jj_gen;
            break label_25;
          }
          jj_consume_token(S);
        }
prefix = MediaQueryPrefix.valueOf(convertIdent(prefixToken.image).toUpperCase());
      } else {
        ;
      }
      mediaType = media_type();
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[31] = jj_gen;
          break label_26;
        }
        jj_consume_token(S);
      }
toReturn = new MediaQuery(prefix, mediaType, -1, -1);
      label_27:
      while (true) {
        if (jj_2_6(1)) {
          ;
        } else {
          break label_27;
        }
        if (getToken(1).image.toLowerCase().equals("and")) {

        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(IDENT);
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[32] = jj_gen;
            break label_28;
          }
          jj_consume_token(S);
        }
        expression = mediaExpression();
toReturn.addMediaFeatureExpression(expression);
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LPARAN:{
        expression = mediaExpression();
toReturn = new MediaQuery(prefix, mediaType, -1, -1); toReturn.addMediaFeatureExpression(expression);
        label_29:
        while (true) {
          if (jj_2_7(1)) {
            ;
          } else {
            break label_29;
          }
          if (getToken(1).image.toLowerCase().equals("and")) {

          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          jj_consume_token(IDENT);
          label_30:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case S:{
              ;
              break;
              }
            default:
              jj_la1[33] = jj_gen;
              break label_30;
            }
            jj_consume_token(S);
          }
          expression = mediaExpression();
toReturn.addMediaFeatureExpression(expression);
        }
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return toReturn;}
    throw new Error("Missing return statement in function");
  }

  final public String media_type() throws ParseException {Token mediaType;
    mediaType = jj_consume_token(IDENT);
{if ("" != null) return convertIdent(mediaType.image);}
    throw new Error("Missing return statement in function");
  }

  final public MediaFeatureExpression mediaExpression() throws ParseException {String feature;
        LexicalUnit featureExpression = null;
    jj_consume_token(LPARAN);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[35] = jj_gen;
        break label_31;
      }
      jj_consume_token(S);
    }
    feature = media_feature();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        break label_32;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      label_33:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[37] = jj_gen;
          break label_33;
        }
        jj_consume_token(S);
      }
      featureExpression = expr(null);
      break;
      }
    default:
      jj_la1[38] = jj_gen;
      ;
    }
    jj_consume_token(RPARAN);
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[39] = jj_gen;
        break label_34;
      }
      jj_consume_token(S);
    }
String featureExpressionStr = "";
                if (featureExpression != null) {
                        featureExpressionStr = featureExpression.toString().trim();
                }

                {if ("" != null) return new MediaFeatureExpression(feature, "".equals(featureExpressionStr) ? null : featureExpressionStr);}
    throw new Error("Missing return statement in function");
  }

  final public String media_feature() throws ParseException {Token feature;
    feature = jj_consume_token(IDENT);
{if ("" != null) return convertIdent(feature.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches the content of a page body.
 * The page body may contain multiple declarations and 
 * page box margins property declarations.
 * 
 * https://www.w3.org/TR/css3-page/#page_body 
 */
  final public void pageBody() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TOPLEFTCORNER_SYM:
    case TOPLEFT_SYM:
    case TOPCENTER_SYM:
    case TOPRIGHT_SYM:
    case TOPRIGHTCORNER_SYM:
    case BOTTOMLEFTCORNER_SYM:
    case BOTTOMLEFT_SYM:
    case BOTTOMCENTER_SYM:
    case BOTTOMRIGHT_SYM:
    case BOTTOMRIGHTCORNER_SYM:
    case LEFTTOP_SYM:
    case LEFTMIDDLE_SYM:
    case LEFTBOTTOM_SYM:
    case RIGHTTOP_SYM:
    case RIGHTMIDDLE_SYM:
    case RIGHTBOTTOM_SYM:
    case FOOTNOTE_SYM:{
      pageMarginBox();
      pageBody();
      break;
      }
    default:
      jj_la1[43] = jj_gen;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case CUSTOM_PROPERTY:{
        declaration();
        break;
        }
      default:
        jj_la1[40] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
        label_35:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[41] = jj_gen;
            break label_35;
          }
          jj_consume_token(S);
        }
        pageBody();
        break;
        }
      default:
        jj_la1[42] = jj_gen;
        ;
      }
    }
  }

/**
 * Matches the content of a page selector. Example:
 * <pre>
 *   myPage:left:first:empty
 *   myPage
 *   :first
 * </pre> 
 * So a selector has multiple parts, the optional page 
 * name, followed by multiple pseudo names.
 */
  final public PageSelector pageSelector() throws ParseException {String pseudo;
  PageSelector pageSelector = new PageSelectorImpl();
  Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      pseudo = pseudoPage();
pageSelector.addPseudo(pseudo);
      break;
      }
    case IDENT:{
      n = jj_consume_token(IDENT);
pageSelector.setName(convertIdent(n.image));
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_36;
      }
      pseudo = pseudoPage();
pageSelector.addPseudo(pseudo);
    }
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[46] = jj_gen;
        break label_37;
      }
      jj_consume_token(S);
    }
{if ("" != null) return pageSelector;}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches a list of page selectors. Example:
 * <pre>
 *  :first, myPage:left, otherPage:right
 * </pre>
 */
  final public PageSelectorList pageSelectorList() throws ParseException {PageSelector selector;
  PageSelectorList pageSelectorList = new PageSelectorListImpl();
    selector = pageSelector();
pageSelectorList.add(selector);
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_38;
      }
      jj_consume_token(COMMA);
      label_39:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[48] = jj_gen;
          break label_39;
        }
        jj_consume_token(S);
      }
      selector = pageSelector();
pageSelectorList.add(selector);
    }
{if ("" != null) return pageSelectorList;}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches a page. A page has list of page rule selectors and a body.
 * Two events are fired, one for the start, one for the end of the 
 * block defining the page.
 */
  final public void page() throws ParseException {boolean start = false;
 Token n = null;
 String page = null;
 String pseudo = null;
 PageSelectorList list = null;
    try {
      jj_consume_token(PAGE_SYM);
      label_40:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[49] = jj_gen;
          break label_40;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:
      case IDENT:{
        list = pageSelectorList();
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        ;
      }
      jj_consume_token(LBRACE);
      label_41:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          break label_41;
        }
        jj_consume_token(S);
      }
start = true;
              documentHandler.startPage(list);
      pageBody();
      jj_consume_token(RBRACE);
      label_42:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[52] = jj_gen;
          break label_42;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.currentToken.next.beginLine,
                                          e.currentToken.next.beginColumn-1);
         reportError(li, e);
         skipStatement();
         // reportWarningSkipText(li, skipStatement());
     } else {
       skipStatement();
     }
    } finally {
if (start) {
       documentHandler.endPage(list);
     }
    }
  }

/**
 * Matches a page margin name.
 */
  final public String pageMarginSymbol() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TOPLEFTCORNER_SYM:{
      n = jj_consume_token(TOPLEFTCORNER_SYM);
      break;
      }
    case TOPLEFT_SYM:{
      n = jj_consume_token(TOPLEFT_SYM);
      break;
      }
    case TOPCENTER_SYM:{
      n = jj_consume_token(TOPCENTER_SYM);
      break;
      }
    case TOPRIGHT_SYM:{
      n = jj_consume_token(TOPRIGHT_SYM);
      break;
      }
    case TOPRIGHTCORNER_SYM:{
      n = jj_consume_token(TOPRIGHTCORNER_SYM);
      break;
      }
    case BOTTOMLEFTCORNER_SYM:{
      n = jj_consume_token(BOTTOMLEFTCORNER_SYM);
      break;
      }
    case BOTTOMLEFT_SYM:{
      n = jj_consume_token(BOTTOMLEFT_SYM);
      break;
      }
    case BOTTOMCENTER_SYM:{
      n = jj_consume_token(BOTTOMCENTER_SYM);
      break;
      }
    case BOTTOMRIGHT_SYM:{
      n = jj_consume_token(BOTTOMRIGHT_SYM);
      break;
      }
    case BOTTOMRIGHTCORNER_SYM:{
      n = jj_consume_token(BOTTOMRIGHTCORNER_SYM);
      break;
      }
    case LEFTTOP_SYM:{
      n = jj_consume_token(LEFTTOP_SYM);
      break;
      }
    case LEFTMIDDLE_SYM:{
      n = jj_consume_token(LEFTMIDDLE_SYM);
      break;
      }
    case LEFTBOTTOM_SYM:{
      n = jj_consume_token(LEFTBOTTOM_SYM);
      break;
      }
    case RIGHTTOP_SYM:{
      n = jj_consume_token(RIGHTTOP_SYM);
      break;
      }
    case RIGHTMIDDLE_SYM:{
      n = jj_consume_token(RIGHTMIDDLE_SYM);
      break;
      }
    case RIGHTBOTTOM_SYM:{
      n = jj_consume_token(RIGHTBOTTOM_SYM);
      break;
      }
    case FOOTNOTE_SYM:{
      n = jj_consume_token(FOOTNOTE_SYM);
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
// Skip the @ from the name.
        {if ("" != null) return convertIdent(n.image).substring(1);}
    throw new Error("Missing return statement in function");
  }

/**
 * Matches a page margin declaration and emmits two events, 
 * one for the start and one for the end.
 * 
 * Example:
 * 
 * <pre>
 * {@literal @}page {
 *   {@literal @}top-left{ 
 *      color:red; 
 *   }
 * }
 * </pre>
 */
  final public void pageMarginBox() throws ParseException {boolean start = false;
 Token n = null;
 String pnm = null;
    try {
      pnm = pageMarginSymbol();
      label_43:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          break label_43;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[55] = jj_gen;
          break label_44;
        }
        jj_consume_token(S);
      }
start = true;
      documentHandler.startPageMargin(pnm);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case CUSTOM_PROPERTY:{
        declaration();
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        ;
      }
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          break label_45;
        }
        jj_consume_token(SEMICOLON);
        label_46:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[58] = jj_gen;
            break label_46;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:
        case CUSTOM_PROPERTY:{
          declaration();
          break;
          }
        default:
          jj_la1[59] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[60] = jj_gen;
          break label_47;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
if (errorHandler != null) {
       LocatorImpl li = new LocatorImpl(this,
                e.currentToken.next.beginLine,
                e.currentToken.next.beginColumn-1);
       reportError(li, e);
       skipStatement();
       // reportWarningSkipText(li, skipStatement());
     } else {
       skipStatement();
     }
    } finally {
if (start) {
       documentHandler.endPageMargin(pnm);
     }
    }
  }

/**
 * Matches a pseudo page token.
 * 
 * https://www.w3.org/TR/css3-page/#syntax-prod-pseudo-page
 */
  final public String pseudoPage() throws ParseException {Token n;
    jj_consume_token(COLON);
    n = jj_consume_token(IDENT);
{if ("" != null) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

  final public void fontFace() throws ParseException {boolean start = false;
    try {
      jj_consume_token(FONT_FACE_SYM);
      label_48:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[61] = jj_gen;
          break label_48;
        }
        jj_consume_token(S);
      }
      jj_consume_token(LBRACE);
      label_49:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[62] = jj_gen;
          break label_49;
        }
        jj_consume_token(S);
      }
start = true; documentHandler.startFontFace();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case CUSTOM_PROPERTY:{
        declaration();
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        ;
      }
      label_50:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[64] = jj_gen;
          break label_50;
        }
        jj_consume_token(SEMICOLON);
        label_51:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[65] = jj_gen;
            break label_51;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:
        case CUSTOM_PROPERTY:{
          declaration();
          break;
          }
        default:
          jj_la1[66] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_52:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[67] = jj_gen;
          break label_52;
        }
        jj_consume_token(S);
      }
    } catch (ParseException e) {
reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } finally {
if (start) {
         documentHandler.endFontFace();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void atRuleDeclaration() throws ParseException {Token n;
 String ret;
    n = jj_consume_token(ATKEYWORD);
ret=skipStatementNoSemicolon();
        reportWarningSkipText(getLocator(), ret);
        if ((ret != null) && (ret.charAt(0) == '@')) {
            documentHandler.ignorableAtRule(ret);
        }
  }

  final public void skipUnknownRule() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ATKEYWORD:{
      n = jj_consume_token(ATKEYWORD);
      break;
      }
    case CDO:{
      n = jj_consume_token(CDO);
      break;
      }
    case CHARSET_SYM:{
      n = jj_consume_token(CHARSET_SYM);
      break;
      }
    case COMMA:{
      n = jj_consume_token(COMMA);
      break;
      }
    case DASHMATCH:{
      n = jj_consume_token(DASHMATCH);
      break;
      }
    case FONT_FACE_SYM:{
      n = jj_consume_token(FONT_FACE_SYM);
      break;
      }
    case FUNCTION:{
      n = jj_consume_token(FUNCTION);
      break;
      }
    case PSEUDO_NTH:{
      n = jj_consume_token(PSEUDO_NTH);
      break;
      }
    case IMPORTANT_SYM:{
      n = jj_consume_token(IMPORTANT_SYM);
      break;
      }
    case IMPORT_SYM:{
      n = jj_consume_token(IMPORT_SYM);
      break;
      }
    case INCLUDES:{
      n = jj_consume_token(INCLUDES);
      break;
      }
    case LBRACE:{
      n = jj_consume_token(LBRACE);
      break;
      }
    case MEDIA_SYM:{
      n = jj_consume_token(MEDIA_SYM);
      break;
      }
    case NONASCII:{
      n = jj_consume_token(NONASCII);
      break;
      }
    case NUMBER:{
      n = jj_consume_token(NUMBER);
      break;
      }
    case PAGE_SYM:{
      n = jj_consume_token(PAGE_SYM);
      break;
      }
    case PERCENTAGE:{
      n = jj_consume_token(PERCENTAGE);
      break;
      }
    case STRING:{
      n = jj_consume_token(STRING);
      break;
      }
    case UNICODERANGE:{
      n = jj_consume_token(UNICODERANGE);
      break;
      }
    case URL:{
      n = jj_consume_token(URL);
      break;
      }
    case SEMICOLON:{
      n = jj_consume_token(SEMICOLON);
      break;
      }
    case PLUS:{
      n = jj_consume_token(PLUS);
      break;
      }
    case PRECEDES:{
      n = jj_consume_token(PRECEDES);
      break;
      }
    case PRECEDES_GEN:{
      n = jj_consume_token(PRECEDES_GEN);
      break;
      }
    case MINUS:{
      n = jj_consume_token(MINUS);
      break;
      }
    case UNKNOWN:{
      n = jj_consume_token(UNKNOWN);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
String ret;
     Locator loc = getLocator();
     ret=skipStatement();
     reportWarningSkipText(loc, ret);
     if ((ret != null) && (n.image.charAt(0) == '@')) {
         documentHandler.ignorableAtRule(ret);
     }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char combinator() throws ParseException {char connector = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:{
      jj_consume_token(PLUS);
      label_53:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[69] = jj_gen;
          break label_53;
        }
        jj_consume_token(S);
      }
{if ("" != null) return '+';}
      break;
      }
    case PRECEDES:{
      jj_consume_token(PRECEDES);
      label_54:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[70] = jj_gen;
          break label_54;
        }
        jj_consume_token(S);
      }
{if ("" != null) return '>';}
      break;
      }
    case PRECEDES_GEN:{
      jj_consume_token(PRECEDES_GEN);
      label_55:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[71] = jj_gen;
          break label_55;
        }
        jj_consume_token(S);
      }
{if ("" != null) return '~';}
      break;
      }
    case S:{
      jj_consume_token(S);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case PRECEDES:
      case PRECEDES_GEN:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:{
          jj_consume_token(PLUS);
connector = '+';
          break;
          }
        case PRECEDES:{
          jj_consume_token(PRECEDES);
connector = '>';
          break;
          }
        case PRECEDES_GEN:{
          jj_consume_token(PRECEDES_GEN);
connector = '~';
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_56:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[73] = jj_gen;
            break label_56;
          }
          jj_consume_token(S);
        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
{if ("" != null) return connector;}
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public String property() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
      break;
      }
    case CUSTOM_PROPERTY:{
      n = jj_consume_token(CUSTOM_PROPERTY);
      break;
      }
    default:
      jj_la1[76] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_57:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[77] = jj_gen;
        break label_57;
      }
      jj_consume_token(S);
    }
{if ("" != null) return convertIdent(n.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void styleRule() throws ParseException {boolean start = false;
    SelectorList l = null;
    Token save;
    Locator loc;
    try {
      l = selectorList();
save = token;
      jj_consume_token(LBRACE);
      label_58:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[78] = jj_gen;
          break label_58;
        }
        jj_consume_token(S);
      }
start = true;
         documentHandler.startSelector(l);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case CUSTOM_PROPERTY:{
        declaration();
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      label_59:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case SEMICOLON:{
          ;
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          break label_59;
        }
        jj_consume_token(SEMICOLON);
        label_60:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case S:{
            ;
            break;
            }
          default:
            jj_la1[81] = jj_gen;
            break label_60;
          }
          jj_consume_token(S);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IDENT:
        case CUSTOM_PROPERTY:{
          declaration();
          break;
          }
        default:
          jj_la1[82] = jj_gen;
          ;
        }
      }
      jj_consume_token(RBRACE);
      label_61:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          break label_61;
        }
        jj_consume_token(S);
      }
    } catch (ThrowedParseException e) {
if (errorHandler != null) {
         LocatorImpl li = new LocatorImpl(this,
                                          e.e.currentToken.next.beginLine,
                                          e.e.currentToken.next.beginColumn-1);
         reportError(li, e.e);
     }
    } catch (ParseException e) {
reportError(getLocator(), e);
     skipStatement();
     // reportWarningSkipText(getLocator(), skipStatement());

    } catch (TokenMgrError e) {
reportWarningSkipText(getLocator(), skipStatement());
    } finally {
if (start) {
         documentHandler.endSelector(l);
     }
    }
  }

  final public SelectorList selectorList() throws ParseException {SelectorListImpl selectors = new SelectorListImpl();
    Selector selector;
    selector = selector();
    label_62:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        break label_62;
      }
      jj_consume_token(COMMA);
      label_63:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[85] = jj_gen;
          break label_63;
        }
        jj_consume_token(S);
      }
selectors.addSelector(selector);
      selector = selector();
    }
selectors.addSelector(selector);
    {if ("" != null) return selectors;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Selector selector() throws ParseException {Selector selector;
    char    comb;
    try {
      selector = simple_selector(null, ' ');
      label_64:
      while (true) {
        if (jj_2_9(2)) {
          ;
        } else {
          break label_64;
        }
        comb = combinator();
        selector = simple_selector(selector, comb);
      }
      label_65:
      while (true) {
        if (jj_2_10(2)) {
          ;
        } else {
          break label_65;
        }
        jj_consume_token(S);
      }
{if ("" != null) return selector;}
    } catch (ParseException e) {
/*
     Token t = getToken(1);
     StringBuffer s = new StringBuffer();
     s.append(getToken(0).image);
     while ((t.kind != COMMA) && (t.kind != SEMICOLON) 
	    && (t.kind != LBRACE) && (t.kind != EOF)) {
	 s.append(t.image);
	 getNextToken();
	 t = getToken(1);
     }
     reportWarningSkipText(getLocator(), s.toString());
     */
     Token t = getToken(1);
     while ((t.kind != COMMA) && (t.kind != SEMICOLON)
            && (t.kind != LBRACE) && (t.kind != EOF)) {
         getNextToken();
         t = getToken(1);
     }

     {if (true) throw new ThrowedParseException(e);}
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Selector simple_selector(Selector selector, char comb) throws ParseException {SimpleSelector simple_current = null;
    Condition negcond = null;
    Condition cond = null;
    pseudoElt = null;
    Token subject = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ANY:
    case IDENT:
    case NAMESPACE_IDENT:{
      simple_current = element_name();
      label_66:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:
        case COLON:
        case HASH:{
          ;
          break;
          }
        default:
          jj_la1[86] = jj_gen;
          break label_66;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASH:{
          cond = hash(cond);
          break;
          }
        case DOT:{
          cond = _class(cond);
          break;
          }
        case LBRACKET:{
          cond = attrib(cond);
          break;
          }
        case COLON:{
          if (jj_2_11(2)) {
            cond = negation(cond);
          } else if (jj_2_12(2)) {
            cond = has(cond);
          } else if (jj_2_13(2)) {
            cond = pseudo(cond);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[87] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case HASH:{
      cond = hash(cond);
      label_67:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:
        case COLON:{
          ;
          break;
          }
        default:
          jj_la1[88] = jj_gen;
          break label_67;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          cond = _class(cond);
          break;
          }
        case LBRACKET:{
          cond = attrib(cond);
          break;
          }
        case COLON:{
          if (jj_2_14(2)) {
            cond = negation(cond);
          } else if (jj_2_15(2)) {
            cond = has(cond);
          } else if (jj_2_16(2)) {
            cond = pseudo(cond);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[89] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    case DOT:{
      cond = _class(cond);
      label_68:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:
        case DOT:
        case COLON:
        case HASH:{
          ;
          break;
          }
        default:
          jj_la1[90] = jj_gen;
          break label_68;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case HASH:{
          cond = hash(cond);
          break;
          }
        case DOT:{
          cond = _class(cond);
          break;
          }
        case LBRACKET:{
          cond = attrib(cond);
          break;
          }
        case COLON:{
          if (jj_2_17(2)) {
            cond = negation(cond);
          } else if (jj_2_18(2)) {
            cond = has(cond);
          } else if (jj_2_19(2)) {
            cond = pseudo(cond);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[98] = jj_gen;
      if (jj_2_29(2)) {
        cond = pseudo(cond);
        label_69:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:
          case COLON:
          case HASH:{
            ;
            break;
            }
          default:
            jj_la1[92] = jj_gen;
            break label_69;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case HASH:{
            cond = hash(cond);
            break;
            }
          case DOT:{
            cond = _class(cond);
            break;
            }
          case LBRACKET:{
            cond = attrib(cond);
            break;
            }
          case COLON:{
            if (jj_2_20(2)) {
              cond = negation(cond);
            } else if (jj_2_21(2)) {
              cond = has(cond);
            } else if (jj_2_22(2)) {
              cond = pseudo(cond);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[93] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else if (jj_2_30(2)) {
        cond = negation(cond);
        label_70:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case LBRACKET:
          case DOT:
          case COLON:
          case HASH:{
            ;
            break;
            }
          default:
            jj_la1[94] = jj_gen;
            break label_70;
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case HASH:{
            cond = hash(cond);
            break;
            }
          case DOT:{
            cond = _class(cond);
            break;
            }
          case LBRACKET:{
            cond = attrib(cond);
            break;
            }
          case COLON:{
            if (jj_2_23(2)) {
              cond = negation(cond);
            } else if (jj_2_24(2)) {
              cond = has(cond);
            } else if (jj_2_25(2)) {
              cond = pseudo(cond);
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
            break;
            }
          default:
            jj_la1[95] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:{
          cond = attrib(cond);
          label_71:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case LBRACKET:
            case DOT:
            case COLON:
            case HASH:{
              ;
              break;
              }
            default:
              jj_la1[96] = jj_gen;
              break label_71;
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case HASH:{
              cond = hash(cond);
              break;
              }
            case DOT:{
              cond = _class(cond);
              break;
              }
            case LBRACKET:{
              cond = attrib(cond);
              break;
              }
            case COLON:{
              if (jj_2_26(2)) {
                cond = negation(cond);
              } else if (jj_2_27(2)) {
                cond = has(cond);
              } else if (jj_2_28(2)) {
                cond = pseudo(cond);
              } else {
                jj_consume_token(-1);
                throw new ParseException();
              }
              break;
              }
            default:
              jj_la1[97] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[99] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SUBJECT:{
      subject = jj_consume_token(SUBJECT);
      break;
      }
    default:
      jj_la1[100] = jj_gen;
      ;
    }
if (simple_current == null) {
                        simple_current = selectorFactory.createElementSelector(null, null, getLocator());
            }
            if (cond != null) {
                        simple_current = selectorFactory.createConditionalSelector(simple_current, cond, getLocator());
            }

        if (subject != null && (simple_current instanceof SubjectSelector)){
           ((SubjectSelector)simple_current).setIsSubject(subject != null);
        }

            if (selector != null) {
                switch (comb) {
                case ' ':
                    selector = selectorFactory.createDescendantSelector(selector,
                                                                       simple_current, subject != null, getLocator());
                    break;
                case '+':
                    selector =
                        selectorFactory.createDirectAdjacentSelector((short) 1,
                                                                     selector,
                                                                     simple_current, getLocator());
                    break;
                case '>':
                    selector = selectorFactory.createChildSelector(selector,
                                                                  simple_current, subject != null, getLocator());
                        break;
                case '~':
                    selector =
                        selectorFactory.createGeneralAdjacentSelector((short) 1,
                                                                     selector,
                                                                     simple_current, getLocator());
                    break;
                default:
                    {if (true) throw new ParseException("invalid state. send a bug report");}
                }
            } else {
              selector= simple_current;
            }
            if (pseudoElt != null) {
              selector = selectorFactory.createChildSelector(selector,
                             selectorFactory.createPseudoElementSelector(null, pseudoElt, getLocator()), subject !=null, getLocator());
            }
            {if ("" != null) return selector;}
    throw new Error("Missing return statement in function");
  }

  final public Condition negation(Condition cond) throws ParseException {Selector s;
    jj_consume_token(COLON);
    jj_consume_token(NOT);
    label_72:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        break label_72;
      }
      jj_consume_token(S);
    }
    s = simple_selector(null, ' ');
    label_73:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[102] = jj_gen;
        break label_73;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPARAN);
Condition neg = conditionFactory.createNegativeCondition(s);

        // Merges the negative condition with the current one, if any.
        if (cond != null) {
                  cond = conditionFactory.createAndCondition(cond, neg);
            } else {
              cond = neg;
            }

        {if ("" != null) return cond;}
    throw new Error("Missing return statement in function");
  }

  final public Condition has(Condition cond) throws ParseException {Selector s;
    jj_consume_token(COLON);
    jj_consume_token(HAS);
    label_74:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[103] = jj_gen;
        break label_74;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PRECEDES:{
      jj_consume_token(PRECEDES);
      label_75:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[104] = jj_gen;
          break label_75;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[105] = jj_gen;
      ;
    }
    s = selector();
    label_76:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[106] = jj_gen;
        break label_76;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPARAN);
Condition has = conditionFactory.createHasCondition(s);

        // Merges the :has condition with the current one, if any.
        if (cond != null) {
                  cond = conditionFactory.createAndCondition(cond, has);
            } else {
              cond = has;
            }

        {if ("" != null) return cond;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Condition _class(Condition pred) throws ParseException {Token n;
Condition c;
    jj_consume_token(DOT);
    n = jj_consume_token(IDENT);
c = conditionFactory.createClassCondition(null, convertIdent(n.image));
          if (pred == null) {
              {if ("" != null) return c;}
          } else {
              {if ("" != null) return conditionFactory.createAndCondition(pred, c);}
          }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public SimpleSelector element_name() throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
String[] uriAndLocal1 = ParserUtil.getElementNSURIAndLocal(convertIdent(n.image), proxyNSMapping);
                {if ("" != null) return selectorFactory.createElementSelector(uriAndLocal1[0], uriAndLocal1[1], getLocator());}
      break;
      }
    case NAMESPACE_IDENT:{
      n = jj_consume_token(NAMESPACE_IDENT);
String[] uriAndLocal2 = ParserUtil.getElementNSURIAndLocal(convertIdent(n.image), proxyNSMapping);
                {if ("" != null) return selectorFactory.createElementSelector(uriAndLocal2[0], uriAndLocal2[1], getLocator());}
      break;
      }
    case ANY:{
      jj_consume_token(ANY);
{if ("" != null) return selectorFactory.createElementSelector(null, null, getLocator());}
      break;
      }
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Condition attrib(Condition pred) throws ParseException {int cases = 0;
    Token att = null;
    Token val = null;
    String attValue = null;
    jj_consume_token(LBRACKET);
    label_77:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[108] = jj_gen;
        break label_77;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      att = jj_consume_token(IDENT);
      break;
      }
    case NAMESPACE_IDENT:{
      att = jj_consume_token(NAMESPACE_IDENT);
      break;
      }
    default:
      jj_la1[109] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_78:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[110] = jj_gen;
        break label_78;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DASHMATCH:
    case INCLUDES:
    case EQ:
    case BEGINS:
    case ENDS:
    case CONTAINS:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
cases = 1;
        break;
        }
      case INCLUDES:{
        jj_consume_token(INCLUDES);
cases = 2;
        break;
        }
      case DASHMATCH:{
        jj_consume_token(DASHMATCH);
cases = 3;
        break;
        }
      case BEGINS:{
        jj_consume_token(BEGINS);
cases = 4;
        break;
        }
      case ENDS:{
        jj_consume_token(ENDS);
cases = 5;
        break;
        }
      case CONTAINS:{
        jj_consume_token(CONTAINS);
cases = 6;
        break;
        }
      default:
        jj_la1[111] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_79:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[112] = jj_gen;
          break label_79;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:{
        val = jj_consume_token(IDENT);
attValue = val.image;
        break;
        }
      case STRING:{
        val = jj_consume_token(STRING);
attValue = convertStringIndex(val.image, 1, val.image.length() -1);
        break;
        }
      default:
        jj_la1[113] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_80:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[114] = jj_gen;
          break label_80;
        }
        jj_consume_token(S);
      }
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      ;
    }
    jj_consume_token(RBRACKET);
String name = convertIdent(att.image);
      Condition c;
      switch (cases) {
          case 0:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, null);
          }
          break;
          case 1: {
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          case 2:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createOneOfAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          case 3:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createBeginHyphenAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          case 4:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createBeginWithAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          case 5:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createEndWithAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          case 6:{
                  String[] nsAndLocal = ParserUtil.getAttrNSURIAndLocal(name, proxyNSMapping);
                  c = conditionFactory.createContainsAttributeCondition(nsAndLocal[1],
                                  nsAndLocal[0], false, attValue);
          }
          break;
          default:
          // never reached.
          c = null;
      }
      if (pred == null) {
          {if ("" != null) return c;}
      } else {
          {if ("" != null) return conditionFactory.createAndCondition(pred, c);}
      }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Condition pseudo(Condition pred) throws ParseException {Token n;
Token language;
Condition c;
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      n = jj_consume_token(IDENT);
String s = convertIdent(n.image);
//	    if (s.equals("first-letter") || s.equals("first-line")) {
//  			if (pseudoElt != null) {
//  			    throw new CSSParseException("duplicate pseudo element definition " 
//  							+ s, getLocator());
//  			} else {
//  			    pseudoElt = s;
//  			    return pred;
//  			}
//	    } else {
                        c = conditionFactory.createPseudoClassCondition(null, s, 1);
                        if (pred == null) {
                            {if ("" != null) return c;}
                        } else {
                            {if ("" != null) return conditionFactory.createAndCondition(pred, c);}
                        }
//	    }

      break;
      }
    case PSEUDO_NTH:{
      n = jj_consume_token(PSEUDO_NTH);
String s = convertIdent(n.image);

                if (pseudoElt != null) {
                    {if (true) throw new CSSParseException("duplicate pseudo element definition "
                                                + s, getLocator());}
                } else {

                    int open = s.indexOf("(");
            int close = s.indexOf(")", open);

                    String pseudo = s.substring(0, open);
            int pseudoNth = Integer.parseInt(s.substring(open + 1, close));

                        c = conditionFactory.createPseudoClassCondition(null, pseudo, pseudoNth);
                        if (pred == null) {
                            {if ("" != null) return c;}
                        } else {
                            {if ("" != null) return conditionFactory.createAndCondition(pred, c);}
                        }
                }
      break;
      }
    case FUNCTION:{
      c = functional_pseudo(pred);
if (pred == null) {
                    {if ("" != null) return c;}
                } else {
                    {if ("" != null) return conditionFactory.createAndCondition(pred, c);}
                }
      break;
      }
    default:
      jj_la1[117] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * Handle all CSS3 pseudo-functions.
 * @exception ParseException exception during the parse
 */
  final public Condition functional_pseudo(Condition pred) throws ParseException {Token n = null;
 Token ident = null;

 char cycle_op = '+';
 char delta_op = '+';

 Token nthExprPrim = null;
 Token nthExpr = null;
 Token delta = null;
    n = jj_consume_token(FUNCTION);
    label_81:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[118] = jj_gen;
        break label_81;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NTH_EXPR:{
      nthExpr = jj_consume_token(NTH_EXPR);
      break;
      }
    case NUMBER:{
      nthExprPrim = jj_consume_token(NUMBER);
      break;
      }
    case IDENT:{
      ident = jj_consume_token(IDENT);
      break;
      }
    default:
      jj_la1[119] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_82:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[120] = jj_gen;
        break label_82;
      }
      jj_consume_token(S);
    }
    jj_consume_token(RPARAN);
String f = convertIdent(n.image);
         Condition d;

         if (f.equals("lang(")) {
                if (ident != null) {
                      d = conditionFactory.createLangCondition(convertIdent(ident.image));
                    } else {
                  {if (true) throw new CSSParseException("Invalid argument for " + f, getLocator());}
                    }
                 } else {
                      // The nth- function collection.         
                  int fDelta = 0;
                  int fCycle = 0;

                  if (nthExprPrim != null){
                        String nes = convertIdent(nthExprPrim.image).toLowerCase();
                        try {
                                fDelta = Float.valueOf(nes).intValue();
                        } catch (NumberFormatException e){
                           {if (true) throw new CSSParseException("Invalid number argument for " + f, getLocator());}
                        }
                  } else if (nthExpr != null){
                        String nes = convertIdent(nthExpr.image).toLowerCase();
                        String parts[] = nes.replaceAll("(\\s)*", "").split("n");
                        try {
                                if ("-".equals(parts[0])){
                              // Like in -n+7 (the first 7 items.)
                                  fCycle = -1;
                                  if (parts.length > 1){
                                        fDelta = Float.valueOf(parts[1]).intValue();
                                  }
                           } else if ("".equals(parts[0])){
                              // Like in n+1 (the first items after the first one.)
                                  fCycle = 1;
                                  if (parts.length > 1){
                                        fDelta = Float.valueOf(parts[1]).intValue();
                                  }
                           } else {
                              // Like in +3n+7
                                  fCycle = Float.valueOf(parts[0]).intValue();
                                  if (parts.length > 1){
                                        fDelta = Float.valueOf(parts[1]).intValue();
                                  }
                           }
                        } catch (NumberFormatException e){
                           {if (true) throw new CSSParseException("Invalid number argument for " + f, getLocator());}
                        }
                  } else if (ident != null) {
                    String oes = convertIdent(ident.image).toLowerCase();
                    if ("odd".equals(oes)) {
                      fCycle = 2;
                      fDelta = 1;
                    } else if ("even".equals(oes)) {
                      fCycle = 2;
                      fDelta = 0;
                    } else if ("n".equals(oes)) {
                      fCycle = 1;
                      fDelta = 0;
                    } else {
                       // If might be a negative number.	               
                       try{
                                fCycle = 0;
                                fDelta = Float.valueOf(oes).intValue();
                       } catch (NumberFormatException e){
                        // Or an expression
                        if (oes.startsWith("n")){
                                fCycle = 1;
                                try {
                                        fDelta = Float.valueOf(oes.substring(1)).intValue();
                                } catch (NumberFormatException ex) {
                                        {if (true) throw new CSSParseException("Invalid argument " + oes + " for " + f, getLocator());}
                                }
                        } else {
                                {if (true) throw new CSSParseException("Invalid argument " + oes + " for " + f, getLocator());}
                        }

                       }
                    }
                  }

                  d = conditionFactory.createStructuralCondition(f, fCycle, fDelta);
         }

                 if (pred == null) {
                                {if ("" != null) return d;}
                 } else {
                                {if ("" != null) return conditionFactory.createAndCondition(pred, d);}
                 }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public Condition hash(Condition pred) throws ParseException {Token n;
    n = jj_consume_token(HASH);
Condition d =
          conditionFactory.createIdCondition(n.image.substring(1));
      if (pred == null) {
          {if ("" != null) return d;}
      } else {
          {if ("" != null) return conditionFactory.createAndCondition(pred, d);}
      }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public void declaration() throws ParseException {boolean important = false;
  String name;
  LexicalUnit exp;
  Token save;
    try {
      name = property();
save = token;
      jj_consume_token(COLON);
      label_83:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          break label_83;
        }
        jj_consume_token(S);
      }
      exp = expr(null);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IMPORTANT_SYM:{
        important = prio();
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        ;
      }
documentHandler.property(name, exp, important);
    } catch (JumpException e) {
skipAfterExpression();
     // reportWarningSkipText(getLocator(), skipAfterExpression());

    } catch (NumberFormatException e) {
if (errorHandler != null) {
         errorHandler.error(new CSSParseException("Invalid number "
                                                  + e.getMessage(),
                                                  getLocator(),
                                                  e));
     }
     reportWarningSkipText(getLocator(), skipAfterExpression());
    } catch (ParseException e) {
if (errorHandler != null) {
         if (e.currentToken != null) {
             LocatorImpl li = new LocatorImpl(this,
                                              e.currentToken.next.beginLine,
                                              e.currentToken.next.beginColumn-1);
             reportError(li, e);
         } else {
             reportError(getLocator(), e);
         }
         skipAfterExpression();
         /*
	 LocatorImpl loc = (LocatorImpl) getLocator();
	 loc.column--;
	 reportWarningSkipText(loc, skipAfterExpression());
	 */
     } else {
         skipAfterExpression();
     }
    }
  }

/**
 * @exception ParseException exception during the parse
 */
  final public boolean prio() throws ParseException {
    jj_consume_token(IMPORTANT_SYM);
    label_84:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[123] = jj_gen;
        break label_84;
      }
      jj_consume_token(S);
    }
{if ("" != null) return true;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl operator(LexicalUnitImpl prev) throws ParseException {Token n;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DIV:{
      n = jj_consume_token(DIV);
      label_85:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[124] = jj_gen;
          break label_85;
        }
        jj_consume_token(S);
      }
{if ("" != null) return LexicalUnitImpl.createSlash(n.beginLine,
                                                       n.beginColumn,
                                                       prev);}
      break;
      }
    case COMMA:{
      n = jj_consume_token(COMMA);
      label_86:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[125] = jj_gen;
          break label_86;
        }
        jj_consume_token(S);
      }
{if ("" != null) return LexicalUnitImpl.createComma(n.beginLine,
                                                         n.beginColumn,
                                                         prev);}
      break;
      }
    case ANY:{
      n = jj_consume_token(ANY);
      label_87:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          break label_87;
        }
        jj_consume_token(S);
      }
{if ("" != null) return LexicalUnitImpl.createMultiply(n.beginLine,
    n.beginColumn,
    prev);}
      break;
      }
    case PLUS:{
      n = jj_consume_token(PLUS);
      label_88:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[127] = jj_gen;
          break label_88;
        }
      }
{if ("" != null) return LexicalUnitImpl.createPlus(n.beginLine,
    n.beginColumn,
    prev);}
      break;
      }
    case MINUS:{
      n = jj_consume_token(MINUS);
      label_89:
      while (true) {
        jj_consume_token(S);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[128] = jj_gen;
          break label_89;
        }
      }
{if ("" != null) return LexicalUnitImpl.createMinus(n.beginLine,
    n.beginColumn,
    prev);}
      break;
      }
    default:
      jj_la1[129] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl expr(LexicalUnitImpl prev) throws ParseException {LexicalUnitImpl first,result;
    result = termWithParant(prev);
first = result;
        result=last(result);
    label_90:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:
      case COMMA:
      case DIV:
      case ANY:
      case LPARAN:
      case STRING:
      case NUMBER:
      case IDENT:
      case CUSTOM_PROPERTY:
      case URL:
      case NAMESPACE_IDENT:
      case PERCENTAGE:
      case DPI:
      case PT:
      case MM:
      case CM:
      case PC:
      case IN:
      case PX:
      case EMS:
      case RMS:
      case EXS:
      case DEG:
      case RAD:
      case GRAD:
      case MS:
      case SECOND:
      case HZ:
      case KHZ:
      case DIMEN:
      case HASH:
      case UNICODERANGE:
      case FUNCTION:{
        ;
        break;
        }
      default:
        jj_la1[130] = jj_gen;
        break label_90;
      }
      if (jj_2_31(2)) {
        result = operator(result);
      } else {
        ;
      }
      result = termWithParant(result);
result = last(result);
    }
{if ("" != null) return first;}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl termWithParant(LexicalUnitImpl prev) throws ParseException {LexicalUnitImpl result = null;
  LexicalUnitImpl first = null;
  Token n = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case STRING:
    case NUMBER:
    case IDENT:
    case CUSTOM_PROPERTY:
    case URL:
    case NAMESPACE_IDENT:
    case PERCENTAGE:
    case DPI:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case RMS:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case FUNCTION:{
      result = term(prev);
first = result;
      break;
      }
    case LPARAN:{
      n = jj_consume_token(LPARAN);
      label_91:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          break label_91;
        }
        jj_consume_token(S);
      }
result = LexicalUnitImpl.createLParan(
                                n.beginLine, n.beginColumn, prev);
                        first = result;
      result = expr(result);
result = last(result);
      n = jj_consume_token(RPARAN);
      label_92:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[132] = jj_gen;
          break label_92;
        }
        jj_consume_token(S);
      }
result = LexicalUnitImpl.createRParan(
                                n.beginLine, n.beginColumn, result);
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return first;}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public char unaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:{
      jj_consume_token(MINUS);
{if ("" != null) return '-';}
      break;
      }
    case PLUS:{
      jj_consume_token(PLUS);
{if ("" != null) return '+';}
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl term(LexicalUnitImpl prev) throws ParseException {LexicalUnitImpl result = null;
  Token n = null;
  char op = ' ';
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case NUMBER:
    case PERCENTAGE:
    case DPI:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case RMS:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case FUNCTION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        op = unaryOperator();
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NUMBER:{
        n = jj_consume_token(NUMBER);
result = LexicalUnitImpl.createNumber(n.beginLine, n.beginColumn,
                                                prev, number(op, n, 0));
        break;
        }
      case PERCENTAGE:{
        n = jj_consume_token(PERCENTAGE);
result = LexicalUnitImpl.createPercentage(n.beginLine, n.beginColumn,
                                                    prev, number(op, n, 1));
        break;
        }
      case DPI:{
        n = jj_consume_token(DPI);
result = LexicalUnitImpl.createDPI(n.beginLine, n.beginColumn,
              prev, number(op, n, 2));
        break;
        }
      case PT:{
        n = jj_consume_token(PT);
result = LexicalUnitImpl.createPT(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case CM:{
        n = jj_consume_token(CM);
result = LexicalUnitImpl.createCM(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case MM:{
        n = jj_consume_token(MM);
result = LexicalUnitImpl.createMM(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case PC:{
        n = jj_consume_token(PC);
result = LexicalUnitImpl.createPC(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case IN:{
        n = jj_consume_token(IN);
result = LexicalUnitImpl.createIN(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case PX:{
        n = jj_consume_token(PX);
result = LexicalUnitImpl.createPX(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case EMS:{
        n = jj_consume_token(EMS);
result = LexicalUnitImpl.createEMS(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 2));
        break;
        }
      case RMS:{
        n = jj_consume_token(RMS);
result = LexicalUnitImpl.createRMS(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
        }
      case EXS:{
        n = jj_consume_token(EXS);
result = LexicalUnitImpl.createEXS(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 2));
        break;
        }
      case DEG:{
        n = jj_consume_token(DEG);
result = LexicalUnitImpl.createDEG(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
        }
      case RAD:{
        n = jj_consume_token(RAD);
result = LexicalUnitImpl.createRAD(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
        }
      case GRAD:{
        n = jj_consume_token(GRAD);
result = LexicalUnitImpl.createGRAD(n.beginLine, n.beginColumn,
                                              prev, number(op, n, 3));
        break;
        }
      case SECOND:{
        n = jj_consume_token(SECOND);
result = LexicalUnitImpl.createS(n.beginLine, n.beginColumn,
                                           prev, number(op, n, 1));
        break;
        }
      case MS:{
        n = jj_consume_token(MS);
result = LexicalUnitImpl.createMS(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case HZ:{
        n = jj_consume_token(HZ);
result = LexicalUnitImpl.createHZ(n.beginLine, n.beginColumn,
                                            prev, number(op, n, 2));
        break;
        }
      case KHZ:{
        n = jj_consume_token(KHZ);
result = LexicalUnitImpl.createKHZ(n.beginLine, n.beginColumn,
                                             prev, number(op, n, 3));
        break;
        }
      case DIMEN:{
        n = jj_consume_token(DIMEN);
String s = n.image;
            int i = 0;
            while (i < s.length()
                   && (Character.isDigit(s.charAt(i)) || (s.charAt(i) == '.'))) {
                i++;
            }
            result = LexicalUnitImpl.createDimen(n.beginLine, n.beginColumn, prev,
                                                 Float.valueOf(s.substring(0, i)).floatValue(),
                                                 s.substring(i));
        break;
        }
      case FUNCTION:{
        result = function(op, prev);
        break;
        }
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    case STRING:
    case IDENT:
    case CUSTOM_PROPERTY:
    case URL:
    case NAMESPACE_IDENT:
    case HASH:
    case UNICODERANGE:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING:{
        n = jj_consume_token(STRING);
result = LexicalUnitImpl.createString
                              (n.beginLine, n.beginColumn, prev,
                                                 convertStringIndex(n.image, 1,
                                                                   n.image.length() -1));
        break;
        }
      case NAMESPACE_IDENT:{
        n = jj_consume_token(NAMESPACE_IDENT);
result = LexicalUnitImpl.createIdent
                  (n.beginLine, n.beginColumn, prev, convertIdent(n.image));
        break;
        }
      case CUSTOM_PROPERTY:{
        n = jj_consume_token(CUSTOM_PROPERTY);
String s = convertIdent(n.image);
         result = LexicalUnitImpl.createIdent
                 (n.beginLine, n.beginColumn, prev, s);
        break;
        }
      case IDENT:{
        n = jj_consume_token(IDENT);
String s = convertIdent(n.image);
              if ("inherit".equals(s))
              {
                result = LexicalUnitImpl.createInherit
                          (n.beginLine, n.beginColumn, prev);
              }
              else if ("initial".equals(s))
              {
                result = LexicalUnitImpl.createInitial
                          (n.beginLine, n.beginColumn, prev);
              }
              else if ("unset".equals(s))
              {
                result = LexicalUnitImpl.createUnset
                          (n.beginLine, n.beginColumn, prev);
              }
              else
              {
                result = LexicalUnitImpl.createIdent
                          (n.beginLine, n.beginColumn, prev, s);
              }

          /* /
         Auto correction code used in the CSS Validator but must not
          be used by a conformant CSS2 parser.
	 * Common error :
	 * H1 {
	 *   color : black
	 *   background : white
	 * }
	 *
	Token t = getToken(1);
	Token semicolon = new Token();
	semicolon.kind = SEMICOLON;
	semicolon.image = ";";
	if (t.kind == COLON) {
	    // @@SEEME. (generate a warning?)
	    // @@SEEME if expression is a single ident, 
	       generate an error ?
	    rejectToken(semicolon);
	    
	    result = prev;
	}
	/ */

        break;
        }
      case HASH:{
        result = hexcolor(prev);
        break;
        }
      case URL:{
        result = url(prev);
        break;
        }
      case UNICODERANGE:{
        result = unicode(prev);
        break;
        }
      default:
        jj_la1[137] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[138] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_93:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[139] = jj_gen;
        break label_93;
      }
      jj_consume_token(S);
    }
{if ("" != null) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * Handle all CSS2 functions.
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl function(char operator, LexicalUnitImpl prev) throws ParseException {Token n;
 LexicalUnit params = null;
    n = jj_consume_token(FUNCTION);
    label_94:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[140] = jj_gen;
        break label_94;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case LPARAN:
    case STRING:
    case NUMBER:
    case IDENT:
    case CUSTOM_PROPERTY:
    case URL:
    case NAMESPACE_IDENT:
    case PERCENTAGE:
    case DPI:
    case PT:
    case MM:
    case CM:
    case PC:
    case IN:
    case PX:
    case EMS:
    case RMS:
    case EXS:
    case DEG:
    case RAD:
    case GRAD:
    case MS:
    case SECOND:
    case HZ:
    case KHZ:
    case DIMEN:
    case HASH:
    case UNICODERANGE:
    case FUNCTION:{
      params = expr(null);
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      ;
    }
    jj_consume_token(RPARAN);
if (operator != ' ') {
            {if (true) throw new CSSParseException("invalid operator before a function.",
                                        getLocator());}
        }
        String f = convertIdent(n.image);
        LexicalUnitImpl l = (LexicalUnitImpl) params;
        boolean loop = true;
        if ("rgb(".equals(f)) {
            // this is a RGB declaration (e.g. rgb(255, 50%, 0) )
            int i = 0;
            while (loop && l != null && i < 5) {
                switch (i) {
                    case 0:
                    case 2:
                    case 4:
                        if ((l.getLexicalUnitType() != LexicalUnit.SAC_INTEGER)
                            && (l.getLexicalUnitType() != LexicalUnit.SAC_PERCENTAGE)) {
                            loop = false;
                        }
                        break;
                    case 1:
                    case 3:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_OPERATOR_COMMA) {
                            loop = false;
                        }
                        break;
                    default:
                        {if (true) throw new ParseException("implementation error");}
                }
                if (loop) {
                    l = (LexicalUnitImpl) l.getNextLexicalUnit();
                    i ++;
                }
            }
            if ((i == 5) && loop && (l == null)) {
                {if ("" != null) return LexicalUnitImpl.createRGBColor(n.beginLine,
                                                      n.beginColumn,
                                                      prev, params);}
            } else {
                if (errorHandler != null) {
                    String errorText;
                    Locator loc;
                    if (i < 5) {
                        if (params == null) {
                            loc = new LocatorImpl(this, n.beginLine,
                                                  n.beginColumn-1);
                            errorText = "not enough parameters.";
                        } else if (l == null) {
                            loc = new LocatorImpl(this, n.beginLine,
                                                  n.beginColumn-1);
                            errorText = "not enough parameters: "
                                + params.toString();
                        } else {
                            loc = new LocatorImpl(this, l.getLineNumber(),
                                                  l.getColumnNumber());
                            errorText = "invalid parameter: "
                                + l.toString();
                        }
                    } else {
                        loc = new LocatorImpl(this, l.getLineNumber(),
                                              l.getColumnNumber());
                        errorText = "too many parameters: "
                            + l.toString();
                    }
                    errorHandler.error(new CSSParseException(errorText, loc));
                }

                {if (true) throw new JumpException();}
                }
          } else if ("rgba(".equals(f)) {
            // this is a RGBA declaration (e.g. rgb(255, 50%, 0, 0.5) )
            // Syntactically a <number>. The uniform opacity setting to be applied across an entire object. 
            // Any values outside the range 0.0 (fully transparent) to 1.0 (fully opaque) will be clamped to this range. 
            // If the object is a container element, then the effect is as if the contents of the container element were 
            // blended against the current background using a mask where the value of each pixel of the mask is <alphavalue>. 
            int i = 0;
            while (loop && l != null && i < 7) {
                switch (i) {
                    case 0:
                    case 2:
                    case 4:
                        if ((l.getLexicalUnitType() != LexicalUnit.SAC_INTEGER)
                            && (l.getLexicalUnitType() != LexicalUnit.SAC_PERCENTAGE)) {
                            loop = false;
                        }
                        break;
                        case 6:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_INTEGER
                                && l.getLexicalUnitType() != LexicalUnit.SAC_REAL
                                && l.getLexicalUnitType() != LexicalUnit.SAC_PERCENTAGE
                                ) {
                                // The alpha is a real number between 0 and 1.
                            loop = false;
                        }
                        break;
                    case 1:
                    case 3:
                    case 5:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_OPERATOR_COMMA) {
                            loop = false;
                        }
                        break;
                    default:
                        {if (true) throw new ParseException("implementation error");}
                }
                if (loop) {
                    l = (LexicalUnitImpl) l.getNextLexicalUnit();
                    i ++;
                }
            }
            if ((i == 7) && loop && (l == null)) {
                {if ("" != null) return LexicalUnitImpl.createRGBColor(n.beginLine,
                                                      n.beginColumn,
                                                      prev, params);}
            } else {
                if (errorHandler != null) {
                    String errorText;
                    Locator loc;
                    if (i < 7) {
                        if (params == null) {
                            loc = new LocatorImpl(this, n.beginLine,
                                                  n.beginColumn-1);
                            errorText = "not enough parameters.";
                        } else if (l == null) {
                            loc = new LocatorImpl(this, n.beginLine,
                                                  n.beginColumn-1);
                            errorText = "not enough parameters: "
                                + params.toString();
                        } else {
                            loc = new LocatorImpl(this, l.getLineNumber(),
                                                  l.getColumnNumber());
                            errorText = "invalid parameter: "
                                + l.toString();
                        }
                    } else {
                        loc = new LocatorImpl(this, l.getLineNumber(),
                                              l.getColumnNumber());
                        errorText = "too many parameters: "
                            + l.toString();
                    }
                    errorHandler.error(new CSSParseException(errorText, loc));
                }

                {if (true) throw new JumpException();}
            }
        } else if ("counter".equals(f)) {
            int i = 0;
            while (loop && l != null && i < 3) {
                switch (i) {
                    case 0:
                    case 2:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_IDENT) {
                            loop = false;
                        }
                        break;
                    case 1:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_OPERATOR_COMMA) {
                            loop = false;
                        }
                        break;
                    default:
                        {if (true) throw new ParseException("implementation error");}
                }
                l = (LexicalUnitImpl) l.getNextLexicalUnit();
                i ++;
            }
            if (((i == 1) || (i == 3)) && loop && (l == null)) {
                {if ("" != null) return LexicalUnitImpl.createCounter(n.beginLine, n.beginColumn,
                                                     prev, params);}
            }

        } else if ("counters(".equals(f)) {

            int i = 0;
            while (loop && l != null && i < 5) {
                switch (i) {
                    case 0:
                    case 4:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_IDENT) {
                            loop = false;
                        }
                        break;
                    case 2:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_STRING_VALUE) {
                            loop = false;
                        }
                        break;
                    case 1:
                    case 3:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_OPERATOR_COMMA) {
                            loop = false;
                        }
                        break;
                    default:
                        {if (true) throw new ParseException("implementation error");}
                }
                l = (LexicalUnitImpl) l.getNextLexicalUnit();
                i ++;
            }
            if (((i == 3) || (i == 5)) && loop && (l == null)) {
                {if ("" != null) return LexicalUnitImpl.createCounters(n.beginLine, n.beginColumn,
                                                      prev, params);}
            }
        } else if ("attr(".equals(f)) {
            if ((l != null)
                && (l.getNextLexicalUnit() == null)
                && (l.getLexicalUnitType() == LexicalUnit.SAC_IDENT)) {
                {if ("" != null) return LexicalUnitImpl.createAttr(l.getLineNumber(),
                                                  l.getColumnNumber(),
                                                  prev, l.getStringValue());}
            }
        } else if ("rect(".equals(f)) {
            int i = 0;
            while (loop && l != null && i < 7) {
                switch (i) {
                    case 0:
                    case 2:
                    case 4:
                    case 6:
                        switch (l.getLexicalUnitType()) {
                        case LexicalUnit.SAC_INTEGER:
                            if (l.getIntegerValue() != 0) {
                                loop = false;
                            }
                            break;
                        case LexicalUnit.SAC_IDENT:
                            if (!l.getStringValue().equals("auto")) {
                                loop = false;
                            }
                            break;
                        case LexicalUnit.SAC_EM:
                        case LexicalUnit.SAC_EX:
                        case LexicalUnit.SAC_PIXEL:
                        case LexicalUnit.SAC_CENTIMETER:
                        case LexicalUnit.SAC_MILLIMETER:
                        case LexicalUnit.SAC_INCH:
                        case LexicalUnit.SAC_POINT:
                        case LexicalUnit.SAC_PICA:
                            // nothing
                            break;
                        default:
                            loop = false;
                        }
                        break;
                    case 1:
                    case 3:
                    case 5:
                        if (l.getLexicalUnitType() != LexicalUnit.SAC_OPERATOR_COMMA) {
                            loop = false;
                        }
                        break;
                    default:
                        {if (true) throw new ParseException("implementation error");}
                }
                l = (LexicalUnitImpl) l.getNextLexicalUnit();
                i ++;
            }
            if ((i == 7) && loop && (l == null)) {
                {if ("" != null) return LexicalUnitImpl.createRect(n.beginLine, n.beginColumn,
                                                  prev, params);}
            }
        }
        {if ("" != null) return LexicalUnitImpl.createFunction(n.beginLine, n.beginColumn, prev,
                                              f.substring(0,
                                                        f.length() -1),
                                              params);}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl unicode(LexicalUnitImpl prev) throws ParseException {Token n;
    n = jj_consume_token(UNICODERANGE);
LexicalUnitImpl params = null;
     String s = n.image.substring(2);
     int index = s.indexOf('-');
     if (index == -1) {
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s, 16));
     } else {
         String s1 = s.substring(0, index);
         String s2 = s.substring(index);

         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s1, 16));
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, Integer.parseInt(s2, 16));
     }

     {if ("" != null) return LexicalUnitImpl.createUnicodeRange(n.beginLine, n.beginColumn,
                                               prev, params);}
    throw new Error("Missing return statement in function");
  }

  final public LexicalUnitImpl url(LexicalUnitImpl prev) throws ParseException {Token n;
    n = jj_consume_token(URL);
String urlname = n.image.substring(4, n.image.length()-1).trim();
   if (urlname.length() > 0 && (urlname.charAt(0) == '"'
       || urlname.charAt(0) == '\'')) {
       urlname = urlname.substring(1, urlname.length()-1);
   }
   {if ("" != null) return LexicalUnitImpl.createURL(n.beginLine, n.beginColumn, prev, urlname);}
    throw new Error("Missing return statement in function");
  }

/**
 * @exception ParseException exception during the parse
 */
  final public LexicalUnitImpl hexcolor(LexicalUnitImpl prev) throws ParseException {Token n;
    n = jj_consume_token(HASH);
int r;
     LexicalUnitImpl first, params = null;
     String s = n.image.substring(1);

     if (s.length() == 3) {
         String sh = s.substring(0,1);
         r = Integer.parseInt(sh+sh, 16);
         first = params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                        params, r);
         params = LexicalUnitImpl.createComma(n.beginLine, n.beginColumn,
                                                 params);
         sh = s.substring(1,2);
         r = Integer.parseInt(sh+sh, 16);
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, r);
         params = LexicalUnitImpl.createComma(n.beginLine, n.beginColumn,
                                                 params);
         sh = s.substring(2,3);
         r = Integer.parseInt(sh+sh, 16);
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, r);
     } else if (s.length() == 6) {
         r = Integer.parseInt(s.substring(0,2), 16);
         first = params = LexicalUnitImpl.createInteger(n.beginLine,
                                                        n.beginColumn,
                                                        params, r);
         params = LexicalUnitImpl.createComma(n.beginLine, n.beginColumn,
                                                 params);
         r = Integer.parseInt(s.substring(2,4), 16);
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, r);
         params = LexicalUnitImpl.createComma(n.beginLine, n.beginColumn,
                                                 params);
         r = Integer.parseInt(s.substring(4,6), 16);
         params = LexicalUnitImpl.createInteger(n.beginLine, n.beginColumn,
                                                params, r);
     } else {
         first = null;
         {if (true) throw new CSSParseException("invalid hexadecimal notation for RGB: " + s,
                                     getLocator());}
     }
     {if ("" != null) return LexicalUnitImpl.createRGBColor(n.beginLine, n.beginColumn,
                                           prev, first);}
    throw new Error("Missing return statement in function");
  }

  float number(char operator, Token n, int lengthUnit) throws ParseException {String image  = n.image;
    float f = 0;

    if (lengthUnit != 0) {
        image = image.substring(0, image.length() - lengthUnit);
    }
    f = Float.valueOf(image).floatValue();
    return (operator == '-')? -f: f;
  }

  int integer(char operator, String image) throws ParseException, ParseException {int i = 0;

    i = Float.valueOf(image).intValue();
    return (operator == '-')? -i: i;
  }

  String skipStatementNoSemicolon() throws ParseException {StringBuffer s = new StringBuffer();
    Token tok = getToken(0);
    if (tok.image != null) {
        s.append(tok.image);
    }
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            return null;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            getNextToken();
            s.append(skip_to_matching_brace());
            getNextToken();
            tok = getToken(1);
            break;
        }
        getNextToken();
    }

    // skip white space
    while (true) {
        if (tok.kind != S) {
            break;
        }
        tok = getNextToken();
        tok = getToken(1);
    }

    return s.toString().trim();
  }

  String skipStatement() throws ParseException {StringBuffer s = new StringBuffer();
    Token tok = getToken(0);
    if (tok.image != null) {
        s.append(tok.image);
    }
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            return null;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            getNextToken();
            s.append(skip_to_matching_brace());
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == RBRACE) {
            getNextToken();
            tok = getToken(1);
            break;
        } else if (tok.kind == SEMICOLON) {
            getNextToken();
            tok = getToken(1);
            break;
        }
        getNextToken();
    }

    // skip white space
    while (true) {
        if (tok.kind != S) {
            break;
        }
        tok = getNextToken();
        tok = getToken(1);
    }

    return s.toString().trim();
  }

  String skip_to_matching_brace() throws ParseException {StringBuffer s = new StringBuffer();
    Token tok;
    int nesting = 1;
    while (true) {
        tok = getToken(1);
        if (tok.kind == EOF) {
            break;
        }
        s.append(tok.image);
        if (tok.kind == LBRACE) {
            nesting++;
        } else if (tok.kind == RBRACE) {
            nesting--;
            if (nesting == 0) {
                break;
            }
        }
        getNextToken();
    }
    return s.toString();
  }

  String convertStringIndex(String s, int start, int len) throws ParseException {StringBuffer buf = new StringBuffer(len);
    int index = start;

    while (index < len) {
        char c = s.charAt(index);
        if (c == '\\') {
            if (++index < len) {
                c = s.charAt(index);
                switch (c) {
                case '0': case '1': case '2': case '3': case '4':
                case '5': case '6': case '7': case '8': case '9':
                case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
                case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
                    int numValue = Character.digit(c, 16);
                    int count = 0;
                    int p = 16;

                    while (index + 1 < len && count < 6) {
                        c = s.charAt(index+1);

                        if (Character.digit(c, 16) != -1) {
                            numValue = (numValue * 16) + Character.digit(c, 16);
                            p *= 16;
                            index++;
                        } else {
                            if (c == ' ') {
                                // skip the latest white space
                                index++;
                            }
                            break;
                        }
                    }
                    buf.append((char) numValue);
                    break;
                case '\n':
                case '\f':
                    break;
                case '\r':
                    if (index + 1 < len) {
                        if (s.charAt(index + 1) == '\n') {
                            index ++;
                        }
                    }
                    break;
                default:
                    buf.append(c);
                }
            } else {
                throw new CSSParseException("invalid string " + s, getLocator());
            }
        } else {
            buf.append(c);
        }
        index++;
    }

    return buf.toString();
  }

  String convertIdent(String s) throws ParseException {return convertStringIndex(s, 0, s.length());
  }

  String convertString(String s) throws ParseException {return convertStringIndex(s, 0, s.length());
  }

  void rejectToken(Token t) throws ParseException {Token fakeToken = new Token();
    t.next = token;
    fakeToken.next = t;
    token = fakeToken;
  }

  String skipAfterExpression() throws ParseException {Token t = getToken(1);
    StringBuffer s = new StringBuffer();
    s.append(getToken(0).image);

    while ((t.kind != RBRACE) && (t.kind != SEMICOLON) && (t.kind != EOF)) {
        s.append(t.image);
        getNextToken();
        t = getToken(1);
    }

    return s.toString();
  }

/**
 * The following functions are useful for a DOM CSS implementation only and are
 * not part of the general CSS2 parser.
 */
  final public 
void _parseRule() throws ParseException {String ret = null;
    label_95:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[142] = jj_gen;
        break label_95;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPORT_SYM:{
      importDeclaration();
      break;
      }
    case LBRACKET:
    case ANY:
    case DOT:
    case COLON:
    case IDENT:
    case NAMESPACE_IDENT:
    case HASH:{
      styleRule();
      break;
      }
    case MEDIA_SYM:{
      media();
      break;
      }
    case PAGE_SYM:{
      page();
      break;
      }
    case FONT_FACE_SYM:{
      fontFace();
      break;
      }
    default:
      jj_la1[143] = jj_gen;
      ret = skipStatement();
if ((ret == null) || (ret.length() == 0)) {
                        {if ("" != null) return;}
                    }
                    if (ret.charAt(0) == '@') {
                        documentHandler.ignorableAtRule(ret);
                    } else {
                        {if (true) throw new CSSParseException("unrecognize rule: " + ret,
                                                    getLocator());}
                    }
    }
  }

  final public void _parseImportRule() throws ParseException {
    label_96:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_96;
      }
      jj_consume_token(S);
    }
    importDeclaration();
  }

  final public void _parseMediaRule() throws ParseException {
    label_97:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_97;
      }
      jj_consume_token(S);
    }
    media();
  }

  final public void _parseDeclarationBlock() throws ParseException {
    label_98:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case S:{
        ;
        break;
        }
      default:
        jj_la1[146] = jj_gen;
        break label_98;
      }
      jj_consume_token(S);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:
    case CUSTOM_PROPERTY:{
      declaration();
      break;
      }
    default:
      jj_la1[147] = jj_gen;
      ;
    }
    label_99:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        ;
        break;
        }
      default:
        jj_la1[148] = jj_gen;
        break label_99;
      }
      jj_consume_token(SEMICOLON);
      label_100:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[149] = jj_gen;
          break label_100;
        }
        jj_consume_token(S);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IDENT:
      case CUSTOM_PROPERTY:{
        declaration();
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        ;
      }
    }
  }

  final public SelectorList _parseSelectors() throws ParseException {SelectorList p = null;
    try {
      label_101:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case S:{
          ;
          break;
          }
        default:
          jj_la1[151] = jj_gen;
          break label_101;
        }
        jj_consume_token(S);
      }
      p = selectorList();
{if ("" != null) return p;}
    } catch (ThrowedParseException e) {
{if (true) throw (ParseException) e.e;}//.fillInStackTrace();

    }
    throw new Error("Missing return statement in function");
  }

  final public String _parseNamespaceToken() throws ParseException {Token retval = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAMESPACE_IDENT:{
      retval = jj_consume_token(NAMESPACE_IDENT);
{if ("" != null) return retval.image;}
      break;
      }
    case IDENT:{
      retval = jj_consume_token(IDENT);
{if ("" != null) return retval.image;}
      break;
      }
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_3_20()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(PAGE_SYM)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_119()) jj_scanpos = xsp;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_127()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3_30()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_164()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3_29()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3_31()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_165()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_139()
 {
    if (jj_3R_147()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(14)) {
    jj_scanpos = xsp;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(7)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(15)) {
    jj_scanpos = xsp;
    if (jj_scan_token(12)) {
    jj_scanpos = xsp;
    if (jj_scan_token(16)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(13)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3R_163()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_157()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_162()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_161()
 {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_160()
 {
    if (jj_3R_143()) return true;
    return false;
  }

  private boolean jj_3R_159()
 {
    if (jj_3R_142()) return true;
    return false;
  }

  private boolean jj_3R_156()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_scan_token(S)) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_3R_142()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_157()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_155()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_154()
 {
    if (jj_3R_158()) return true;
    return false;
  }

  private boolean jj_3R_144()
 {
    if (jj_scan_token(LBRACKET)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) return true;
    }
    return false;
  }

  private boolean jj_3R_124()
 {
    if (jj_3R_141()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_156()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    }
    return false;
  }

  private boolean jj_3R_135()
 {
    if (jj_scan_token(MINUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_112()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_124()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) return true;
    }
    }
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(18)) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_134()
 {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    if (jj_scan_token(1)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_145()
 {
    if (jj_scan_token(FUNCTION)) return true;
    return false;
  }

  private boolean jj_3R_153()
 {
    if (jj_scan_token(ANY)) return true;
    return false;
  }

  private boolean jj_3R_133()
 {
    if (jj_scan_token(ANY)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_132()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_152()
 {
    if (jj_scan_token(NAMESPACE_IDENT)) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_131()) {
    jj_scanpos = xsp;
    if (jj_3R_132()) {
    jj_scanpos = xsp;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_131()
 {
    if (jj_scan_token(DIV)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_151()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_141()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_158()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_130()
 {
    if (jj_3R_145()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_3R_111()) return true;
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_138()
 {
    if (jj_scan_token(COMMA)) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    return false;
  }

  private boolean jj_3R_143()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_146()
 {
    if (jj_scan_token(LPARAN)) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    return false;
  }

  private boolean jj_3R_137()
 {
    if (jj_3R_112()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_9()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_10()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_129()
 {
    if (jj_scan_token(PSEUDO_NTH)) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.toLowerCase().equals("and");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_108()) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    jj_lookingAhead = true;
    jj_semLA = getToken(1).image.toLowerCase().equals("and");
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_107()) return true;
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_3R_137()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_138()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_136()
 {
    if (jj_3R_146()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(HAS)) return true;
    return false;
  }

  private boolean jj_3_28()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_109()) jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_128()
 {
    if (jj_scan_token(IDENT)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    if (jj_scan_token(COLON)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_128()) {
    jj_scanpos = xsp;
    if (jj_3R_129()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_117()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) return true;
    }
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(COLON)) return true;
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_142()
 {
    if (jj_scan_token(HASH)) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_148()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_3R_118()) return true;
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_140()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_27()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_3R_117()) return true;
    return false;
  }

  private boolean jj_3R_150()
 {
    if (jj_scan_token(PRECEDES_GEN)) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_149()
 {
    if (jj_scan_token(PRECEDES)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_scan_token(S)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_140()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(PRECEDES_GEN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(PRECEDES)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_3R_139()) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) {
    jj_scanpos = xsp;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_scan_token(PLUS)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_scan_token(MEDIA_SYM)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(1)) { jj_scanpos = xsp; break; }
    }
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_26()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_3R_114()) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_3R_113()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[153];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x62,0x62,0x0,0x60,0x2,0x0,0x60,0x2,0x2,0x2,0x20d00000,0x60,0x2,0x60,0x2,0x0,0x2,0x2,0x2,0x2,0x0,0x0,0x2,0x2,0x2,0x60d3f6a0,0x2,0x4000,0x2,0x2,0x2,0x2,0x2,0x1000000,0x2,0x2,0x2,0x20000000,0x2,0x0,0x2,0x8000,0x0,0x20000000,0x20000000,0x2,0x4000,0x2,0x2,0x20000000,0x2,0x2,0x0,0x2,0x2,0x0,0x8000,0x2,0x0,0x2,0x2,0x2,0x0,0x8000,0x2,0x0,0x2,0x4003f6a0,0x2,0x2,0x2,0x31000,0x2,0x31000,0x31002,0x0,0x2,0x2,0x0,0x8000,0x2,0x0,0x2,0x4000,0x2,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0x20900000,0xc00000,0x100000,0x40000,0x2,0x2,0x2,0x2,0x10000,0x2,0x400000,0x2,0x0,0x2,0x1c000e00,0x2,0x0,0x2,0x1c000e00,0x20000000,0x0,0x2,0x0,0x2,0x2,0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x487000,0x1487000,0x2,0x2,0x1003000,0x3000,0x3000,0x0,0x0,0x3000,0x2,0x2,0x1003000,0x2,0x20d00000,0x2,0x2,0x2,0x0,0x8000,0x2,0x0,0x2,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000,0x0,0x0,0x0,0x0,0x10400,0x0,0x0,0x0,0x0,0x2000,0x10400,0x0,0x0,0x0,0x72c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x6000,0x0,0x0,0x0,0x6000,0x0,0x0,0x6000,0x0,0x50c00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6000,0x0,0x0,0x6000,0x0,0x0,0x6000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x22000,0x0,0x22000,0x0,0x0,0x0,0x2400,0x0,0x0,0x0,0x2000,0x0,0x3800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffff6c00,0x0,0x0,0xffff6c00,0x0,0x0,0xfffc0800,0x36400,0xffff6c00,0x0,0x0,0xffff6c00,0x0,0x22000,0x0,0x0,0x0,0x6000,0x0,0x0,0x6000,0x0,0x22000,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x100,0x20000000,0x20000000,0x40,0x20000000,0x0,0x8000000,0x20000000,0x0,0x0,0x0,0x100002a0,0x20000000,0x0,0x20000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x700003e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7fffc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x700003c0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,0x20,0x0,0x0,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3f,0x0,0x0,0x3f,0x0,0x0,0x1f,0x20,0x3f,0x0,0x0,0x3f,0x0,0x100002e0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3900,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1800,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1100,0x0,0x0,0x1100,0x0,0x0,0x1000,0x100,0x1100,0x0,0x0,0x1100,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[31];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public Parser(CharStream stream) {
    token_source = new ParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 153; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_lookingAhead = false;
    jj_gen = 0;
    for (int i = 0; i < 153; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 153; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 153; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) {
       return;
    }

    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];

      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }

      for (int[] oldentry : jj_expentries) {
        if (oldentry.length == jj_expentry.length) {
          boolean isMatched = true;

          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              isMatched = false;
              break;
            }

          }
          if (isMatched) {
            jj_expentries.add(jj_expentry);
            break;
          }
        }
      }

      if (pos != 0) {
        jj_lasttokens[(jj_endpos = pos) - 1] = kind;
      }
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[110];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 153; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 110; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 31; i++) {
      try {
        JJCalls p = jj_2_rtns[i];

        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
              case 3: jj_3_4(); break;
              case 4: jj_3_5(); break;
              case 5: jj_3_6(); break;
              case 6: jj_3_7(); break;
              case 7: jj_3_8(); break;
              case 8: jj_3_9(); break;
              case 9: jj_3_10(); break;
              case 10: jj_3_11(); break;
              case 11: jj_3_12(); break;
              case 12: jj_3_13(); break;
              case 13: jj_3_14(); break;
              case 14: jj_3_15(); break;
              case 15: jj_3_16(); break;
              case 16: jj_3_17(); break;
              case 17: jj_3_18(); break;
              case 18: jj_3_19(); break;
              case 19: jj_3_20(); break;
              case 20: jj_3_21(); break;
              case 21: jj_3_22(); break;
              case 22: jj_3_23(); break;
              case 23: jj_3_24(); break;
              case 24: jj_3_25(); break;
              case 25: jj_3_26(); break;
              case 26: jj_3_27(); break;
              case 27: jj_3_28(); break;
              case 28: jj_3_29(); break;
              case 29: jj_3_30(); break;
              case 30: jj_3_31(); break;
            }
          }
          p = p.next;
        } while (p != null);

        } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }

    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
