/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.css.sac;


/**
 * Interface marking all the selectors that may have subjects.
 * 
 * @author dan
 */
public interface SubjectSelector extends Selector {

  /**
   * Sets the subject flag.
   * 
   * @param isSubject <code>true</code> if this selector is the subject of a larger selector.
   */
  void setIsSubject(boolean isSubject);
  
  /**
   * Tests if this selector is the subject in a CSS level 4 subject selector: A!&gt;B.
   * 
   * @return Returns <code>true</code> if this selector is the subject of a larger selector.
   */
  boolean isSubject();
  
  /**
   * Tests if this selector contains a subject in a CSS level 4 subject selector.
   * 
   * @return Returns <code>true</code> if this selector contains the subject. The current 
   * selector may be a simple selector marked as being subject, or a descendant selector that has subject sub-selectors. 
   */
  boolean hasSubject();

  /**
   * Gets the subject ancestor part of the selector.
   * 
   * @return In case of a descendant selector returns the subject selector from the subject 
   * upwards. In case of simple selectors returns the simple selector itself.
   */
  Selector getSubjectAncestorSelector();
  
}
