xquery version "3.0" encoding "utf-8";

(: 
    XQuery document used to implement 'Insert new element' operation from XML Refactor tool.    
:)
import module namespace xr = "http://www.oxygenxml.com/ns/xmlRefactoring" at "http://www.oxygenxml.com/ns/xmlRefactoring/resources/commons.xq";

declare namespace output = "http://www.w3.org/2010/xslt-xquery-serialization";
declare namespace saxon = "http://saxon.sf.net/";

declare option output:method   "xml";
declare option output:indent   "no";

declare variable $element_xpath as xs:string external;

declare variable $wrapper_element_local_name as xs:string external;

declare variable $wrapper_element_namespace_uri as xs:string external;

declare function local:eval($expression as xs:string, $context-item as item()?) as item()* {
  transform(
    map {
      'stylesheet-node' : <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0" 
        xmlns:mf="http://example.com/mf"
        xmlns:xs="http://www.w3.org/2001/XMLSchema"
        exclude-result-prefixes="#all">
        <xsl:function name="mf:eval" as="item()*" visibility="public">
          <xsl:param name="expression" as="xs:string"/>
          <xsl:param name="context-item" as="item()?"/>
          <xsl:evaluate xpath="$expression" context-item="$context-item" namespace-context="$context-item"/>
        </xsl:function>
      </xsl:stylesheet>,
      'initial-function' : QName('http://example.com/mf', 'eval'),
      'function-params': [$expression, $context-item],
      'delivery-format': 'raw'
    }
  )?output
};

let $elements := local:eval($element_xpath, (./*)[1])
for $elem in $elements
let $elementContents := $elem/node()
let $elementQName := xr:compute-qname($wrapper_element_local_name, $wrapper_element_namespace_uri, $elem)
where $elem instance of element()
  return
    (
      insert node element {$elementQName} {
         $elementContents
      } as first into $elem,
      delete nodes $elementContents
     )


