package ro.sync.util.editorvars.expander;

import ro.sync.util.editorvars.parser.model.EditorVariable;

/**
 * Resolves an editor variable to an actual value. For example ${cfn} to the current file name.
 */
public interface EditorVariableResolver {
  
  /**
   * Expand editor variable.
   * 
   * @param edVar The editor variable to expand.
   * 
   * @return The results of expanding the editor variable. If <code>null</code> the editor variable will be serialized
   *         just like it was before being parsed.
   * 
   * @throws OperationCancelledException The operation required user confirmation and the user cancelled the operation.
   */
  String resolve(EditorVariable edVar) throws OperationCancelledException;

}
