/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.rof;

import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadOnlyFileInputStream
extends InputStream {
    protected ReadOnlyFile rof;
    private long mark = -1L;

    public ReadOnlyFileInputStream(ReadOnlyFile readOnlyFile) {
        this.rof = readOnlyFile;
    }

    public int read() throws IOException {
        return this.rof.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.rof.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.rof.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.rof.getFilePointer();
        long l3 = this.rof.length();
        long l4 = l3 - l2;
        if (l > l4) {
            l = (int)l4;
        }
        this.rof.seek(l2 + l);
        return l;
    }

    public int available() throws IOException {
        long l = this.rof.length() - this.rof.getFilePointer();
        return l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
    }

    public void close() throws IOException {
        this.rof.close();
    }

    public void mark(int n) {
        try {
            this.mark = this.rof.getFilePointer();
        }
        catch (IOException iOException) {
            Logger.getLogger(ReadOnlyFileInputStream.class.getName()).log(Level.WARNING, "mark()/reset() not supported", iOException);
            this.mark = -2L;
        }
    }

    public void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException(this.mark == -1L ? "no mark set" : "mark()/reset() not supported by underlying file");
        }
        this.rof.seek(this.mark);
    }

    public boolean markSupported() {
        try {
            this.rof.seek(this.rof.getFilePointer());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

