/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.File;
import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.archive.tar.TarEntry;
import de.schlichtherle.io.util.Paths;
import de.schlichtherle.io.util.Temps;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.apache.tools.tar.TarConstants;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarUtils;

public class TarInputArchive
implements InputArchive,
TarConstants {
    private static final byte[] NULL_RECORD;
    private static final int CHECKSUM_OFFSET = 148;
    private static final String TEMP_FILE_PREFIX = "tzp-tar";
    private final Map entries = new LinkedHashMap();
    private InputArchiveMetaData metaData;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TarInputArchive(InputStream inputStream) throws IOException {
        TarInputStream tarInputStream = TarInputArchive.createValidatedTarInputStream(inputStream);
        try {
            org.apache.tools.tar.TarEntry tarEntry;
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                TarEntry tarEntry2;
                String string = Paths.normalize(tarEntry.getName(), '/');
                if (tarEntry.isDirectory()) {
                    tarEntry2 = new TarEntry(tarEntry);
                } else {
                    java.io.File file;
                    try {
                        tarEntry2 = (TarEntry)this.entries.get(string);
                        file = tarEntry2 != null ? tarEntry2.getFile() : Temps.createTempFile(TEMP_FILE_PREFIX);
                        try {
                            FileOutputStream fileOutputStream = new FileOutputStream(file);
                            try {
                                File.cat((InputStream)tarInputStream, fileOutputStream);
                            }
                            finally {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            boolean bl = file.delete();
                            if (!$assertionsDisabled && !bl) {
                                throw new AssertionError();
                            }
                            throw iOException;
                        }
                    }
                    catch (InputIOException inputIOException) {
                        throw inputIOException;
                    }
                    catch (IOException iOException) {
                        throw new TransientIOException(new TempFileException(tarEntry, iOException));
                    }
                    tarEntry2 = new TarEntry(tarEntry, file);
                }
                tarEntry2.setName(string);
                this.entries.put(string, tarEntry2);
            }
        }
        catch (IOException iOException) {
            this.close0();
            throw iOException;
        }
    }

    private static TarInputStream createValidatedTarInputStream(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[512];
        InputStream inputStream2 = TarInputArchive.readAhead(inputStream, byArray);
        if (!Arrays.equals(byArray, NULL_RECORD)) {
            long l = TarUtils.parseOctal((byte[])byArray, (int)148, (int)8);
            for (int i = 0; i < 8; ++i) {
                byArray[148 + i] = 32;
            }
            long l2 = TarUtils.computeCheckSum((byte[])byArray);
            if (l != l2) {
                throw new IOException("Illegal initial record in TAR file: Expected checksum " + l + ", is " + l2 + "!");
            }
        }
        return new TarInputStream(inputStream2, 10240, 512);
    }

    static InputStream readAhead(InputStream inputStream, byte[] byArray) throws IOException {
        if (!(inputStream instanceof InflaterInputStream) && inputStream.markSupported()) {
            inputStream.mark(byArray.length);
            TarInputArchive.readFully(inputStream, byArray);
            inputStream.reset();
            return inputStream;
        }
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
        TarInputArchive.readFully(pushbackInputStream, byArray);
        pushbackInputStream.unread(byArray);
        return pushbackInputStream;
    }

    private static void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        do {
            if ((n = inputStream.read(byArray, n3, n2 - n3)) != -1) continue;
            throw new EOFException();
        } while ((n3 += n) < n2);
    }

    public int getNumArchiveEntries() {
        return this.entries.size();
    }

    public Enumeration getArchiveEntries() {
        return Collections.enumeration(this.entries.values());
    }

    public ArchiveEntry getArchiveEntry(String string) {
        return (TarEntry)this.entries.get(string);
    }

    public InputStream getInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        return new FileInputStream(((TarEntry)archiveEntry).getFile());
    }

    public void close() throws IOException {
        this.close0();
    }

    private void close0() throws IOException {
        Collection collection = this.entries.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TarEntry tarEntry = (TarEntry)iterator.next();
            java.io.File file = tarEntry.getFile();
            if (file == null) {
                if (!$assertionsDisabled && !tarEntry.isDirectory()) {
                    throw new AssertionError();
                }
            } else {
                if (!$assertionsDisabled && !file.exists()) {
                    throw new AssertionError();
                }
                if (!file.delete()) {
                    file.deleteOnExit();
                }
            }
            iterator.remove();
        }
    }

    public InputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(InputArchiveMetaData inputArchiveMetaData) {
        this.metaData = inputArchiveMetaData;
    }

    static {
        $assertionsDisabled = !TarInputArchive.class.desiredAssertionStatus();
        NULL_RECORD = new byte[512];
    }

    private static final class TempFileException
    extends FileNotFoundException {
        private TempFileException(org.apache.tools.tar.TarEntry tarEntry, IOException iOException) {
            super(tarEntry.getName() + " (couldn't create temp file for archive entry)");
            this.initCause(iOException);
        }
    }
}

