/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.ArchiveFileSystemController;
import de.schlichtherle.io.ArchiveInputBusyException;
import de.schlichtherle.io.ArchiveInputBusyWarningException;
import de.schlichtherle.io.ArchiveOutputBusyException;
import de.schlichtherle.io.ArchiveOutputBusyWarningException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.CountingOutputStream;
import de.schlichtherle.io.CountingReadOnlyFile;
import de.schlichtherle.io.File;
import de.schlichtherle.io.Files;
import de.schlichtherle.io.IORunnable;
import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.ReentrantLock;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.TransientIOException;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.io.util.Temps;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UpdatingArchiveController
extends ArchiveFileSystemController {
    private static final String CLASS_NAME;
    private static final Logger logger;
    static final String TEMP_FILE_PREFIX = "tzp-ctrl";
    static final String TEMP_FILE_SUFFIX = ".tmp";
    private java.io.File inFile;
    private InputArchive inArchive;
    private java.io.File outFile;
    private OutputArchive outArchive;
    private boolean needsReassembly;
    static final /* synthetic */ boolean $assertionsDisabled;

    UpdatingArchiveController(java.io.File file, ArchiveController archiveController, String string, ArchiveDriver archiveDriver) {
        super(file, archiveController, string, archiveDriver);
    }

    void mount(boolean bl) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outFile != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getFileSystem() != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINER, "mount.entering", new Object[]{this.getPath(), bl});
        try {
            this.mount0(bl);
        }
        catch (IOException iOException) {
            if (!$assertionsDisabled && !this.writeLock().isLocked()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.inArchive != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.outFile != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.outArchive != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.getFileSystem() != null) {
                throw new AssertionError();
            }
            logger.log(Level.FINER, "mount.throwing", iOException);
            throw iOException;
        }
        logger.log(Level.FINER, "mount.exiting");
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bl && this.inArchive == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bl && this.outFile != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !bl && this.outArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getFileSystem() == null) {
            throw new AssertionError();
        }
    }

    private void mount0(boolean bl) throws IOException {
        if (this.isRfsEntryTarget()) {
            long l;
            if (this.inFile == null) {
                this.inFile = this.getTarget();
            }
            if ((l = this.inFile.lastModified()) != 0L) {
                boolean bl2 = !Files.isWritableOrCreatable(this.inFile);
                try {
                    this.initInArchive(this.inFile);
                }
                catch (IOException iOException) {
                    throw new ArchiveController.RfsEntryFalsePositiveException(this, iOException);
                }
                this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, l, bl2));
            } else {
                if (!bl) {
                    throw new ArchiveController.ArchiveFileNotFoundException(this, "may not create");
                }
                this.ensureOutArchive();
                this.setFileSystem(new ArchiveFileSystem(this));
            }
        } else if (this.inFile == null) {
            this.unwrap(this.getEnclController(), this.getEnclEntryName(), bl);
        } else {
            try {
                this.initInArchive(this.inFile);
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"We should never get here! Read the source code comments for full details.");
                }
                throw new ArchiveController.FileArchiveEntryFalsePositiveException(this, this.getEnclController(), this.getEnclEntryName(), iOException);
            }
            this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, this.inFile.lastModified(), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwrap(ArchiveController archiveController, String string, boolean bl) throws IOException {
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inFile != null) {
            throw new AssertionError();
        }
        try {
            ReentrantLock reentrantLock = bl ? archiveController.writeLock() : archiveController.readLock();
            archiveController.readLock().lock();
            if (archiveController.hasNewData(string) || bl) {
                archiveController.readLock().unlock();
                class Locker
                implements IORunnable {
                    private final /* synthetic */ ArchiveController val$controller;
                    private final /* synthetic */ String val$entryName;
                    private final /* synthetic */ ReentrantLock val$lock;

                    Locker(ArchiveController archiveController, String string, ReentrantLock reentrantLock) {
                        this.val$controller = archiveController;
                        this.val$entryName = string;
                        this.val$lock = reentrantLock;
                    }

                    public void run() throws IOException {
                        this.val$controller.autoUmount(this.val$entryName);
                        this.val$lock.lock();
                    }
                }
                archiveController.runWriteLocked(new Locker(archiveController, string, reentrantLock));
            }
            try {
                this.unwrapFromLockedController(archiveController, string, bl);
            }
            finally {
                reentrantLock.unlock();
            }
        }
        catch (ArchiveController.DirectoryArchiveEntryFalsePositiveException directoryArchiveEntryFalsePositiveException) {
            if (directoryArchiveEntryFalsePositiveException.getEnclController() == archiveController) {
                throw directoryArchiveEntryFalsePositiveException;
            }
            this.unwrap(archiveController.getEnclController(), archiveController.enclEntryName(string), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unwrapFromLockedController(ArchiveController archiveController, String string, boolean bl) throws IOException {
        ArchiveFileSystem archiveFileSystem;
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || archiveController.readLock().isLocked() || archiveController.writeLock().isLocked())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inFile != null) {
            throw new AssertionError();
        }
        try {
            archiveFileSystem = archiveController.autoMount(bl && File.isLenient());
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"FIXME: Explain or remove this!");
            }
            throw (IOException)rfsEntryFalsePositiveException.getCause();
        }
        if (archiveFileSystem.isFile(string)) {
            java.io.File file = Temps.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            try {
                File.cp(archiveController.createInputStream0(string), new FileOutputStream(file));
                try {
                    this.initInArchive(file);
                }
                catch (IOException iOException) {
                    throw new ArchiveController.FileArchiveEntryFalsePositiveException(this, archiveController, string, iOException);
                }
                this.setFileSystem(new ArchiveFileSystem(this, this.inArchive, archiveFileSystem.lastModified(string), archiveFileSystem.isReadOnly()));
                this.inFile = file;
            }
            catch (Throwable throwable) {
                if (!file.delete()) {
                    IOException iOException = new IOException(file.getPath() + " (couldn't delete corrupted input file)");
                    iOException.initCause(throwable);
                    throw iOException;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
        }
        if (archiveFileSystem.isDirectory(string)) {
            throw new ArchiveController.DirectoryArchiveEntryFalsePositiveException(this, archiveController, string, new FileNotFoundException("cannot read directories"));
        }
        if (!bl) {
            throw new ArchiveController.ArchiveFileNotFoundException(this, "may not create");
        }
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !archiveController.writeLock().isLocked()) {
            throw new AssertionError();
        }
        ArchiveFileSystem.Delta delta = archiveFileSystem.link(string, File.isLenient());
        this.ensureOutArchive();
        try {
            delta.commit();
        }
        catch (IOException iOException) {
            try {
                try {
                    this.outArchive.close();
                }
                finally {
                    this.outArchive = null;
                }
            }
            finally {
                boolean bl2 = this.outFile.delete();
                if (!$assertionsDisabled && !bl2) {
                    throw new AssertionError();
                }
                this.outFile = null;
            }
            throw iOException;
        }
        this.setFileSystem(new ArchiveFileSystem(this));
    }

    private void initInArchive(java.io.File file) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINEST, "initInArchive.entering", file);
        try {
            ReadOnlyFile readOnlyFile = new SimpleReadOnlyFile(file);
            if (this.isRfsEntryTarget()) {
                readOnlyFile = new CountingReadOnlyFile(readOnlyFile);
            }
            try {
                this.inArchive = this.getDriver().createInputArchive(this, readOnlyFile);
            }
            catch (Throwable throwable) {
                readOnlyFile.close();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new AssertionError((Object)throwable);
            }
            this.inArchive.setMetaData(new InputArchiveMetaData(this, this.inArchive));
        }
        catch (IOException iOException) {
            if (!$assertionsDisabled && this.inArchive != null) {
                throw new AssertionError();
            }
            logger.log(Level.FINEST, "initInArchive.throwing", iOException);
            throw iOException;
        }
        logger.log(Level.FINEST, "initInArchive.exiting", new Integer(this.inArchive.getNumArchiveEntries()));
        if (!$assertionsDisabled && this.inArchive == null) {
            throw new AssertionError();
        }
    }

    InputStream createInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.hasNewData(archiveEntry.getName())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveEntry.isDirectory()) {
            throw new AssertionError();
        }
        InputStream inputStream = this.inArchive.getMetaData().createInputStream(archiveEntry, archiveEntry2);
        if (inputStream == null) {
            throw new ArchiveController.ArchiveEntryNotFoundException(this, archiveEntry.getName(), "bad archive driver: returned illegal null value");
        }
        return inputStream;
    }

    OutputStream createOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && archiveEntry == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.hasNewData(archiveEntry.getName())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveEntry.isDirectory()) {
            throw new AssertionError();
        }
        this.ensureOutArchive();
        OutputStream outputStream = this.outArchive.getMetaData().createOutputStream(archiveEntry, archiveEntry2);
        if (outputStream == null) {
            throw new ArchiveController.ArchiveEntryNotFoundException(this, archiveEntry.getName(), "bad archive driver: returned illegal null value");
        }
        return outputStream;
    }

    void touch() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        this.ensureOutArchive();
        super.touch();
    }

    private void ensureOutArchive() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (this.outArchive != null) {
            return;
        }
        java.io.File file = this.outFile;
        if (file == null) {
            file = this.isRfsEntryTarget() && !this.getTarget().isFile() ? this.getTarget() : Temps.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        try {
            this.initOutArchive(file);
        }
        catch (TransientIOException transientIOException) {
            throw transientIOException.getTransientCause();
        }
        this.outFile = file;
    }

    private void initOutArchive(java.io.File file) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINEST, "initOutArchive.entering", file);
        try {
            OutputStream outputStream = new FileOutputStream(file);
            if (file == this.getTarget()) {
                outputStream = new CountingOutputStream(outputStream);
            }
            try {
                this.outArchive = this.getDriver().createOutputArchive(this, outputStream, this.inArchive);
            }
            catch (Throwable throwable) {
                ((OutputStream)outputStream).close();
                if (!file.delete()) {
                    IOException iOException = new IOException(file.getPath() + " (couldn't delete corrupted output file)");
                    iOException.initCause(throwable);
                    throw iOException;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new AssertionError((Object)throwable);
            }
            this.outArchive.setMetaData(new OutputArchiveMetaData(this, this.outArchive));
        }
        catch (IOException iOException) {
            if (!$assertionsDisabled && this.outArchive != null) {
                throw new AssertionError();
            }
            logger.log(Level.FINEST, "initOutArchive.throwing", iOException);
            throw iOException;
        }
        logger.log(Level.FINEST, "initOutArchive.exiting");
        if (!$assertionsDisabled && this.outArchive == null) {
            throw new AssertionError();
        }
    }

    boolean hasNewData(String string) {
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        return this.outArchive != null && this.outArchive.getArchiveEntry(string) != null;
    }

    void umount(ArchiveException archiveException, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ArchiveException {
        if (!$assertionsDisabled && !bl2 && bl4) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bl5 && !bl6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null && this.inFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isTouched() && this.outArchive == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null && this.outFile == null) {
            throw new AssertionError();
        }
        logger.log(Level.FINER, "umount.entering", new Object[]{this.getPath(), archiveException, bl, bl2, bl3, bl4, bl5, bl6});
        try {
            this.umount0(archiveException, bl, bl2, bl3, bl4, bl5, bl6);
        }
        catch (ArchiveException archiveException2) {
            logger.log(Level.FINER, "umount.throwing", archiveException2);
            throw archiveException2;
        }
        logger.log(Level.FINER, "umount.exiting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void umount0(ArchiveException archiveException, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ArchiveException {
        ArchiveException archiveException2;
        block32: {
            Object object;
            int n;
            archiveException2 = archiveException;
            if (this.outArchive != null && (n = ((OutputArchiveMetaData)(object = this.outArchive.getMetaData())).waitAllOutputStreamsByOtherThreads(bl3 ? 0L : 50L)) > 0) {
                if (!bl4) {
                    throw new ArchiveOutputBusyException(archiveException2, this.getPath(), n);
                }
                archiveException2 = new ArchiveOutputBusyWarningException(archiveException2, this.getPath(), n);
            }
            if (this.inArchive != null && (n = ((InputArchiveMetaData)(object = this.inArchive.getMetaData())).waitAllInputStreamsByOtherThreads(bl ? 0L : 50L)) > 0) {
                if (!bl2) {
                    throw new ArchiveInputBusyException(archiveException2, this.getPath(), n);
                }
                archiveException2 = new ArchiveInputBusyWarningException(archiveException2, this.getPath(), n);
            }
            try {
                if (this.isTouched()) {
                    this.needsReassembly = true;
                    try {
                        archiveException2 = this.update(archiveException2);
                        if (!$assertionsDisabled && this.getFileSystem() != null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.inArchive != null) {
                            throw new AssertionError();
                        }
                    }
                    finally {
                        if (!$assertionsDisabled && this.outArchive != null) {
                            throw new AssertionError();
                        }
                    }
                    try {
                        if (bl6) {
                            archiveException2 = this.reassemble(archiveException2);
                            this.needsReassembly = false;
                        }
                        this.shutdownStep3(bl5 && !this.needsReassembly);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        this.shutdownStep3(bl5 && !this.needsReassembly);
                        throw throwable;
                    }
                }
                if (bl6 && this.needsReassembly) {
                    if (!$assertionsDisabled && this.outFile != null) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && this.inFile == null) {
                        throw new AssertionError();
                    }
                    this.shutdownStep2(archiveException2);
                    this.outFile = this.inFile;
                    this.inFile = null;
                    try {
                        archiveException2 = this.reassemble(archiveException2);
                        this.needsReassembly = false;
                        this.shutdownStep3(bl5 && !this.needsReassembly);
                        break block32;
                    }
                    catch (Throwable throwable) {
                        this.shutdownStep3(bl5 && !this.needsReassembly);
                        throw throwable;
                    }
                }
                if (bl5) {
                    if (!$assertionsDisabled && !bl6) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && this.needsReassembly) {
                        throw new AssertionError();
                    }
                    this.shutdownStep2(archiveException2);
                    this.shutdownStep3(true);
                } else if (!$assertionsDisabled && this.outArchive != null) {
                    throw new AssertionError();
                }
            }
            catch (ArchiveException archiveException3) {
                throw archiveException3;
            }
            catch (IOException iOException) {
                throw new ArchiveException(archiveException2, iOException);
            }
            finally {
                this.setScheduled(this.needsReassembly);
            }
        }
        if (archiveException2 != archiveException) {
            throw archiveException2;
        }
    }

    final int waitAllInputStreamsByOtherThreads(long l) {
        return this.inArchive != null ? this.inArchive.getMetaData().waitAllInputStreamsByOtherThreads(l) : 0;
    }

    final int waitAllOutputStreamsByOtherThreads(long l) {
        return this.outArchive != null ? this.outArchive.getMetaData().waitAllOutputStreamsByOtherThreads(l) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveException update(ArchiveException archiveException) throws ArchiveException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isTouched()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.checkNoDeletedEntriesWithNewData(archiveException) != archiveException) {
            throw new AssertionError();
        }
        ArchiveFileSystem archiveFileSystem = this.getFileSystem();
        ArchiveEntry archiveEntry = archiveFileSystem.getRoot();
        try {
            try {
                try {
                    archiveException = this.shutdownStep1(archiveException);
                    ArchiveWarningException archiveWarningException = null;
                    ArchiveWarningException archiveWarningException2 = null;
                    Enumeration enumeration = archiveFileSystem.getArchiveEntries();
                    while (enumeration.hasMoreElements()) {
                        ArchiveEntry archiveEntry2 = (ArchiveEntry)enumeration.nextElement();
                        String string = archiveEntry2.getName();
                        if (this.hasNewData(string)) continue;
                        if (archiveEntry2.isDirectory()) {
                            if (archiveEntry == archiveEntry2 || archiveEntry2.getTime() < 0L) continue;
                            this.outArchive.getOutputStream(archiveEntry2, null).close();
                            continue;
                        }
                        if (this.inArchive != null && this.inArchive.getArchiveEntry(string) != null) {
                            InputStream inputStream;
                            if (!$assertionsDisabled && archiveEntry2 != this.inArchive.getArchiveEntry(string)) {
                                throw new AssertionError();
                            }
                            try {
                                inputStream = this.inArchive.getInputStream(archiveEntry2, archiveEntry2);
                                if (!$assertionsDisabled && inputStream == null) {
                                    throw new AssertionError();
                                }
                            }
                            catch (IOException iOException) {
                                if (archiveWarningException != null) continue;
                                archiveWarningException = new ArchiveWarningException(archiveException, this.getPath() + " (skipped one or more corrupted archive entries in the input)", iOException);
                                archiveException = archiveWarningException;
                                continue;
                            }
                            try {
                                OutputStream outputStream = this.outArchive.getOutputStream(archiveEntry2, archiveEntry2);
                                try {
                                    Streams.cat(inputStream, outputStream);
                                    continue;
                                }
                                catch (InputIOException inputIOException) {
                                    if (archiveWarningException2 != null) continue;
                                    archiveWarningException2 = new ArchiveWarningException(archiveException, this.getPath() + " (one or more archive entries in the output are corrupted)", (IOException)inputIOException);
                                    archiveException = archiveWarningException2;
                                    continue;
                                }
                                finally {
                                    outputStream.close();
                                    continue;
                                }
                            }
                            finally {
                                try {
                                    inputStream.close();
                                    continue;
                                }
                                catch (IOException iOException) {
                                    if (archiveWarningException == null) {
                                        archiveWarningException = new ArchiveWarningException(archiveException, this.getPath() + " (one or more archive entries in the input are corrupted)", iOException);
                                        archiveException = archiveWarningException;
                                    }
                                    throw iOException;
                                }
                            }
                        }
                        this.outArchive.getOutputStream(archiveEntry2, null).close();
                    }
                }
                finally {
                    this.shutdownStep2(archiveException);
                }
            }
            catch (IOException iOException) {
                boolean bl = this.outFile.delete();
                this.outFile = null;
                if (!$assertionsDisabled && !bl) {
                    throw new AssertionError();
                }
                throw iOException;
            }
        }
        catch (ArchiveException archiveException2) {
            throw archiveException2;
        }
        catch (IOException iOException) {
            throw new ArchiveException(archiveException, this.getPath() + " (could not update archive file - all changes are lost)", iOException);
        }
        if (!this.outFile.setLastModified(archiveEntry.getTime())) {
            archiveException = new ArchiveWarningException(archiveException, this.getPath() + " (couldn't preserve last modification time)");
        }
        return archiveException;
    }

    private ArchiveException checkNoDeletedEntriesWithNewData(ArchiveException archiveException) {
        if (!$assertionsDisabled && !this.isTouched()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getFileSystem() == null) {
            throw new AssertionError();
        }
        ArchiveFileSystem archiveFileSystem = this.getFileSystem();
        Enumeration enumeration = this.outArchive.getArchiveEntries();
        while (enumeration.hasMoreElements()) {
            ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
            String string = archiveEntry.getName();
            if (archiveFileSystem.get(string) != null) continue;
            archiveException = new ArchiveWarningException(archiveException, this.getPath() + " (couldn't remove archive entry: " + string + ")");
        }
        return archiveException;
    }

    private ArchiveException reassemble(ArchiveException archiveException) throws ArchiveException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (this.isRfsEntryTarget()) {
            if (this.outFile != this.getTarget()) {
                try {
                    FileInputStream fileInputStream;
                    CountingOutputStream countingOutputStream = new CountingOutputStream(new FileOutputStream(this.getTarget()));
                    try {
                        fileInputStream = new FileInputStream(this.outFile);
                    }
                    catch (IOException iOException) {
                        ((OutputStream)countingOutputStream).close();
                        throw iOException;
                    }
                    File.cp(fileInputStream, countingOutputStream);
                }
                catch (IOException iOException) {
                    throw new ArchiveException(archiveException, this.getPath() + " (could not reassemble archive file - all changes are lost)", iOException);
                }
                long l = this.outFile.lastModified();
                if (l != 0L && !this.getTarget().setLastModified(l)) {
                    archiveException = new ArchiveWarningException(archiveException, this.getPath() + " (couldn't preserve last modification time)");
                }
            }
        } else {
            try {
                this.wrap(this.getEnclController(), this.getEnclEntryName());
            }
            catch (IOException iOException) {
                throw new ArchiveException(archiveException, this.getEnclController().getPath() + "/" + this.getEnclEntryName() + " (could not update archive entry - all changes are lost)", iOException);
            }
        }
        return archiveException;
    }

    private void wrap(final ArchiveController archiveController, final String string) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        archiveController.runWriteLocked(new IORunnable(){

            public void run() throws IOException {
                UpdatingArchiveController.this.wrapToWriteLockedController(archiveController, string);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapToWriteLockedController(ArchiveController archiveController, String string) throws IOException {
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !archiveController.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "".equals(string)) {
            throw new AssertionError();
        }
        FileInputStream fileInputStream = new FileInputStream(this.outFile);
        try {
            Files.cp0(true, this.outFile, fileInputStream, archiveController, string);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    void reset() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        ArchiveException archiveException = this.shutdownStep1(null);
        this.shutdownStep2(archiveException);
        this.shutdownStep3(true);
        this.setScheduled(false);
        if (archiveException != null) {
            throw archiveException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            logger.log(Level.FINEST, "finalize.entering", this.getPath());
            if (this.isTouched() || this.readLock().isLocked() || this.writeLock().isLocked()) {
                logger.log(Level.SEVERE, "finalize.invalidState", this.getPath());
            }
            this.shutdownStep1(null);
            this.shutdownStep2(null);
            this.shutdownStep3(true);
        }
        finally {
            super.finalize();
        }
    }

    private ArchiveException shutdownStep1(ArchiveException archiveException) {
        if (this.outArchive != null) {
            archiveException = this.outArchive.getMetaData().closeAllOutputStreams(archiveException);
        }
        if (this.inArchive != null) {
            archiveException = this.inArchive.getMetaData().closeAllInputStreams(archiveException);
        }
        return archiveException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownStep2(ArchiveException archiveException) throws IOException {
        ArchiveException archiveException2 = archiveException;
        super.reset();
        if (this.outArchive != null) {
            try {
                this.outArchive.close();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveException(archiveException, iOException);
            }
            finally {
                this.outArchive = null;
            }
        }
        if (this.inArchive != null) {
            try {
                this.inArchive.close();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveException(archiveException, iOException);
            }
            finally {
                this.inArchive = null;
            }
        }
        if (archiveException != archiveException2) {
            throw archiveException;
        }
    }

    private void shutdownStep3(boolean bl) {
        boolean bl2;
        if (this.inFile != null) {
            if (this.inFile != this.getTarget()) {
                bl2 = this.inFile.delete();
                if (!$assertionsDisabled && !bl2) {
                    throw new AssertionError();
                }
            }
            this.inFile = null;
        }
        if (this.outFile != null) {
            if (bl) {
                if (this.outFile != this.getTarget()) {
                    bl2 = this.outFile.delete();
                    if (!$assertionsDisabled && !bl2) {
                        throw new AssertionError();
                    }
                }
            } else {
                if (!$assertionsDisabled && !this.outFile.isFile()) {
                    throw new AssertionError();
                }
                this.inFile = this.outFile;
            }
            this.outFile = null;
        }
        if (bl) {
            this.needsReassembly = false;
        }
    }

    static {
        $assertionsDisabled = !UpdatingArchiveController.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/UpdatingArchiveController".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }
}

