/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.util;

import java.lang.reflect.Field;
import javafx.animation.AnimationTimer;
import javafx.scene.web.WebEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JFXComponentsInternalUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JFXComponentsInternalUtils.class.getName());

    private JFXComponentsInternalUtils() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static AnimationTimer getJavaFxPulseTimer(WebEngine engine) throws Exception {
        Class<?> pulseTimerClass = Class.forName(engine.getClass().getName() + "$PulseTimer");
        Field animationField = pulseTimerClass.getDeclaredField("animation");
        animationField.setAccessible(true);
        Object value = animationField.get(pulseTimerClass);
        return (AnimationTimer)value;
    }

    public static void startJavaFxPulseTimer(WebEngine engine) {
        try {
            JFXComponentsInternalUtils.getJavaFxPulseTimer(engine).start();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void stopJavaFxPulseTimer(WebEngine engine) {
        try {
            JFXComponentsInternalUtils.getJavaFxPulseTimer(engine).stop();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String dumpThreads(Thread currentThread) {
        StringBuilder buf = new StringBuilder(500);
        ThreadGroup root = null;
        for (ThreadGroup currentGroup = currentThread.getThreadGroup(); currentGroup != null; currentGroup = currentGroup.getParent()) {
            root = currentGroup;
        }
        buf.append("========================\n").append("  Group: ").append(root == null ? String.valueOf(root) : root.getName()).append("\n========================\n\n");
        int maxThreads = 100;
        Thread[] threads = new Thread[100];
        int cnt = 0;
        if (root != null) {
            cnt = root.enumerate(threads, true);
        }
        for (int i = 0; i < cnt; ++i) {
            buf.append("======================\n");
            if (threads[i] != null) {
                buf.append(i).append(" - Thread \"").append(threads[i].getName()).append("\" [");
                ThreadGroup threadGroup = threads[i].getThreadGroup();
                buf.append(threadGroup != null ? threadGroup.getName() : "NULL Thread group, thread probably STOPPED").append("] - state: ").append((Object)threads[i].getState()).append('\n');
            }
            buf.append("----------------------\n");
            StackTraceElement[] ste = threads[i].getStackTrace();
            for (int j = 0; j < ste.length; ++j) {
                buf.append(' ').append(ste[j]).append('\n');
            }
        }
        return buf.toString();
    }
}

