/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.browser;

import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.media.ClosableJFXPanel;
import ro.sync.jfx.media.browser.BrowserEventHandler;
import ro.sync.jfx.media.browser.BrowserPanelChangeListener;
import ro.sync.jfx.media.browser.WebEngineStateTracker;
import ro.sync.jfx.media.util.JFXComponentsInternalUtils;
import ro.sync.net.URLUtil;

public class SwingBrowserPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SwingBrowserPanel.class.getName());
    private final ClosableJFXPanel jfxPanel;
    private URL url;
    private final BrowserEventHandler handler;
    private ChangeListener<Worker.State> changeListener;
    private WebView view;

    public SwingBrowserPanel(boolean showUrlAndStatus, BrowserEventHandler handler) {
        super(new BorderLayout());
        this.handler = handler;
        this.jfxPanel = new ClosableJFXPanel();
        this.initComponents();
        LOGGER.debug("Create browser");
    }

    private void initComponents() {
        this.createScene();
        this.add((Component)((Object)this.jfxPanel), "Center");
    }

    private void createScene() {
        Platform.runLater(() -> {
            this.view = new WebView();
            WebEngine engine = this.view.getEngine();
            JFXWebEngineInstanceCounter.increase(engine);
            final WebEngineStateTracker progressTracker = new WebEngineStateTracker(engine);
            this.changeListener = new BrowserPanelChangeListener(this.view, this.handler, this.jfxPanel, progressTracker);
            engine.getLoadWorker().stateProperty().addListener(this.changeListener);
            engine.getLoadWorker().cancel();
            final StackPane stackPane = new StackPane();
            stackPane.getChildren().addAll((Object[])new Node[]{this.view, progressTracker.getIndicator()});
            this.jfxPanel.setScene(new Scene((Parent)stackPane));
            progressTracker.setStateTrackerListener(new WebEngineStateTracker.StateTrackerListener(){

                @Override
                public void stopped() {
                    stackPane.getChildren().remove((Object)progressTracker.getIndicator());
                }
            });
            progressTracker.start();
        });
    }

    public URL getLoadedUrl() {
        return this.url;
    }

    public void loadURL(URL url) {
        LOGGER.debug("Load URL {}", (Object)url);
        this.url = url;
        Platform.runLater(() -> {
            String tmp = URLUtil.toExternalFormURL(url.toExternalForm());
            if (tmp == null) {
                tmp = URLUtil.toExternalFormURL("http://" + url.toExternalForm());
            }
            this.view.getEngine().load(tmp);
        });
    }

    private void removeStagePulseListener() {
        try {
            Field stagePulseListener = this.view.getClass().getDeclaredField("stagePulseListener");
            stagePulseListener.setAccessible(true);
            Object value = stagePulseListener.get(this.view);
            if (value != null) {
                Toolkit.getToolkit().removeStageTkPulseListener((TKPulseListener)value);
            }
            LOGGER.debug("WebView stagePulseListener was removed");
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() {
        if (this.jfxPanel != null) {
            this.jfxPanel.dispose();
        }
        Platform.runLater(() -> {
            WebEngine engine = this.view.getEngine();
            engine.getLoadWorker().stateProperty().removeListener(this.changeListener);
            engine.load(null);
            CookieHandler.setDefault(new CookieManager());
            this.removeStagePulseListener();
            JFXWebEngineInstanceCounter.decrese(engine);
            try {
                Field instanceCountWebEngine = engine.getClass().getDeclaredField("instanceCount");
                instanceCountWebEngine.setAccessible(true);
                Object instanceCountValue = instanceCountWebEngine.get(engine);
                LOGGER.debug("engine instance count = {}", instanceCountValue);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            LOGGER.debug(JFXComponentsInternalUtils.dumpThreads(Thread.currentThread()));
        });
    }

    public WebEngine getEngineForTests() {
        return this.view.getEngine();
    }

    private static class JFXWebEngineInstanceCounter {
        private static int counter;

        private JFXWebEngineInstanceCounter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void increase(WebEngine engine) {
            if (engine != null) {
                Class<JFXWebEngineInstanceCounter> clazz = JFXWebEngineInstanceCounter.class;
                synchronized (JFXWebEngineInstanceCounter.class) {
                    if (++counter == 1) {
                        JFXComponentsInternalUtils.startJavaFxPulseTimer(engine);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            } else {
                LOGGER.error("No engine!", (Throwable)new Exception());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void decrese(WebEngine engine) {
            if (engine != null) {
                Class<JFXWebEngineInstanceCounter> clazz = JFXWebEngineInstanceCounter.class;
                synchronized (JFXWebEngineInstanceCounter.class) {
                    if (--counter == 0) {
                        JFXComponentsInternalUtils.stopJavaFxPulseTimer(engine);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                }
            } else {
                LOGGER.error("No engine!", (Throwable)new Exception());
            }
        }
    }
}

