/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.aqua.AquaDFButton;
import com.jidesoft.plaf.aqua.AquaJideUtils;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class AquaDockableFrameTitlePane
extends BasicDockableFrameTitlePane {
    private static final Color COLOR1 = new Color(130, 130, 130);
    private static final Color COLOR2 = new Color(86, 86, 86);
    private static final Color COLOR3 = new Color(252, 252, 252);

    public AquaDockableFrameTitlePane(DockableFrame f) {
        super(f);
    }

    @Override
    protected Dimension getMaximumButtonSize() {
        return new Dimension(11, 13);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        this.adjustSelectionColor();
    }

    @Override
    protected void changeButtonType(AbstractButton button, int type) {
        if (button instanceof AquaDFButton) {
            ((AquaDFButton)button).setType(type);
        }
    }

    @Override
    protected void paintTitleBackground(Graphics g) {
        boolean paintAsSelected = this._frame.isActive() && JideSwingUtilities.isAncestorOfFocusOwner(this._frame);
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getTitleBarHeight());
        this.getPainter().paintDockableFrameTitlePane(this, g, rect, 0, paintAsSelected ? 3 : 0);
        this._closeButton.setEnabled(this._frame.getCloseAction().isEnabled());
        this._maximizeButton.setEnabled(this._frame.getMaximizeAction().isEnabled());
        this._autohideButton.setEnabled(this._frame.getAutohideAction().isEnabled());
        if (this._floatButton != null) {
            this._floatButton.setEnabled(this._frame.getFloatingAction().isEnabled());
        }
    }

    @Override
    protected void createComponents() {
        boolean usingMacStandardIcons;
        this._gripper = new Gripper();
        Object object = this._frame.getClientProperty("DraggingListener");
        if (object != null) {
            this._gripper.addMouseListener((MouseListener)object);
            this._gripper.addMouseMotionListener((MouseMotionListener)object);
        }
        this._title = this._frame.getTitleLabelComponent();
        if (this._title == null) {
            this._title = this.createDefaultTitleLabel();
        }
        if (this._title instanceof JLabel) {
            ((JLabel)this._title).setHorizontalAlignment(this._titleAlignment);
            ((JLabel)this._title).setVerticalAlignment(0);
            if (this._showIcon) {
                ((JLabel)this._title).setIcon(this._frame.getFrameIcon());
            }
        }
        if (!(usingMacStandardIcons = UIDefaultsLookup.getBoolean("DockableFrame.usingMacStandardIcons"))) {
            this._floatButton = new AquaDFButton(this._frame, this, 3);
            this.setupButton(this._floatButton, this._frame.getFloatingAction());
        }
        this._autohideButton = new AquaDFButton(this._frame, this, 1);
        this.setupButton(this._autohideButton, this._frame.getAutohideAction());
        this._closeButton = usingMacStandardIcons ? new AquaDFButton(this._frame, this, 0) : new AquaCloseButton();
        this.setupButton(this._closeButton, this._frame.getCloseAction());
        this._maximizeButton = new AquaDFButton(this._frame, this, 5);
        this.setupButton(this._maximizeButton, this._frame.getMaximizeAction());
        ButtonChangeListener buttonChangeListener = new ButtonChangeListener();
        this._closeButton.addChangeListener(buttonChangeListener);
        this._autohideButton.addChangeListener(buttonChangeListener);
        if (this._floatButton != null) {
            this._floatButton.addChangeListener(buttonChangeListener);
        }
        this._maximizeButton.addChangeListener(buttonChangeListener);
        this.setButtonIcons();
    }

    @Override
    protected void updateButtonVisibilities() {
    }

    protected boolean anyRollovers() {
        return this._closeButton.getModel().isRollover() || this._autohideButton.getModel().isRollover() || this._floatButton != null && this._floatButton.getModel().isRollover() || this._maximizeButton.getModel().isRollover();
    }

    @Override
    protected LayoutManager createLayout() {
        return new AquaTitlePaneLayout();
    }

    private boolean isAnyControlButtonVisible() {
        return this.isAutohideButtonVisible() || this.isFloatingButtonVisible() || this.isMaximizeButtonVisible();
    }

    private boolean shouldCloseButtonVisible() {
        return this.isAnyControlButtonVisible();
    }

    private boolean shouldHideAutohideButtonVisible() {
        return this._frame.getHideAutohideAction().isEnabled() && (this._frame.getAvailableButtons() & 2) != 0;
    }

    private boolean shouldAutohideButtonVisible() {
        return this.isAnyControlButtonVisible();
    }

    private boolean shouldFloatButtonVisible() {
        return this.isAnyControlButtonVisible();
    }

    private boolean shouldMaximizeButtonVisible() {
        return this.isAnyControlButtonVisible();
    }

    @Override
    protected boolean dockableFrameHasFocus() {
        return true;
    }

    public class AquaCloseButton
    extends JButton
    implements UIResource {
        @Override
        public void updateUI() {
            super.updateUI();
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusPainted(false);
            this.setRolloverEnabled(true);
        }

        public AquaCloseButton() {
            this.setContentAreaFilled(false);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            AquaJideUtils.antialiasShape(g, true);
            Color color = g.getColor();
            if (this.isEnabled()) {
                if (this.getModel().isRollover() && this.getModel().isPressed()) {
                    g.setColor(COLOR1);
                    g.fillOval(1, 2, this.getWidth() - 3, this.getHeight() - 4);
                    g.setColor(COLOR2);
                } else if (this.getModel().isRollover()) {
                    g.setColor(COLOR1);
                    g.fillOval(1, 2, this.getWidth() - 3, this.getHeight() - 4);
                    g.setColor(COLOR3);
                } else {
                    g.setColor(COLOR1);
                }
            }
            int centerX = this.getWidth() >> 1;
            int centerY = this.getHeight() >> 1;
            if (this.isEnabled()) {
                g.drawLine(centerX - 2, centerY - 2, centerX + 2, centerY + 2);
                g.drawLine(centerX - 3, centerY - 2, centerX + 1, centerY + 2);
                g.drawLine(centerX + 2, centerY - 2, centerX - 2, centerY + 2);
                g.drawLine(centerX + 1, centerY - 2, centerX - 3, centerY + 2);
            } else {
                g.drawLine(centerX - 3, centerY - 3, centerX + 3, centerY + 3);
                g.drawLine(centerX + 3, centerY - 3, centerX - 3, centerY + 3);
            }
            g.setColor(color);
            AquaJideUtils.antialiasShape(g, false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    public class AquaTitlePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 0;
            int height = 0;
            Dimension titleBarComponentSize = AquaDockableFrameTitlePane.this._frame.getTitleBarComponent() != null && AquaDockableFrameTitlePane.this._frame.getTitleBarComponent().isVisible() ? AquaDockableFrameTitlePane.this._frame.getTitleBarComponent().getPreferredSize() : new Dimension(0, 0);
            Dimension buttonSize = AquaDockableFrameTitlePane.this.getMaximumButtonSize();
            width += AquaDockableFrameTitlePane.this.calculateButtonWidth();
            FontMetrics fm = AquaDockableFrameTitlePane.this.getFontMetrics(AquaDockableFrameTitlePane.this.getFont());
            String frameTitle = AquaDockableFrameTitlePane.this._frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 && frameTitle != null ? (width += title_w < (subtitle_w = fm.stringWidth(frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            width = Math.max(titleBarComponentSize.width, width);
            height = Math.max(fm.getHeight() + 2, height);
            height = Math.max(buttonSize.height + (AquaDockableFrameTitlePane.this._closeIcon == null ? 0 : 5), height);
            if (AquaDockableFrameTitlePane.this.getBorder() != null) {
                Insets insets = AquaDockableFrameTitlePane.this.getBorder().getBorderInsets(c);
                height += insets.top + insets.bottom;
                width += insets.left + insets.right;
            }
            height += ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.bottom;
            height = AquaDockableFrameTitlePane.this.isSameLine(c) ? Math.max(titleBarComponentSize.height, height) : (height += titleBarComponentSize.height);
            return new Dimension(width, height);
        }

        @Override
        public void layoutContainer(Container c) {
            int x;
            boolean leftToRight = AquaDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() && AquaDockableFrameTitlePane.this._buttonsAlignment == 11;
            int w = c.getWidth() - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.right;
            int h = AquaDockableFrameTitlePane.this.getTitleBarHeight() - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.bottom;
            Dimension buttonSize = AquaDockableFrameTitlePane.this.getMaximumButtonSize();
            int buttonHeight = buttonSize.height + (AquaDockableFrameTitlePane.this._closeIcon == null ? 0 : 2);
            int buttonWidth = buttonSize.width + AquaDockableFrameTitlePane.this._buttonGap;
            int n = x = leftToRight ? AquaDockableFrameTitlePane.this.getWidth() - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.right : ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left;
            if (!leftToRight) {
                x += AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left + 2 : 0;
            }
            int offset = leftToRight ? -(buttonWidth + AquaDockableFrameTitlePane.this._buttonGap) : buttonWidth + AquaDockableFrameTitlePane.this._buttonGap;
            int voffset = 0;
            boolean firstOne = true;
            boolean usingMacStandardIcons = UIDefaultsLookup.getBoolean("DockableFrame.usingMacStandardIcons");
            if (usingMacStandardIcons) {
                if (AquaDockableFrameTitlePane.this.shouldCloseButtonVisible()) {
                    if (AquaDockableFrameTitlePane.this._closeButton != null) {
                        if (firstOne) {
                            x += leftToRight ? offset : 0;
                            firstOne = false;
                        } else {
                            x += offset;
                        }
                        AquaDockableFrameTitlePane.this._closeButton.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                    }
                } else if (AquaDockableFrameTitlePane.this._closeButton != null) {
                    AquaDockableFrameTitlePane.this._closeButton.setBounds(0, 0, 0, 0);
                }
            } else if (AquaDockableFrameTitlePane.this.shouldFloatButtonVisible()) {
                if (AquaDockableFrameTitlePane.this._floatButton != null) {
                    if (firstOne) {
                        x += leftToRight ? offset : 0;
                        firstOne = false;
                    } else {
                        x += offset;
                    }
                    AquaDockableFrameTitlePane.this._floatButton.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                }
            } else if (AquaDockableFrameTitlePane.this._floatButton != null) {
                AquaDockableFrameTitlePane.this._floatButton.setBounds(0, 0, 0, 0);
            }
            if (AquaDockableFrameTitlePane.this.shouldAutohideButtonVisible()) {
                if (AquaDockableFrameTitlePane.this._autohideButton != null) {
                    if (firstOne) {
                        x += leftToRight ? offset : 0;
                        firstOne = false;
                    } else {
                        x += offset;
                    }
                    AquaDockableFrameTitlePane.this._autohideButton.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                }
            } else if (AquaDockableFrameTitlePane.this._autohideButton != null) {
                AquaDockableFrameTitlePane.this._autohideButton.setBounds(0, 0, 0, 0);
            }
            if (AquaDockableFrameTitlePane.this.shouldHideAutohideButtonVisible()) {
                if (AquaDockableFrameTitlePane.this._hideAutohideButton != null) {
                    if (firstOne) {
                        x += leftToRight ? offset : 0;
                        firstOne = false;
                    } else {
                        x += offset;
                    }
                    AquaDockableFrameTitlePane.this._hideAutohideButton.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                }
            } else if (AquaDockableFrameTitlePane.this._hideAutohideButton != null) {
                AquaDockableFrameTitlePane.this._hideAutohideButton.setBounds(0, 0, 0, 0);
            }
            if (AquaDockableFrameTitlePane.this.shouldMaximizeButtonVisible()) {
                if (AquaDockableFrameTitlePane.this._maximizeButton != null) {
                    if (firstOne) {
                        x += leftToRight ? offset : 0;
                        firstOne = false;
                    } else {
                        x += offset;
                    }
                    AquaDockableFrameTitlePane.this._maximizeButton.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                }
            } else if (AquaDockableFrameTitlePane.this._maximizeButton != null) {
                AquaDockableFrameTitlePane.this._maximizeButton.setBounds(0, 0, 0, 0);
            }
            Insets insets = AquaDockableFrameTitlePane.this.getInsets();
            if (AquaDockableFrameTitlePane.this._frame.getTitleBarComponent() != null && AquaDockableFrameTitlePane.this._frame.getTitleBarComponent().isVisible()) {
                int cWidth = ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._frame.getTitleBarComponent().getPreferredSize().width;
                if (AquaDockableFrameTitlePane.this.isSameLine(c)) {
                    AquaDockableFrameTitlePane.this._frame.getTitleBarComponent().setBounds(x += offset, insets.top + 1, cWidth, h - 2);
                } else {
                    AquaDockableFrameTitlePane.this._frame.getTitleBarComponent().setBounds(insets.left, h + 2, c.getWidth() - insets.left - insets.right, AquaDockableFrameTitlePane.this.getHeight() - h - 2 - insets.top - insets.bottom);
                }
            }
            if (AquaDockableFrameTitlePane.this._titleAlignment == 0) {
                if (leftToRight) {
                    if ((w + ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._title.getPreferredSize().width) / 2 > x - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left - (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0)) {
                        AquaDockableFrameTitlePane.this._title.setBounds(((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left + (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, x - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left - (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), h);
                        if (AquaDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)AquaDockableFrameTitlePane.this._title).setHorizontalAlignment(11);
                        }
                    } else {
                        AquaDockableFrameTitlePane.this._title.setBounds(((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left + (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, w, h);
                        if (AquaDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)AquaDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                        }
                    }
                } else if ((w - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._title.getPreferredSize().width) / 2 < (x += offset)) {
                    AquaDockableFrameTitlePane.this._title.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, w - x - (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), h);
                    if (AquaDockableFrameTitlePane.this._title instanceof JLabel) {
                        ((JLabel)AquaDockableFrameTitlePane.this._title).setHorizontalAlignment(10);
                    }
                } else {
                    AquaDockableFrameTitlePane.this._title.setBounds(((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, w, h);
                    if (AquaDockableFrameTitlePane.this._title instanceof JLabel) {
                        ((JLabel)AquaDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                    }
                }
            } else if (leftToRight) {
                AquaDockableFrameTitlePane.this._title.setBounds(((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left + (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, x - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.left - (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), h);
            } else {
                AquaDockableFrameTitlePane.this._title.setBounds(x, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top, w - x - (AquaDockableFrameTitlePane.this._frame.isShowGripper() ? AquaDockableFrameTitlePane.this._gripperWidth : 0), h);
            }
            if (!usingMacStandardIcons) {
                if (AquaDockableFrameTitlePane.this.shouldCloseButtonVisible()) {
                    if (AquaDockableFrameTitlePane.this._closeButton != null) {
                        if (firstOne) {
                            x += leftToRight ? offset : 0;
                            firstOne = false;
                        } else {
                            x += offset;
                        }
                        AquaDockableFrameTitlePane.this._closeButton.setBounds(AquaDockableFrameTitlePane.this._frame.getWidth() - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.right - offset, ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.top + (h - buttonHeight) / 2 + voffset, buttonWidth, buttonHeight);
                    }
                } else if (AquaDockableFrameTitlePane.this._closeButton != null) {
                    AquaDockableFrameTitlePane.this._closeButton.setBounds(0, 0, 0, 0);
                }
            }
            if (AquaDockableFrameTitlePane.this._gripper != null) {
                if (AquaDockableFrameTitlePane.this._frame.isShowGripper()) {
                    Rectangle gripperRect = AquaDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, 0, AquaDockableFrameTitlePane.this._gripperWidth, AquaDockableFrameTitlePane.this.getTitleBarHeight()) : new Rectangle(AquaDockableFrameTitlePane.this.getWidth() - AquaDockableFrameTitlePane.this._gripperWidth, 0, AquaDockableFrameTitlePane.this.getWidth() - ((AquaDockableFrameTitlePane)AquaDockableFrameTitlePane.this)._titleInsets.right, AquaDockableFrameTitlePane.this.getTitleBarHeight());
                    AquaDockableFrameTitlePane.this._gripper.setBounds(gripperRect);
                } else {
                    AquaDockableFrameTitlePane.this._gripper.setBounds(new Rectangle(0, 0, 0, 0));
                }
            }
        }
    }

    protected class ButtonChangeListener
    implements ChangeListener,
    Serializable {
        @Override
        public void stateChanged(ChangeEvent changeevent) {
            if (AquaDockableFrameTitlePane.this._closeButton != null && AquaDockableFrameTitlePane.this._closeButton.isEnabled()) {
                AquaDockableFrameTitlePane.this._closeButton.repaint();
            }
            if (AquaDockableFrameTitlePane.this._floatButton != null && AquaDockableFrameTitlePane.this._floatButton.isEnabled()) {
                AquaDockableFrameTitlePane.this._floatButton.repaint();
            }
            if (AquaDockableFrameTitlePane.this._autohideButton != null && AquaDockableFrameTitlePane.this._autohideButton.isEnabled()) {
                AquaDockableFrameTitlePane.this._autohideButton.repaint();
            }
            if (AquaDockableFrameTitlePane.this._maximizeButton != null && AquaDockableFrameTitlePane.this._maximizeButton.isEnabled()) {
                AquaDockableFrameTitlePane.this._maximizeButton.repaint();
            }
        }

        ButtonChangeListener() {
        }
    }
}

