/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.plaf.UIResource;

public class Workspace
extends JPanel
implements DockableHolder,
Refocusable {
    private static final Logger LOGGER_FOCUS = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    private DockingManager _dockingManager;
    private boolean _acceptDockableFrame = true;
    private WeakReference<Component> _defaultFocusComponent;
    private WeakReference<Component> _lastFocusedComponent;
    private String _layoutConstraint = null;
    private boolean _adjustOpacityOnFly = false;

    public Workspace() {
        this((DockingManager)null);
    }

    public Workspace(DockingManager dockingManager) {
        super(new BorderLayout());
        this.setDockingManager(dockingManager);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        JideFocusTracker currentFocusOwnerTracker = new JideFocusTracker(this);
        currentFocusOwnerTracker.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                if (!evt.isTemporary()) {
                    Workspace.this.setLastFocusedComponent(evt.getComponent());
                }
            }
        });
        this.setOpaque(false);
        this.updateUI();
    }

    public boolean isAdjustOpacityOnFly() {
        return this._adjustOpacityOnFly;
    }

    public void setAdjustOpacityOnFly(boolean adjustOpacityOnFly) {
        this._adjustOpacityOnFly = adjustOpacityOnFly;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isOpaque() && this.isAdjustOpacityOnFly() && this.isEmpty(this)) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private boolean isEmpty(Container container) {
        return container.getComponentCount() == 0 || container.getComponentCount() == 1 && container.getComponent(0) instanceof JideSplitPane && this.isEmpty((Container)container.getComponent(0));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
            this.setBackground(UIDefaultsLookup.getColor("Workspace.background"));
        }
    }

    public boolean isAcceptDockableFrame() {
        return this._acceptDockableFrame;
    }

    public void setAcceptDockableFrame(boolean acceptDockableFrame) {
        this._acceptDockableFrame = acceptDockableFrame;
    }

    @Override
    public boolean requestFocusInInternalWindow() {
        Component comp;
        if (this.getDockingManager() == null) {
            LOGGER_FOCUS.fine("Workspace :requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        if (this.getComponentCount() == 0) {
            return this.requestFocusInWindow();
        }
        if (this != this.getFocusedComponent() && this.isAncestorOf(comp = this.getFocusedComponent()) && JideSwingUtilities.passesFocusabilityTest(comp)) {
            return comp.requestFocusInWindow();
        }
        comp = this.getDefaultFocusComponent();
        if (this != comp && this.isAncestorOf(comp) && JideSwingUtilities.passesFocusabilityTest(comp)) {
            return comp.requestFocusInWindow();
        }
        if (!JideSwingUtilities.compositeRequestFocus(this.getComponent(0))) {
            return this.requestFocusInWindow();
        }
        return true;
    }

    public boolean requestFocusInInternalWindowNew() {
        if (this.getDockingManager() == null) {
            return false;
        }
        Component focusComponent = this.getFocusedComponent();
        boolean success = JideSwingUtilities.passesFocusabilityTest(focusComponent);
        if (success) {
            focusComponent.requestFocus();
            return true;
        }
        success = JideSwingUtilities.compositeRequestFocus(this);
        return success;
    }

    @Override
    public Component getFocusedComponent() {
        if (this._lastFocusedComponent == null) {
            return this.getDefaultFocusComponent();
        }
        return (Component)this._lastFocusedComponent.get();
    }

    protected void setLastFocusedComponent(Component lastFocusedComponent) {
        if (lastFocusedComponent == this) {
            lastFocusedComponent = null;
        }
        this._lastFocusedComponent = new WeakReference<Component>(lastFocusedComponent);
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent != null ? (Component)this._defaultFocusComponent.get() : null;
    }

    @Override
    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this._defaultFocusComponent = new WeakReference<Component>(defaultFocusComponent);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (!(comp instanceof ContainerContainer)) {
            this.setAcceptDockableFrame(false);
        }
        super.addImpl(comp, constraints, index);
    }

    public void setDockingManager(DockingManager dockingManager) {
        this._dockingManager = dockingManager;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    public String getLayoutConstraint() {
        if (this._layoutConstraint == null || !"vary".equals(this._layoutConstraint) && !"flexible".equals(this._layoutConstraint) && !"fix".equals(this._layoutConstraint)) {
            return SecurityUtils.getProperty("jide.workspaceConstraints", "vary");
        }
        return this._layoutConstraint;
    }

    public void setLayoutConstraint(String layoutConstraint) {
        this._layoutConstraint = layoutConstraint;
    }
}

