/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.ContainerContainerDivider;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingFrameworkContour;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.utils.SecurityUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class OutlineContour
extends JComponent
implements DockingFrameworkContour {
    private static final Logger LOGGER_OUTLINE = Logger.getLogger(DefaultDockingManager.class.getName() + ".outline");
    private int _thickness = 4;
    private float _alpha = 0.5f;
    private static final int TAB_WIDTH = 42;
    private static final int TAB_LEADING = 8;
    private Color _lineColor = new Color(136, 136, 136);
    private int _tabHeight = 22;
    private boolean _allowDocking = true;
    private boolean _tabDocking;
    private int _tabSide;
    private boolean _floating;
    private Component _attachedComponent;
    private DockingManager _attachedDockingManager;
    private int _attachedSide;
    private boolean _single;
    private JComponent _saveDraggedComponent;
    private int _saveX;
    private int _saveY;
    private int _saveMouseModifier;
    private int _currentMouseX;
    private int _currentMouseY;
    private Container _relativeContainer;
    private int _outlineMode = 0;
    private OutlineHW _fullOutline;
    private Outline _topOutline;
    private Outline _bottomOutline;
    private Outline _leftOutline;
    private Outline _rightOutline;
    private Content _emptyContent;
    private boolean _ghost = false;
    private Component _glassPane;
    private boolean _changeCursor = false;
    private double _relativeX;
    private double _relativeY;
    private int _dragStartOffsetX;
    private int _dragStartOffsetY;
    private JLayeredPane _activeLayerPane;
    private RootPaneContainer _rootPaneContainer;
    private int _sensitiveAreaSize = 40;
    private int _outsideSensitiveAreaSize = 40;
    private DockingManager _dockingManager;

    public OutlineContour() {
        this(22);
        this.setOpaque(false);
        this.setDoubleBuffered(true);
    }

    public OutlineContour(int tabHeight) {
        this._thickness = UIDefaultsLookup.getInt("Contour.thickness") == 0 ? 4 : UIDefaultsLookup.getInt("Contour.thickness");
        this._lineColor = UIDefaultsLookup.getColor("Contour.color") == null ? new Color(136, 136, 136) : UIDefaultsLookup.getColor("Contour.color");
        this.setTabHeight(tabHeight);
        if (this.isHeavyweight()) {
            this.initOutline();
        }
    }

    private boolean isHeavyweight() {
        return this.getOutlineMode() == 1 || this.getOutlineMode() == 2 || this.getOutlineMode() == 4 || this.getOutlineMode() == 5;
    }

    private void initOutline() {
        this._fullOutline = new OutlineHW();
        this._topOutline = new Outline();
        this._emptyContent = new Content();
        this._bottomOutline = new Outline();
        this._leftOutline = new Outline();
        this._rightOutline = new Outline();
    }

    @Override
    public boolean isDoubleBuffered() {
        return true;
    }

    @Override
    public void paint(Graphics g) {
        int mode;
        if (!this._ghost && (mode = this.getOutlineMode()) != 2 && mode != 4 && mode != 5) {
            this.paintOutline(g, false);
        }
    }

    private void paintOutline(Graphics g, boolean xorMode) {
        Rectangle bounds = this.getBounds();
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.getOutlineMode() != 5 && this.getOutlineMode() != 4) {
            g2d.translate(-bounds.x, -bounds.y);
        } else {
            bounds.x = 0;
            bounds.y = 0;
        }
        --bounds.width;
        --bounds.height;
        if (xorMode) {
            bounds = SwingUtilities.convertRectangle(this, bounds, this.getRelativeContainer());
        } else {
            g2d.setColor(this._lineColor);
        }
        if (this.getOutlineMode() != 2) {
            if (this.isTabDocking()) {
                if (this.getOutlineMode() != 3 && this.getOutlineMode() != 4) {
                    this.drawTab(g2d, bounds.x, bounds.y, bounds.width, bounds.height, this._tabHeight, 42, 8, this._thickness, this.getTabSide());
                } else {
                    this.fillTab(g2d, bounds.x, bounds.y, bounds.width, bounds.height, this._tabHeight, 42, 8, this._alpha, this.getTabSide());
                }
            } else if (this.getOutlineMode() != 3 && this.getOutlineMode() != 4) {
                this.drawRect(g2d, bounds.x, bounds.y, bounds.width, bounds.height, this._thickness);
            } else {
                this.fillTab(g2d, bounds.x, bounds.y, bounds.width, bounds.height, this._alpha);
            }
        }
        g2d.dispose();
    }

    private void paintTitle(Graphics g) {
        Container container;
        if (this._attachedDockingManager == null || !this._attachedDockingManager.isShowTitleOnOutline()) {
            return;
        }
        Rectangle bounds = this.getBounds();
        Color old = g.getColor();
        if (this.getOutlineMode() == 3) {
            ThemePainter painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
            if (painter != null) {
                g.setColor(painter.getDockableFrameTitleBarActiveForeground());
            } else {
                g.setColor(UIDefaultsLookup.getColor("activeCaptionText"));
            }
        } else {
            g.setColor(this._lineColor);
        }
        g.setFont(UIDefaultsLookup.getFont("DockableFrame.font"));
        JComponent component = this._saveDraggedComponent;
        String title = "";
        if (component instanceof DockableFrame) {
            title = ((DockableFrame)component).getTitle();
        }
        if (!this.isSingle() && (container = component.getParent()) instanceof JideTabbedPane && ((JideTabbedPane)container).getTabCount() > 1) {
            title = title + " (" + ((JideTabbedPane)container).getTabCount() + ")";
        }
        FontMetrics fm = g.getFontMetrics();
        int x = bounds.x + bounds.width / 2 - fm.stringWidth(title) / 2;
        int y = bounds.y + bounds.height / 2;
        JideSwingUtilities.drawString(this, g, title, x, y);
        g.setColor(old);
    }

    private void drawLine(Graphics g, int x1, int y1, int x2, int y2, int thick) {
        if (x1 == x2) {
            if (y2 > y1) {
                g.fillRect(x1, y1, thick, y2 - y1);
            } else {
                g.fillRect(x1, y2, thick, y1 - y2);
            }
        } else if (y1 == y2) {
            if (x2 > x1) {
                g.fillRect(x1, y1, x2 - x1, thick);
            } else {
                g.fillRect(x2, y1, x1 - x2, thick);
            }
        }
    }

    private void drawRect(Graphics g, int x, int y, int width, int height, int thick) {
        if (width <= thick) {
            this.drawLine(g, x, y, x, y + height, thick);
        } else if (height <= thick) {
            this.drawLine(g, x, y, x + width, y, thick);
        } else {
            this.drawLine(g, x, y, x + width - thick, y, thick);
            this.drawLine(g, x + width - thick, y, x + width - thick, y + height - thick, thick);
            this.drawLine(g, x + width, y + height - thick, x + thick, y + height - thick, thick);
            this.drawLine(g, x, y + height, x, y + thick, thick);
        }
        this.paintTitle(g);
    }

    private void fillTab(Graphics g, int x, int y, int width, int height, float alpha) {
        Graphics2D g2d = (Graphics2D)g.create();
        Composite old = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.fillRect(x, y, width, height);
        this.paintTitle(g2d);
        g2d.setComposite(old);
        g2d.drawRect(x, y, width, height);
        g2d.dispose();
    }

    private void drawTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick, int side) {
        switch (side) {
            case 1: {
                this.drawTopTab(g, x, y, width, height, tabHeight, tabWidth, tabLeading, thick);
                break;
            }
            case 3: {
                this.drawBottomTab(g, x, y, width, height, tabHeight, tabWidth, tabLeading, thick);
                break;
            }
            case 2: {
                this.drawLeftTab(g, x, y, width, height, tabWidth, tabHeight, tabLeading, thick);
                break;
            }
            case 4: {
                this.drawRightTab(g, x, y, width, height, tabWidth, tabHeight, tabLeading, thick);
            }
        }
        this.paintTitle(g);
    }

    private void drawTopTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        this.drawLine(g, x + width - thick, y + tabHeight, x + width - thick, y + height - 1, thick);
        this.drawLine(g, x + tabLeading + thick, y + tabHeight, x, y + tabHeight, thick);
        this.drawLine(g, x + tabWidth + tabLeading, y + tabHeight, x + tabWidth + tabLeading, y, thick);
        this.drawLine(g, x + tabWidth + tabLeading, y, x + tabLeading + 1, y, thick);
        this.drawLine(g, x + tabLeading, y, x + tabLeading, y + tabHeight, thick);
        this.drawLine(g, x + width, y + tabHeight, x + tabWidth + tabLeading, y + tabHeight, thick);
        this.drawLine(g, x, y + tabHeight, x, y + height, thick);
        this.drawLine(g, x, y + height - thick, x + width, y + height - thick, thick);
    }

    private void fillTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, float alpha, int tabPlacement) {
        Polygon p;
        Graphics2D g2d = (Graphics2D)g.create();
        Composite old = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        switch (tabPlacement) {
            case 3: {
                p = new Polygon(new int[]{x, x + width, x + width, x + tabLeading + tabWidth, x + tabLeading + tabWidth, x + tabLeading, x + tabLeading, x}, new int[]{y, y, y + height - tabHeight, y + height - tabHeight, y + height, y + height, y + height - tabHeight, y + height - tabHeight}, 8);
                break;
            }
            case 2: {
                p = new Polygon(new int[]{x, x + tabHeight, x + tabHeight, x + width, x + width, x + tabHeight, x + tabHeight, x}, new int[]{y + tabLeading, y + tabLeading, y, y, y + height, y + height, y + tabLeading + tabWidth, y + tabLeading + tabWidth}, 8);
                break;
            }
            case 4: {
                p = new Polygon(new int[]{x, x + width - tabHeight, x + width - tabHeight, x + width, x + width, x + width - tabHeight, x + width - tabHeight, x}, new int[]{y, y, y + tabLeading, y + tabLeading, y + tabLeading + tabWidth, y + tabLeading + tabWidth, y + height, y + height}, 8);
                break;
            }
            default: {
                p = new Polygon(new int[]{x + tabLeading, x + tabLeading + tabWidth, x + tabLeading + tabWidth, x + width, x + width, x, x, x + tabLeading}, new int[]{y, y, y + tabHeight, y + tabHeight, y + height, y + height, y + tabHeight, y + tabHeight}, 8);
            }
        }
        g2d.fillPolygon(p);
        this.paintTitle(g2d);
        g2d.setComposite(old);
        g2d.drawPolygon(p);
        g2d.dispose();
    }

    private void drawBottomTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        this.drawLine(g, x, y, x + width - 1, y, thick);
        this.drawLine(g, x + width - thick, y, x + width - thick, y + height - tabHeight - 1, thick);
        this.drawLine(g, x + width, y + height - tabHeight - thick, x + tabWidth + tabLeading, y + height - tabHeight - thick, thick);
        this.drawLine(g, x + tabWidth + tabLeading, y + height - tabHeight, x + tabWidth + tabLeading, y + height, thick);
        this.drawLine(g, x + tabWidth + tabLeading, y + height - thick, x + tabLeading + 1, y + height - thick, thick);
        this.drawLine(g, x + tabLeading, y + height, x + tabLeading, y + height - tabHeight, thick);
        this.drawLine(g, x + tabLeading + thick, y + height - tabHeight - thick, x + 1, y + height - tabHeight - thick, thick);
        this.drawLine(g, x, y + height - tabHeight, x, y + 1, thick);
    }

    private void drawLeftTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        this.drawLine(g, x + tabWidth, y, x + width, y, thick);
        this.drawLine(g, x + width - thick, y, x + width - thick, y + height - 1, thick);
        this.drawLine(g, x + tabWidth, y, x + tabWidth, y + tabLeading + thick, thick);
        this.drawLine(g, x + tabWidth, y + tabLeading, x, y + tabLeading, thick);
        this.drawLine(g, x, y + tabLeading, x, y + tabHeight + tabLeading, thick);
        this.drawLine(g, x + tabWidth, y + tabHeight + tabLeading, x, y + tabHeight + tabLeading, thick);
        this.drawLine(g, x + tabWidth, y + tabHeight + tabLeading, x + tabWidth, y + height, thick);
        this.drawLine(g, x + tabWidth, y + height - thick, x + width, y + height - thick, thick);
    }

    private void drawRightTab(Graphics g, int x, int y, int width, int height, int tabHeight, int tabWidth, int tabLeading, int thick) {
        this.drawLine(g, x, y, x + width - tabWidth, y, thick);
        this.drawLine(g, x, y + height - thick, x + width - tabWidth, y + height - thick, thick);
        this.drawLine(g, x + width - tabWidth - thick, y, x + width - tabWidth - thick, y + tabLeading + thick, thick);
        this.drawLine(g, x + width - tabWidth - thick, y + tabLeading, x + width - thick, y + tabLeading, thick);
        this.drawLine(g, x + width - thick, y + tabLeading, x + width - thick, y + tabHeight + tabLeading + thick, thick);
        this.drawLine(g, x + width - tabWidth - thick, y + tabHeight + tabLeading, x + width - thick, y + tabHeight + tabLeading, thick);
        this.drawLine(g, x + width - tabWidth - thick, y + tabHeight + tabLeading, x + width - tabWidth - thick, y + height, thick);
        this.drawLine(g, x, y + height - thick, x, y + 1, thick);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.isLightweight()) {
            if (!this.isHeavyweight()) {
                if (this._ghost && (this.getRelativeContainer() != null || this.getParent() != null)) {
                    Graphics g = this.getRelativeContainer().getGraphics();
                    g.setXORMode(this._lineColor);
                    this.paintOutline(g, true);
                }
                super.setBounds(x, y, width, height);
            } else {
                Rectangle rectangle = new Rectangle(x, y, width, height);
                if (this.getParent() != null) {
                    Rectangle parentRectangle = this.getParent().getBounds();
                    super.setBounds(x, y, width, height);
                    if (this.getOutlineMode() == 1 && parentRectangle.contains(rectangle)) {
                        this._leftOutline.setVisible(false);
                        this._rightOutline.setVisible(false);
                        this._topOutline.setVisible(false);
                        this._bottomOutline.setVisible(false);
                        this._emptyContent.setVisible(false);
                    } else {
                        super.setVisible(false);
                        Point point = rectangle.getLocation();
                        SwingUtilities.convertPointToScreen(point, this.getParent());
                        this.arrangeOutline(rectangle, point);
                    }
                }
            }
        } else if (this.getRelativeContainer() != null) {
            Point point = new Point(x, y);
            SwingUtilities.convertPointToScreen(point, this.getRelativeContainer());
            super.setBounds(point.x, point.y, width, height);
        }
    }

    private void arrangeOutline(Rectangle rectangle, Point point) {
        if (this.getOutlineMode() == 5 || this.getOutlineMode() == 4) {
            this._fullOutline.setBounds(point.x, point.y, rectangle.width - 1, rectangle.height);
            if (!this._fullOutline.isVisible()) {
                this._fullOutline.setVisible(true);
            }
        } else {
            this._leftOutline.setBounds(point.x, point.y, this._thickness, rectangle.height - this._thickness);
            this._topOutline.setBounds(point.x + this._thickness, point.y, rectangle.width - this._thickness - 1, this._thickness);
            this._emptyContent.setBounds(point.x + this._currentMouseX - 1, point.y + this._currentMouseY - 1, 2, 2);
            this._rightOutline.setBounds(point.x + rectangle.width - this._thickness - 1, point.y + this._thickness, this._thickness, rectangle.height - this._thickness);
            this._bottomOutline.setBounds(point.x, point.y + rectangle.height - this._thickness, rectangle.width - 1, this._thickness);
            if (!this._topOutline.isVisible()) {
                this._topOutline.setVisible(true);
            }
            if (!this._leftOutline.isVisible()) {
                this._leftOutline.setVisible(true);
            }
            if (!this._rightOutline.isVisible()) {
                this._rightOutline.setVisible(true);
            }
            if (!this._bottomOutline.isVisible()) {
                this._bottomOutline.setVisible(true);
            }
            if (!this._emptyContent.isVisible()) {
                this._emptyContent.setVisible(true);
            }
        }
    }

    private void checkParent() {
        RootPaneContainer rpc = this._rootPaneContainer;
        if (rpc == null) {
            return;
        }
        if (rpc instanceof JDialog) {
            this._fullOutline = this.recreateOutline(this._fullOutline, rpc);
            this._leftOutline = this.recreateOutline(this._leftOutline, rpc);
            this._rightOutline = this.recreateOutline(this._rightOutline, rpc);
            this._topOutline = this.recreateOutline(this._topOutline, rpc);
            this._bottomOutline = this.recreateOutline(this._bottomOutline, rpc);
        } else {
            this._fullOutline = this.recreateOutline(this._fullOutline, null);
            this._leftOutline = this.recreateOutline(this._leftOutline, null);
            this._rightOutline = this.recreateOutline(this._rightOutline, null);
            this._topOutline = this.recreateOutline(this._topOutline, null);
            this._bottomOutline = this.recreateOutline(this._bottomOutline, null);
        }
    }

    private OutlineHW recreateOutline(OutlineHW outline, RootPaneContainer rpc) {
        if (outline == null) {
            if (rpc == null) {
                return new OutlineHW();
            }
            return new OutlineHW((JDialog)rpc);
        }
        if (rpc == null && outline.getOwner() instanceof JDialog) {
            outline.dispose();
            return new OutlineHW();
        }
        if (outline.getOwner().getClass().getName().indexOf("SharedOwnerFrame") != -1) {
            outline.dispose();
            return new OutlineHW((JDialog)rpc);
        }
        return outline;
    }

    private Outline recreateOutline(Outline outline, RootPaneContainer rpc) {
        if (outline == null) {
            if (rpc == null) {
                return new Outline();
            }
            return new Outline((JDialog)rpc);
        }
        if (rpc == null && outline.getOwner() instanceof JDialog) {
            outline.dispose();
            return new Outline();
        }
        if (outline.getOwner().getClass().getName().indexOf("SharedOwnerFrame") != -1) {
            outline.dispose();
            return new Outline((JDialog)rpc);
        }
        return outline;
    }

    @Override
    public int getTabHeight() {
        return this._tabHeight;
    }

    @Override
    public void setTabHeight(int tabHeight) {
        this._tabHeight = tabHeight == 0 ? 22 : tabHeight;
    }

    @Override
    public boolean isTabDocking() {
        return this._tabDocking;
    }

    @Override
    public void setTabDocking(boolean tabDocking) {
        this._tabDocking = tabDocking;
        this.updateCursor();
    }

    @Override
    public int getTabSide() {
        return this._tabSide;
    }

    @Override
    public void setTabSide(int tabSide) {
        this._tabSide = tabSide;
    }

    @Override
    public boolean isFloating() {
        return this._floating;
    }

    @Override
    public void setFloating(boolean floating) {
        this._floating = floating;
        this.updateCursor();
    }

    @Override
    public Component getAttachedComponent() {
        return this._attachedComponent;
    }

    @Override
    public DockingManager getAttachedDockingManager() {
        return this._attachedDockingManager;
    }

    @Override
    public void setAttachedDockingManager(DockingManager attachedDockingManager) {
        this._attachedDockingManager = attachedDockingManager;
    }

    @Override
    public void setAttachedComponent(Component attachedComponent) {
        this._attachedComponent = attachedComponent;
    }

    @Override
    public int getAttachedSide() {
        return this._attachedSide;
    }

    @Override
    public void setAttachedSide(int attachedSide) {
        this._attachedSide = attachedSide;
        this.updateCursor();
    }

    private void updateCursor() {
        if (!this._dockingManager.isUseGlassPaneEnabled()) {
            return;
        }
        if (this.getGlassPane() == null) {
            return;
        }
        if (!this.isVisible() && this._floating) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(23));
            return;
        }
        DockingUtils.clearGlassPaneCursor(this._dockingManager);
        if (!this._changeCursor) {
            return;
        }
        if (!this.isVisible()) {
            DockingUtils.clearGlassPaneCursor(this._dockingManager);
            return;
        }
        if (this.isVisible() && (!this._allowDocking || this._floating)) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(29));
        } else if (this.isVisible() && this._tabDocking) {
            DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(28));
        } else if (this.getAttachedComponent() instanceof JideSplitPaneDivider) {
            if (((JideSplitPaneDivider)this.getAttachedComponent()).getJideSplitPane().getOrientation() == 1) {
                DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(31));
            } else {
                DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(30));
            }
        } else {
            switch (this._attachedSide) {
                case 1: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(24));
                    break;
                }
                case 2: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(25));
                    break;
                }
                case 4: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(26));
                    break;
                }
                case 8: {
                    DockingUtils.updateGlassPaneCursor(this._dockingManager, JideCursors.getPredefinedCursor(27));
                    break;
                }
                default: {
                    DockingUtils.clearGlassPaneCursor(this._dockingManager);
                }
            }
        }
    }

    @Override
    public boolean isSingle() {
        return this._single;
    }

    @Override
    public void setSingle(boolean single) {
        this._single = single;
    }

    @Override
    public boolean isAllowDocking() {
        return this._allowDocking;
    }

    @Override
    public void setAllowDocking(boolean allowDocking) {
        this._allowDocking = allowDocking;
        this.updateCursor();
    }

    @Override
    public Container getRelativeContainer() {
        return this._relativeContainer;
    }

    @Override
    public void setRelativeContainer(Container relativeContainer) {
        this._relativeContainer = relativeContainer;
    }

    @Override
    public int getSaveX() {
        return this._saveX;
    }

    @Override
    public int getSaveY() {
        return this._saveY;
    }

    @Override
    public int getSaveMouseModifier() {
        return this._saveMouseModifier;
    }

    @Override
    public JComponent getSaveDraggedComponent() {
        return this._saveDraggedComponent;
    }

    @Override
    public void beginDraggingFrame(JComponent f, int mouseX, int mouseY, double relativeX, double relativeY, boolean single) {
        this.setChangeCursor(UIDefaultsLookup.getBoolean("DockingFramework.changeCursor"));
        if (f.isShowing() && f.isVisible()) {
            this._dragStartOffsetX = mouseX - f.getLocationOnScreen().x;
            this._dragStartOffsetY = mouseY - f.getLocationOnScreen().y;
        } else {
            this._dragStartOffsetX = 0;
            this._dragStartOffsetY = 0;
        }
        this._relativeX = relativeX;
        this._relativeY = relativeY;
        this._single = single;
    }

    private boolean floatingFrameFreeze() {
        return "true".equals(SecurityUtils.getProperty("docking.freezeFloatingWhileNotRearrangable", "false"));
    }

    @Override
    public void dragFrame(JComponent comp, int newX, int newY, int mouseModifier) {
        int gridSize = this._dockingManager.getSnapGridSize();
        if (gridSize > 0 && (newX - this._dragStartOffsetX) % gridSize != 0) {
            newX = newX > this._dragStartOffsetX ? (newX += gridSize - (newX - this._dragStartOffsetX) % gridSize) : (newX -= gridSize - (this._dragStartOffsetX - newX) % gridSize);
        }
        if (gridSize > 0 && (newY - this._dragStartOffsetY) % gridSize != 0) {
            newY = newY > this._dragStartOffsetY ? (newY += gridSize - (newY - this._dragStartOffsetY) % gridSize) : (newY -= gridSize - (this._dragStartOffsetY - newY) % gridSize);
        }
        this._saveDraggedComponent = comp;
        this._saveX = newX;
        this._saveY = newY;
        this._saveMouseModifier = mouseModifier;
        DockableFrame dockableFrame = (DockableFrame)comp;
        Rectangle undockedBounds = dockableFrame.getUndockedBounds();
        if (!((!dockableFrame.isFloated() || this._dockingManager.isRearrangable() && dockableFrame.isRearrangable() || this.floatingFrameFreeze()) && dockableFrame.isDockable())) {
            Rectangle bounds = this.calculateContourBounds(new Rectangle(0, 0, undockedBounds.width, undockedBounds.height), newX, newY);
            Point point = bounds.getLocation();
            SwingUtilities.convertPointToScreen(point, this.getRootPaneContainerAsComponent());
            Container floatingContainer = dockableFrame.getTopLevelAncestor();
            if (floatingContainer instanceof FloatingContainer) {
                floatingContainer.setLocation(point.x, point.y + (DockingUtils.isFloatingContainerDecorated((FloatingContainer)((Object)floatingContainer)) ? 0 : 20));
                LOGGER_OUTLINE.fine("FloatingContainer.setLocation " + floatingContainer.getX() + ", " + floatingContainer.getY());
            }
            return;
        }
        if (!this._dockingManager.isRearrangable() || !dockableFrame.isRearrangable()) {
            return;
        }
        Point screenPoint = new Point(newX, newY);
        SwingUtilities.convertPointToScreen(screenPoint, this.getRootPaneContainerAsComponent());
        Component firstWindow = (Component)((Object)this._dockingManager.findFloatingComponentAt(screenPoint.x, screenPoint.y));
        DockedFrameContainer mainComponent = this.getDockingManager().getDockedFrameContainer();
        boolean visible = true;
        boolean showing = true;
        for (Container parent = mainComponent; parent != null && !(parent instanceof JRootPane); parent = parent.getParent()) {
            if (!parent.isVisible()) {
                visible = false;
                break;
            }
            if (parent.isShowing()) continue;
            showing = false;
        }
        if (dockableFrame.isDockable() && this.isAllowDocking() && this.getDockingManager().isAutoDocking() && visible) {
            Rectangle bounds;
            Container targetParent;
            Component component;
            Point contentPanePoint;
            int outside;
            Point mainComponentPoint = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), newX, newY, mainComponent);
            int n = outside = this._dockingManager.isSideDockAllowed() ? DockingUtils.outsideOfComponent(mainComponent, mainComponentPoint.x, mainComponentPoint.y, this.getOutsideSensitiveAreaSize()) : 32;
            if (dockableFrame.getDockingManager().isPreserveStateOnDragging() && dockableFrame.isFloated()) {
                outside = 32;
            }
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            FloatingContainer floatingContainer = null;
            if (this.getDockingManager().isNestedFloatingAllowed() && firstWindow instanceof FloatingContainer) {
                floatingContainer = (FloatingContainer)((Object)firstWindow);
            }
            if (floatingContainer == null) {
                if (outside != 32 && (outside & this.getDockingManager().getAllowedDockSides()) == 0) {
                    outside = 32;
                }
                if (outside != 32 && this.getDockingManager().getMaximizedFrameKey() != null) {
                    outside = 32;
                }
                if (outside != 32 && outside != 16 && DockingUtils.getContainerContainerOnSide(outside, this.getDockingManager().getDockedFrameContainer(), this.getDockingManager().getWorkspace()) != null) {
                    outside = 32;
                }
                switch (outside) {
                    case 1: {
                        width = ((Component)mainComponent).getWidth();
                        height = Math.min(dockableFrame.getDockedHeight(), ((Component)mainComponent).getHeight() / 2);
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 2: {
                        width = ((Component)mainComponent).getWidth();
                        height = Math.min(dockableFrame.getDockedHeight(), ((Component)mainComponent).getHeight() / 2);
                        x = 0;
                        y = ((Component)mainComponent).getHeight() - height;
                        break;
                    }
                    case 8: {
                        width = Math.min(dockableFrame.getDockedWidth(), ((Component)mainComponent).getWidth() / 2);
                        height = ((Component)mainComponent).getHeight();
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 4: {
                        width = Math.min(dockableFrame.getDockedWidth(), ((Component)mainComponent).getWidth() / 2);
                        height = ((Component)mainComponent).getHeight();
                        x = ((Component)mainComponent).getWidth() - width;
                        y = 0;
                        break;
                    }
                }
                if (outside != 32 && this.getDockingManager().isDropAllowed(dockableFrame, mainComponent, outside) && showing) {
                    this.setAttachedComponent(mainComponent);
                    this.setAttachedDockingManager(this.getDockingManager());
                    this.setAttachedSide(outside);
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    Rectangle bounds2 = this.calculateContourBounds(new Rectangle(x, y, width, height), mainComponent);
                    this.setContourBounds(bounds2);
                    this.setTabDocking(false);
                    this.setFloating(false);
                    LOGGER_OUTLINE.fine("Dock to outside " + outside);
                    return;
                }
            }
            if (floatingContainer == null) {
                List<DockingManager> allDockingManagers;
                this.showOutline(this.getRootPaneContainer().getLayeredPane());
                contentPanePoint = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), newX, newY, this.getDockingManager().getDockedFrameContainer());
                component = this.getDockingManager().getDockedFrameContainer().findComponentAt(contentPanePoint.x, contentPanePoint.y);
                this.setAttachedDockingManager(this.getDockingManager());
                if (component == null && this.getDockingManager().isCrossDraggingAllowed() && (allDockingManagers = DefaultDockingManager.getAllDockingManagers()).size() >= 1 && !this.getDockingManager().isWithinFrameBoundsOnDragging()) {
                    for (DockingManager manager : allDockingManagers) {
                        if (manager == this.getDockingManager() || !manager.isCrossDroppingAllowed() || manager.getFrame(dockableFrame.getKey()) != null) continue;
                        DockedFrameContainer topLevelAncestor = manager.getDockedFrameContainer();
                        Point p = SwingUtilities.convertPoint(this.getDockingManager().getDockedFrameContainer(), contentPanePoint, topLevelAncestor);
                        component = topLevelAncestor.findComponentAt(p.x, p.y);
                        if (component == null) continue;
                        Container container = component.getParent();
                        boolean validDockingManager = true;
                        do {
                            if (container instanceof DockedFrameContainer) {
                                boolean bl = validDockingManager = container == topLevelAncestor;
                                if (validDockingManager || !(container.getParent() instanceof ContainerContainer)) break;
                                DockingManager targetManager = ((ContainerContainer)container.getParent()).getDockingManager();
                                if (dockableFrame.getDockingManager() == targetManager || targetManager.isCrossDroppingAllowed()) break;
                                container = container.getParent();
                                continue;
                            }
                            container = container.getParent();
                        } while (container != null);
                        if (!validDockingManager) continue;
                        if (manager != this.getAttachedDockingManager()) {
                            this.setAttachedDockingManager(manager);
                            this.showOutline(this.getAttachedDockingManager().getRootPaneContainer().getLayeredPane());
                        }
                        break;
                    }
                }
            } else {
                this.showOutline(floatingContainer.getLayeredPane());
                contentPanePoint = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), newX, newY, floatingContainer.getContentPane());
                component = floatingContainer.getContentPane().findComponentAt(contentPanePoint.x, contentPanePoint.y);
                this.setAttachedDockingManager(floatingContainer.getDockingManager());
            }
            component = DockingUtils.getValidParentOf(component, dockableFrame, this.isSingle());
            DockableFrame targetFrame = null;
            if (component instanceof DockableFrame) {
                targetFrame = (DockableFrame)component;
                this.setAttachedComponent(targetFrame);
                this.setAttachedDockingManager(targetFrame.getDockingManager());
            } else if (component instanceof FrameContainer) {
                targetFrame = ((FrameContainer)component).getSelectedFrame();
                this.setAttachedComponent(component);
                this.setAttachedDockingManager(targetFrame.getDockingManager());
            } else if (component instanceof DockableHolder) {
                this.setAttachedComponent(component);
                this.setAttachedDockingManager(((DockableHolder)((Object)component)).getDockingManager());
            } else {
                this.setAttachedComponent(component);
            }
            if (dockableFrame.getDockingManager().isPreserveStateOnDragging()) {
                if (dockableFrame.isDocked() && targetFrame != null && targetFrame.isFloated()) {
                    component = null;
                }
                if (dockableFrame.isFloated() && DockingUtils.containsInMainContainer(this.getDockingManager().getDockedFrameContainer(), component)) {
                    component = null;
                }
            }
            if (this.getDockingManager().isTabDockAllowed() && dockableFrame.isTabDockAllowed() && component instanceof BasicDockableFrameTitlePane && showing) {
                targetParent = component.getParent();
                if (targetParent instanceof DockableFrame && (targetFrame = (DockableFrame)targetParent).getDockingManager().isDropAllowed(dockableFrame, targetFrame, 16)) {
                    boolean hasTab = true;
                    if (targetFrame.getParent() != null && targetFrame.getParent() instanceof FrameContainer && !((FrameContainer)targetFrame.getParent()).isTabShown()) {
                        hasTab = false;
                    }
                    if (targetFrame.getParent() instanceof FrameContainer) {
                        this.setTabHeight(((FrameContainer)targetFrame.getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)targetFrame.getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        bounds = this.calculateTabContourBounds(hasTab, targetFrame);
                        this.setContourBounds(bounds);
                        this.setTabDocking(true);
                        this.setFloating(false);
                    }
                    LOGGER_OUTLINE.fine("tabDocking to " + targetFrame.getKey());
                    return;
                }
            } else if (this._dockingManager.isSideDockAllowed() && component != null && component instanceof ContainerContainerDivider && showing) {
                targetParent = component.getParent();
                ContainerContainer targetPane = null;
                if (targetParent instanceof ContainerContainer) {
                    targetPane = (ContainerContainer)targetParent;
                }
                if (targetPane != null && targetPane.getDockingManager().isDropAllowed(dockableFrame, component, -1)) {
                    if (targetPane.getOrientation() == 1) {
                        width = dockableFrame.getDockedWidth();
                        height = targetPane.getHeight();
                        x = component.getX() - width / 2;
                        y = component.getY();
                    } else {
                        width = targetPane.getWidth();
                        height = dockableFrame.getDockedHeight();
                        x = component.getX();
                        y = component.getY() - height / 2;
                    }
                    bounds = this.calculateContourBounds(new Rectangle(x, y, width, height), targetPane);
                    if (!this.isVisible()) {
                        this.setVisible(true);
                    }
                    this.setContourBounds(bounds);
                    this.setTabDocking(false);
                    this.setFloating(false);
                    LOGGER_OUTLINE.fine("sideDocking");
                    return;
                }
            } else if (component != null && showing && (component instanceof Workspace || component instanceof FrameContainer && component.getParent() instanceof ContainerContainer)) {
                int side;
                Point p = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), newX, newY, component);
                boolean sideDockAllowed = true;
                if (component instanceof FrameContainer && ((FrameContainer)component).getSelectedFrame() != null && !((FrameContainer)component).getSelectedFrame().isSideDockAllowed()) {
                    sideDockAllowed = false;
                } else if (!this._dockingManager.isSideDockAllowed()) {
                    sideDockAllowed = false;
                }
                if (component instanceof FrameContainer && sideDockAllowed && ((FrameContainer)component).getUI() instanceof BasicJideTabbedPaneUI) {
                    Point tabPoint = SwingUtilities.convertPoint(this.getRootPaneContainerAsComponent(), newX, newY, ((BasicJideTabbedPaneUI)((FrameContainer)component).getUI())._tabScroller.viewport);
                    int tabIndex = ((BasicJideTabbedPaneUI)((FrameContainer)component).getUI()).getTabAtLocation(tabPoint.x, tabPoint.y);
                    if ((tabIndex >= 0 || ((BasicJideTabbedPaneUI)((FrameContainer)component).getUI()).isEmptyTabArea(tabPoint.x, tabPoint.y)) && this._dockingManager.isDropAllowed(dockableFrame, component, 16)) {
                        boolean hasTab = true;
                        if (targetFrame.getParent() != null && targetFrame.getParent() instanceof FrameContainer && !((FrameContainer)targetFrame.getParent()).isTabShown()) {
                            hasTab = false;
                        }
                        this.setTabHeight(((FrameContainer)targetFrame.getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)targetFrame.getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle bounds3 = this.calculateTabContourBounds(hasTab, targetFrame);
                        this.setContourBounds(bounds3);
                        this.setTabDocking(true);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("tabDocking to DockableFrame " + targetFrame.getKey());
                        return;
                    }
                }
                int n2 = side = sideDockAllowed ? DockingUtils.sideOfComponent(component, p.x, p.y, this.getSensitiveAreaSize(), dockableFrame.isTabDockAllowed()) : 16;
                if (16 == side && !dockableFrame.isTabDockAllowed()) {
                    side = 32;
                }
                if ((component instanceof Workspace || component instanceof FrameContainer) && side != 32 && (side & this.getAttachedDockingManager().getAllowedDockSides()) == 0) {
                    side = 32;
                }
                if (component instanceof FrameContainer && sideDockAllowed) {
                    ContainerContainer outerContainer;
                    ContainerContainer innerContainer;
                    if (side == 4 || side == 8) {
                        if (component.getParent() instanceof ContainerContainer && component.getParent().getParent() instanceof ContainerContainer) {
                            int sensitiveSide;
                            innerContainer = (ContainerContainer)component.getParent();
                            outerContainer = (ContainerContainer)innerContainer.getParent();
                            if (innerContainer.getOrientation() == 0 && outerContainer.getPaneCount() > 1 && (sensitiveSide = DockingUtils.sideOfComponent(innerContainer, p.x, p.y, this.getSensitiveAreaSize() / 2, dockableFrame.isTabDockAllowed())) == side) {
                                component = innerContainer;
                                this.setAttachedComponent(component);
                                this.setAttachedDockingManager(innerContainer.getDockingManager());
                            }
                        }
                    } else if ((side == 1 || side == 2) && component.getParent() instanceof ContainerContainer && component.getParent().getParent() instanceof ContainerContainer) {
                        int sensitiveSide;
                        innerContainer = (ContainerContainer)component.getParent();
                        outerContainer = (ContainerContainer)innerContainer.getParent();
                        if (innerContainer.getOrientation() == 1 && outerContainer.getPaneCount() > 1 && (sensitiveSide = DockingUtils.sideOfComponent(innerContainer, p.x, p.y, this.getSensitiveAreaSize() / 2, dockableFrame.isTabDockAllowed())) == side) {
                            component = innerContainer;
                            this.setAttachedComponent(component);
                            this.setAttachedDockingManager(innerContainer.getDockingManager());
                        }
                    }
                }
                switch (side) {
                    case 1: {
                        width = component.getWidth();
                        int height1 = dockableFrame.getDockedHeight();
                        int height2 = component.getPreferredSize().height;
                        height = height2 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == component ? height1 : component.getHeight() * height1 / (height2 + height1);
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 2: {
                        width = component.getWidth();
                        int height1 = dockableFrame.getDockedHeight();
                        int height2 = component.getPreferredSize().height;
                        height = height2 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == component ? height1 : component.getHeight() * height1 / (height2 + height1);
                        x = 0;
                        y = component.getHeight() - height;
                        break;
                    }
                    case 8: {
                        int width1 = dockableFrame.getDockedWidth();
                        int width2 = component.getPreferredSize().width;
                        width = width2 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == component ? width1 : component.getWidth() * width1 / (width2 + width1);
                        height = component.getHeight();
                        x = 0;
                        y = 0;
                        break;
                    }
                    case 4: {
                        int width1 = dockableFrame.getDockedWidth();
                        int width2 = component.getPreferredSize().width;
                        width = width2 == 0 || this._dockingManager != null && this._dockingManager.getWorkspace() == component ? width1 : component.getWidth() * width1 / (width2 + width1);
                        height = component.getHeight();
                        x = component.getWidth() - width;
                        y = 0;
                        break;
                    }
                    case 16: {
                        DockableFrame targetParent2;
                        DockingManager dockingManager = this.getAttachedDockingManager();
                        if (dockingManager == null) {
                            dockingManager = this.getDockingManager();
                        }
                        if (dockingManager.isTabDockAllowed() && dockingManager.isEasyTabDock() && component instanceof Workspace && ((Workspace)component).isAcceptDockableFrame() && ((Workspace)component).getDockingManager().isDropAllowed(dockableFrame, component, side)) {
                            FrameContainer targetFC = dockingManager.createFrameContainer();
                            boolean hasTab = false;
                            this.setTabHeight(targetFC.getTabHeight());
                            this.setTabSide(targetFC.getTabPlacement());
                            if (!this.isVisible()) {
                                this.setVisible(true);
                            }
                            Rectangle bounds4 = this.calculateTabContourBounds(hasTab, dockingManager.getWorkspace());
                            this.setContourBounds(bounds4);
                            this.setTabDocking(true);
                            this.setFloating(false);
                            LOGGER_OUTLINE.fine("tabDocking to Workspace");
                            return;
                        }
                        if (!dockingManager.isTabDockAllowed() || !dockingManager.isEasyTabDock() || !(component instanceof FrameContainer) || ((FrameContainer)component).getSelectedFrame() == null || !((FrameContainer)component).getSelectedFrame().isTabDockAllowed() || !((targetParent2 = ((FrameContainer)component).getSelectedFrame()) instanceof DockableFrame) || !(targetFrame = targetParent2).getDockingManager().isDropAllowed(dockableFrame, targetFrame, 16)) break;
                        boolean hasTab = true;
                        if (targetFrame.getParent() != null && targetFrame.getParent() instanceof FrameContainer && !((FrameContainer)targetFrame.getParent()).isTabShown()) {
                            hasTab = false;
                        }
                        this.setTabHeight(((FrameContainer)targetFrame.getParent()).getTabHeight());
                        this.setTabSide(((FrameContainer)targetFrame.getParent()).getTabPlacement());
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle bounds5 = this.calculateTabContourBounds(hasTab, targetFrame);
                        this.setContourBounds(bounds5);
                        this.setTabDocking(true);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("tabDocking to DockableFrame " + targetFrame.getKey());
                        return;
                    }
                }
                if (side != 32 && side != 16) {
                    if (component instanceof Workspace && ((Workspace)component).getDockingManager().isDropAllowed(dockableFrame, component, side)) {
                        this.setAttachedSide(side);
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle bounds6 = this.calculateContourBounds(new Rectangle(x, y, width, height), component);
                        this.setContourBounds(bounds6);
                        this.setTabDocking(false);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("sideDocking to Workspace " + side);
                        return;
                    }
                    if (targetFrame != null && targetFrame.getDockingManager().isDropAllowed(dockableFrame, targetFrame, side)) {
                        this.setAttachedSide(side);
                        if (!this.isVisible()) {
                            this.setVisible(true);
                        }
                        Rectangle bounds7 = this.calculateContourBounds(new Rectangle(x, y, width, height), component);
                        this.setContourBounds(bounds7);
                        this.setTabDocking(false);
                        this.setFloating(false);
                        LOGGER_OUTLINE.fine("sideDocking to Workspace");
                        return;
                    }
                }
            }
        }
        this.setAttachedComponent(null);
        if (dockableFrame.isFloatable() && this.getDockingManager().isFloatable() && (!this.getDockingManager().isPreserveStateOnDragging() || dockableFrame.isFloated())) {
            Rectangle bounds = this.calculateContourBounds(new Rectangle(0, 0, undockedBounds.width, undockedBounds.height), newX, newY);
            if (this._dockingManager.isWithinFrameBoundsOnDragging() && this._dockingManager.getRootPaneContainer() != null) {
                RootPaneContainer rootPaneContainer = this._dockingManager.getRootPaneContainer();
                Rectangle rect = rootPaneContainer.getLayeredPane().getBounds();
                if (this.getRelativeContainer() != this._dockingManager.getRootPaneContainer()) {
                    bounds = SwingUtilities.convertRectangle(this.getRelativeContainer(), bounds, rootPaneContainer.getLayeredPane().getParent());
                }
                if (bounds.x < rect.x) {
                    bounds.x = rect.x;
                }
                if (bounds.y < rect.y) {
                    bounds.y = rect.y;
                }
                if (bounds.x > rect.x + rect.width - bounds.width) {
                    bounds.x = rect.x + rect.width - bounds.width;
                }
                if (bounds.y > rect.y + rect.height - bounds.height) {
                    bounds.y = rect.y + rect.height - bounds.height;
                }
                if (this.getRelativeContainer() != this._dockingManager.getRootPaneContainer()) {
                    bounds = SwingUtilities.convertRectangle(rootPaneContainer.getLayeredPane().getParent(), bounds, this.getRelativeContainer());
                }
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
            this.setTabDocking(false);
            this.setFloating(true);
            this.setContourBounds(bounds);
        } else {
            this.setVisible(false);
            this.setTabDocking(false);
            this.setFloating(true);
        }
    }

    @Override
    public void pauseDragFrame() {
        this.setVisible(false);
        this.setAttachedComponent(null);
    }

    @Override
    public void cancelDragFrame() {
        this.setVisible(false);
        this.cleanup();
    }

    @Override
    public void cleanup() {
        if (this.isHeavyweight()) {
            this._fullOutline.dispose();
            this._fullOutline = null;
            this._leftOutline.dispose();
            this._leftOutline = null;
            this._rightOutline.dispose();
            this._rightOutline = null;
            this._topOutline.dispose();
            this._topOutline = null;
            this._bottomOutline.dispose();
            this._bottomOutline = null;
            this._emptyContent.dispose();
            this._emptyContent = null;
        }
        if (this._dockingManager.isUseGlassPaneEnabled() && this.getGlassPane() != null) {
            DockingUtils.clearGlassPaneCursor(this._dockingManager);
        }
        this.hideOutline();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        this.updateCursor();
        if (!aFlag && this.isHeavyweight()) {
            this._leftOutline.setVisible(false);
            this._rightOutline.setVisible(false);
            this._topOutline.setVisible(false);
            this._bottomOutline.setVisible(false);
            this._emptyContent.setVisible(false);
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() || this.isHeavyweight() && (this._fullOutline != null && this._fullOutline.isVisible() || this._topOutline != null && this._topOutline.isVisible() || this._bottomOutline != null && this._bottomOutline.isVisible() || this._leftOutline != null && this._leftOutline.isVisible() || this._rightOutline != null && this._rightOutline.isVisible());
    }

    public int getOutlineMode() {
        return this._outlineMode;
    }

    public void setOutlineMode(int outlineMode) {
        this._outlineMode = outlineMode;
        if (this.isHeavyweight()) {
            this.initOutline();
        }
    }

    @Override
    public Component getGlassPane() {
        return this._glassPane;
    }

    @Override
    public void setGlassPane(Component glassPane) {
        this._glassPane = glassPane;
    }

    public boolean isChangeCursor() {
        return this._changeCursor;
    }

    @Override
    public void setChangeCursor(boolean changeCursor) {
        this._changeCursor = changeCursor;
    }

    @Override
    public void setRelativeXY(double x, double y) {
        this._relativeX = x;
        this._relativeY = y;
    }

    @Override
    public void setRootPaneContainer(RootPaneContainer rootPaneContainer) {
        this._rootPaneContainer = rootPaneContainer;
        this._activeLayerPane = this.getRootPaneContainer().getLayeredPane();
        this._relativeContainer = this._activeLayerPane;
        this._glassPane = this.getRootPaneContainer().getGlassPane();
        this._activeLayerPane.add((Component)this, JLayeredPane.DRAG_LAYER);
    }

    private RootPaneContainer getRootPaneContainer() {
        return this._rootPaneContainer;
    }

    private Component getRootPaneContainerAsComponent() {
        return (Component)((Object)this.getRootPaneContainer());
    }

    @Override
    public Rectangle calculateContourBounds(Rectangle frameBounds, int mouseX, int mouseY) {
        frameBounds.x = mouseX - (int)(frameBounds.getWidth() * this._relativeX);
        frameBounds.y = mouseY - (int)(frameBounds.getHeight() * this._relativeY);
        Rectangle rectangle = SwingUtilities.convertRectangle(this.getRootPaneContainerAsComponent(), frameBounds, this.getRelativeContainer());
        this._currentMouseX = (int)((double)rectangle.width * this._relativeX);
        this._currentMouseY = (int)((double)rectangle.height * this._relativeY);
        return rectangle;
    }

    @Override
    public Rectangle calculateContourBounds(Rectangle frameBounds, Component f) {
        return SwingUtilities.convertRectangle(f, frameBounds, this.getRelativeContainer());
    }

    @Override
    public Rectangle getContourBounds() {
        return this.getBounds();
    }

    @Override
    public void setContourBounds(Rectangle r) {
        this.setBounds(r);
    }

    public int getSensitiveAreaSize() {
        return this._sensitiveAreaSize;
    }

    public void setSensitiveAreaSize(int sensitiveAreaSize) {
        this._sensitiveAreaSize = sensitiveAreaSize;
    }

    public int getOutsideSensitiveAreaSize() {
        return this._outsideSensitiveAreaSize;
    }

    public void setOutsideSensitiveAreaSize(int sensitiveAreaSize) {
        this._outsideSensitiveAreaSize = sensitiveAreaSize;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setDockingManager(DockingManager defaultDockingManager) {
        this._dockingManager = defaultDockingManager;
        this.setAllowDocking(this._dockingManager.isAutoDockingAsDefault());
        this.setOutlineMode(this._dockingManager.getOutlineMode());
        this.setSensitiveAreaSize(this._dockingManager.getSensitiveAreaSize());
        this.setOutsideSensitiveAreaSize(this._dockingManager.getOutsideSensitiveAreaSize());
        this.setRootPaneContainer(this._dockingManager.getRootPaneContainer());
        this.checkParent();
    }

    @Override
    public JLayeredPane getLayeredPane() {
        return this._activeLayerPane;
    }

    private Rectangle calculateTabContourBounds(boolean hasTab, Component targetFrame) {
        Rectangle bounds;
        switch (this.getTabSide()) {
            case 1: {
                bounds = this.calculateContourBounds(new Rectangle(0, hasTab ? -this.getTabHeight() : 0, targetFrame.getBounds().width, targetFrame.getBounds().height + (hasTab ? this.getTabHeight() : 0)), targetFrame);
                break;
            }
            case 2: {
                bounds = this.calculateContourBounds(new Rectangle(hasTab ? -this.getTabHeight() : 0, 0, targetFrame.getBounds().width + (hasTab ? this.getTabHeight() : 0), targetFrame.getBounds().height), targetFrame);
                break;
            }
            case 4: {
                bounds = this.calculateContourBounds(new Rectangle(0, 0, targetFrame.getBounds().width + (hasTab ? this.getTabHeight() : 0), targetFrame.getBounds().height), targetFrame);
                break;
            }
            default: {
                bounds = this.calculateContourBounds(new Rectangle(0, 0, targetFrame.getBounds().width, targetFrame.getBounds().height + (hasTab ? this.getTabHeight() : 0)), targetFrame);
            }
        }
        return bounds;
    }

    private void hideOutline() {
        this._activeLayerPane.remove(this);
    }

    private void showOutline(JLayeredPane newLayerPane) {
        if (newLayerPane == null || !newLayerPane.isShowing()) {
            return;
        }
        if (this._activeLayerPane != null && this._activeLayerPane != newLayerPane) {
            this._activeLayerPane.repaint();
            this._activeLayerPane = newLayerPane;
            this._activeLayerPane.add((Component)this, JLayeredPane.DRAG_LAYER);
            this.setRelativeContainer(this._activeLayerPane);
        }
    }

    class OutlineHW
    extends JWindow {
        public OutlineHW() {
            this.initialize();
        }

        public OutlineHW(Window window) {
            super(window);
            this.initialize();
        }

        private void initialize() {
            this.setVisible(false);
            Object opacity = UIManager.getDefaults().get("Contour.opacity");
            if (opacity instanceof Double) {
                opacity = Float.valueOf(((Double)opacity).floatValue());
            } else if (!(opacity instanceof Float)) {
                opacity = Float.valueOf(0.75f);
            }
            JideSwingUtilities.setWindowOpacity(this, ((Float)opacity).floatValue());
            this.setBackground(OutlineContour.this._lineColor);
            Color color = UIDefaultsLookup.getColor("Contour.background");
            if (color != null) {
                this.getContentPane().setBackground(color);
            }
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            OutlineContour.this.paintOutline(g, false);
        }
    }

    class Outline
    extends JWindow {
        public Outline() {
            this.setVisible(false);
            this.setBackground(OutlineContour.this._lineColor);
        }

        public Outline(Window window) {
            super(window);
            this.setVisible(false);
            this.setBackground(OutlineContour.this._lineColor);
        }

        @Override
        public void paint(Graphics g) {
            Color old = g.getColor();
            g.setColor(OutlineContour.this._lineColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(old);
        }
    }

    private class Content
    extends JWindow {
        public Content() {
            this.setVisible(false);
            JideSwingUtilities.setWindowOpacity(this, 0.1f);
        }

        public Content(Window window) {
            super(window);
            this.setVisible(false);
            JideSwingUtilities.setWindowOpacity(this, 0.1f);
        }
    }
}

