/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.AutoHideContainer;
import com.jidesoft.docking.DefaultDockingManager;
import com.jidesoft.docking.DockContext;
import com.jidesoft.docking.DockableFrameMouseInputAdapter;
import com.jidesoft.docking.DockableHolder;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.DragableDockable;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.NotificationFlasher;
import com.jidesoft.docking.PreviousState;
import com.jidesoft.docking.Refocusable;
import com.jidesoft.docking.Resource;
import com.jidesoft.docking.event.DockableFrameEvent;
import com.jidesoft.docking.event.DockableFrameListener;
import com.jidesoft.plaf.DockableFrameUI;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.TabColorProvider;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.MouseInputListener;

public class DockableFrame
extends JComponent
implements Accessible,
WindowConstants,
DragableDockable,
Refocusable,
DockableHolder,
TabColorProvider {
    private static final Logger LOGGER_EVENT;
    private static final Logger LOGGER_FOCUS;
    private DockingManager _dockingManager;
    private DockContext _context;
    private DockContext _previousContext;
    private static final String uiClassID = "DockableFrameUI";
    private JRootPane rootPane;
    private boolean rootPaneCheckingEnabled = false;
    private Icon _frameIcon;
    private String _key;
    private String _tabTitle;
    private String _sideTitle;
    private String _title;
    public static final String PROPERTY_CONTENT_PANE = "contentPane";
    public static final String PROPERTY_MENU_BAR = "JMenuBar";
    public static final String PROPERTY_TAB_TITLE = "tabTitle";
    public static final String PROPERTY_SIDE_TITLE = "sideTitle";
    public static final String PROPERTY_TITLE = "title";
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_LAYERED_PANE = "layeredPane";
    public static final String PROPERTY_ROOT_PANE = "rootPane";
    public static final String PROPERTY_GLASS_PANE = "glassPane";
    public static final String PROPERTY_FRAME_ICON = "frameIcon";
    public static final String PROPERTY_AVAILABLE_BUTTONS = "availableButtons";
    public static final String PROPERTY_BUTTONS_ORDER = "buttonsOrder";
    public static final String PROPERTY_TITLE_BAR_COMPONENT = "titleBarComponent";
    public static final String PROPERTY_TITLE_LABEL_COMPONENT = "titleLabelComponent";
    public static final String PROPERTY_VISIBLE = "visible";
    public static final String PROPERTY_AVAILABLE = "available";
    public static final String PROPERTY_SLIDING_AUTOHIDE = "slidingAutohide";
    public static final String PROPERTY_TRANSIENT = "transient";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_DOCKABLE = "dockable";
    public static final String PROPERTY_AUTOHIDABLE = "autohidable";
    public static final String PROPERTY_MAXIMIZABLE = "maximizable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_ACTIVE = "active";
    public static final String PROPERTY_MAXIMIZED = "maximized";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_DOCKED = "docked";
    public static final String PROPERTY_FLOATED = "floated";
    public static final String PROPERTY_AUTOHIDE = "autohide";
    public static final String PROPERTY_AUTOHIDE_SHOWING = "autohideShowing";
    public static final String PROPERTY_TAB_DOCK_ALLOWED = "tabDockAllowed";
    public static final String PROPERTY_SIDE_DOCK_ALLOWED = "sideDockAllowed";
    public static final String PROPERTY_STAY_IN_GROUP = "stayInGroup";
    public static final String PROPERTY_SHOW_GRIPPER = "showGripper";
    public static final String PROPERTY_SHOW_TITLE_BAR = "showTitleBar";
    public static final String PROPERTY_SHOW_CONTENT_PANE = "showContentPane";
    public static final String PROPERTY_SHOW_CONTEXT_MENU = "showContextMenu";
    public static final String PROPERTY_INIT_SIDE = "initSide";
    public static final String PROPERTY_INIT_MODE = "initMode";
    public static final String PROPERTY_INIT_INDEX = "initIndex";
    public static final String PROPERTY_DOCKED_WIDTH = "dockedWidth";
    public static final String PROPERTY_DOCKED_HEIGHT = "dockedHeight";
    public static final String PROPERTY_AUTOHIDE_WIDTH = "autohideWidth";
    public static final String PROPERTY_AUTOHIDE_HEIGHT = "autohideHeight";
    public static final String PROPERTY_UNDOCKED_BOUNDS = "undockedBounds";
    public static final String PROPERTY_PREFERRED_AUTOHIDE_SIDE = "preferredAutohideSide";
    public static final String PROPERTY_CLOSE_ACTION = "closeAction";
    public static final String PROPERTY_AUTOHIDE_ACTION = "autohideAction";
    public static final String PROPERTY_HIDE_AUTOHIDE_ACTION = "hideAutohideAction";
    public static final String PROPERTY_FLOATING_ACTION = "floatingAction";
    public static final String PROPERTY_MAXIMIZE_ACTION = "maximizeAction";
    public static final String PROPERTY_DOCKABLE_ACTION = "dockableAction";
    public static final String PROPERTY_DOUBLE_CLICK_ACTION = "doubleClickAction";
    public static final String PROPERTY_DEFAULT_CLOSE_ACTION = "defaultCloseAction";
    public static final String PROPERTY_DEFAULT_AUTOHIDE_ACTION = "defaultAutohideAction";
    public static final String PROPERTY_DEFAULT_ESCAPE_ACTION = "defaultEscapeAction";
    public static final String PROPERTY_AUTOHIDE_WHEN_ACTIVE = "autohideWhenActive";
    @Deprecated
    public static final String PROPERTY_ADDITONAL_BUTTON_ACTIONS = "additionalButtonActions";
    public static final String PROPERTY_ADDITIONAL_BUTTON_ACTIONS = "additionalButtonActions";
    private final LinkedList<Action> _additionalButtonActions = new LinkedList();
    private boolean _showGripper = false;
    private boolean _showTitleBarConfigured = false;
    private boolean _showTitleBar = true;
    private boolean _showContentPane = true;
    private boolean _rearrangable = true;
    private boolean _active;
    private boolean _maximized;
    private MouseInputListener _mouseListener;
    private boolean _notified;
    public static final int BUTTON_CLOSE = 1;
    public static final int BUTTON_HIDE_AUTOHIDE = 2;
    public static final int BUTTON_AUTOHIDE = 4;
    public static final int BUTTON_FLOATING = 8;
    public static final int BUTTON_MAXIMIZE = 16;
    public static final int BUTTON_ALL = -1;
    private int _availableButtons = 15;
    private JComponent _titleBarComponent;
    private JComponent _titleLabelComponent;
    private boolean _maximizable = true;
    private boolean _slidingAutohide = true;
    private NotificationFlasher _animator;
    private boolean _transient;
    private JideFocusTracker _currentFocusOwnerTracker;
    private FocusListener _focusListenerInternalTracking;
    private Component _defaultFocusComponent;
    private Component _internalFocusedComponent;
    protected PropertyChangeListener _focusChangeListener;
    private int _preferredAutohideSide = -1;
    private boolean _tabDockAllowed = true;
    private boolean _sideDockAllowed = true;
    private boolean _alwaysStayInGroup = false;
    protected Action _closeAction;
    protected Action _hideAutohideAction;
    protected Action _floatingAction;
    protected Action _autohideAction;
    protected Action _maximizeAction;
    protected Action _dockableAction;
    protected Action _customDoubleClickAction;
    private Action _closeActionByDefault;
    private Action _hideAutohideActionByDefault;
    private Action _floatingActionByDefault;
    private Action _autohideActionByDefault;
    private Action _maximizeActionByDefault;
    private Action _dockableActionByDefault;
    protected boolean _showContextMenu = true;
    private boolean _realized = false;
    private Color _tabBackground;
    private Color _tabForeground;
    public static final int CLOSE_ACTION_TO_HIDE = 0;
    public static final int CLOSE_ACTION_TO_REMOVE = 1;
    public static final int CLOSE_ACTION_TO_REMOVE_AND_DISPOSE = 2;
    private int _defaultCloseAction = 0;
    public static final int AUTOHIDE_ACTION_TO_REMAIN_ACTIVE = 0;
    public static final int ESCAPE_ACTION_TO_YIELD_FOCUS = 0;
    public static final int ESCAPE_ACTION_DO_NOTING = 1;
    public static final int ESCAPE_ACTION_TO_HIDE = 2;
    public static final int ESCAPE_ACTION_TO_REMOVE = 3;
    private int _defaultEscapeAction = 0;
    private boolean _autohideWhenActive = false;
    private int[] _buttonsOrder = new int[]{1, 4, 2, 8, 16};
    private boolean _settingSize = false;
    private Dimension _savedPreferredSize = null;

    protected String getResourceString(String key) {
        return this.getDockingManager() != null ? this.getDockingManager().getResourceString(key) : Resource.getResourceBundle(Locale.getDefault()).getString(key);
    }

    public DockableFrame() {
        this("");
    }

    public DockableFrame(String key) {
        this(key, UIDefaultsLookup.getIcon("DockableFrame.defaultIcon"));
    }

    public DockableFrame(Icon frameIcon) {
        this("", frameIcon);
    }

    public DockableFrame(String key, Icon frameIcon) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        this.setRootPane(this.createRootPane());
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setLayout(new BorderLayout());
        this._key = key;
        this.setName(this._key);
        this.setFrameIcon(frameIcon);
        this._context = new DockContext();
        this.setRootPaneCheckingEnabled(true);
        this._mouseListener = this.createDockableFrameMouseInputListener();
        this.addMouseListener(this._mouseListener);
        this.addMouseMotionListener(this._mouseListener);
        this.putClientProperty("DraggingListener", this._mouseListener);
        this.updateUI();
        this.addFocusTracker();
    }

    protected void addFocusTracker() {
        this._currentFocusOwnerTracker = new JideFocusTracker(this.getContentPane());
        this._focusListenerInternalTracking = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                if (!evt.isTemporary()) {
                    DockableFrame.this.setLastFocusedComponent(evt.getComponent());
                }
            }
        };
    }

    @Override
    public boolean isOpaque() {
        return this.getDockingManager() != null && this.getDockingManager().isHeavyweightComponentEnabled() || super.isOpaque();
    }

    public MouseInputListener createDockableFrameMouseInputListener() {
        return new DockableFrameMouseInputAdapter(this);
    }

    void updateDockedWidthOrHeight(int direction) {
        Container container = this.getParent();
        if (container instanceof FrameContainer) {
            try {
                this.setSettingSize(true);
                if (direction == 1) {
                    this.setDockedWidth(this.getWidth());
                } else if (direction == 0) {
                    this.setDockedHeight(this.getHeight());
                }
            }
            finally {
                this.setSettingSize(false);
            }
        }
    }

    protected void deinstallMouseHandlers() {
        Component titlePane;
        DockableFrameUI ui = this.getUI();
        if (ui != null && (titlePane = ui.getTitlePane()) != null) {
            titlePane.removeMouseListener(this._mouseListener);
            titlePane.removeMouseMotionListener(this._mouseListener);
        }
    }

    protected void installMouseHandlers() {
        Component titlePane;
        DockableFrameUI ui = this.getUI();
        if (ui != null && (titlePane = ui.getTitlePane()) != null) {
            titlePane.addMouseListener(this._mouseListener);
            titlePane.addMouseMotionListener(this._mouseListener);
        }
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    @Override
    public DockableFrameUI getUI() {
        return (DockableFrameUI)this.ui;
    }

    public void setUI(DockableFrameUI ui) {
        boolean checkingEnabled = this.isRootPaneCheckingEnabled();
        try {
            this.setRootPaneCheckingEnabled(false);
            super.setUI(ui);
        }
        finally {
            this.setRootPaneCheckingEnabled(checkingEnabled);
        }
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.deinstallMouseHandlers();
        this.setUI((DockableFrameUI)UIManager.getUI(this));
        this.installMouseHandlers();
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().add(comp, constraints, index);
        } else {
            super.addImpl(comp, constraints, index);
        }
    }

    @Override
    public void remove(Component comp) {
        int oldCount = this.getComponentCount();
        super.remove(comp);
        if (oldCount == this.getComponentCount()) {
            this.getContentPane().remove(comp);
        }
    }

    @Override
    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            this.getContentPane().setLayout(manager);
        } else {
            super.setLayout(manager);
        }
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public void setJMenuBar(JMenuBar m) {
        JMenuBar oldValue = this.getJMenuBar();
        this.getRootPane().setJMenuBar(m);
        this.firePropertyChange(PROPERTY_MENU_BAR, oldValue, m);
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public void setContentPane(Container c) {
        Container oldValue = this.getContentPane();
        this.getRootPane().setContentPane(c);
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(false);
        }
        if (oldValue != c) {
            if (this._focusListenerInternalTracking != null && this._currentFocusOwnerTracker != null) {
                this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
                this._currentFocusOwnerTracker = null;
            }
            this._internalFocusedComponent = null;
            this.addFocusTracker();
        }
        this.firePropertyChange(PROPERTY_CONTENT_PANE, oldValue, c);
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public void setLayeredPane(JLayeredPane layered) {
        JLayeredPane oldValue = this.getLayeredPane();
        this.getRootPane().setLayeredPane(layered);
        this.firePropertyChange(PROPERTY_LAYERED_PANE, oldValue, layered);
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public void setGlassPane(Component glass) {
        Component oldValue = this.getGlassPane();
        this.getRootPane().setGlassPane(glass);
        this.firePropertyChange(PROPERTY_GLASS_PANE, oldValue, glass);
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        JRootPane oldValue = this.getRootPane();
        this.rootPane = root;
        if (this.rootPane != null) {
            boolean checkingEnabled = this.isRootPaneCheckingEnabled();
            try {
                this.setRootPaneCheckingEnabled(false);
                this.add((Component)this.rootPane, "Center");
            }
            finally {
                this.setRootPaneCheckingEnabled(checkingEnabled);
            }
        }
        this.firePropertyChange(PROPERTY_ROOT_PANE, oldValue, root);
    }

    public int getAvailableButtons() {
        return this._availableButtons;
    }

    public void setAvailableButtons(int availableButtons) {
        if (this.getAvailableButtons() == availableButtons) {
            return;
        }
        int oldValue = this.getAvailableButtons();
        this._availableButtons = availableButtons;
        this.firePropertyChange(PROPERTY_AVAILABLE_BUTTONS, oldValue, availableButtons);
    }

    public void setHidable(boolean b) {
        if (b != this.isHidable()) {
            boolean oldValue = this.isHidable();
            this.getContext().setHidable(b);
            this.firePropertyChange(PROPERTY_HIDABLE, oldValue, b);
        }
    }

    public boolean isHidable() {
        return this.getContext().isHidable();
    }

    public boolean isHidden() {
        return this.getContext().isHidden();
    }

    public void setHidden(boolean b) throws PropertyVetoException {
        if (this.getContext().isHidden() == b) {
            return;
        }
        boolean oldValue = this.getContext().isHidden();
        this.fireVetoableChange(PROPERTY_HIDDEN, oldValue, b);
        if (b) {
            this.changeMode(0);
        }
        this.firePropertyChange(PROPERTY_HIDDEN, oldValue, b);
        this.setVisible(!b);
    }

    public void setDockable(boolean b) {
        if (b != this.isDockable()) {
            boolean oldValue = this.isDockable();
            this.getContext().setDockable(b);
            this.firePropertyChange(PROPERTY_DOCKABLE, oldValue, b);
        }
    }

    public boolean isDockable() {
        return this.getContext().isDockable();
    }

    public void setAutohidable(boolean b) {
        if (b != this.isAutohidable()) {
            boolean oldValue = this.isAutohidable();
            this.getContext().setAutohidable(b);
            this.firePropertyChange(PROPERTY_AUTOHIDABLE, oldValue, b);
        }
    }

    public boolean isAutohidable() {
        return this.getContext().isAutohidable();
    }

    public void setFloatable(boolean b) {
        if (b != this.isFloatable()) {
            boolean oldValue = this.isFloatable();
            this.getContext().setFloatable(b);
            this.firePropertyChange(PROPERTY_FLOATABLE, oldValue, b);
        }
    }

    public boolean isFloatable() {
        return this.getContext().isFloatable();
    }

    public void setRearrangable(boolean b) {
        if (b != this.isRearrangable()) {
            boolean oldValue = this.isRearrangable();
            this._rearrangable = b;
            this.firePropertyChange(PROPERTY_REARRANGABLE, oldValue, b);
        }
    }

    public boolean isRearrangable() {
        return this._rearrangable;
    }

    public boolean isFloated() {
        return this.getContext().isFloated();
    }

    public boolean isDocked() {
        return this.getContext().isDocked();
    }

    protected void setDocked(boolean b) throws PropertyVetoException {
        boolean oldValue = this.getContext().isDocked();
        if (b != oldValue) {
            this.fireVetoableChange(PROPERTY_DOCKED, oldValue, b);
            if (b) {
                boolean wasHidden = this.getContext().isHidden();
                this.changeMode(4);
                if (wasHidden) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4003);
            }
            this.firePropertyChange(PROPERTY_DOCKED, oldValue, b);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setFloated(boolean b) throws PropertyVetoException {
        boolean oldValue = this.getContext().isFloated();
        if (b != oldValue) {
            this.fireVetoableChange(PROPERTY_FLOATED, oldValue, b);
            if (b) {
                boolean wasHidden = this.getContext().isHidden();
                this.changeMode(1);
                if (wasHidden) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4004);
            }
            this.firePropertyChange(PROPERTY_FLOATED, oldValue, b);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (!JideSwingUtilities.equals(this._previousContext.getUndockedBounds(), this.getContext().getUndockedBounds())) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setAutohide(boolean b) throws PropertyVetoException {
        boolean oldValue = this.getContext().isAutohide();
        if (b != oldValue) {
            this.fireVetoableChange(PROPERTY_AUTOHIDE, oldValue, b);
            if (b) {
                this.changeMode(2);
                this.fireDockableFrameEvent(4005);
            }
            this.firePropertyChange(PROPERTY_AUTOHIDE, oldValue, b);
            this.updateUI();
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    protected void setAutohideShowing(boolean b) throws PropertyVetoException {
        boolean oldValue = this.getContext().isAutohideShowing();
        if (oldValue != b) {
            this.fireVetoableChange(PROPERTY_AUTOHIDE_SHOWING, oldValue, b);
            if (b) {
                boolean wasHidden = this.getContext().isHidden();
                this.changeMode(3);
                this.firePropertyChange(PROPERTY_AUTOHIDE_SHOWING, oldValue, b);
                if (wasHidden) {
                    this.fireDockableFrameEvent(4001);
                }
                this.fireDockableFrameEvent(4006);
            } else {
                this.firePropertyChange(PROPERTY_AUTOHIDE_SHOWING, oldValue, b);
            }
            this.setNotified(false);
            this.recordPreviousContext();
        } else if (this._previousContext == null) {
            this.recordPreviousContext();
        } else if (this._previousContext.getCurrentDockSide() != this.getContext().getCurrentDockSide()) {
            this.fireDockableFrameEvent(4014);
            this.recordPreviousContext();
        }
    }

    public void setKey(String key) {
        if (this._key.equals(key)) {
            return;
        }
        if (this.getDockingManager() != null && this.getDockingManager().getFrame(key) != null) {
            throw new IllegalArgumentException("The DockableFrame exists with name \"" + key + "\". Please specify a new name for the frame.");
        }
        String oldKey = this._key;
        this._key = key;
        this.setName(this._key);
        this.firePropertyChange(PROPERTY_KEY, oldKey, this._key);
        if (this._tabTitle == null) {
            this.firePropertyChange(PROPERTY_TAB_TITLE, oldKey, key);
            if (this._sideTitle == null) {
                this.firePropertyChange(PROPERTY_SIDE_TITLE, oldKey, key);
            }
            if (this._title == null) {
                this.firePropertyChange(PROPERTY_TITLE, oldKey, key);
            }
        }
    }

    public String getKey() {
        return this._key;
    }

    public String getTabTitle() {
        if (this._tabTitle != null) {
            return this._tabTitle;
        }
        return this.getKey();
    }

    public void setTabTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String oldValue = this._tabTitle;
        if (!title.equals(oldValue)) {
            FrameContainer fc;
            int index;
            this._tabTitle = title;
            this.firePropertyChange(PROPERTY_TAB_TITLE, oldValue, title);
            if (this._title == null) {
                this.firePropertyChange(PROPERTY_TITLE, oldValue, title);
            }
            if (this._sideTitle == null) {
                this.firePropertyChange(PROPERTY_SIDE_TITLE, oldValue, title);
            }
            if (this.getParent() instanceof FrameContainer && (index = (fc = (FrameContainer)this.getParent()).indexOfComponent(this)) != -1) {
                fc.setTitleAt(index, this._tabTitle);
            }
        }
    }

    public String getSideTitle() {
        if (this._sideTitle != null) {
            return this._sideTitle;
        }
        return this.getTabTitle();
    }

    public void setSideTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String oldValue = this._sideTitle;
        if (!title.equals(oldValue)) {
            this._sideTitle = title;
            this.firePropertyChange(PROPERTY_SIDE_TITLE, oldValue, title);
        }
    }

    public String getTitle() {
        if (this._title != null) {
            return this._title;
        }
        return this.getTabTitle();
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String oldValue = this._title;
        if (!title.equals(oldValue)) {
            this._title = title;
            this.firePropertyChange(PROPERTY_TITLE, oldValue, title);
        }
    }

    public boolean isAutohide() {
        return this.getContext().isAutohide();
    }

    public boolean isAutohideShowing() {
        return this.getContext().isAutohideShowing();
    }

    public void setFrameIcon(Icon icon) {
        FrameContainer fc;
        int index;
        Icon oldIcon = this._frameIcon;
        this._frameIcon = icon;
        this.firePropertyChange(PROPERTY_FRAME_ICON, oldIcon, icon);
        if (this.getParent() instanceof FrameContainer && (index = (fc = (FrameContainer)this.getParent()).indexOfComponent(this)) != -1) {
            fc.setIconAt(index, this.getFrameIcon());
        }
    }

    public Icon getFrameIcon() {
        return this._frameIcon;
    }

    protected Component getFocusOwner() {
        if (this.isActive()) {
            Component focusOwner = PortingUtils.getCurrentFocusComponent(null);
            if (focusOwner != null && !SwingUtilities.isDescendingFrom(focusOwner, this)) {
                focusOwner = null;
            }
            return focusOwner;
        }
        return null;
    }

    public void addDockableFrameListener(DockableFrameListener l) {
        DockableFrameListener[] listeners;
        for (DockableFrameListener listener : listeners = (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class)) {
            if (listener != l) continue;
            return;
        }
        this.listenerList.add(DockableFrameListener.class, l);
        this.enableEvents(0L);
    }

    public void removeDockableFrameListener(DockableFrameListener l) {
        this.listenerList.remove(DockableFrameListener.class, l);
    }

    public DockableFrameListener[] getDockableFrameListeners() {
        return (DockableFrameListener[])this.listenerList.getListeners(DockableFrameListener.class);
    }

    protected void fireDockableFrameEvent(int id, DockingManager oppositeDockingManager) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 4013: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is transferred, oppositeDockingManager is " + (oppositeDockingManager == null ? "null" : oppositeDockingManager));
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        AWTEvent e = null;
        block6: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableFrameListener.class) continue;
            if (e == null) {
                e = new DockableFrameEvent(this, id, oppositeDockingManager);
            }
            switch (e.getID()) {
                case 4013: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameTransferred((DockableFrameEvent)e);
                    continue block6;
                }
            }
        }
    }

    protected void fireDockableFrameEvent(int id, DockableFrame oppositeDockableFrame) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 4007: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is activated, oppositeDockableFrame is " + (oppositeDockableFrame == null ? "null" : oppositeDockableFrame.getKey()));
                    break;
                }
                case 4008: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is deactivated, oppositeDockableFrame is " + (oppositeDockableFrame == null ? "null" : oppositeDockableFrame.getKey()));
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        AWTEvent e = null;
        block8: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableFrameListener.class) continue;
            if (e == null) {
                e = new DockableFrameEvent(this, id, oppositeDockableFrame);
            }
            switch (e.getID()) {
                case 4007: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameActivated((DockableFrameEvent)e);
                    continue block8;
                }
                case 4008: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameDeactivated((DockableFrameEvent)e);
                    continue block8;
                }
            }
        }
    }

    protected void fireDockableFrameEvent(int id) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (id) {
                case 3999: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is added");
                    break;
                }
                case 4000: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is removed");
                    break;
                }
                case 4003: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is docked " + DockContext.getStateName(this.getContext().getCurrentMode()) + " " + DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
                    break;
                }
                case 4004: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is floating " + DockContext.getStateName(this.getContext().getCurrentMode()));
                    break;
                }
                case 4005: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is autohidden " + DockContext.getStateName(this.getContext().getCurrentMode()) + " " + DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
                    break;
                }
                case 4006: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is autohide showing " + DockContext.getStateName(this.getContext().getCurrentMode()));
                    break;
                }
                case 4001: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is shown " + this.isVisible());
                    break;
                }
                case 4002: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is hidden " + this.isVisible());
                    break;
                }
                case 4007: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is activated");
                    break;
                }
                case 4008: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is deactivated");
                    break;
                }
                case 4009: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is tab shown " + this.isVisible());
                    break;
                }
                case 4010: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is tab hidden " + this.isVisible());
                    break;
                }
                case 4011: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is maximized");
                    break;
                }
                case 4012: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is restored");
                    break;
                }
                case 4014: {
                    LOGGER_EVENT.fine("DockableFrame \"" + this.getKey() + "\" is moved");
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        AWTEvent e = null;
        block34: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableFrameListener.class) continue;
            if (e == null) {
                e = new DockableFrameEvent(this, id);
            }
            switch (e.getID()) {
                case 3999: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameAdded((DockableFrameEvent)e);
                    continue block34;
                }
                case 4000: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameRemoved((DockableFrameEvent)e);
                    continue block34;
                }
                case 4003: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameDocked((DockableFrameEvent)e);
                    continue block34;
                }
                case 4004: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameFloating((DockableFrameEvent)e);
                    continue block34;
                }
                case 4005: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameAutohidden((DockableFrameEvent)e);
                    continue block34;
                }
                case 4006: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameAutohideShowing((DockableFrameEvent)e);
                    continue block34;
                }
                case 4001: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameShown((DockableFrameEvent)e);
                    continue block34;
                }
                case 4002: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameHidden((DockableFrameEvent)e);
                    continue block34;
                }
                case 4007: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameActivated((DockableFrameEvent)e);
                    continue block34;
                }
                case 4008: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameDeactivated((DockableFrameEvent)e);
                    continue block34;
                }
                case 4009: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameTabShown((DockableFrameEvent)e);
                    continue block34;
                }
                case 4010: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameTabHidden((DockableFrameEvent)e);
                    continue block34;
                }
                case 4011: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameMaximized((DockableFrameEvent)e);
                    continue block34;
                }
                case 4012: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameRestored((DockableFrameEvent)e);
                    continue block34;
                }
                case 4014: {
                    ((DockableFrameListener)listeners[i + 1]).dockableFrameMoved((DockableFrameEvent)e);
                    continue block34;
                }
            }
        }
    }

    public DockContext getContext() {
        return this._context;
    }

    public void setContext(DockContext context) {
        int oldMode = this.getContext().getCurrentMode();
        boolean oldHidable = this.getContext().isHidable();
        boolean oldAvailable = this.getContext().isAvailable();
        this._context = context;
        boolean isDocked = this.isDocked();
        boolean isFloated = this.isFloated();
        boolean isAutohide = this.isAutohide();
        boolean isAutohideShowing = this.isAutohideShowing();
        boolean isHidden = this.isHidden();
        this._context.setCurrentMode(oldMode);
        this._context.setHidable(oldHidable);
        if (oldAvailable != this.isAvailable()) {
            this._context.setAvailable(oldAvailable);
            this.setAvailable(!oldAvailable);
        }
        try {
            if (isDocked) {
                this.setDocked(true);
            } else if (isFloated) {
                this.setFloated(true);
            } else if (isAutohide) {
                this.setAutohide(true);
            } else if (isAutohideShowing) {
                this.setAutohideShowing(true);
            } else if (isHidden) {
                this.setHidden(true);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setHiddenPreviousState(PreviousState state) {
        this.getContext().setHiddenPreviousState(state);
    }

    @Override
    public PreviousState getHiddenPreviousState() {
        return this.getContext().getHiddenPreviousState();
    }

    public void saveHiddenPreviousState() {
        DockingUtils.saveHiddenPreviousState(this);
    }

    public void setAvailablePreviousState(PreviousState state) {
        this.getContext().setAvailablePreviousState(state);
    }

    public PreviousState getAvailablePreviousState() {
        return this.getContext().getAvailablePreviousState();
    }

    public void saveAvailablePreviousState() {
        DockingUtils.saveAvailablePreviousState(this);
    }

    public void setMaximizedPreviousState(PreviousState state) {
        this.getContext().setMaximizedPreviousState(state);
    }

    public PreviousState getMaximizedPreviousState() {
        return this.getContext().getMaximizedPreviousState();
    }

    public void saveMaximizedPreviousState() {
        DockingUtils.saveMaximizedPreviousState(this);
    }

    public void setClosePreviousState(PreviousState state) {
        if (!this.isTransient()) {
            this.getContext().setClosePreviousState(state);
        }
    }

    public PreviousState getClosePreviousState() {
        return this.getContext().getClosePreviousState();
    }

    public void saveClosePreviousState() {
        DockingUtils.saveClosePreviousState(this);
    }

    @Override
    public void setDockPreviousState(PreviousState state) {
        this.getContext().setDockPreviousState(state);
    }

    @Override
    public PreviousState getDockPreviousState() {
        return this.getContext().getDockPreviousState();
    }

    public void saveDockPreviousState() {
        DockingUtils.saveDockPreviousState(this, true);
    }

    @Override
    public void setFloatPreviousState(PreviousState state) {
        this.getContext().setFloatPreviousState(state);
    }

    @Override
    public PreviousState getFloatPreviousState() {
        return this.getContext().getFloatPreviousState();
    }

    public void saveFloatPreviousState() {
        DockingUtils.saveFloatPreviousState(this, true);
    }

    @Override
    public void setAutohidePreviousState(PreviousState state) {
        this.getContext().setAutohidePreviousState(state);
    }

    @Override
    public PreviousState getAutohidePreviousState() {
        return this.getContext().getAutohidePreviousState();
    }

    public void saveAutohidePreviousState() {
        DockingUtils.saveAutohidePreviousState(this);
    }

    public boolean isActive() {
        boolean returnActive = this._active;
        if (!returnActive && this.getParent() instanceof FrameContainer) {
            returnActive = ((FrameContainer)this.getParent()).isTabEditing();
        }
        return returnActive;
    }

    void setActive(boolean active, DockableFrame oppositeDockableFrame) throws PropertyVetoException {
        this.setActive(active, oppositeDockableFrame, true);
    }

    void setActive(boolean active, DockableFrame oppositeDockableFrame, boolean requestFocus) throws PropertyVetoException {
        Container container;
        if (active != this._active) {
            boolean oldValue = this._active;
            this.fireVetoableChange(PROPERTY_ACTIVE, oldValue, active);
            this._active = active;
            if (this._active) {
                if (this._currentFocusOwnerTracker != null) {
                    this._currentFocusOwnerTracker.addFocusListener(this._focusListenerInternalTracking);
                }
                this.fireDockableFrameEvent(4007, oppositeDockableFrame);
            } else {
                if (this._currentFocusOwnerTracker != null) {
                    this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
                }
                this.fireDockableFrameEvent(4008, oppositeDockableFrame);
            }
            this.firePropertyChange(PROPERTY_ACTIVE, oldValue, active);
        }
        if ((container = this.getParent()) instanceof FrameContainer) {
            ((FrameContainer)container).repaintTabAreaAndContentBorder();
        } else if (this.getUI() != null) {
            this.getUI().getTitlePane().repaint();
        }
        this.setNotified(false);
    }

    public void setActive(boolean active) throws PropertyVetoException {
        this.setActive(active, null);
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean maximized) throws PropertyVetoException {
        if (maximized != this._maximized) {
            boolean oldValue = this._maximized;
            this.fireVetoableChange(PROPERTY_MAXIMIZED, oldValue, maximized);
            this._maximized = maximized;
            if (this._maximized) {
                this.fireDockableFrameEvent(4011);
            } else {
                this.fireDockableFrameEvent(4012);
            }
            this.firePropertyChange(PROPERTY_MAXIMIZED, oldValue, maximized);
        }
    }

    @Override
    public boolean requestFocusInInternalWindow() {
        if (this.getDockingManager() == null) {
            LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: returning false DockingManager == null.");
            return false;
        }
        Component focusComponent = this.getFocusedComponent();
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: focusComponent=" + focusComponent);
        boolean success = this.isAncestorOf(focusComponent) && JideSwingUtilities.passesFocusabilityTest(focusComponent);
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: isAncestor && passesFocusability=" + success);
        if (success) {
            focusComponent.requestFocusInWindow();
            return true;
        }
        success = JideSwingUtilities.compositeRequestFocus(this.getContentPane());
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: compositeRequestFocus(getContentPane()) return " + success);
        if (!success) {
            if (!JideSwingUtilities.passesFocusabilityTest(this)) {
                LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: this does not passFocusabilityTest.");
            }
            LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: requestFocus on DockableFrame.");
            this.requestFocus();
            return true;
        }
        LOGGER_FOCUS.fine("DockableFrame(" + this.getTitle() + "):requestFocusInInternalWindow: return " + success);
        return success;
    }

    @Override
    public Component getDefaultFocusComponent() {
        return this._defaultFocusComponent;
    }

    @Override
    public void setDefaultFocusComponent(Component defaultFocusComponent) {
        this._defaultFocusComponent = defaultFocusComponent;
    }

    @Override
    public Component getFocusedComponent() {
        if (this._internalFocusedComponent == null) {
            return this.getDefaultFocusComponent();
        }
        return this._internalFocusedComponent;
    }

    public void setLastFocusedComponent(Component lastFocusedComponent) {
        this._internalFocusedComponent = lastFocusedComponent;
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean visible = this.isVisible();
        if (aFlag != visible) {
            super.setVisible(aFlag);
            this.firePropertyChange(PROPERTY_VISIBLE, visible, aFlag);
        }
    }

    @Override
    public void setDockingManager(DockingManager dockingManager) {
        DockingManager oldValue = this._dockingManager;
        this._dockingManager = dockingManager;
        if (this._dockingManager != null) {
            this.setShowGripper(this._dockingManager.isShowGripper());
            if (!this._showTitleBarConfigured) {
                this.internalSetShowTitleBar(this._dockingManager.isShowTitleBar());
            }
            this.updateUI();
            this.resetDockID();
            if (oldValue != dockingManager) {
                this.fireDockableFrameEvent(3999);
            }
        } else if (oldValue instanceof DefaultDockingManager) {
            ((DefaultDockingManager)oldValue).discardAllUndoEdits(this.getKey());
        }
    }

    @Override
    public void setDockedWidth(int dockedWidth) {
        int old = this.getContext().getDockedWidth();
        if (old != dockedWidth) {
            this.getContext().setDockedWidth(dockedWidth);
            this.firePropertyChange(PROPERTY_DOCKED_WIDTH, old, dockedWidth);
            if (this.getDockingManager() != null && this.getDockingManager().getDockedFrameContainer() != null && this.getDockingManager().getDockedFrameContainer().isShowing()) {
                this.setPreferredSizeWithDockedWidthAndHeight();
            }
        }
    }

    @Override
    public void setDockedHeight(int dockedHeight) {
        int old = this.getContext().getDockedHeight();
        if (old != dockedHeight) {
            this.getContext().setDockedHeight(dockedHeight);
            this.firePropertyChange(PROPERTY_DOCKED_HEIGHT, old, dockedHeight);
            if (this.getDockingManager() != null && this.getDockingManager().getDockedFrameContainer() != null && this.getDockingManager().getDockedFrameContainer().isShowing()) {
                this.setPreferredSizeWithDockedWidthAndHeight();
            }
        }
    }

    @Override
    public int getDockedWidth() {
        if (this.getContext().getDockedWidth() <= 0) {
            Dimension preferredSize = super.getPreferredSize();
            int width = preferredSize.width < 200 ? 200 : preferredSize.width;
            this.getContext().setDockedWidth(width);
            return width;
        }
        return this.getContext().getDockedWidth();
    }

    @Override
    public int getDockedHeight() {
        if (this.getContext().getDockedHeight() <= 0) {
            Dimension preferredSize = super.getPreferredSize();
            int height = preferredSize.height < 200 ? 200 : preferredSize.height;
            this.getContext().setDockedHeight(height);
            return height;
        }
        return this.getContext().getDockedHeight();
    }

    @Override
    public void setAutohideWidth(int w) {
        int old = this.getContext().getAutohideWidth();
        if (old != w) {
            this.getContext().setAutohideWidth(w);
            this.firePropertyChange(PROPERTY_AUTOHIDE_WIDTH, old, w);
            if (!this._settingSize) {
                this.getContext().setInitAutohideWidth(w);
            }
        }
    }

    @Override
    public void setAutohideHeight(int autohideHeight) {
        int old = this.getContext().getAutohideHeight();
        if (old != autohideHeight) {
            this.getContext().setAutohideHeight(autohideHeight);
            this.firePropertyChange(PROPERTY_AUTOHIDE_HEIGHT, old, autohideHeight);
            if (!this._settingSize) {
                this.getContext().setInitAutohideHeight(autohideHeight);
            }
        }
    }

    @Override
    public int getAutohideWidth() {
        if (this.getContext().getAutohideWidth() <= 0) {
            if (this.getContext().getInitAutohideWidth() <= 0) {
                return Math.max(this.getMinimumSize().width, this.getPreferredSize().width);
            }
            return Math.max(this.getMinimumSize().width, this.getContext().getInitAutohideWidth());
        }
        return Math.max(this.getMinimumSize().width, this.getContext().getAutohideWidth());
    }

    @Override
    public int getAutohideHeight() {
        if (this.getContext().getAutohideHeight() <= 0) {
            if (this.getContext().getInitAutohideHeight() <= 0) {
                return Math.max(this.getMinimumSize().height, this.getPreferredSize().height);
            }
            return Math.max(this.getMinimumSize().height, this.getContext().getInitAutohideHeight());
        }
        return Math.max(this.getMinimumSize().height, this.getContext().getAutohideHeight());
    }

    @Override
    public Rectangle getUndockedBounds() {
        Rectangle bounds = this._context.getUndockedBounds();
        if (bounds == null && (bounds = this._context.getInitUndockedBounds()) == null) {
            Point start = new Point(0, 0);
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isDocked()) {
                width = this.getDockedWidth();
                height = this.getDockedHeight();
            }
            if (this.isShowing()) {
                try {
                    start = this.getLocationOnScreen();
                }
                catch (IllegalComponentStateException e) {
                    JideSwingUtilities.ignoreException(e);
                }
            }
            if (this.isShowTitleBar() && this.getUI().getTitlePane() != null) {
                Component titlePane = this.getUI().getTitlePane();
                start.x += titlePane.getHeight();
                start.y += titlePane.getHeight();
            } else {
                start.x += 20;
                start.y += 20;
            }
            bounds = new Rectangle(start.x, start.y, width, height);
        }
        return bounds;
    }

    @Override
    public void setUndockedBounds(Rectangle undockedBounds) {
        Rectangle old = this.getContext().getUndockedBounds();
        if (undockedBounds != null && !undockedBounds.equals(old) || undockedBounds == null && old != null) {
            this.getContext().setUndockedBounds(undockedBounds);
            this.firePropertyChange(PROPERTY_UNDOCKED_BOUNDS, old, undockedBounds);
            if (!this._settingSize) {
                this.getContext().setInitUndockedBounds(undockedBounds);
            }
        }
    }

    @Override
    public int getDockID() {
        return this.getContext().getDockID();
    }

    @Override
    public void setDockID(int id) {
        this.getContext().setDockID(this._dockingManager, id);
    }

    @Override
    public void resetDockID() {
        this.getContext().resetDockID(this._dockingManager);
        this.getContext().setInitPosition(false);
    }

    public boolean isAvailable() {
        return this.getContext().isAvailable();
    }

    public void setAvailable(boolean available) {
        if (available != this.isAvailable()) {
            boolean old = this.isAvailable();
            this.getContext().setAvailable(available);
            this.firePropertyChange(PROPERTY_AVAILABLE, old, available);
            if (!available) {
                this.setVisible(available);
            }
        }
    }

    public void setTitleBarComponent(JComponent component) {
        JComponent old = this._titleBarComponent;
        if (old != component) {
            this._titleBarComponent = component;
            this.firePropertyChange(PROPERTY_TITLE_BAR_COMPONENT, old, this._titleBarComponent);
        }
    }

    public JComponent getTitleBarComponent() {
        return this._titleBarComponent;
    }

    public void setTitleLabelComponent(JComponent component) {
        JComponent old = this._titleLabelComponent;
        if (old != component) {
            if (old != null) {
                old.removeMouseListener(this._mouseListener);
                old.removeMouseMotionListener(this._mouseListener);
            }
            this._titleLabelComponent = component;
            if (this._titleLabelComponent != null) {
                this._titleLabelComponent.addMouseListener(this._mouseListener);
                this._titleLabelComponent.addMouseMotionListener(this._mouseListener);
            }
            this.firePropertyChange(PROPERTY_TITLE_LABEL_COMPONENT, old, this._titleLabelComponent);
        }
    }

    public JComponent getTitleLabelComponent() {
        return this._titleLabelComponent;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDockableFrame();
        }
        return this.accessibleContext;
    }

    public boolean isShowGripper() {
        return !(!this._showGripper || this.isAutohide() || this.isAutohideShowing() || !this.isRearrangable() || this._dockingManager != null && !this._dockingManager.isShowGripper() || this._dockingManager != null && !this._dockingManager.isRearrangable());
    }

    public void setShowGripper(boolean showGripper) {
        if (this._showGripper != showGripper) {
            boolean oldShowGripper = this._showGripper;
            this._showGripper = showGripper;
            this.firePropertyChange(PROPERTY_SHOW_GRIPPER, oldShowGripper, this._showGripper);
        }
    }

    public boolean isShowTitleBar() {
        return this._showTitleBar && (this._dockingManager == null || this._dockingManager.isShowTitleBar());
    }

    boolean isShowTitleBarConfigured() {
        return this._showTitleBarConfigured;
    }

    void setShowTitleBarConfigured(boolean showTitleBarConfigured) {
        this._showTitleBarConfigured = showTitleBarConfigured;
    }

    public void setShowTitleBar(boolean showTitleBar) {
        this._showTitleBarConfigured = true;
        this.internalSetShowTitleBar(showTitleBar);
    }

    void internalSetShowTitleBar(boolean showTitleBar) {
        if (this._showTitleBar != showTitleBar) {
            boolean oldShowTitleBar = this._showTitleBar;
            this._showTitleBar = showTitleBar;
            this.firePropertyChange(PROPERTY_SHOW_TITLE_BAR, oldShowTitleBar, this._showTitleBar);
        }
    }

    public boolean isShowContentPane() {
        return this._showContentPane;
    }

    public void setShowContentPane(boolean showContentPane) {
        if (this._showContentPane != showContentPane) {
            boolean oldShowContentPane = this._showContentPane;
            this._showContentPane = showContentPane;
            this.firePropertyChange(PROPERTY_SHOW_CONTENT_PANE, oldShowContentPane, this._showContentPane);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (maximizable != this._maximizable) {
            boolean old = this._maximizable;
            this._maximizable = maximizable;
            this.firePropertyChange(PROPERTY_MAXIMIZABLE, old, this._maximizable);
        }
    }

    private void changeMode(int mode) {
        if (this.isNotified()) {
            this.setNotified(false);
        }
        this.getContext().setCurrentMode(mode);
    }

    public boolean isNotified() {
        return this._notified;
    }

    public void setNotified(boolean notified) {
        if (this._notified && notified) {
            return;
        }
        if (notified) {
            if (this.getParent() instanceof FrameContainer) {
                FrameContainer frameContainer = (FrameContainer)this.getParent();
                if (this.shouldNotify(frameContainer)) {
                    this._animator = this.createNotificationFlasher(frameContainer);
                    this._animator.start();
                    this._notified = true;
                }
            } else if (this.isAutohide()) {
                int side = this.getContext().getCurrentDockSide();
                AutoHideContainer autoHideContainer = this.getDockingManager().getAutoHideContainer(side);
                this._animator = this.createNotificationFlasher(autoHideContainer);
                this._animator.start();
                this._notified = true;
            }
        } else {
            this._notified = false;
            if (this._animator != null) {
                this._animator.stop();
            }
        }
    }

    protected boolean shouldNotify(FrameContainer frameContainer) {
        return frameContainer != null && frameContainer.getSelectedFrame() != null && !this.equals(frameContainer.getSelectedFrame());
    }

    protected NotificationFlasher createNotificationFlasher(AutoHideContainer autoHideContainer) {
        return new NotificationFlasher(autoHideContainer, this, 0, this.getDockingManager().getNotificationDelay(), this.getDockingManager().getNotificationSteps());
    }

    protected NotificationFlasher createNotificationFlasher(FrameContainer fc) {
        return new NotificationFlasher(fc, this, 0, this.getDockingManager().getNotificationDelay(), this.getDockingManager().getNotificationSteps());
    }

    public boolean shouldVetoShowing() {
        return false;
    }

    public boolean shouldVetoHiding() {
        return false;
    }

    public boolean shouldVetoRemoving() {
        return false;
    }

    public boolean isSlidingAutohide() {
        return this._slidingAutohide;
    }

    public void setSlidingAutohide(boolean slidingAutohide) {
        if (this._slidingAutohide != slidingAutohide) {
            boolean old = this._slidingAutohide;
            this._slidingAutohide = slidingAutohide;
            this.firePropertyChange(PROPERTY_SLIDING_AUTOHIDE, old, this._slidingAutohide);
        }
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this._dockingManager = null;
        this._defaultFocusComponent = null;
        this._internalFocusedComponent = null;
        this.removeMouseListener(this._mouseListener);
        this.removeMouseMotionListener(this._mouseListener);
        this.putClientProperty("DraggingListener", null);
        this._mouseListener = null;
        this.putClientProperty("DraggingListener", null);
        if (this._currentFocusOwnerTracker != null) {
            this._currentFocusOwnerTracker.removeFocusListener(this._focusListenerInternalTracking);
            this._currentFocusOwnerTracker = null;
        }
        this._focusListenerInternalTracking = null;
        this.setRootPaneCheckingEnabled(false);
        this.getUI().uninstallUI(this);
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean isTransient) {
        if (isTransient != this._transient) {
            boolean old = this._transient;
            this._transient = isTransient;
            this.firePropertyChange(PROPERTY_TRANSIENT, old, this._transient);
        }
    }

    public int getInitMode() {
        return this.getContext().getInitMode();
    }

    public void setInitMode(int initMode) {
        int old = this.getContext().getInitMode();
        if (old != initMode) {
            this.getContext().setInitMode(initMode);
            this.firePropertyChange(PROPERTY_INIT_MODE, old, initMode);
        }
    }

    public int getInitSide() {
        return this.getContext().getInitSide();
    }

    public void setInitSide(int initSide) {
        int old = this.getContext().getInitSide();
        if (old != initSide) {
            this.getContext().setInitSide(initSide);
            this.firePropertyChange(PROPERTY_INIT_SIDE, old, initSide);
        }
    }

    public int getInitIndex() {
        return this.getContext().getInitIndex();
    }

    public void setInitIndex(int initIndex) {
        int old = this.getContext().getInitIndex();
        if (old != initIndex) {
            this.getContext().setInitIndex(initIndex);
        }
    }

    protected PropertyChangeListener createFocusChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                boolean hasFocus;
                boolean hadFocus = DockableFrame.this.isAncestorOf((Component)evt.getOldValue()) || DockableFrame.this == evt.getOldValue() || DockableFrame.this.hasFocus();
                boolean bl = hasFocus = DockableFrame.this.isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) || DockableFrame.this == KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() || DockableFrame.this.hasFocus();
                if (hasFocus != hadFocus) {
                    DockableFrame.this.getUI().getTitlePane().repaint();
                }
            }
        };
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this._focusChangeListener == null) {
            this._focusChangeListener = this.createFocusChangeListener();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this._focusChangeListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this._focusChangeListener);
            this._focusChangeListener = null;
        }
    }

    public int getPreferredAutohideSide() {
        return this._preferredAutohideSide;
    }

    public void setPreferredAutohideSide(int preferredAutohideSide) {
        if (this._preferredAutohideSide != preferredAutohideSide) {
            int old = this._preferredAutohideSide;
            this._preferredAutohideSide = preferredAutohideSide;
            this.firePropertyChange(PROPERTY_PREFERRED_AUTOHIDE_SIDE, old, this._preferredAutohideSide);
        }
    }

    public boolean isTabDockAllowed() {
        return this._tabDockAllowed;
    }

    public void setTabDockAllowed(boolean tabDockAllowed) {
        if (this._tabDockAllowed != tabDockAllowed) {
            boolean old = this._tabDockAllowed;
            this._tabDockAllowed = tabDockAllowed;
            this.firePropertyChange(PROPERTY_TAB_DOCK_ALLOWED, old, this._tabDockAllowed);
        }
    }

    public boolean isAlwaysStayInGroup() {
        return this._alwaysStayInGroup;
    }

    public void setAlwaysStayInGroup(boolean alwaysStayInGroup) {
        if (this._alwaysStayInGroup != alwaysStayInGroup) {
            boolean old = this._alwaysStayInGroup;
            this._alwaysStayInGroup = alwaysStayInGroup;
            this.firePropertyChange(PROPERTY_STAY_IN_GROUP, old, this._alwaysStayInGroup);
        }
    }

    public boolean isSideDockAllowed() {
        return this._sideDockAllowed;
    }

    public void setSideDockAllowed(boolean sideDockAllowed) {
        if (this._sideDockAllowed != sideDockAllowed) {
            boolean old = this._sideDockAllowed;
            this._sideDockAllowed = sideDockAllowed;
            this.firePropertyChange(PROPERTY_SIDE_DOCK_ALLOWED, old, this._sideDockAllowed);
        }
    }

    @Override
    protected String paramString() {
        return "key=" + this.getKey() + ",title=" + this.getTitle() + ",mode=" + (this.getContext() == null ? "unknown" : DockContext.getStateName(this.getContext().getCurrentMode())) + ",side=" + (this.getContext() == null ? "unknown" : DockContext.getDockSideName(this.getContext().getCurrentDockSide()));
    }

    public Action getCloseAction() {
        if (this._closeAction == null) {
            if (this._closeActionByDefault == null) {
                this._closeActionByDefault = new CloseAction();
            }
            return this._closeActionByDefault;
        }
        return this._closeAction;
    }

    public void setCloseAction(Action closeAction) {
        Action old = this._closeAction;
        if (old != closeAction) {
            this._closeAction = closeAction;
            this.firePropertyChange(PROPERTY_CLOSE_ACTION, old, this._closeAction);
        }
    }

    public Action getHideAutohideAction() {
        if (this._hideAutohideAction == null) {
            if (this._hideAutohideActionByDefault == null) {
                this._hideAutohideActionByDefault = new HideAutohideAction();
            }
            return this._hideAutohideActionByDefault;
        }
        return this._hideAutohideAction;
    }

    public void setHideAutohideAction(Action hideAutohideAction) {
        Action old = this._hideAutohideAction;
        if (old != hideAutohideAction) {
            this._hideAutohideAction = hideAutohideAction;
            this.firePropertyChange(PROPERTY_HIDE_AUTOHIDE_ACTION, old, this._hideAutohideAction);
        }
    }

    public Action getFloatingAction() {
        return this.getFloatingAction(false);
    }

    public Action getFloatingAction(boolean single) {
        if (this._floatingAction == null) {
            if (this._floatingActionByDefault == null) {
                this._floatingActionByDefault = new FloatingAction(single);
            } else {
                ((FloatingAction)this._floatingActionByDefault).setSingle(single);
            }
            return this._floatingActionByDefault;
        }
        return this._floatingAction;
    }

    public void setFloatingAction(Action floatingAction) {
        Action old = this._floatingAction;
        if (old != floatingAction) {
            this._floatingAction = floatingAction;
            this.firePropertyChange(PROPERTY_FLOATING_ACTION, old, this._floatingAction);
        }
    }

    public Action getAutohideAction() {
        if (this._autohideAction == null) {
            if (this._autohideActionByDefault == null) {
                this._autohideActionByDefault = new AutohideAction();
            }
            return this._autohideActionByDefault;
        }
        return this._autohideAction;
    }

    public void setAutohideAction(Action autohideAction) {
        Action old = this._autohideAction;
        if (old != autohideAction) {
            this._autohideAction = autohideAction;
            this.firePropertyChange(PROPERTY_AUTOHIDE_ACTION, old, this._autohideAction);
        }
    }

    public Action getMaximizeAction() {
        if (this._maximizeAction == null) {
            if (this._maximizeActionByDefault == null) {
                this._maximizeActionByDefault = new MaximizeAction();
            }
            return this._maximizeActionByDefault;
        }
        return this._maximizeAction;
    }

    public void setMaximizeAction(Action maximizeAction) {
        Action old = this._maximizeAction;
        if (old != maximizeAction) {
            this._maximizeAction = maximizeAction;
            this.firePropertyChange(PROPERTY_MAXIMIZE_ACTION, old, this._maximizeAction);
        }
    }

    public Action getDockableAction() {
        if (this._dockableAction == null) {
            if (this._dockableActionByDefault == null) {
                this._dockableActionByDefault = new DockableAction();
            }
            return this._dockableActionByDefault;
        }
        return this._dockableAction;
    }

    public void setDockableAction(Action dockableAction) {
        Action old = this._dockableAction;
        if (old != dockableAction) {
            this._dockableAction = dockableAction;
            this.firePropertyChange(PROPERTY_DOCKABLE_ACTION, old, this._dockableAction);
        }
    }

    public Action getCustomDoubleClickAction() {
        return this._customDoubleClickAction;
    }

    public void setCustomDoubleClickAction(Action customDoubleClickAction) {
        Action old = this._customDoubleClickAction;
        if (old != customDoubleClickAction) {
            this._customDoubleClickAction = customDoubleClickAction;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ACTION, old, this._customDoubleClickAction);
        }
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        if (!this._settingSize) {
            this._savedPreferredSize = preferredSize;
        }
        super.setPreferredSize(preferredSize);
    }

    void setSettingSize(boolean settingSize) {
        this._settingSize = settingSize;
    }

    void resetPreferredSize() {
        this.setPreferredSize(this._savedPreferredSize);
    }

    void internalSetPreferredSize() {
        try {
            this.setSettingSize(true);
            this.setPreferredSizeWithDockedWidthAndHeight();
        }
        finally {
            this.setSettingSize(false);
        }
    }

    void setPreferredSizeWithDockedWidthAndHeight() {
        int height;
        Dimension preferredSize = this.getPreferredSize();
        int width = this.getDockedWidth();
        if (width <= 0) {
            width = preferredSize.width;
        }
        if ((height = this.getDockedHeight()) <= 0) {
            height = preferredSize.height;
        }
        this.setPreferredSize(new Dimension(width, height));
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    public void setShowContextMenu(boolean showContextMenu) {
        boolean old = this._showContextMenu;
        if (old != showContextMenu) {
            this._showContextMenu = showContextMenu;
            this.firePropertyChange(PROPERTY_SHOW_CONTEXT_MENU, old, this._showContextMenu);
        }
    }

    protected boolean isDraggingTarget(MouseEvent e) {
        if (this.getDockingManager() == null) {
            return false;
        }
        Object source = e.getSource();
        return (!this.isShowGripper() || this._dockingManager != null && !this._dockingManager.isDragGripperOnly()) && (source == this.getUI().getTitlePane() || source == this.getTitleLabelComponent() || source == this.getTitleBarComponent()) || source instanceof Gripper;
    }

    protected Component getDraggingTarget(MouseEvent e) {
        if (!this.isDraggingTarget(e)) {
            return null;
        }
        if (e.getSource() == this.getParent() && this.getParent() instanceof JideTabbedPane) {
            Point p;
            Point point = e.getPoint();
            Component tabPanel = ((JideTabbedPaneUI)((JideTabbedPane)this.getParent()).getUI()).getTabPanel();
            if (tabPanel.contains(p = SwingUtilities.convertPoint((Component)e.getSource(), point, tabPanel))) {
                return this.getParent();
            }
        } else if (!this.getDockingManager().isDragAllTabs() && e.getSource() == this.getUI().getTitlePane()) {
            Point p;
            Point point = e.getPoint();
            Component titlePane = this.getUI().getTitlePane();
            if (titlePane.contains(p = SwingUtilities.convertPoint((Component)e.getSource(), point, titlePane))) {
                return this.getParent();
            }
        }
        return this;
    }

    public int getDefaultEscapeAction() {
        return this._defaultEscapeAction;
    }

    public void setDefaultEscapeAction(int defaultEscapeAction) {
        int old = this._defaultEscapeAction;
        if (this._defaultEscapeAction != defaultEscapeAction) {
            this._defaultEscapeAction = defaultEscapeAction;
            this.firePropertyChange(PROPERTY_DEFAULT_ESCAPE_ACTION, old, this._defaultEscapeAction);
        }
    }

    public int getDefaultCloseAction() {
        return this._defaultCloseAction;
    }

    public void setDefaultCloseAction(int defaultCloseAction) {
        int old = this._defaultCloseAction;
        if (this._defaultCloseAction != defaultCloseAction) {
            this._defaultCloseAction = defaultCloseAction;
            this.firePropertyChange(PROPERTY_DEFAULT_CLOSE_ACTION, old, this._defaultCloseAction);
        }
    }

    public boolean isAutohideWhenActive() {
        return this._autohideWhenActive;
    }

    public void setAutohideWhenActive(boolean autohideWhenActive) {
        boolean old = this._autohideWhenActive;
        if (old != autohideWhenActive) {
            this._autohideWhenActive = autohideWhenActive;
            this.firePropertyChange(PROPERTY_AUTOHIDE_WHEN_ACTIVE, old, autohideWhenActive);
        }
    }

    public int[] getButtonsOrder() {
        return this._buttonsOrder;
    }

    public void setButtonsOrder(int[] buttonsOrder) {
        int[] old = this._buttonsOrder;
        if (buttonsOrder != this._buttonsOrder) {
            this._buttonsOrder = buttonsOrder;
            this.firePropertyChange(PROPERTY_BUTTONS_ORDER, old, this._buttonsOrder);
        }
    }

    @Deprecated
    public boolean isActivateAfterSliding() {
        return false;
    }

    @Deprecated
    public void addAdditionalButtonActions(Action action, Icon icon) {
        this.addAdditionalButtonActions(action);
    }

    public void addAdditionalButtonActions(Action action) {
        if (action == null) {
            return;
        }
        if (this._additionalButtonActions.contains(action)) {
            return;
        }
        Object oldAdditionalButtonActions = this._additionalButtonActions.clone();
        this._additionalButtonActions.add(action);
        this.firePropertyChange("additionalButtonActions", oldAdditionalButtonActions, this._additionalButtonActions);
    }

    public void removeAdditionalButtonActions(Action action) {
        if (action == null) {
            return;
        }
        if (!this._additionalButtonActions.contains(action)) {
            return;
        }
        Object oldAdditionalButtons = this._additionalButtonActions.clone();
        this._additionalButtonActions.remove(action);
        this.firePropertyChange("additionalButtonActions", oldAdditionalButtons, this._additionalButtonActions);
    }

    public Icon getActionIcon(Action action) {
        if (action == null) {
            return null;
        }
        return (Icon)action.getValue("SmallIcon");
    }

    public List<Action> getAdditionalButtonActions() {
        return Collections.unmodifiableList(this._additionalButtonActions);
    }

    private void recordPreviousContext() {
        if (this._previousContext == null) {
            this._previousContext = new DockContext();
        }
        this._previousContext.setCurrentMode(-1);
        this._previousContext.setCurrentDockSide(0);
        this._previousContext.setUndockedBounds(null);
    }

    boolean isRealized() {
        return this._realized;
    }

    void setRealized(boolean realized) {
        this._realized = realized;
    }

    public void setTabBackground(Color background) {
        this._tabBackground = background;
    }

    @Override
    public Color getTabBackground() {
        return this._tabBackground;
    }

    public void setTabForeground(Color foreground) {
        this._tabForeground = foreground;
    }

    @Override
    public Color getTabForeground() {
        return this._tabForeground;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (!Q.zz(1)) {
            Lm.showInvalidProductMessage(DockableFrame.class.getName(), 1);
        }
        LOGGER_EVENT = Logger.getLogger(DockableFrameEvent.class.getName());
        LOGGER_FOCUS = Logger.getLogger(DefaultDockingManager.class.getName() + ".focus");
    }

    protected class AccessibleDockableFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        protected AccessibleDockableFrame() {
            super(DockableFrame.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return DockableFrame.this.getTabTitle();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            if (DockableFrame.this.isActive()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            if (n instanceof Integer) {
                try {
                    if (n.intValue() == 0) {
                        DockableFrame.this.setActive(true);
                    } else {
                        DockableFrame.this.setActive(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }

    public class DockableAction
    extends AbstractAction {
        public DockableAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.dockableText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.dockableTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockableFrame.this.getDockingManager().toggleDockable(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.getDockingManager() != null && !DockableFrame.this.isMaximized() && DockableFrame.this.getDockingManager().isFloatable() && DockableFrame.this.isFloatable() && !DockableFrame.this.isAutohide() && !DockableFrame.this.isAutohideShowing() && super.isEnabled();
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.maximizeText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.maximizeTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DockableFrame.this.getDockingManager().getMaximizedFrameKey() == null) {
                DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.maximize"));
            } else {
                DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.restore"));
            }
            DockableFrame.this.getDockingManager().toggleMaximizeState(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isMaximizable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.isDockable() && super.isEnabled();
        }
    }

    public class HideAutohideAction
    extends AbstractAction {
        public HideAutohideAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.hideAutohideText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.hideAutohideTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DockableFrame.this.getDockingManager() != null && DockableFrame.this.isAutohideShowing()) {
                DockableFrame.this.getDockingManager().stopShowingAutohideFrame(0, true);
            }
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.getDockingManager() != null && DockableFrame.this.isAutohideShowing() && super.isEnabled();
        }
    }

    public class FloatingAction
    extends AbstractAction {
        private boolean _single;

        public FloatingAction() {
            this(false);
        }

        public FloatingAction(boolean single) {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.floatingText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.floatingTooltip"));
            this.setSingle(single);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean single = this.isSingle() || !DockableFrame.this.getDockingManager().isFloatAllTabs();
            DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.toggle"));
            DockableFrame.this.getDockingManager().toggleState(DockableFrame.this.getKey(), single);
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isDockable() && DockableFrame.this.isFloatable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isFloatable() && super.isEnabled();
        }

        public boolean isSingle() {
            return this._single;
        }

        public void setSingle(boolean single) {
            this._single = single;
        }
    }

    public class AutohideAction
    extends AbstractAction {
        public AutohideAction() {
            super(DockableFrame.this.getResourceString("DockableFrameTitlePane.autohideText"));
            this.putValue("ShortDescription", DockableFrame.this.getResourceString("DockableFrameTitlePane.autohideTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getResourceString("Undo.toggleAutohide"));
            DockableFrame.this.getDockingManager().toggleAutohideState(DockableFrame.this.getKey());
        }

        @Override
        public boolean isEnabled() {
            return !DockableFrame.this.isFloated() && DockableFrame.this.isDockable() && DockableFrame.this.isAutohidable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isAutohidable() && super.isEnabled();
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(DockableFrame.this.getDockingManager() != null ? DockableFrame.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeText") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeText"));
            this.putValue("ShortDescription", DockableFrame.this.getDockingManager() != null ? DockableFrame.this.getDockingManager().getResourceString("DockableFrameTitlePane.closeTooltip") : Resource.getResourceBundle(Locale.getDefault()).getString("DockableFrameTitlePane.closeTooltip"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (DockableFrame.this.getDefaultCloseAction()) {
                case 0: {
                    if (DockableFrame.this.isHidden() || DockableFrame.this.shouldVetoHiding()) break;
                    if (e == null || !"hiddenByParentContainer".equals(e.getActionCommand())) {
                        DockableFrame.this.getDockingManager().addUndo(DockableFrame.this.getDockingManager().getResourceString("Undo.hide"));
                    }
                    DockableFrame.this.getDockingManager().hideFrame(DockableFrame.this.getKey());
                    break;
                }
                case 1: {
                    if (DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey()) == null || DockableFrame.this.shouldVetoRemoving()) break;
                    DockableFrame.this.getDockingManager().removeFrame(DockableFrame.this.getKey());
                    break;
                }
                case 2: {
                    if (DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey()) == null || DockableFrame.this.shouldVetoRemoving()) break;
                    DockableFrame frameDispose = DockableFrame.this.getDockingManager().getFrame(DockableFrame.this.getKey());
                    DockableFrame.this.getDockingManager().removeFrame(DockableFrame.this.getKey());
                    frameDispose.dispose();
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return DockableFrame.this.isHidable() && DockableFrame.this.getDockingManager() != null && DockableFrame.this.getDockingManager().isHidable() && super.isEnabled();
        }
    }
}

