/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class ContainerContainerDivider
extends JideSplitPaneDivider {
    public ContainerContainerDivider(JideSplitPane splitPane) {
        super(splitPane);
        if (!this.isResizable()) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected JideSplitPaneDivider.MouseHandler createMouseHandler() {
        return new ContainerContainerMouseHandler();
    }

    private boolean isResizable() {
        if (this._jideSplitPane != null && ((ContainerContainer)this._jideSplitPane).getDockingManager() != null) {
            return this.getDockingManager().isResizable();
        }
        return true;
    }

    private DockingManager getDockingManager() {
        return ((ContainerContainer)this._jideSplitPane).getDockingManager();
    }

    private DockableFrame getAutohideShowingFrame() {
        int index = this._jideSplitPane.indexOfDivider(this);
        Component compCheck = this._jideSplitPane.getPaneAt(index);
        if (compCheck instanceof DockableFrame && ((DockableFrame)compCheck).isAutohideShowing()) {
            return (DockableFrame)compCheck;
        }
        compCheck = this._jideSplitPane.getPaneAt(index + 1);
        if (compCheck instanceof DockableFrame && ((DockableFrame)compCheck).isAutohideShowing()) {
            return (DockableFrame)compCheck;
        }
        return null;
    }

    class ContainerContainerMouseHandler
    extends JideSplitPaneDivider.MouseHandler {
        ContainerContainerMouseHandler() {
            super(ContainerContainerDivider.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mousePressed(e);
                DockableFrame frameAutoshowing = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (frameAutoshowing != null) {
                    ContainerContainerDivider.this.getDockingManager().beginResizingFrame(frameAutoshowing, 0);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mouseReleased(e);
                if (ContainerContainerDivider.this._jideSplitPane == null) {
                    return;
                }
                DockableFrame frameAutoshowing = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (frameAutoshowing != null) {
                    ContainerContainerDivider.this.getDockingManager().endResizingFrame(frameAutoshowing);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ContainerContainerDivider.this.isResizable()) {
                super.mouseDragged(e);
                DockableFrame frameAutoshowing = ContainerContainerDivider.this.getAutohideShowingFrame();
                if (frameAutoshowing != null) {
                    ContainerContainerDivider.this.getDockingManager().endResizingFrame(frameAutoshowing);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ContainerContainerDivider.this.isResizable() && SystemInfo.isJdk6Above()) {
                super.mouseMoved(e);
            }
        }
    }
}

