/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.ContentContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;

class DockableBarUtils {
    DockableBarUtils() {
    }

    public static int sideOfComponent(Component comp, int x, int y) {
        int sensitiveX = Math.min(20, comp.getWidth() / 3);
        int sensitiveY = Math.min(20, comp.getHeight() / 3);
        if (x >= 0 && x < sensitiveX && y >= 0 && y < comp.getHeight()) {
            return 7;
        }
        if (x >= comp.getWidth() - sensitiveX && x < comp.getWidth() && y >= 0 && y <= comp.getHeight()) {
            return 3;
        }
        if (y >= 0 && y < sensitiveY && x >= 0 && x < comp.getWidth()) {
            return 1;
        }
        if (y >= comp.getHeight() - sensitiveY && y < comp.getHeight() && x >= 0 && x <= comp.getWidth()) {
            return 5;
        }
        return 0;
    }

    static void saveClosePreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getClosePreviousState());
        dockableBar.getContext().setClosePreviousState(PreviousState.createPreviousState(dockableBar));
    }

    static void saveHiddenPreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getHiddenPreviousState());
        dockableBar.getContext().setHiddenPreviousState(PreviousState.createPreviousState(dockableBar));
    }

    static void saveFloatPreviousState(DockableBar DockableBar2) {
        PreviousState.disposePreviousState(DockableBar2.getContext().getFloatPreviousState());
        DockableBar2.getContext().setFloatPreviousState(PreviousState.createPreviousState(DockableBar2));
    }

    static void saveDockPreviousState(DockableBar DockableBar2) {
        PreviousState.disposePreviousState(DockableBar2.getContext().getDockPreviousState());
        DockableBar2.getContext().setDockPreviousState(PreviousState.createPreviousState(DockableBar2));
    }

    public static Container getDockableBarContainer(DockableBarManager manager, Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof DockableBarContainer && ((DockableBarContainer)component).getDockableBarManager() == manager) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container p = (Container)component; p != null; p = p.getParent()) {
            if (!(p instanceof DockableBarContainer) || ((DockableBarContainer)p).getDockableBarManager() != manager) continue;
            return p;
        }
        return null;
    }

    public static Container getDockableBarOrContainer(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof DockableBarContainer) {
            return (Container)component;
        }
        if (component instanceof DockableBar) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container p = (Container)component; p != null; p = p.getParent()) {
            if (p instanceof DockableBarContainer) {
                return p;
            }
            if (!(p instanceof DockableBar)) continue;
            return p;
        }
        return null;
    }

    public static Container findNearbyDockableBarContainerAt(DockableBarManager manager, Container container, Point p, int r) {
        Container pane = DockableBarUtils.findDockableBarContainerAt(manager, container, p);
        if (pane != null) {
            return pane;
        }
        Point[] points = new Point[]{new Point(p.x, p.y - r), new Point(p.x - r, p.y), new Point(p.x, p.y + r), new Point(p.x + r, p.y)};
        for (int i = 0; i < points.length && (pane = DockableBarUtils.findDockableBarContainerAt(manager, container, points[i])) == null; ++i) {
        }
        return pane;
    }

    public static Container findDockableBarContainerAt(DockableBarManager manager, Container container, Point p) {
        Component component = container.findComponentAt(p);
        return DockableBarUtils.getDockableBarContainer(manager, component);
    }

    private static Container findContentContainer(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof ContentContainer) {
            return (Container)component;
        }
        component = component.getParent();
        for (Container p = (Container)component; p != null; p = p.getParent()) {
            if (!(p instanceof ContentContainer)) continue;
            return p;
        }
        return null;
    }

    public static Container findContentContainerAt(Container container, Point p) {
        Component component = container.findComponentAt(p);
        return DockableBarUtils.findContentContainer(component);
    }

    public static int convertSideToDockSide(int side) {
        switch (side) {
            case 1: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 7: {
                return 8;
            }
            case 3: {
                return 4;
            }
        }
        throw new IllegalArgumentException(side + " is not a valid side in SwingConstants.");
    }

    public static int convertDockSideToSide(int dockSide) {
        switch (dockSide) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 3;
            }
        }
        throw new IllegalArgumentException(dockSide + " is not a valid DOCK_SIDE.");
    }

    static void saveAvailablePreviousState(DockableBar dockableBar) {
        PreviousState.disposePreviousState(dockableBar.getContext().getAvailablePreviousState());
        dockableBar.getContext().setAvailablePreviousState(PreviousState.createPreviousState(dockableBar));
    }
}

