/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainerLayout;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyVetoException;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class DockableBarContainer
extends JComponent
implements SwingConstants {
    private int _side;
    private DockableBarListList _dockableBarList;
    public static int OFFSET = 3;
    private DockableBarManager _dockableBarManager;
    private DockableBarShrinkOrderProvider _shrinkOrderProvider;

    public DockableBarContainer(DockableBarManager dockableBarManager, int side) {
        this(dockableBarManager);
        this.setSide(side);
    }

    public DockableBarContainer(DockableBarManager dockableBarManager) {
        this._dockableBarManager = dockableBarManager;
        this._dockableBarList = new DockableBarListList(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateGaps();
    }

    private void updateGaps() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof DockableBarContainerLayout) {
            if (UIDefaultsLookup.get("CommandBarContainer.verticalGap") instanceof Integer) {
                int vGap = UIDefaultsLookup.getInt("CommandBarContainer.verticalGap");
                ((DockableBarContainerLayout)layoutManager).setVerticalGap(vGap);
            }
            if (UIDefaultsLookup.get("CommandBarContainer.horizontalGap") instanceof Integer) {
                int hGap = UIDefaultsLookup.getInt("CommandBarContainer.horizontalGap");
                ((DockableBarContainerLayout)layoutManager).setHorizontalGap(hGap);
            }
            this.revalidate();
        }
    }

    public void setSide(int side) {
        this._side = side;
        this.setLayout(new DockableBarContainerLayout(this, this._side));
        this.updateGaps();
        if (this._side == 3 || this._side == 7) {
            JideSwingUtilities.setOrientationOf(this, 1);
        } else if (this._side == 1 || this._side == 5) {
            JideSwingUtilities.setOrientationOf(this, 0);
        }
    }

    public int getSide() {
        return this._side;
    }

    public void setDockableBarList(DockableBarListList list) {
        this.removeAll();
        this._dockableBarList = list;
        for (int i = 0; i < list.size(); ++i) {
            DockableBarList l = (DockableBarList)list.get(i);
            for (int j = 0; j < l.size(); ++j) {
                DockableBarItem item = (DockableBarItem)l.get(j);
                item.getComponent().setVisible(true);
                this.add(item.getComponent());
            }
        }
        this.invalidate();
    }

    public DockableBarShrinkOrderProvider getShrinkOrderProvider() {
        return this._shrinkOrderProvider;
    }

    public void setShrinkOrderProvider(DockableBarShrinkOrderProvider shrinkOrderProvider) {
        this._shrinkOrderProvider = shrinkOrderProvider;
    }

    public DockableBarListList getDockableBarList() {
        return this._dockableBarList;
    }

    public int getRowCount() {
        return this.getDockableBarList().size();
    }

    public int getRowHeight(int row) {
        return ((DockableBarContainerLayout)this.getLayout()).getRowHeightAt(row);
    }

    public int getRowAndGapIndexAt(Point point) {
        int y;
        int n = y = this.getOrientation() == 0 ? point.y : point.x;
        if (y < 0) {
            return 0;
        }
        if (y >= (this.getOrientation() == 0 ? this.getHeight() : this.getWidth())) {
            return this.getRowCount() * 2;
        }
        int currentY = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (y >= currentY + OFFSET && y < currentY + this.getRowHeight(i) - (i != this.getRowCount() - 1 ? OFFSET : 0)) {
                return i * 2 + 1;
            }
            currentY += this.getRowHeight(i);
            if (i == this.getRowCount() - 1) continue;
            if (y >= currentY - OFFSET && y < currentY + ((DockableBarContainerLayout)this.getLayout()).getVerticalGap() + OFFSET) {
                return i * 2 + 2;
            }
            currentY += ((DockableBarContainerLayout)this.getLayout()).getVerticalGap();
        }
        return -1;
    }

    public int getOrientation() {
        if (this._side == 1 || this._side == 5) {
            return 0;
        }
        return 1;
    }

    public boolean isHorizontal() {
        return this.getOrientation() == 0;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        JideSwingUtilities.setOrientationOf(comp, this.getOrientation());
    }

    public void addDockableBar(DockableBar bar, int row, boolean createNewRow, int start) {
        try {
            if (this.isHorizontal()) {
                bar.setHoriDocked();
            } else {
                bar.setVertDocked();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.add(bar);
        this._dockableBarList.changeComponentRow(bar, row, createNewRow, start);
        this.revalidate();
    }

    public int getCurrentRowOf(DockableBar bar) {
        DockableBarItem item = this.getDockableBarList().getDockableBarItemOf(bar);
        return item.getRow();
    }

    public DockableBarManager getDockableBarManager() {
        return this._dockableBarManager;
    }

    public static interface DockableBarShrinkOrderProvider {
        public int[] getShrinkOrder(int var1);
    }
}

