/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarBorderListener;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarFactory;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.DockableBarPersistenceUtils;
import com.jidesoft.action.DockableBarPopupMenuCustomizer;
import com.jidesoft.action.DockableBarUtils;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.MainContainer;
import com.jidesoft.action.PreviousState;
import com.jidesoft.action.Resource;
import com.jidesoft.action.SaveUtils;
import com.jidesoft.action.event.DockableBarState;
import com.jidesoft.action.event.DockableBarStateTransition;
import com.jidesoft.action.event.DockableBarsRearrangedEvent;
import com.jidesoft.action.event.DockableBarsRearrangedListener;
import com.jidesoft.converter.XmlUtils;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AbstractLayoutPersistence;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultDockableBarManager
extends AbstractLayoutPersistence
implements DockableBarManager,
AWTEventListener,
SwingConstants {
    private static final Logger LOGGER;
    private static final Logger LOGGER_EVENT;
    private final Map<String, DockableBar> _allDockableBars = new HashMap<String, DockableBar>();
    private final List<String> _allDockableBarKeys = new ArrayList<String>();
    private final Map<String, DockableBarContext> _allContexts = new HashMap<String, DockableBarContext>();
    private Container _contentContainer;
    private RootPaneContainer _rootPaneContainer;
    private MainContainer _mainContainer;
    FloatingDockableBars<FloatingDockableBarContainer> _floatingDockableBars;
    HiddenDockableBars<String> _hiddenDockableBars = new HiddenDockableBars();
    DockableBarContainer _eastDockableBarContainer;
    DockableBarContainer _westDockableBarContainer;
    DockableBarContainer _northDockableBarContainer;
    DockableBarContainer _southDockableBarContainer;
    private boolean _startInFloat;
    private double _relativeX;
    private double _relativeY;
    private boolean _isDragging = false;
    private JComponent _draggingComponent = null;
    private boolean _isResizing = false;
    private DockableBarContainer _resizingPane = null;
    private boolean _rearrangeable = true;
    private boolean _floatable = true;
    private boolean _hidable = true;
    private DockableBarPopupMenuCustomizer _dockableBarPopupMenuCustomizer;
    private boolean _showContextMenu = true;
    private boolean _realized = false;
    private Rectangle _initBounds = new Rectangle();
    private int _initState;
    private boolean _hideFloatingDockableBarsWhenDeactivate = true;
    private boolean _showFloatingDockableBars = true;
    int _state;
    Rectangle _unmaximizedBounds = new Rectangle();
    public ComponentAdapter _componentListener;
    private Window _lastFocusedWindow;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;
    private boolean _loadingLayoutData = false;
    private KeyEventDispatcher _keyEventDispatcher;
    private boolean _preserveAvailableProperty = false;
    private boolean _showInitial = true;
    FloatingDockableBarContainer _currentFloatingCommandBar;
    private JPopupMenu _globalContextMenu;
    private PropertyChangeListener _dockableBarPropertyChangeListener;
    private boolean _loadDataSuccessful = true;
    protected DockableBarsSnapshot _preDragSnapshot = new DockableBarsSnapshot();
    protected DockableBarsSnapshot _postDragSnapshot = new DockableBarsSnapshot();
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean _redispatchingKeyEventToFloaters = false;
    public static final String PROPERTY_INIT_BOUNDS = "initBounds";
    public static final String PROPERTY_INIT_STATE = "initState";
    public static final String PROPERTY_HIDABLE = "hidable";
    public static final String PROPERTY_FLOATABLE = "floatable";
    public static final String PROPERTY_REARRANGABLE = "rearrangable";
    public static final String PROPERTY_HIDE_FLOATING_DOCKABLE_BARS_WHEN_DEACTIVATE = "hideFloatingDockableBarsWhenDeactivate";
    public static final String PROPERTY_SHOW_CONTEXT_MENU = "showContextMenu";
    public static final String PROPERTY_DOUBLE_CLICK_ACTION = "doubleClickAction";
    private FloaterKeyEventPostProcessor _keyEventPostProcessor;
    private WindowListener _windowListener;
    protected boolean _glassPaneVisibility;
    private boolean _useGlassPaneEnabled = true;
    private int _doubleClickAction = 0;
    int _saveDeltaX;
    int _saveDeltaY;
    private DockableBarFactory _dockableBarFactory;
    private static final String NODE_MANAGERS = "Managers";
    private static final String NODE_DOCKABLE_BAR_MANAGER = "DockableBarManager";
    private static final String NODE_DOCKABLE_BARS = "DockableBars";
    private static final String NODE_DOCKABLE_BAR = "DockableBar";
    private static final String ATTRIBUTE_KEY = "key";

    public DefaultDockableBarManager(RootPaneContainer rootContainer, Container contentContainer) {
        this.switchRootPaneContainer(rootContainer);
        Method method = null;
        try {
            method = contentContainer.getClass().getMethod("getContentPane", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            try {
                Object contentPane = method.invoke((Object)contentContainer, new Object[0]);
                if (contentPane instanceof Container) {
                    ((Container)contentPane).removeAll();
                }
            }
            catch (Exception exception) {}
        } else {
            contentContainer.removeAll();
        }
        this._contentContainer = contentContainer;
        this._mainContainer = new MainContainer();
        this.getContentContainer().setBackground(UIDefaultsLookup.getColor("ContentContainer.background"));
        this.getContentContainer().setLayout(new BorderLayout());
        this.getContentContainer().add((Component)this._mainContainer, "Center");
        this.addMouseEventHandler();
        this._dockableBarPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DefaultDockableBarManager.ATTRIBUTE_KEY.equals(evt.getPropertyName())) {
                    DefaultDockableBarManager.this.updateKey((String)evt.getOldValue(), (String)evt.getNewValue());
                }
            }
        };
        this._keyEventPostProcessor = new FloaterKeyEventPostProcessor();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this._keyEventPostProcessor);
        this.setRealized(false);
    }

    @Override
    public void switchRootPaneContainer(RootPaneContainer rootContainer) {
        if (rootContainer == null) {
            return;
        }
        this._rootPaneContainer = rootContainer;
        this._componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                this.clearUp();
                this.getWindowGeometry(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.clearUp();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.clearUp();
                this.getWindowGeometry(e);
            }

            private void clearUp() {
                if (DefaultDockableBarManager.this.isDragging()) {
                    DefaultDockableBarManager.this.cancelDragging();
                }
            }

            private void getWindowGeometry(ComponentEvent e) {
                if (e.getComponent() instanceof Frame) {
                    Frame frame = (Frame)e.getComponent();
                    if (PortingUtils.getFrameState(frame) != 6) {
                        DefaultDockableBarManager.this._unmaximizedBounds.x = frame.getX();
                        DefaultDockableBarManager.this._unmaximizedBounds.y = frame.getY();
                        DefaultDockableBarManager.this._unmaximizedBounds.width = frame.getWidth();
                        DefaultDockableBarManager.this._unmaximizedBounds.height = frame.getHeight();
                    }
                } else if (e.getComponent() instanceof Window) {
                    Window window = (Window)e.getComponent();
                    DefaultDockableBarManager.this._unmaximizedBounds.x = window.getX();
                    DefaultDockableBarManager.this._unmaximizedBounds.y = window.getY();
                    DefaultDockableBarManager.this._unmaximizedBounds.width = window.getWidth();
                    DefaultDockableBarManager.this._unmaximizedBounds.height = window.getHeight();
                }
            }
        };
        if (this.getRootPaneContainerAsComponent() != null) {
            this.getRootPaneContainerAsComponent().addComponentListener(this._componentListener);
        }
        this._windowListener = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent event) {
                if (DefaultDockableBarManager.this.isHideFloatingDockableBarsWhenDeactivate()) {
                    DefaultDockableBarManager.this.internalSetFloatingDockableBarsVisible(true);
                }
                if (DefaultDockableBarManager.this._lastFocusedWindow != null) {
                    DefaultDockableBarManager.this._lastFocusedWindow = null;
                }
            }

            @Override
            public void windowDeactivated(WindowEvent event) {
                if (!DefaultDockableBarManager.this.isOwnedWindow(event.getOppositeWindow()) && !DefaultDockableBarManager.this.isOwnedFloatingDockableBar(event.getOppositeWindow())) {
                    Component comp;
                    if (DefaultDockableBarManager.this._lastFocusedWindow == null && (comp = DefaultDockableBarManager.this.getRootPaneContainerAsComponent()) instanceof Window) {
                        DefaultDockableBarManager.this._lastFocusedWindow = (Window)comp;
                    }
                    if (DefaultDockableBarManager.this.isHideFloatingDockableBarsWhenDeactivate()) {
                        DefaultDockableBarManager.this.internalSetFloatingDockableBarsVisible(false);
                    }
                }
            }
        };
        if (rootContainer instanceof Window) {
            ((Window)((Object)rootContainer)).addWindowListener(this._windowListener);
        }
    }

    @Override
    public void setFloatingDockableBarsVisible(boolean show) {
        this._showFloatingDockableBars = show;
        this.internalSetFloatingDockableBarsVisible(show);
    }

    private void internalSetFloatingDockableBarsVisible(boolean show) {
        if (this._floatingDockableBars == null) {
            return;
        }
        for (FloatingDockableBarContainer floatingContainer : this._floatingDockableBars) {
            if (this._showFloatingDockableBars && show) {
                this.hackSetFrameVisible(floatingContainer, show);
                continue;
            }
            this.hackSetFrameVisible(floatingContainer, false);
        }
    }

    protected void hackSetFrameVisible(FloatingDockableBarContainer floatingContainer, boolean show) {
        try {
            int contX = floatingContainer.getLocationOnScreen().x;
            int contY = floatingContainer.getLocationOnScreen().y;
            if (show && !this.hackIsFrameVisible(floatingContainer)) {
                floatingContainer.setLocation(contX, contY + 10000);
            } else if (!show && this.hackIsFrameVisible(floatingContainer)) {
                floatingContainer.setLocation(contX, contY - 10000);
            }
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
    }

    protected boolean hackIsFrameVisible(FloatingDockableBarContainer floatingContainer) {
        int contY = floatingContainer.getLocationOnScreen().y;
        return contY >= -5000;
    }

    protected boolean isOwnedFloatingDockableBar(Window aWindow) {
        if (this._floatingDockableBars == null || this._floatingDockableBars.size() == 0 || aWindow == null) {
            return false;
        }
        return this._floatingDockableBars.contains(aWindow);
    }

    protected boolean isOwnedWindow(Window aWindow) {
        RootPaneContainer rootPaneContainer = this.getRootPaneContainer();
        return aWindow != null && rootPaneContainer instanceof Container && ((Container)((Object)rootPaneContainer)).isAncestorOf(aWindow);
    }

    private void addGlobalEventHandler() {
        try {
            this._keyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    DefaultDockableBarManager.this.handleKeyEvent(e);
                    return false;
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeGlobalEventHandler() {
        try {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this._keyEventDispatcher);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void addMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(DefaultDockableBarManager.this, 48L);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldAWTEventListenerBeUsed() {
        return SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"));
    }

    private void removeMouseEventHandler() {
        if (this.shouldAWTEventListenerBeUsed()) {
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(DefaultDockableBarManager.this);
                    return null;
                }
            });
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof MouseEvent) {
            if (event.getID() == 506) {
                MouseEvent e = (MouseEvent)event;
                if (this.isDragging()) {
                    Point screenPoint = e.getPoint();
                    Object source = e.getSource();
                    if (source instanceof Component) {
                        CommandBarBorderListener.convertPointToScreen(screenPoint, (Component)source, this._startInFloat);
                        this.dragDockableBar(null, screenPoint.x, screenPoint.y, e.getModifiersEx());
                        e.consume();
                    }
                }
            } else if (event.getID() == 502) {
                MouseEvent e = (MouseEvent)event;
                if (this.isDragging()) {
                    this.endDraggingDockableBar();
                    e.consume();
                }
                if (SystemInfo.isWindows() && this._globalContextMenu != null && this._globalContextMenu.isVisible() && !this._globalContextMenu.isAncestorOf((Component)e.getSource())) {
                    this._globalContextMenu.setVisible(false);
                    this._globalContextMenu = null;
                }
                this.triggerPopupMenu(e);
            } else if (event.getID() == 501) {
                this.triggerPopupMenu((MouseEvent)event);
            }
        }
    }

    private void triggerPopupMenu(MouseEvent e) {
        if (this.isShowContextMenu() && e.isPopupTrigger()) {
            Component component = null;
            Object source = e.getSource();
            if (source instanceof Component && (component = SwingUtilities.getDeepestComponentAt((Component)source, e.getX(), e.getY())) != null) {
                if (component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("DockableBarManager.suppressContextMenu"))) {
                    return;
                }
                if ((component = DockableBarUtils.getDockableBarOrContainer(component)) instanceof DockableBar) {
                    if (((DockableBar)component).getDockableBarManager() == this) {
                        this.showContextMenu(e, component);
                    }
                } else if (component instanceof DockableBarContainer && ((DockableBarContainer)component).getDockableBarManager() == this) {
                    this.showContextMenu(e, component);
                }
            }
        }
    }

    private void handleKeyEvent(AWTEvent event) {
        if (event instanceof KeyEvent) {
            if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27) {
                if (this.isDragging()) {
                    this.cancelDragging();
                }
            } else if (event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 17) {
                this.setAllowDraggingDockableBarDocking(false);
            } else if (event.getID() == 402 && ((KeyEvent)event).getKeyCode() == 17) {
                this.setAllowDraggingDockableBarDocking(true);
            }
        }
    }

    @Override
    public void resetToDefault() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalResetToDefault();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalResetToDefault();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalResetToDefault() {
        this.clearLayout();
        this._unmaximizedBounds = (Rectangle)this.getInitBounds().clone();
        this._state = this.getInitState();
        this._floatingDockableBars = new FloatingDockableBars();
        this._eastDockableBarContainer = this.createDockableBarContainer();
        this._eastDockableBarContainer.setSide(3);
        this._westDockableBarContainer = this.createDockableBarContainer();
        this._westDockableBarContainer.setSide(7);
        this._northDockableBarContainer = this.createDockableBarContainer();
        this._northDockableBarContainer.setSide(1);
        this._southDockableBarContainer = this.createDockableBarContainer();
        this._southDockableBarContainer.setSide(5);
        this.getContentContainer().add((Component)this._eastDockableBarContainer, "East");
        this.getContentContainer().add((Component)this._westDockableBarContainer, "West");
        this.getContentContainer().add((Component)this._southDockableBarContainer, "South");
        this.getContentContainer().add((Component)this._northDockableBarContainer, "North");
        ArrayList<DockableBar> westBars = new ArrayList<DockableBar>();
        ArrayList<DockableBar> eastBars = new ArrayList<DockableBar>();
        ArrayList<DockableBar> northBars = new ArrayList<DockableBar>();
        ArrayList<DockableBar> southBars = new ArrayList<DockableBar>();
        ArrayList<DockableBar> floatingBars = new ArrayList<DockableBar>();
        for (String key : this._allDockableBarKeys) {
            DockableBar dockableBar = this.getDockableBar(key);
            dockableBar.getContext().setInitPosition(true);
            int mode = dockableBar.getContext().getInitMode();
            dockableBar.getContext().setCurrentMode(mode < 0 ? 0 : mode);
            if (dockableBar.isHidden()) {
                this._hiddenDockableBars.add(dockableBar.getKey());
            }
            if (dockableBar.isVertDocked() || dockableBar.isHoriDocked()) {
                int dockSide = dockableBar.getContext().getInitSide();
                dockableBar.getContext().setCurrentDockSide(dockSide);
                switch (DockableBarUtils.convertDockSideToSide(dockSide)) {
                    case 3: {
                        eastBars.add(dockableBar);
                        break;
                    }
                    case 7: {
                        westBars.add(dockableBar);
                        break;
                    }
                    case 1: {
                        northBars.add(dockableBar);
                        break;
                    }
                    case 5: {
                        southBars.add(dockableBar);
                    }
                }
                continue;
            }
            if (!dockableBar.isFloating()) continue;
            floatingBars.add(dockableBar);
        }
        DockableBarListList eastListList = this.createDockableBarListList(eastBars, this._eastDockableBarContainer);
        DockableBarListList westListList = this.createDockableBarListList(westBars, this._westDockableBarContainer);
        DockableBarListList northListList = this.createDockableBarListList(northBars, this._northDockableBarContainer);
        DockableBarListList southListList = this.createDockableBarListList(southBars, this._southDockableBarContainer);
        this._eastDockableBarContainer.setDockableBarList(eastListList);
        this._westDockableBarContainer.setDockableBarList(westListList);
        this._northDockableBarContainer.setDockableBarList(northListList);
        this._southDockableBarContainer.setDockableBarList(southListList);
        this.createFloatedContainer(floatingBars);
        if (this._allContexts != null) {
            Set<String> col = this._allContexts.keySet();
            for (String name : col) {
                DockableBar dockableBar = this.getDockableBar(name);
                if (dockableBar == null) continue;
                dockableBar.setContext(this._allContexts.get(name));
            }
        }
        this.setRealized(true);
        this.setBoundsState();
        this.fireBarEvents();
    }

    private void createFloatedContainer(List<DockableBar> bars) {
        if (bars.size() == 0) {
            return;
        }
        for (DockableBar bar : bars) {
            this.floatDockableBar(bar, bar.getUndockedBounds());
        }
    }

    private List<Integer> sortByIndex(List<DockableBar> bars) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (DockableBar bar : bars) {
            Integer index = bar.getContext().getInitIndex();
            if (list.indexOf(index) != -1) continue;
            list.add(index);
        }
        Collections.sort(list);
        return list;
    }

    private DockableBarListList createDockableBarListList(List<DockableBar> bars, Container target) {
        DockableBarListList dockableBarListList = new DockableBarListList(target);
        List<Integer> list = this.sortByIndex(bars);
        for (Integer integer : list) {
            DockableBarList dockableBarList = new DockableBarList(dockableBarListList);
            for (DockableBar bar : bars) {
                if (integer.intValue() != bar.getContext().getInitIndex()) continue;
                dockableBarList.add(new DockableBarItem(bar, bar.getContext().getInitSubindex()));
            }
            dockableBarListList.add(dockableBarList);
        }
        return dockableBarListList;
    }

    @Override
    public void addDockableBar(final DockableBar bar) {
        if (bar == null) {
            return;
        }
        if (bar.getKey() == null || bar.getKey().trim().length() == 0) {
            throw new IllegalArgumentException("The DockableBar is null or it has a null or empty key. Please call setKey() method to set a non-empty string as the key before adding it to DockableBarManager.");
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalAddDockableBar(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalAddDockableBar(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalAddDockableBar(DockableBar bar) {
        if (this._allDockableBars.containsKey(bar.getKey())) {
            throw new IllegalArgumentException("The DockableBar exists with name \"" + bar.getKey() + "\". Please specify a new name for the dockable bar.");
        }
        this._allDockableBars.put(bar.getKey(), bar);
        this._allDockableBarKeys.add(bar.getKey());
        bar.addPropertyChangeListener(ATTRIBUTE_KEY, this._dockableBarPropertyChangeListener);
        bar.setDockableBarManager(this);
        DockableBarContext dockableBarContext = this.getDockableBarContextOf(bar.getKey());
        if (dockableBarContext == null) {
            this.addContext(bar.getKey(), bar.getContext());
            if (this.isRealized()) {
                if (bar.isHidden()) {
                    this._hiddenDockableBars.add(bar.getKey());
                } else {
                    this.loadClosePreviousState(bar);
                    this._hiddenDockableBars.remove(bar.getKey());
                }
            }
            bar.getContext().setInitPosition(true);
        } else {
            bar.setContext(dockableBarContext);
            if (this.isRealized() && !dockableBarContext.isHidden()) {
                this.loadClosePreviousState(bar);
                this._hiddenDockableBars.remove(bar.getKey());
            }
        }
    }

    @Override
    public void removeAllDockableBars() {
        List<String> list = this.getAllDockableBarNames();
        for (String key : list) {
            this.removeDockableBar(key);
        }
    }

    @Override
    public void removeExtraContexts() {
        if (this._allContexts != null) {
            String[] col;
            for (String key : col = this._allContexts.keySet().toArray(new String[this._allContexts.size()])) {
                DockableBar dockableBar = this.getDockableBar(key);
                if (dockableBar != null) continue;
                this.removeContext(key);
            }
        }
        if (this._hiddenDockableBars != null) {
            for (int i = this._hiddenDockableBars.size() - 1; i >= 0; --i) {
                String key = (String)this._hiddenDockableBars.get(i);
                DockableBar dockableBar = this.getDockableBar(key);
                if (dockableBar != null) continue;
                this._hiddenDockableBars.remove(key);
            }
        }
    }

    @Override
    public void removeDockableBar(String name) {
        this.removeDockableBar(name, false);
    }

    public void removeDockableBar(String key, final boolean keepPreviousState) {
        this.checkBarKey(key, "removeDockableBar");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.removeDockableBar(bar, keepPreviousState);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.removeDockableBar(bar, keepPreviousState);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void removeDockableBar(DockableBar bar, boolean keepPreviousState) {
        if (this._allDockableBars.containsKey(bar.getKey())) {
            int currentState = -1;
            if (keepPreviousState) {
                DockableBarUtils.saveClosePreviousState(bar);
                currentState = bar.getContext().getCurrentMode();
            }
            if (this.isRealized() && !bar.isHidden()) {
                this.doHideDockableBar(bar);
            }
            this._allDockableBars.remove(bar.getKey());
            this._allDockableBarKeys.remove(bar.getKey());
            if (this._hiddenDockableBars.contains(bar.getKey())) {
                this._hiddenDockableBars.remove(bar.getKey());
            }
            bar.removePropertyChangeListener(this._dockableBarPropertyChangeListener);
            if (!keepPreviousState) {
                this.removeContext(bar.getKey());
            } else {
                bar.getContext().setCurrentMode(currentState);
            }
            bar.fireDockableBarEvent(5000);
            bar.setDockableBarManager(null);
        }
    }

    void showDockableBar(DockableBar dockableBar) {
        if (dockableBar.getContext() == null || !dockableBar.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(dockableBar.getKey())) {
            this.addDockableBar(dockableBar);
        }
        if (!dockableBar.isVisible()) {
            dockableBar.setVisible(true);
        }
        if (!this._hiddenDockableBars.contains(dockableBar.getKey()) || !this.loadHiddenPreviousState(dockableBar)) {
            if (dockableBar.isFloating()) {
                this.floatDockableBar(dockableBar, dockableBar.getUndockedBounds());
            } else {
                this.dockDockableBar(dockableBar, DockableBarUtils.convertDockSideToSide(dockableBar.getContext().getInitSide()), dockableBar.getContext().getInitIndex(), false, dockableBar.getContext().getInitSubindex());
            }
        }
        this._hiddenDockableBars.remove(dockableBar.getKey());
    }

    @Override
    public void showDockableBar(String key) {
        this.checkBarKey(key, "removeDockableBar");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (!bar.isHidden()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.showDockableBar(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.showDockableBar(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    @Override
    public DockableBar getDockableBar(String key) {
        this.checkBarKey(key, "getDockableBar");
        return this._allDockableBars.get(key);
    }

    @Override
    public void hideDockableBar(String key) {
        this.checkBarKey(key, "hideDockableBar");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (!bar.isHidable() || !this.isHidable()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.hideDockableBar(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.hideDockableBar(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void hideDockableBar(DockableBar bar) {
        if (bar.getContext() == null || !bar.isAvailable()) {
            return;
        }
        if (bar.isHidden()) {
            return;
        }
        if (!this._allDockableBars.containsKey(bar.getKey())) {
            this.addDockableBar(bar);
        }
        this.doHideDockableBar(bar);
    }

    private void doHideDockableBar(DockableBar bar) {
        if (bar.isHidden()) {
            return;
        }
        DockableBarUtils.saveHiddenPreviousState(bar);
        try {
            Container topLevelAncestor;
            if (bar.getParent() != null && bar.getParent() instanceof DockableBarContainer) {
                bar.getParent().remove(bar);
            }
            bar.setHidden();
            bar.fireDockableBarEvent(5002);
            if (!this._hiddenDockableBars.contains(bar.getKey())) {
                this._hiddenDockableBars.add(bar.getKey());
            }
            if ((topLevelAncestor = bar.getTopLevelAncestor()) instanceof FloatingDockableBarContainer && this._floatingDockableBars != null) {
                this._floatingDockableBars.remove(topLevelAncestor);
                topLevelAncestor.setVisible(false);
                ((FloatingDockableBarContainer)topLevelAncestor).dispose();
            }
        }
        catch (PropertyVetoException e) {
            throw new RuntimeException(e);
        }
        this.doLayout();
    }

    @Override
    public void dockDockableBar(final DockableBar bar, final int side, final int row, final boolean createNewRow, final int start) {
        if (bar.getContext() != null && !bar.isAvailable()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalDockDockableBar(bar, side, row, createNewRow, start);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalDockDockableBar(bar, side, row, createNewRow, start);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalDockDockableBar(DockableBar bar, int side, int row, boolean createNewRow, int start) {
        if (side != 1 && side != 5 && side != 3 && side != 7) {
            throw new IllegalArgumentException("Invalid argument side. side must be one of following value, WEST, EAST, NORTH, or SOUTH: " + side);
        }
        if (start < 0) {
            throw new IllegalArgumentException("Argument start must be a positive integer.");
        }
        DockableBarContainer dbc = this.getDockableBarContainer(side);
        if (dbc != null) {
            dbc.addDockableBar(bar, row, createNewRow, start);
            bar.invalidate();
            bar.repaint();
        }
    }

    @Override
    public void floatDockableBar(final DockableBar bar, final Rectangle bounds) {
        if (bar.getContext() == null || !bar.isAvailable()) {
            return;
        }
        if (!bar.isFloatable() || !this.isFloatable()) {
            return;
        }
        bar.resetDockID();
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalFloatDockableBar(bar, bounds);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalFloatDockableBar(bar, bounds);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalFloatDockableBar(DockableBar bar, Rectangle bounds) {
        FloatingDockableBarContainer floatingCommandBar;
        if (!bar.isFloatable()) {
            return;
        }
        if (bounds == null) {
            Point p = new Point(0, 0);
            try {
                p = bar.getLocationOnScreen();
            }
            catch (IllegalComponentStateException e) {
                JideSwingUtilities.ignoreException(e);
            }
            bounds = new Rectangle(p.x + 10, p.y + 10, 0, 0);
        }
        if ((floatingCommandBar = this.createFloatingDockableBarContainer(SwingUtilities.getWindowAncestor(this.getRootPaneContainer().getRootPane()))) != null) {
            bar.setOrientation(0);
            try {
                bar.setFloating();
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
            Container oldParent = bar.getParent();
            if (oldParent != null) {
                oldParent.remove(bar);
            }
            floatingCommandBar.getContentPane().add((Component)bar, "Center");
            if (bounds.isEmpty()) {
                floatingCommandBar.setSize(bar.getPreferredSize());
            } else {
                floatingCommandBar.setSize(bounds.getSize());
            }
            floatingCommandBar.pack();
            bounds.x -= (int)((double)floatingCommandBar.getWidth() * this._relativeX);
            bounds.y -= (int)((double)floatingCommandBar.getHeight() * this._relativeY);
            Rectangle screenBounds = PortingUtils.getScreenBounds(floatingCommandBar);
            if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
                bounds.y = screenBounds.y + screenBounds.height - bounds.height;
            }
            if (bounds.y < screenBounds.y) {
                bounds.y = screenBounds.y;
            }
            floatingCommandBar.setLocation(bounds.x, bounds.y);
            floatingCommandBar.setVisible(true);
            if (this._isDragging) {
                this._currentFloatingCommandBar = floatingCommandBar;
            }
            if (this._floatingDockableBars == null) {
                this._floatingDockableBars = new FloatingDockableBars();
            }
            this._floatingDockableBars.add(floatingCommandBar);
        }
    }

    @Override
    public void beginDraggingDockableBar(JComponent f, int mouseX, int mouseY, double relativeX, double relativeY, boolean startInFloat) {
        if (!this.isRearrangable()) {
            return;
        }
        if (f instanceof DockableBar && !((DockableBar)f).isRearrangable()) {
            return;
        }
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(f);
        this._relativeX = relativeX;
        this._relativeY = relativeY;
        this._startInFloat = startInFloat;
        if (f.getTopLevelAncestor() instanceof FloatingDockableBarContainer) {
            this._currentFloatingCommandBar = (FloatingDockableBarContainer)f.getTopLevelAncestor();
        }
        if (this._rootPaneContainer != null && this.isUseGlassPaneEnabled()) {
            this._glassPaneVisibility = this.getRootPaneContainer().getGlassPane().isVisible();
            this.getRootPaneContainer().getGlassPane().setCursor(Cursor.getPredefinedCursor(13));
            this.getRootPaneContainer().getGlassPane().setVisible(true);
        }
        this._isDragging = true;
        this._draggingComponent = f;
        this.addGlobalEventHandler();
    }

    protected DockableBarsSnapshot createDockableBarsSnapshot(JComponent possiblyMoved) {
        int[] dbIndices;
        DockableBarsSnapshot snapshot = new DockableBarsSnapshot();
        snapshot._possiblyMoved = possiblyMoved;
        for (int j : dbIndices = new int[]{1, 5, 3, 7, 0}) {
            DockableBarState oneBar;
            DockableBarContainer barContainer = this.getDockableBarContainer(j);
            if (barContainer != null) {
                DockableBarListList rowList = barContainer.getDockableBarList();
                for (int rowIndex = 0; rowIndex < rowList.size(); ++rowIndex) {
                    DockableBarItem toolbarPaneItem;
                    List row = (List)rowList.get(rowIndex);
                    ArrayList<DockableBarItem> items = new ArrayList<DockableBarItem>();
                    for (Object item : row) {
                        toolbarPaneItem = (DockableBarItem)item;
                        items.add(toolbarPaneItem);
                    }
                    this.sortDockableBarRowItems(items);
                    int itemIndex = -1;
                    for (Object e : items) {
                        toolbarPaneItem = (DockableBarItem)e;
                        oneBar = new DockableBarState();
                        oneBar._rowOrCol = rowIndex;
                        oneBar._index = ++itemIndex;
                        oneBar._start = toolbarPaneItem.getStart();
                        oneBar._component = toolbarPaneItem.getComponent();
                        if (oneBar._component.isVisible()) {
                            oneBar._bounds = new Rectangle(oneBar._component.getLocationOnScreen(), oneBar._component.getSize());
                        }
                        oneBar._dockableContainerID = j;
                        if (j == 1) {
                            oneBar._orientation = 0;
                            snapshot._northBars.add(oneBar);
                            continue;
                        }
                        if (j == 5) {
                            oneBar._orientation = 0;
                            snapshot._southBars.add(oneBar);
                            continue;
                        }
                        if (j == 3) {
                            oneBar._orientation = 1;
                            snapshot._eastBars.add(oneBar);
                            continue;
                        }
                        oneBar._orientation = 1;
                        snapshot._westBars.add(oneBar);
                    }
                }
                continue;
            }
            if (this._floatingDockableBars == null) continue;
            for (FloatingDockableBarContainer container : this._floatingDockableBars) {
                if (container.getContentPane().getComponentCount() == 0) continue;
                oneBar = new DockableBarState();
                oneBar._rowOrCol = 0;
                oneBar._index = 0;
                oneBar._start = 0;
                oneBar._component = container.getContentPane().getComponent(0);
                if (oneBar._component.isVisible()) {
                    oneBar._bounds = new Rectangle(oneBar._component.getLocationOnScreen(), oneBar._component.getSize());
                }
                oneBar._dockableContainerID = j;
                oneBar._orientation = 0;
                snapshot._floatingBars.add(oneBar);
            }
        }
        return snapshot;
    }

    protected void sortDockableBarRowItems(List row) {
        Collections.sort(row, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof DockableBarItem && o2 instanceof DockableBarItem) {
                    int x2;
                    int x1 = ((DockableBarItem)o1).getStart();
                    if (x1 == (x2 = ((DockableBarItem)o2).getStart())) {
                        return 0;
                    }
                    if (x1 > x2) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    @Override
    public void pauseDragDockableBar() {
    }

    private boolean isDragging() {
        return this._isDragging;
    }

    public void cancelDragging() {
        this.removeGlobalEventHandler();
        if (SwingUtilities.isEventDispatchThread()) {
            this.internalCancelDragging();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.internalCancelDragging();
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void internalCancelDragging() {
        this._relativeX = 0.0;
        this._relativeY = 0.0;
        this._startInFloat = false;
        if (this.isUseGlassPaneEnabled() && this.getRootPaneContainer() != null) {
            this.getRootPaneContainer().getGlassPane().setVisible(this._glassPaneVisibility);
            this.getRootPaneContainer().getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        this._currentFloatingCommandBar = null;
        this._isDragging = false;
        this._isResizing = false;
        this._resizingPane = null;
        this._draggingComponent = null;
        this.removeGlobalEventHandler();
    }

    private void setAllowDraggingDockableBarDocking(boolean enable) {
    }

    @Override
    public void dragDockableBar(JComponent f, int newX, int newY, int mouseModifiers) {
        Rectangle bounds;
        Point position;
        if (!this.isDragging()) {
            return;
        }
        if (f == null) {
            f = this._draggingComponent;
        }
        DockableBarContainer pane = null;
        Point screenPoint = new Point(newX, newY);
        if (this._isResizing && this._resizingPane != null) {
            pane = this._resizingPane;
        } else {
            Container topLevelContainer = this.getContentContainer();
            if (topLevelContainer != null) {
                Container holder;
                Point contentPanePoint = new Point(screenPoint);
                CommandBarBorderListener.convertPointFromScreen(contentPanePoint, topLevelContainer, this._startInFloat);
                pane = (DockableBarContainer)DockableBarUtils.findNearbyDockableBarContainerAt(this, topLevelContainer, contentPanePoint, 22);
                if (pane != null && pane.getDockableBarManager() != this) {
                    pane = null;
                }
                if (pane == null && (holder = this.getContentContainer()) != null) {
                    Point holderPoint = new Point(screenPoint);
                    CommandBarBorderListener.convertPointFromScreen(holderPoint, holder, this._startInFloat);
                    int side = DockableBarUtils.sideOfComponent(holder, contentPanePoint.x, contentPanePoint.y);
                    switch (side) {
                        case 7: {
                            pane = this._westDockableBarContainer;
                            break;
                        }
                        case 1: {
                            pane = this._northDockableBarContainer;
                            break;
                        }
                        case 5: {
                            pane = this._southDockableBarContainer;
                            break;
                        }
                        case 3: {
                            pane = this._eastDockableBarContainer;
                        }
                    }
                    if (pane != null && !pane.isShowing()) {
                        pane = null;
                    }
                }
                if (pane != null) {
                    int paneSide = pane.getSide();
                    if ((((DockableBar)f).getAllowedDockSides() & DockableBarUtils.convertSideToDockSide(paneSide)) == 0) {
                        pane = null;
                    }
                }
                if (pane == null && !((DockableBar)f).isFloatable() && !((DockableBar)f).isFloating()) {
                    pane = (DockableBarContainer)f.getParent();
                }
            }
        }
        if (this._currentFloatingCommandBar == null && pane != null) {
            position = new Point(screenPoint);
            CommandBarBorderListener.convertPointFromScreen(position, pane, this._startInFloat);
            int x = position.x - (int)((double)f.getWidth() * this._relativeX);
            int y = position.y - (int)((double)f.getHeight() * this._relativeY);
            int currentRow = -1;
            if (!pane.equals(f.getParent())) {
                Container oldParent = f.getParent();
                oldParent.remove(f);
                if (f instanceof DockableBar) {
                    ((DockableBar)f).setOrientation(pane.getOrientation());
                    ((DockableBar)f).getContext().setCurrentDockSide(DockableBarUtils.convertSideToDockSide(pane.getSide()));
                    try {
                        if (pane.getOrientation() == 0) {
                            ((DockableBar)f).setHoriDocked();
                        } else {
                            ((DockableBar)f).setVertDocked();
                        }
                    }
                    catch (PropertyVetoException e) {
                        throw new RuntimeException(e);
                    }
                }
                pane.add(f);
            } else {
                currentRow = pane.getCurrentRowOf((DockableBar)f);
            }
            int row = pane.getRowAndGapIndexAt(position);
            if (((DockableBar)f).isStretch() && row > 0 && row / 2 > currentRow && row <= currentRow * 2 + 2) {
                row = currentRow * 2;
            }
            if (currentRow != -1 && row % 2 != 0 && row / 2 == currentRow) {
                int start = pane.getOrientation() == 0 ? (pane.getComponentOrientation().isLeftToRight() ? x : pane.getWidth() - position.x) : y;
                pane.getDockableBarList().changeComponentStart(f, start);
            } else {
                pane.getDockableBarList().changeComponentRow(f, row / 2, row % 2 == 0, pane.getOrientation() == 0 ? x : y);
            }
        } else if (this._currentFloatingCommandBar == null && pane == null) {
            if (f instanceof DockableBar) {
                int x = newX;
                int y = newY;
                bounds = ((DockableBar)f).getUndockedBounds();
                if (bounds != null) {
                    this.floatDockableBar((DockableBar)f, new Rectangle(x, y, bounds.width, bounds.height));
                } else {
                    this.floatDockableBar((DockableBar)f, new Rectangle(x, y, 0, 0));
                }
            }
        } else if (this._currentFloatingCommandBar != null && pane == null) {
            int x = newX - (int)((double)this._currentFloatingCommandBar.getWidth() * this._relativeX);
            int y = newY - (int)((double)this._currentFloatingCommandBar.getHeight() * this._relativeY);
            bounds = new Rectangle(x, y, this._currentFloatingCommandBar.getWidth(), this._currentFloatingCommandBar.getHeight());
            Rectangle screenBounds = PortingUtils.getScreenBounds(this._currentFloatingCommandBar);
            if (bounds.y + bounds.height > screenBounds.y + screenBounds.height) {
                bounds.y = screenBounds.y + screenBounds.height - bounds.height;
            }
            if (bounds.y < screenBounds.y) {
                bounds.y = screenBounds.y;
            }
            this._currentFloatingCommandBar.setLocation(bounds.x, bounds.y);
            if (f instanceof DockableBar) {
                ((DockableBar)f).setUndockedBounds(bounds);
            }
        } else if (this._currentFloatingCommandBar != null && pane != null) {
            this._currentFloatingCommandBar.setVisible(false);
            if (this._floatingDockableBars != null) {
                this._floatingDockableBars.remove(this._currentFloatingCommandBar);
            }
            this._currentFloatingCommandBar.dispose();
            this._currentFloatingCommandBar = null;
            if (f instanceof DockableBar) {
                ((DockableBar)f).getContext().setCurrentDockSide(DockableBarUtils.convertSideToDockSide(pane.getSide()));
                try {
                    if (pane.getOrientation() == 0) {
                        ((DockableBar)f).setHoriDocked();
                    } else {
                        ((DockableBar)f).setVertDocked();
                    }
                }
                catch (PropertyVetoException e) {
                    throw new RuntimeException(e);
                }
            }
            position = new Point(screenPoint);
            CommandBarBorderListener.convertPointFromScreen(position, pane, this._startInFloat);
            int row = pane.getRowAndGapIndexAt(position);
            if (f instanceof DockableBar) {
                ((DockableBar)f).setOrientation(pane.getOrientation());
            }
            pane.add(f);
            int start = pane.getOrientation() == 0 ? position.x - (int)((double)f.getWidth() * this._relativeX) : position.y - (int)((double)f.getHeight() * this._relativeY);
            pane.getDockableBarList().changeComponentRow(f, row / 2, row % 2 == 0, start);
        }
    }

    @Override
    public void endDraggingDockableBar() {
        this.internalCancelDragging();
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    protected void checkForRearrangedDockableBars() {
        DockableBarStateTransition stateTransition;
        DockableBarState postBar;
        boolean rearranged = false;
        DockableBarsRearrangedEvent event = null;
        ArrayList[] preBars = new ArrayList[]{this._preDragSnapshot._northBars, this._preDragSnapshot._southBars, this._preDragSnapshot._eastBars, this._preDragSnapshot._westBars, this._preDragSnapshot._floatingBars};
        ArrayList[] postBars = new ArrayList[]{this._postDragSnapshot._northBars, this._postDragSnapshot._southBars, this._postDragSnapshot._eastBars, this._postDragSnapshot._westBars, this._postDragSnapshot._floatingBars};
        for (int i = 0; i < preBars.length; ++i) {
            Iterator preBarIter = preBars[i].iterator();
            Iterator postBarIter = postBars[i].iterator();
            while (preBarIter.hasNext()) {
                DockableBarState preBar = (DockableBarState)preBarIter.next();
                DockableBarState dockableBarState = postBar = postBarIter.hasNext() ? (DockableBarState)postBarIter.next() : null;
                if (!rearranged && postBar != null && preBar._component == postBar._component && preBar._dockableContainerID == postBar._dockableContainerID && preBar._mode == postBar._mode && preBar._orientation == postBar._orientation && preBar._rowOrCol == postBar._rowOrCol && preBar._index == postBar._index && preBar._bounds.equals(postBar._bounds) && preBar._start == postBar._start) continue;
                rearranged = true;
                if (event == null) {
                    event = new DockableBarsRearrangedEvent(this._preDragSnapshot._possiblyMoved, 0);
                }
                stateTransition = this.getTransition(preBar);
                if (preBar._component == this._preDragSnapshot._possiblyMoved) {
                    event.setStateTransition(stateTransition);
                    continue;
                }
                event.addOtherRearrangedBar(stateTransition);
            }
        }
        boolean foundNewBar = false;
        for (int i = 0; i < postBars.length && !foundNewBar; ++i) {
            Iterator iterator = postBars[i].iterator();
            while (iterator.hasNext() && !foundNewBar) {
                postBar = (DockableBarState)iterator.next();
                DockableBarState preBarData = this.findComponentInSnapshot(postBar._component, this._preDragSnapshot);
                if (preBarData != null) continue;
                stateTransition = new DockableBarStateTransition();
                stateTransition.setComponent(postBar._component);
                stateTransition.setPostState(postBar);
                DockableBarState newPreBarData = new DockableBarState();
                newPreBarData._component = postBar._component;
                newPreBarData._mode = 1;
                stateTransition.setPreState(newPreBarData);
                stateTransition.setTransitionID(5102);
                rearranged = true;
                if (event == null) {
                    event = new DockableBarsRearrangedEvent(this._preDragSnapshot._possiblyMoved, 0);
                }
                event.setStateTransition(stateTransition);
                foundNewBar = true;
            }
        }
        if (event != null) {
            this.fireDockableBarsRearranged(event);
            event.clear();
        }
    }

    @Override
    public void addDockableBarsRearrangedListener(DockableBarsRearrangedListener l) {
        this.listenerList.add(DockableBarsRearrangedListener.class, l);
    }

    @Override
    public void removeDockableBarsRearrangedListener(DockableBarsRearrangedListener l) {
        this.listenerList.remove(DockableBarsRearrangedListener.class, l);
    }

    @Override
    public DockableBarsRearrangedListener[] getDockableBarsRearrangedListeners() {
        return (DockableBarsRearrangedListener[])this.listenerList.getListeners(DockableBarsRearrangedListener.class);
    }

    protected void fireDockableBarsRearranged(DockableBarsRearrangedEvent event) {
        if (event == null) {
            return;
        }
        int id = event.getID();
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            String key = event.getComponent() != null && event.getComponent() instanceof DockableBar ? " \"" + ((DockableBar)event.getComponent()).getKey() + "\"" : "";
            switch (id) {
                case 5099: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is added");
                    break;
                }
                case 5100: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is removed");
                    break;
                }
                case 5101: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is floated");
                    break;
                }
                case 5102: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is docked");
                    break;
                }
                case 5103: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is hidden");
                    break;
                }
                case 5104: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is moved to another container");
                    break;
                }
                case 5105: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is moved to another row or column");
                    break;
                }
                case 5106: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is moved within its row or column");
                    break;
                }
                case 5107: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is resized");
                    break;
                }
                case 5108: {
                    LOGGER_EVENT.fine("Dock rearranged, DockableBar" + key + " is moved");
                    break;
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DockableBarsRearrangedListener.class) continue;
            ((DockableBarsRearrangedListener)listeners[i + 1]).dockableBarsRearranged(event);
        }
    }

    protected DockableBarState findComponentInSnapshot(Component component, DockableBarsSnapshot snapshot) {
        ArrayList[] snapshotBars;
        if (component == null || snapshot == null) {
            return null;
        }
        for (ArrayList snapshotBar : snapshotBars = new ArrayList[]{snapshot._northBars, snapshot._southBars, snapshot._eastBars, snapshot._westBars, snapshot._floatingBars}) {
            for (Object aSnapshotBar : snapshotBar) {
                DockableBarState candidate = (DockableBarState)aSnapshotBar;
                if (candidate._component != component) continue;
                return candidate;
            }
        }
        return null;
    }

    protected DockableBarStateTransition getTransition(DockableBarState preState) {
        if (preState == null) {
            throw new IllegalArgumentException("arguments may not be null");
        }
        DockableBarStateTransition stateTransition = new DockableBarStateTransition();
        DockableBarState newBarData = this.findComponentInSnapshot(preState._component, this._postDragSnapshot);
        DockableBarState oldBarData = this.findComponentInSnapshot(preState._component, this._preDragSnapshot);
        int transitionId = -1;
        if (this._preDragSnapshot._floatingBars.contains(oldBarData) == this._postDragSnapshot._floatingBars.contains(newBarData)) {
            if (newBarData._dockableContainerID != preState._dockableContainerID) {
                transitionId = 5104;
            } else if (newBarData._rowOrCol != preState._rowOrCol) {
                transitionId = 5105;
            } else if (newBarData._index != preState._index) {
                transitionId = 5106;
            } else if (newBarData._start != preState._start) {
                transitionId = 5108;
            } else if (!newBarData._bounds.getLocation().equals(preState._bounds.getLocation())) {
                transitionId = 5108;
            } else if (!newBarData._bounds.getSize().equals(preState._bounds.getSize())) {
                transitionId = 5107;
            }
        } else {
            newBarData = new DockableBarState();
            newBarData._component = preState._component;
            if (preState._component instanceof DockableBar) {
                DockableBar bar = (DockableBar)preState._component;
                newBarData._orientation = bar.getOrientation();
                if (this.getAllDockableBars().contains(bar)) {
                    if (bar.isFloating()) {
                        transitionId = 5101;
                        newBarData._mode = 1;
                    } else if (bar.isHidden()) {
                        transitionId = 5103;
                        newBarData._mode = 0;
                    } else if (bar.isVertDocked()) {
                        transitionId = 5102;
                        newBarData._mode = 3;
                    } else if (bar.isHoriDocked()) {
                        transitionId = 5102;
                        newBarData._mode = 2;
                    } else {
                        transitionId = 5100;
                    }
                } else {
                    transitionId = 5100;
                }
            } else {
                transitionId = 5100;
            }
        }
        stateTransition.setComponent(preState._component);
        stateTransition.setTransitionID(transitionId);
        stateTransition.setPreState(preState);
        stateTransition.setPostState(newBarData);
        return stateTransition;
    }

    @Override
    public void beginResizingDockableBar(JComponent f, int direction) {
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(f);
    }

    @Override
    public void resizingDockableBar(JComponent f, int newX, int newY, int newWidth, int newHeight, int deltaX, int deltaY) {
        Container container;
        if (f instanceof CommandBar) {
            ((CommandBar)f).purposeBounds(newX, newY, newWidth, newHeight, deltaX, this._saveDeltaX, deltaY, this._saveDeltaY);
        }
        if ((container = f.getTopLevelAncestor()) instanceof Window) {
            Window floatingCommandBar = (Window)container;
            Rectangle rect = floatingCommandBar.getBounds();
            if (rect.width != f.getWidth() || rect.height != f.getHeight()) {
                this._saveDeltaX = deltaX;
                this._saveDeltaY = deltaY;
                ((DockableBar)f).setUndockedBounds(new Rectangle(rect.x + newX, rect.y + newY, f.getWidth(), f.getHeight()));
                floatingCommandBar.setBounds(((DockableBar)f).getUndockedBounds());
                floatingCommandBar.validate();
            }
        }
    }

    @Override
    public void endResizingDockableBar(JComponent f) {
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    void removeExtraFloatingDockableBars() {
        if (this._floatingDockableBars != null) {
            for (int i = 0; i < this._floatingDockableBars.size(); ++i) {
                FloatingDockableBarContainer floatingDockableBarContainer = (FloatingDockableBarContainer)this._floatingDockableBars.get(i);
                if (floatingDockableBarContainer.isVisible()) continue;
                this._floatingDockableBars.remove(floatingDockableBarContainer);
                --i;
            }
        }
    }

    private boolean loadHiddenPreviousState(DockableBar dockableBar) {
        PreviousState state = dockableBar.getContext().getHiddenPreviousState();
        if (state != null) {
            this.restorePreviousState(dockableBar, state);
            return true;
        }
        return false;
    }

    private boolean loadClosePreviousState(DockableBar dockableBar) {
        PreviousState state = dockableBar.getContext().getClosePreviousState();
        if (state != null) {
            this.restorePreviousState(dockableBar, state);
            return true;
        }
        if (dockableBar.getContext().getInitMode() == 1) {
            Point p = dockableBar.getLocationOnScreen();
            this.floatDockableBar(dockableBar, new Rectangle(p.x + 10, p.y + 10, 0, 0));
        } else {
            this.dockDockableBar(dockableBar, DockableBarUtils.convertDockSideToSide(dockableBar.getContext().getInitSide()), dockableBar.getContext().getInitIndex(), false, 0);
        }
        return true;
    }

    private boolean loadDockPreviousState(DockableBar dockableBar) {
        PreviousState state = dockableBar.getContext().getDockPreviousState();
        if (state != null) {
            this.restorePreviousState(dockableBar, state);
            return true;
        }
        this.dockDockableBar(dockableBar, 1, Integer.MAX_VALUE, true, 0);
        return true;
    }

    private boolean loadFloatPreviousState(DockableBar dockableBar) {
        PreviousState state = dockableBar.getContext().getFloatPreviousState();
        if (state != null) {
            this.restorePreviousState(dockableBar, state);
            return true;
        }
        Point p = dockableBar.getLocationOnScreen();
        this.floatDockableBar(dockableBar, new Rectangle(p.x + 10, p.y + 10, 0, 0));
        return true;
    }

    private void restorePreviousState(DockableBar dockableBar, PreviousState state) {
        if (state.mode == 1) {
            if (dockableBar.isFloatable() && this.isFloatable()) {
                this.floatDockableBar(dockableBar, state.rcBounds);
            } else {
                this.loadDockPreviousState(dockableBar);
                this.doLayout();
            }
        } else if (state.mode == 2 || state.mode == 3) {
            int side = state.side;
            if (state.side != 1 && state.side != 7 && state.side != 3 && state.side != 5) {
                side = 1;
            }
            this.dockDockableBar(dockableBar, side, state.row, state.newRow, state.start);
        }
    }

    @Override
    public RootPaneContainer getRootPaneContainer() {
        Container topLevelAncestor;
        if (this._rootPaneContainer == null && this.getContentContainer() instanceof JComponent && (topLevelAncestor = ((JComponent)this.getContentContainer()).getTopLevelAncestor()) instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)topLevelAncestor);
        }
        return this._rootPaneContainer;
    }

    private Component getRootPaneContainerAsComponent() {
        return (Component)((Object)this._rootPaneContainer);
    }

    @Override
    public MainContainer getMainContainer() {
        return this._mainContainer;
    }

    @Override
    public boolean isLoadDataSuccessful() {
        return this._loadDataSuccessful;
    }

    @Override
    public void beginLoadLayoutData() {
        this.setRealized(false);
    }

    void clearLayout() {
        Collection<DockableBar> collection = this._allDockableBars.values();
        for (DockableBar bar : collection) {
            if (bar.getParent() == null) continue;
            bar.getParent().remove(bar);
        }
        if (this.getContentContainer() != null) {
            if (this._eastDockableBarContainer != null) {
                this.getContentContainer().remove(this._eastDockableBarContainer);
            }
            if (this._westDockableBarContainer != null) {
                this.getContentContainer().remove(this._westDockableBarContainer);
            }
            if (this._northDockableBarContainer != null) {
                this.getContentContainer().remove(this._northDockableBarContainer);
            }
            if (this._southDockableBarContainer != null) {
                this.getContentContainer().remove(this._southDockableBarContainer);
            }
        }
        if (this._floatingDockableBars != null) {
            for (FloatingDockableBarContainer floatingContainer : this._floatingDockableBars) {
                floatingContainer.removeAll();
                floatingContainer.setVisible(false);
                floatingContainer.dispose();
            }
            this._floatingDockableBars.clear();
        }
        this._hiddenDockableBars.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final Document document) {
        this._loadDataSuccessful = false;
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = DockableBarPersistenceUtils.internalLoad(this, document, this.getLoadCallback());
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockableBarManager.this._loadDataSuccessful = DockableBarPersistenceUtils.internalLoad(DefaultDockableBarManager.this, document, DefaultDockableBarManager.this.getLoadCallback());
                        }
                    });
                }
                catch (InterruptedException e) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                }
                catch (InvocationTargetException e) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
        return this._loadDataSuccessful;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadLayoutFrom(final InputStream in) {
        this._loadDataSuccessful = false;
        boolean previousLoadingData = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this._loadDataSuccessful = this.internalLoadLayoutDataDockableBar(in);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            DefaultDockableBarManager.this._loadDataSuccessful = DefaultDockableBarManager.this.internalLoadLayoutDataDockableBar(in);
                        }
                    });
                }
                catch (InterruptedException e) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                }
                catch (InvocationTargetException e) {
                    this._loadDataSuccessful = false;
                    this.resetToDefault();
                    JideSwingUtilities.throwInvocationTargetException(e);
                }
            }
        }
        finally {
            this._loadingLayoutData = previousLoadingData;
        }
        return this._loadDataSuccessful;
    }

    private boolean internalLoadLayoutDataDockableBar(InputStream inputStream) {
        boolean internalLoadDataSuccessful = false;
        if (inputStream == null) {
            this.resetToDefault();
            return internalLoadDataSuccessful;
        }
        InputStream in = inputStream;
        if (this.isNeedFormatCheck()) {
            byte[] buffer;
            try {
                buffer = PersistenceUtils.bufferStreamToArray(inputStream);
            }
            catch (IOException e) {
                this.resetToDefault();
                return internalLoadDataSuccessful;
            }
            in = new ByteArrayInputStream(buffer);
            if (PersistenceUtils.isXmlFormat(buffer)) {
                try {
                    DockableBarPersistenceUtils.load(this, in, this.getLoadCallback());
                }
                catch (ParserConfigurationException e) {
                    this.resetToDefault();
                    return false;
                }
                catch (SAXException e) {
                    this.resetToDefault();
                    return false;
                }
                catch (IOException e) {
                    this.resetToDefault();
                    return false;
                }
                return true;
            }
        }
        try {
            this.clearLayout();
            DataInputStream stream = new DataInputStream(in);
            short version = SaveUtils.readVersion(stream);
            if (!this.isVersionCompatible(version)) {
                throw new IOException("Layout data version number changed. Ignore previous layout data");
            }
            Rectangle rectangle = SaveUtils.readRectangle(stream);
            if (this.isUseFrameBounds()) {
                this._unmaximizedBounds = rectangle;
            }
            this._state = SaveUtils.readInt(stream);
            SaveUtils.readContext(stream, this._allContexts);
            if (this._allContexts != null) {
                String[] col;
                Set<String> stringSet = this._allContexts.keySet();
                for (String key : col = stringSet.toArray(new String[stringSet.size()])) {
                    DockableBarFactory factory;
                    DockableBar dockableBar = this.getDockableBar(key);
                    if (dockableBar == null && (factory = this.getDockableBarFactory()) != null) {
                        dockableBar = factory.create(key);
                        this.addDockableBar(dockableBar);
                    }
                    if (dockableBar != null) {
                        dockableBar.setContext(this._allContexts.get(key));
                    }
                    this._hiddenDockableBars.add(key);
                }
            }
            this._eastDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, stream);
            this._southDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, stream);
            this._westDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, stream);
            this._northDockableBarContainer = (DockableBarContainer)SaveUtils.readComponent(this, stream);
            if (this._eastDockableBarContainer == null || this._westDockableBarContainer == null || this._northDockableBarContainer == null || this._southDockableBarContainer == null) {
                throw new IOException("Layout Data is corrupted. Layout will be reset.");
            }
            this.getContentContainer().add((Component)this._eastDockableBarContainer, "East");
            this.getContentContainer().add((Component)this._southDockableBarContainer, "South");
            this.getContentContainer().add((Component)this._westDockableBarContainer, "West");
            this.getContentContainer().add((Component)this._northDockableBarContainer, "North");
            this._floatingDockableBars = SaveUtils.readFloatingDockableBars(this, stream);
            for (FloatingDockableBarContainer floatingContainer : this._floatingDockableBars) {
                floatingContainer.setVisible(true);
            }
            for (int i = this._hiddenDockableBars.size() - 1; i >= 0; --i) {
                String name = (String)this._hiddenDockableBars.get(i);
                DockableBar bar = this.getDockableBar(name);
                if (bar == null || bar.isHidden()) continue;
                this.showDockableBar(bar);
            }
            this.setRealized(true);
            this.fireBarEvents();
            this.setBoundsState();
            internalLoadDataSuccessful = true;
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Error loading layout - " + e.getLocalizedMessage());
            }
            this.resetToDefault();
        }
        return internalLoadDataSuccessful;
    }

    void fireBarEvents() {
        List<String> names = this.getAllDockableBarNames();
        for (String key : names) {
            DockableBar bar = this.getDockableBar(key);
            this.fireBarEvent(bar);
        }
    }

    private void fireBarEvent(DockableBar bar) {
        if (bar != null) {
            if (!bar.isHidden()) {
                if (bar.isHoriDocked()) {
                    bar.fireDockableBarEvent(5001);
                } else if (bar.isVertDocked()) {
                    bar.fireDockableBarEvent(5001);
                } else if (bar.isFloating()) {
                    bar.fireDockableBarEvent(5001);
                }
            } else {
                bar.fireDockableBarEvent(5002);
            }
        }
    }

    void setBoundsState() {
        if (this._useFrameBounds) {
            boolean wasVisible;
            Component rootPaneContainerAsComponent = this.getRootPaneContainerAsComponent();
            this._unmaximizedBounds = PortingUtils.ensureVisible(rootPaneContainerAsComponent, this._unmaximizedBounds);
            if (rootPaneContainerAsComponent != null && this.shouldUseFrameBounds(wasVisible = rootPaneContainerAsComponent.isVisible())) {
                rootPaneContainerAsComponent.setBounds(this._unmaximizedBounds);
            }
        }
        if (this.isShowInitial()) {
            this.showInitial();
        }
    }

    @Override
    public void setShowInitial(boolean value) {
        this._showInitial = value;
    }

    @Override
    public boolean isShowInitial() {
        return this._showInitial;
    }

    @Override
    public void showInitial() {
        boolean wasVisible = false;
        Component rootPaneContainerAsComponent = this.getRootPaneContainerAsComponent();
        if (rootPaneContainerAsComponent != null) {
            wasVisible = rootPaneContainerAsComponent.isVisible();
        }
        if (this.shouldUseFrameBounds(wasVisible) && !SystemInfo.isJdk142Above() && rootPaneContainerAsComponent != null) {
            rootPaneContainerAsComponent.setVisible(true);
        }
        if (this.shouldUseFrameState(wasVisible) && rootPaneContainerAsComponent instanceof Frame) {
            PortingUtils.setFrameState((Frame)rootPaneContainerAsComponent, this._state);
        }
        if (this.shouldUseFrameBounds(wasVisible) && SystemInfo.isJdk142Above() && rootPaneContainerAsComponent != null) {
            rootPaneContainerAsComponent.setVisible(true);
        }
    }

    void saveCurrentContext() {
        for (String key : this._allDockableBarKeys) {
            DockableBar bar = this.getDockableBar(key);
            boolean available = bar.isAvailable();
            if (!available) {
                this.setDockableBarAvailable(bar);
            }
            bar.getContext().setClosePreviousState(PreviousState.createPreviousState(bar));
            if (!this.isPreserveAvailableProperty() || available) continue;
            this.setDockableBarUnavailable(bar);
        }
    }

    @Override
    public void saveLayoutTo(Document document) throws ParserConfigurationException {
        DockableBarPersistenceUtils.saveToDocument(this, document, this.getSaveCallback());
    }

    @Override
    public void saveLayoutTo(OutputStream out) throws IOException {
        if (this._loadingLayoutData) {
            return;
        }
        if (this.isXmlFormat()) {
            try {
                DockableBarPersistenceUtils.save(this, out);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return;
        }
        this.removeExtraFloatingDockableBars();
        this.saveCurrentContext();
        DataOutputStream stream = new DataOutputStream(out);
        SaveUtils.writeVersion(stream, this._version);
        SaveUtils.writeRectangle(stream, this._unmaximizedBounds);
        if (this.getRootPaneContainerAsComponent() instanceof Frame) {
            SaveUtils.writeInt(stream, PortingUtils.getFrameState((Frame)this.getRootPaneContainerAsComponent()));
        } else {
            SaveUtils.writeInt(stream, 0);
        }
        SaveUtils.writeContext(stream, this._allContexts);
        SaveUtils.writeComponent(stream, this.getDockableBarContainer(3));
        SaveUtils.writeComponent(stream, this.getDockableBarContainer(5));
        SaveUtils.writeComponent(stream, this.getDockableBarContainer(7));
        SaveUtils.writeComponent(stream, this.getDockableBarContainer(1));
        SaveUtils.writeFloatingDockableBars(stream, this._floatingDockableBars);
    }

    Container getContentContainer() {
        return this._contentContainer;
    }

    private void doLayout() {
        this.getContentContainer().validate();
        this.getMainContainer().validate();
        this.getContentContainer().repaint();
        this.setRealized(true);
    }

    @Override
    public void toggleState(String key) {
        this.checkBarKey(key, "toggleState");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (!bar.isHidden()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.toggleState(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.toggleState(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    @Override
    public void toggleState(DockableBar bar) {
        if (!bar.isAvailable()) {
            return;
        }
        if (!(bar.isRearrangable() && bar.isFloatable() && this.isRearrangable() && this.isFloatable())) {
            return;
        }
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
        this._preDragSnapshot = this.createDockableBarsSnapshot(bar);
        if (bar.isFloating()) {
            PreviousState state = PreviousState.createPreviousState(bar);
            PreviousState.disposePreviousState(bar.getContext().getFloatPreviousState());
            bar.getContext().setFloatPreviousState(state);
            this.loadDockPreviousState(bar);
        } else {
            PreviousState state = PreviousState.createPreviousState(bar);
            PreviousState.disposePreviousState(bar.getContext().getDockPreviousState());
            bar.getContext().setDockPreviousState(state);
            this.loadFloatPreviousState(bar);
        }
        if (this._preDragSnapshot._possiblyMoved == null) {
            return;
        }
        this._postDragSnapshot = this.createDockableBarsSnapshot(null);
        this.checkForRearrangedDockableBars();
        this._preDragSnapshot.clear();
        this._postDragSnapshot.clear();
    }

    @Override
    public void removeFromHiddenDockableBars(String key) {
        this._hiddenDockableBars.remove(key);
    }

    @Override
    public boolean isRearrangable() {
        return this._rearrangeable && !this.shouldAWTEventListenerBeUsed();
    }

    @Override
    public void setRearrangable(boolean rearrangeable) {
        boolean old = this._rearrangeable;
        if (old != rearrangeable) {
            this._rearrangeable = rearrangeable;
            List<String> list = this.getAllDockableBarNames();
            for (String key : list) {
                DockableBar bar = this.getDockableBar(key);
                if (bar == null) continue;
                bar.firePropertyChange(PROPERTY_REARRANGABLE, old, rearrangeable);
            }
            this.firePropertyChange(PROPERTY_REARRANGABLE, old, rearrangeable);
        }
    }

    @Override
    public boolean isFloatable() {
        return this._floatable;
    }

    @Override
    public void setFloatable(boolean floatable) {
        boolean old = this._floatable;
        if (old != floatable) {
            this._floatable = floatable;
            List<String> list = this.getAllDockableBarNames();
            for (String o : list) {
                String name = o;
                DockableBar bar = this.getDockableBar(name);
                if (bar == null) continue;
                bar.firePropertyChange(PROPERTY_FLOATABLE, old, floatable);
            }
            this.firePropertyChange(PROPERTY_FLOATABLE, old, floatable);
        }
    }

    @Override
    public boolean isHidable() {
        return this._hidable;
    }

    @Override
    public void setHidable(boolean hidable) {
        boolean old = this._hidable;
        if (old != hidable) {
            this._hidable = hidable;
            List<String> list = this.getAllDockableBarNames();
            for (String o : list) {
                String name = o;
                DockableBar bar = this.getDockableBar(name);
                if (bar == null) continue;
                bar.firePropertyChange(PROPERTY_HIDABLE, old, hidable);
            }
            this.firePropertyChange(PROPERTY_HIDABLE, old, hidable);
        }
    }

    @Override
    public void updateComponentTreeUI() {
        if (this.getRootPaneContainerAsComponent() != null) {
            SwingUtilities.updateComponentTreeUI(this.getRootPaneContainerAsComponent());
        }
        if (this._floatingDockableBars != null) {
            for (FloatingDockableBarContainer container : this._floatingDockableBars) {
                SwingUtilities.updateComponentTreeUI(container);
            }
        }
        List<String> list = this.getAllDockableBarNames();
        for (String o : list) {
            String s = o;
            DockableBar bar = this.getDockableBar(s);
            if (bar == null || !bar.isHidden()) continue;
            SwingUtilities.updateComponentTreeUI(bar);
        }
        this.getContentContainer().invalidate();
        this.getContentContainer().doLayout();
    }

    @Override
    public Collection<DockableBar> getAllDockableBars() {
        return this._allDockableBars.values();
    }

    @Override
    public List<String> getAllDockableBarNames() {
        return new ArrayList<String>(this._allDockableBarKeys);
    }

    @Override
    public Rectangle getInitBounds() {
        if (this._initBounds.isEmpty()) {
            Dimension size = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
            if (size.width <= 1024) {
                this._initBounds.setBounds(0, 0, size.width, size.height);
            } else {
                this._initBounds.setBounds(0, 0, 1024, 768);
            }
        }
        return this._initBounds;
    }

    @Override
    public void setInitBounds(Rectangle initBounds) {
        if (initBounds == null) {
            throw new IllegalArgumentException("InitBounds value cannot be null.");
        }
        Rectangle old = this._initBounds;
        if (!initBounds.equals(old)) {
            this._initBounds = initBounds;
            this.firePropertyChange(PROPERTY_INIT_BOUNDS, old, initBounds);
        }
    }

    private void addContext(String key, DockableBarContext dockableBarContext) {
        this._allContexts.put(key, dockableBarContext);
    }

    private void removeContext(String key) {
        this._allContexts.remove(key);
    }

    @Override
    public int getInitState() {
        Dimension size = PortingUtils.getScreenSize(this.getRootPaneContainerAsComponent());
        Rectangle bounds = this.getInitBounds();
        if (bounds.width > size.width || bounds.height > size.height) {
            return 6;
        }
        return this._initState;
    }

    @Override
    public void setInitState(int initState) {
        int old = this._initState;
        if (old != initState) {
            this._initState = initState;
            this.firePropertyChange(PROPERTY_INIT_STATE, old, initState);
        }
    }

    @Override
    public DockableBarContext getDockableBarContextOf(String key) {
        DockableBarContext dockContext = this._allContexts.get(key);
        if (dockContext != null) {
            return dockContext;
        }
        return null;
    }

    @Override
    public DockableBarPopupMenuCustomizer getDockableBarPopupMenuCustomizer() {
        return this._dockableBarPopupMenuCustomizer;
    }

    @Override
    public void setDockableBarPopupMenuCustomizer(DockableBarPopupMenuCustomizer customizerDockableBar) {
        this._dockableBarPopupMenuCustomizer = customizerDockableBar;
    }

    @Override
    public void dispose() {
        this.removeAllDockableBars();
        this.removeMouseEventHandler();
        this._keyEventDispatcher = null;
        if (this._allContexts != null) {
            this._allContexts.clear();
        }
        if (this.getRootPaneContainerAsComponent() != null) {
            this.getRootPaneContainerAsComponent().removeComponentListener(this._componentListener);
        }
        this._componentListener = null;
        this._eastDockableBarContainer = null;
        this._westDockableBarContainer = null;
        this._northDockableBarContainer = null;
        this._southDockableBarContainer = null;
        this._currentFloatingCommandBar = null;
        if (this._floatingDockableBars != null) {
            this._floatingDockableBars.clear();
            this._floatingDockableBars = null;
        }
        if (this._hiddenDockableBars != null) {
            this._hiddenDockableBars.clear();
        }
        this._contentContainer = null;
        this._dockableBarPopupMenuCustomizer = null;
        this._mainContainer = null;
        if (this._rootPaneContainer instanceof Window) {
            ((Window)((Object)this._rootPaneContainer)).removeWindowListener(this._windowListener);
        }
        this._rootPaneContainer = null;
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this._keyEventPostProcessor);
    }

    @Override
    public boolean isHideFloatingDockableBarsWhenDeactivate() {
        return this._hideFloatingDockableBarsWhenDeactivate;
    }

    @Override
    public void setHideFloatingDockableBarsWhenDeactivate(boolean hideFloatingDockableBarsWhenDeactivate) {
        boolean old = this._hideFloatingDockableBarsWhenDeactivate;
        if (old != hideFloatingDockableBarsWhenDeactivate) {
            this._hideFloatingDockableBarsWhenDeactivate = hideFloatingDockableBarsWhenDeactivate;
            this.firePropertyChange(PROPERTY_HIDE_FLOATING_DOCKABLE_BARS_WHEN_DEACTIVATE, old, hideFloatingDockableBarsWhenDeactivate);
        }
    }

    @Override
    public DockableBarContainer getDockableBarContainer(int side) {
        switch (side) {
            case 7: {
                return this._westDockableBarContainer;
            }
            case 3: {
                return this._eastDockableBarContainer;
            }
            case 1: {
                return this._northDockableBarContainer;
            }
            case 5: {
                return this._southDockableBarContainer;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    @Override
    public DockableBarContainer createDockableBarContainer() {
        return new DockableBarContainer(this);
    }

    @Override
    public void showContextMenu(MouseEvent e, Component component) {
        this._globalContextMenu = this.getContextMenu();
        if (this.getDockableBarPopupMenuCustomizer() != null) {
            this.getDockableBarPopupMenuCustomizer().customizePopupMenu(this._globalContextMenu, this, component);
        }
        if (this._globalContextMenu.getComponentCount() > 0) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), component);
            this._globalContextMenu.show(component, p.x, p.y);
        }
    }

    @Override
    public JPopupMenu getContextMenu() {
        List<String> list = this.getAllDockableBarNames();
        JidePopupMenu menu = new JidePopupMenu();
        for (final String key : list) {
            DockableBar bar = this.getDockableBar(key);
            if (bar == null) continue;
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menu.add(new JCheckBoxMenuItem(bar.getTitle()));
            menuItem.setName(bar.getKey());
            if (bar.isHidable() && this.isHidable()) {
                menuItem.addActionListener(new AbstractAction(){
                    private static final long serialVersionUID = -1046823503732889210L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DockableBar bar = DefaultDockableBarManager.this.getDockableBar(key);
                        if (bar != null) {
                            if (bar.isHidden()) {
                                DefaultDockableBarManager.this.showDockableBar(key);
                            } else {
                                DefaultDockableBarManager.this.hideDockableBar(key);
                            }
                        }
                    }
                });
            } else {
                menuItem.setEnabled(false);
            }
            menuItem.setSelected(!bar.isHidden());
        }
        menu.addSeparator();
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.rearrangeable")));
        menuItem.setName("DockableBar.rearrangeable");
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 6759293385626521734L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDockableBarManager.this.setRearrangable(!DefaultDockableBarManager.this.isRearrangable());
            }
        });
        menuItem.setSelected(this.isRearrangable());
        menuItem = (JCheckBoxMenuItem)menu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.hidable")));
        menuItem.setName("DockableBar.hidable");
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -5475345567338601724L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDockableBarManager.this.setHidable(!DefaultDockableBarManager.this.isHidable());
            }
        });
        menuItem.setSelected(this.isHidable());
        menuItem = (JCheckBoxMenuItem)menu.add(new JCheckBoxMenuItem(resourceBundle.getString("DockableBar.floatable")));
        menuItem.setName("DockableBar.floatable");
        menuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 7175150795685209459L;

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDockableBarManager.this.setFloatable(!DefaultDockableBarManager.this.isFloatable());
            }
        });
        menuItem.setSelected(this.isFloatable());
        return menu;
    }

    @Override
    public FloatingDockableBarContainer createFloatingDockableBarContainer(Window owner) {
        FloatingDockableBarContainer floatingDockableBarContainer;
        if (this.getRootPaneContainer() instanceof Applet) {
            Frame f = JideSwingUtilities.getFrame((Applet)((Object)this._rootPaneContainer));
            floatingDockableBarContainer = new FloatingDockableBarContainer((Window)f);
        } else {
            Window window = JideSwingUtilities.getWindowForComponent(this.getContentContainer());
            if (window instanceof Dialog) {
                floatingDockableBarContainer = new FloatingDockableBarContainer(window);
            } else if (window instanceof Frame) {
                floatingDockableBarContainer = new FloatingDockableBarContainer(window);
            } else {
                throw new UnsupportedOperationException("JIDE Action Framework doesn't support floating command bar if rootPaneContainer is " + this._rootPaneContainer.getClass().getName());
            }
        }
        return floatingDockableBarContainer;
    }

    private void updateKey(String oldKey, String newKey) {
        if (this._allContexts != null && this._allContexts.containsKey(oldKey)) {
            DockableBarContext context = this._allContexts.get(oldKey);
            this._allContexts.remove(oldKey);
            this._allContexts.put(newKey, context);
        }
        if (this._allDockableBars != null && this._allDockableBars.containsKey(oldKey)) {
            DockableBar bar = this._allDockableBars.get(oldKey);
            this._allDockableBars.remove(oldKey);
            this._allDockableBars.put(newKey, bar);
        }
        if (this._allDockableBarKeys != null && this._allDockableBarKeys.contains(oldKey)) {
            this._allDockableBarKeys.set(this._allDockableBarKeys.indexOf(oldKey), newKey);
        }
        if (this._hiddenDockableBars.contains(oldKey)) {
            this._hiddenDockableBars.set(this._hiddenDockableBars.indexOf(oldKey), newKey);
        }
    }

    private boolean isRealized() {
        return this._realized;
    }

    void setRealized(boolean realized) {
        this._realized = realized;
    }

    @Override
    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    @Override
    public void setShowContextMenu(boolean showContextMenu) {
        boolean old = this._showContextMenu;
        if (old != showContextMenu) {
            this._showContextMenu = showContextMenu;
            this.firePropertyChange(PROPERTY_SHOW_CONTEXT_MENU, old, showContextMenu);
        }
    }

    protected boolean redispatchKeyEventToFloatingContainers(KeyEvent e) {
        if (this._floatingDockableBars == null) {
            return false;
        }
        for (Object e2 : this._floatingDockableBars) {
            Object iterObject = e2;
            if (!(iterObject instanceof FloatingDockableBarContainer)) continue;
            FloatingDockableBarContainer floatingContainer = (FloatingDockableBarContainer)iterObject;
            this.processKeyBindingForFloatingDockableWindow(e, floatingContainer);
            if (!e.isConsumed()) continue;
            return true;
        }
        return false;
    }

    protected void processKeyBindingForFloatingDockableWindow(KeyEvent e, JWindow dockableWindow) {
        Component[] comps;
        if (e == null || dockableWindow == null) {
            return;
        }
        for (Component comp : comps = dockableWindow.getComponents()) {
            if (!(comp instanceof Container)) continue;
            this.processKeyBindingsForContainerInFloatingDockable(e, (Container)comp);
            if (!e.isConsumed()) continue;
            return;
        }
    }

    protected void processKeyBindingsForContainerInFloatingDockable(KeyEvent e, Container container) {
        Component[] comps;
        if (container instanceof JComponent) {
            this.processKeyBindingForComponentInFloatingDockable(e, (JComponent)container);
        }
        if (e.isConsumed()) {
            return;
        }
        for (Component comp : comps = container.getComponents()) {
            if (!(comp instanceof Container)) continue;
            this.processKeyBindingsForContainerInFloatingDockable(e, (Container)comp);
            if (!e.isConsumed()) continue;
            return;
        }
    }

    protected void processKeyBindingForComponentInFloatingDockable(KeyEvent e, JComponent comp) {
        boolean pressed;
        if (e == null || comp == null) {
            return;
        }
        boolean bl = pressed = e.getID() == 401;
        KeyStroke ks = e.getID() == 400 ? KeyStroke.getKeyStroke(e.getKeyChar()) : KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), !pressed);
        InputMap map = comp.getInputMap(2);
        ActionMap am = comp.getActionMap();
        if (map != null && am != null && comp.isEnabled()) {
            Action action;
            Object binding = map.get(ks);
            Action action2 = action = binding == null ? null : am.get(binding);
            if (action != null) {
                SwingUtilities.notifyAction(action, ks, e, comp, e.getModifiers());
            }
        }
    }

    @Override
    public DockableBarFactory getDockableBarFactory() {
        return this._dockableBarFactory;
    }

    @Override
    public void setDockableBarFactory(DockableBarFactory dockableBarFactory) {
        this._dockableBarFactory = dockableBarFactory;
    }

    @Override
    public void loadInitialLayout(Document layoutDocument) {
        NodeList managers = layoutDocument.getElementsByTagName(NODE_MANAGERS).item(0).getChildNodes();
        for (int index = 0; index < managers.getLength(); ++index) {
            Node node = managers.item(index);
            if (!NODE_DOCKABLE_BAR_MANAGER.equals(node.getNodeName())) continue;
            Element dockableBarManagerElement = (Element)node;
            XmlUtils.readElement(this, dockableBarManagerElement);
            Element barsElement = (Element)dockableBarManagerElement.getElementsByTagName(NODE_DOCKABLE_BARS).item(0);
            NodeList nodeList = barsElement.getElementsByTagName(NODE_DOCKABLE_BAR);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element barElement = (Element)nodeList.item(i);
                this.readBarElement(barElement);
            }
            break;
        }
    }

    private void readBarElement(Element element) {
        DockableBarFactory factory;
        String key = element.getAttribute(ATTRIBUTE_KEY);
        DockableBar dockableBar = this.getDockableBar(key);
        if (dockableBar == null && (factory = this.getDockableBarFactory()) != null) {
            dockableBar = factory.create(key);
        }
        if (dockableBar == null) {
            return;
        }
        if (this.getDockableBar(key) == null) {
            this.addDockableBar(dockableBar);
        }
        XmlUtils.readElement(dockableBar, element);
    }

    @Override
    public boolean isUseGlassPaneEnabled() {
        return this._useGlassPaneEnabled;
    }

    @Override
    public void setUseGlassPaneEnabled(boolean useGlassPaneEnabled) {
        this._useGlassPaneEnabled = useGlassPaneEnabled;
    }

    @Override
    public void setDockableBarAvailable(String key) {
        this.checkBarKey(key, "setDockableBarAvailable");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDockableBarAvailable(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.setDockableBarAvailable(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void setDockableBarAvailable(DockableBar b) {
        if (b.getContext() == null || b.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(b.getKey())) {
            this.addDockableBar(b);
        }
        if (!b.isHidden() && !b.isVisible()) {
            b.setVisible(true);
        }
        b.setAvailable(true);
        if (!this.loadAvailablePreviousState(b)) {
            if (b.isFloating()) {
                this.floatDockableBar(b, b.getUndockedBounds());
            } else {
                this.dockDockableBar(b, DockableBarUtils.convertDockSideToSide(b.getContext().getInitSide()), b.getContext().getInitIndex(), false, b.getContext().getInitSubindex());
            }
        }
    }

    @Override
    public void setDockableBarUnavailable(String key) {
        this.checkBarKey(key, "setDockableBarUnavailable");
        final DockableBar bar = this.getDockableBar(key);
        if (bar == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDockableBarUnavailable(bar);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultDockableBarManager.this.setDockableBarUnavailable(bar);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
        }
    }

    private void setDockableBarUnavailable(DockableBar b) {
        if (b.getContext() == null || !b.isAvailable()) {
            return;
        }
        if (!this._allDockableBars.containsKey(b.getKey())) {
            this.addDockableBar(b);
        }
        DockableBarUtils.saveAvailablePreviousState(b);
        if (b.getParent() != null && b.getParent() instanceof DockableBarContainer) {
            b.getParent().remove(b);
        }
        b.setAvailable(false);
        Container topLevelAncestor = b.getTopLevelAncestor();
        if (topLevelAncestor instanceof FloatingDockableBarContainer && this._floatingDockableBars != null) {
            this._floatingDockableBars.remove(topLevelAncestor);
            topLevelAncestor.setVisible(false);
            ((FloatingDockableBarContainer)topLevelAncestor).dispose();
        }
        this.doLayout();
    }

    public boolean isPreserveAvailableProperty() {
        return this._preserveAvailableProperty;
    }

    public void setPreserveAvailableProperty(boolean preserveAvailableProperty) {
        this._preserveAvailableProperty = preserveAvailableProperty;
    }

    private boolean loadAvailablePreviousState(DockableBar dockableBar) {
        PreviousState state = dockableBar.getContext().getAvailablePreviousState();
        if (state != null) {
            this.restorePreviousState(dockableBar, state);
            return true;
        }
        return false;
    }

    protected void checkBarKey(String key, String methodName) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("The dockable bar key passed to " + methodName + " is empty. Please use DockableBar#getKey() method to get the unique key when using APIs on DockableBarManager.");
        }
    }

    @Override
    public int getDoubleClickAction() {
        return this._doubleClickAction;
    }

    @Override
    public void setDoubleClickAction(int doubleClickAction) {
        int old = this._doubleClickAction;
        if (this._doubleClickAction != doubleClickAction) {
            this._doubleClickAction = doubleClickAction;
            this.firePropertyChange(PROPERTY_DOUBLE_CLICK_ACTION, old, this._doubleClickAction);
        }
    }

    Rectangle getUnmaximizedBounds() {
        return this._unmaximizedBounds;
    }

    Map<String, DockableBarContext> getAllContexts() {
        return this._allContexts;
    }

    boolean isUseFrameBounds() {
        return this._useFrameBounds;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29) {
                System.err.println("The Lm class is invalid, exiting ...");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.exit(-1);
        }
        if (!Q.zz(16)) {
            Lm.showInvalidProductMessage(DefaultDockableBarManager.class.getName(), 16);
        }
        LOGGER = Logger.getLogger(DefaultDockableBarManager.class.getName());
        LOGGER_EVENT = Logger.getLogger(DockableBarsRearrangedEvent.class.getName());
    }

    protected class FloaterKeyEventPostProcessor
    implements KeyEventPostProcessor {
        protected FloaterKeyEventPostProcessor() {
        }

        @Override
        public boolean postProcessKeyEvent(KeyEvent e) {
            if (DefaultDockableBarManager.this._redispatchingKeyEventToFloaters) {
                return false;
            }
            if (e.isConsumed() || !e.isAltDown()) {
                return false;
            }
            return DefaultDockableBarManager.this.redispatchKeyEventToFloatingContainers(e);
        }
    }

    protected class DockableBarsSnapshot {
        protected Component _possiblyMoved;
        protected ArrayList<DockableBarState> _northBars = new ArrayList();
        protected ArrayList<DockableBarState> _southBars = new ArrayList();
        protected ArrayList<DockableBarState> _eastBars = new ArrayList();
        protected ArrayList<DockableBarState> _westBars = new ArrayList();
        protected ArrayList<DockableBarState> _floatingBars = new ArrayList();

        protected DockableBarsSnapshot() {
        }

        protected void clear() {
            this._possiblyMoved = null;
            this._northBars.clear();
            this._southBars.clear();
            this._eastBars.clear();
            this._westBars.clear();
            this._floatingBars.clear();
        }
    }
}

