/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.xhtml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.ECXHTMLTableCustomizerInvoker;
import ro.sync.ecss.extensions.commons.table.operations.xhtml.SAXHTMLTableCustomizerInvoker;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
@WebappRestSafe
public class InsertTableOperation
implements AuthorOperation,
InsertTableOperationBase {
    private static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private static final CommonsOperationsUtil.ConversionElementHelper CONVERSION_ELEMENT_CHECKER = new CommonsOperationsUtil.ConversionElementHelper(){

        @Override
        public boolean blockContentMustBeConverted(AuthorNode node, AuthorAccess authorAccess) throws AuthorOperationException {
            AuthorElement element;
            String name;
            boolean canBeConverted = false;
            if (node instanceof AuthorElement && (name = (element = (AuthorElement)node).getLocalName()) != null && ("p".equals(name) || "li".equals(name) || "dd".equals(name) || "dt".equals(name) || "ul".equals(name) || "ol".equals(name) || "dl".equals(name))) {
                canBeConverted = true;
            }
            if (!canBeConverted) {
                throw new AuthorOperationException(authorAccess.getAuthorResourceBundle().getMessage("table.convert.exception"));
            }
            return canBeConverted;
        }
    };

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        AuthorDocumentFragment[] fragments = null;
        ArrayList<Map<String, String>> attributes = null;
        List<CommonsOperationsUtil.SelectedFragmentInfo> selectedFrags = CommonsOperationsUtil.getSelectedFragmentsForConversions(authorAccess, CONVERSION_ELEMENT_CHECKER);
        if (selectedFrags != null) {
            fragments = new AuthorDocumentFragment[selectedFrags.size()];
            attributes = new ArrayList<Map<String, String>>(selectedFrags.size());
            for (int i = 0; i < selectedFrags.size(); ++i) {
                CommonsOperationsUtil.SelectedFragmentInfo currentFrag = selectedFrags.get(i);
                fragments[i] = currentFrag.getSelectedFragment();
                attributes.add(currentFrag.getAttributes());
            }
        }
        Object tableInfoObj = args.getArgumentValue("table_info");
        int minRows = fragments != null ? fragments.length : 0;
        TableInfo tableInfo = tableInfoObj != null ? new TableInfo((Map)tableInfoObj, minRows) : null;
        this.insertTable(fragments, attributes, false, authorAccess, null, null, tableInfo);
    }

    public void insertTable(AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        if (tableInfo == null) {
            Platform platform;
            int rowsCount = -1;
            int columnsCount = -1;
            if (fragments != null) {
                rowsCount = fragments.length;
                columnsCount = 1;
            }
            if (Platform.STANDALONE == (platform = authorAccess.getWorkspaceAccess().getPlatform())) {
                tableInfo = SAXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
            } else if (Platform.ECLIPSE == platform) {
                tableInfo = ECXHTMLTableCustomizerInvoker.getInstance().customizeTable(authorAccess, rowsCount, columnsCount);
            }
        }
        if (tableInfo == null) {
            throw new AuthorOperationStoppedByUserException("Cancelled by user");
        }
        List<Position> emptyElementsPositions = CommonsOperationsUtil.removeCurrentSelection(authorAccess);
        AuthorDocumentController controller = authorAccess.getDocumentController();
        SchemaAwareHandlerResult result = controller.insertXMLFragmentSchemaAware(InsertTableOperation.getTableXMLFragment(tableInfo, NAMESPACE, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper).toString(), authorAccess.getEditorAccess().getCaretOffset());
        TableOperationsUtil.placeCaretInFirstCell(authorAccess, tableInfo, controller, result);
        CommonsOperationsUtil.removeEmptyElements(authorAccess, emptyElementsPositions);
    }

    @Override
    public void insertTable(AuthorDocumentFragment[] fragments, boolean cellsFragments, AuthorAccess authorAccess, String namespace, AuthorTableHelper tableHelper, TableInfo tableInfo) throws AuthorOperationException {
        this.insertTable(fragments, null, cellsFragments, authorAccess, namespace, tableHelper, tableInfo);
    }

    private static void addTableBody(StringBuilder tableXMLFragment, TableInfo tableInfo, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper, String namespace) throws AuthorOperationException {
        tableXMLFragment.append("<tbody>");
        for (int i = 0; i < tableInfo.getRowsNumber(); ++i) {
            Map<String, String> map;
            tableXMLFragment.append("<tr");
            if (rowAttributes != null && i < rowAttributes.size() && (map = rowAttributes.get(i)) != null) {
                Set<String> keySet = map.keySet();
                for (String attrName : keySet) {
                    tableXMLFragment.append(" ").append(attrName).append("=").append("\"").append(map.get(attrName)).append("\"");
                }
            }
            tableXMLFragment.append(">");
            for (int j = 0; j < tableInfo.getColumnsNumber(); ++j) {
                if (j == 0 && fragments != null) {
                    String cellXMLFragment = TableOperationsUtil.createCellXMLFragment(authorAccess, fragments, cellsFragments, "td", i, namespace, tableHelper, new String[0]);
                    tableXMLFragment.append(cellXMLFragment);
                    continue;
                }
                tableXMLFragment.append("<td></td>");
            }
            tableXMLFragment.append("</tr>");
        }
        tableXMLFragment.append("</tbody>");
    }

    private static void addTableCols(StringBuilder tableXMLFragment, TableInfo tableInfo) {
        tableXMLFragment.append("<colgroup>");
        for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
            tableXMLFragment.append("<col />");
        }
        tableXMLFragment.append("</colgroup>");
    }

    private static void addTableFooter(StringBuilder tableXMLFragment, TableInfo tableInfo) throws AuthorOperationException {
        if (tableInfo.isGenerateFooter()) {
            tableXMLFragment.append("<tfoot><tr>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<td></td>");
            }
            tableXMLFragment.append("</tr></tfoot>");
        }
    }

    private static void addTableHeader(StringBuilder tableXMLFragment, TableInfo tableInfo) throws AuthorOperationException {
        if (tableInfo.isGenerateHeader()) {
            tableXMLFragment.append("<thead><tr>");
            for (int i = 1; i <= tableInfo.getColumnsNumber(); ++i) {
                tableXMLFragment.append("<th></th>");
            }
            tableXMLFragment.append("</tr></thead>");
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    public String getDescription() {
        return "Insert a XHTML table";
    }

    private static StringBuilder getTableXMLFragment(TableInfo tableInfo, String namespace, AuthorDocumentFragment[] fragments, List<Map<String, String>> rowAttributes, boolean cellsFragments, AuthorAccess authorAccess, AuthorTableHelper tableHelper) throws AuthorOperationException {
        StringBuilder tableXMLFragment = new StringBuilder();
        tableXMLFragment.append("<table");
        tableXMLFragment.append(" xmlns=\"").append(namespace).append("\"");
        if (tableInfo.getFrame() != null) {
            tableXMLFragment.append(" frame=\"").append(tableInfo.getFrame()).append("\"");
        }
        if (tableInfo.getAlign() != null) {
            tableXMLFragment.append(" align=\"").append(tableInfo.getAlign()).append("\"");
        }
        tableXMLFragment.append(">");
        if (tableInfo.getTitle() != null) {
            tableXMLFragment.append("<caption>").append(authorAccess.getXMLUtilAccess().escapeTextValue(tableInfo.getTitle())).append("</caption>");
        }
        InsertTableOperation.addTableCols(tableXMLFragment, tableInfo);
        InsertTableOperation.addTableHeader(tableXMLFragment, tableInfo);
        InsertTableOperation.addTableBody(tableXMLFragment, tableInfo, fragments, rowAttributes, cellsFragments, authorAccess, tableHelper, namespace);
        InsertTableOperation.addTableFooter(tableXMLFragment, tableInfo);
        tableXMLFragment.append("</table>");
        return tableXMLFragment;
    }
}

