/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class InsertRowOperation
extends InsertRowOperationBase
implements CALSConstants,
InsertTableCellsContentConstants {
    protected String cellContent;

    public InsertRowOperation() {
        super(new CALSDocumentTypeHelper());
    }

    public InsertRowOperation(AuthorTableHelper helper) {
        super(helper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object cellFragmentObj = args.getArgumentValue("cellFragment");
        if (cellFragmentObj instanceof String) {
            this.cellContent = (String)cellFragmentObj;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperationInternal(authorAccess, args);
    }

    @Override
    protected String getCellElementName(AuthorElement tableElement, int columnIndex) {
        return "entry";
    }

    @Override
    protected String getRowElementName(AuthorElement tableElement) {
        return "row";
    }

    @Override
    protected boolean useCurrentRowTemplateOnInsert() {
        return true;
    }

    @Override
    protected ArgumentDescriptor[] getOperationArguments() {
        ArgumentDescriptor[] arguments = null;
        ArgumentDescriptor[] args = super.getOperationArguments();
        if (args != null) {
            arguments = new ArgumentDescriptor[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                arguments[i] = args[i];
            }
            arguments[args.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
        return arguments;
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }
}

