/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.commons.AbstractDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpanSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSDocumentTypeHelper
extends AbstractDocumentTypeHelper
implements CALSConstants {
    private static final String[] ROW_ELEMENT_NAMES = new String[]{"row"};
    private static final String[] CELL_ELEMENT_NAMES = new String[]{"entry"};
    private static final String[] TABLE_ELEMENT_NAMES = new String[]{"tgroup", "informaltable"};

    @Override
    public String[] getTableCellElementNames() {
        return CELL_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableRowElementNames() {
        return ROW_ELEMENT_NAMES;
    }

    @Override
    public String[] getTableElementLocalName() {
        return TABLE_ELEMENT_NAMES;
    }

    @Override
    public void checkTableColSpanIsDefined(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSpanSupport, AuthorElement cellElement) throws AuthorOperationException {
        CALSColSpanSpec cellSpanSpec = ((CALSTableCellInfoProvider)tableSpanSupport).getCellSpanSpec(authorAccess, cellElement);
        if (cellSpanSpec == null) {
            AuthorOperationException ex = new AuthorOperationException("Cannot compute the horizontal span specifications for the involved cells because there are missing 'colspec' elements.");
            ex.setOperationRejectedOnPurpose(true);
            throw ex;
        }
    }

    private static CALSColSpec getTableColSpec(AuthorTableCellSpanProvider tableSpanSupport, int colIndex) throws AuthorOperationException {
        CALSColSpec colSpec = ((CALSTableCellInfoProvider)tableSpanSupport).getColSpec(colIndex);
        if (colSpec == null) {
            throw new AuthorOperationException("There is no column specification for column with index: " + colIndex);
        }
        return colSpec;
    }

    @Override
    public void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider tableSupport, AuthorElement cellElem, int startCol, int endCol) throws AuthorOperationException {
        CALSColSpec startColSpec = CALSDocumentTypeHelper.getTableColSpec(tableSupport, startCol);
        CALSColSpec endColSpec = CALSDocumentTypeHelper.getTableColSpec(tableSupport, endCol);
        AuthorDocumentController controller = authorAccess.getDocumentController();
        if (startColSpec.getColumnNumber() == endColSpec.getColumnNumber()) {
            controller.removeAttribute("namest", cellElem);
            controller.removeAttribute("nameend", cellElem);
        } else {
            controller.setAttribute("namest", new AttrValue(startColSpec.getColumnName()), cellElem);
            controller.setAttribute("nameend", new AttrValue(endColSpec.getColumnName()), cellElem);
        }
        authorAccess.getDocumentController().removeAttribute("spanname", cellElem);
        authorAccess.getDocumentController().removeAttribute("colname", cellElem);
    }

    @Override
    public AuthorTableCellSpanProvider getTableCellSpanProvider(AuthorElement tgroupElement) {
        CALSTableCellInfoProvider tableSpanSupport = new CALSTableCellInfoProvider();
        tableSpanSupport.init(tgroupElement);
        return tableSpanSupport;
    }

    @Override
    public void updateTableRowSpan(AuthorAccess authorAccess, AuthorElement cellElem, int rowSpan) {
        if (rowSpan > 1) {
            authorAccess.getDocumentController().setAttribute("morerows", new AttrValue(String.valueOf(rowSpan - 1)), cellElem);
        } else {
            authorAccess.getDocumentController().removeAttribute("morerows", cellElem);
        }
    }

    @Override
    public void updateTableColumnNumber(AuthorAccess authorAccess, AuthorElement tableElement, int colsNumber) {
        authorAccess.getDocumentController().setAttribute("cols", new AttrValue(String.valueOf(colsNumber)), tableElement);
    }

    @Override
    public void updateTableRowNumber(AuthorAccess authorAccess, AuthorElement tableElement, int rowsNumber) {
    }

    @Override
    public String[] getIgnoredRowAttributes() {
        return new String[]{"morerows"};
    }

    @Override
    public String[] getIgnoredCellIDAttributes() {
        return new String[]{"xml:id", "id"};
    }

    @Override
    public String[] getAllowedCellAttributesToCopy() {
        return new String[]{"namest", "nameend", "rowsep", "colsep", "colname", "spanname", "align", "valign", "charoff", "rotate"};
    }

    @Override
    public String[] getIgnoredColumnAttributes() {
        return new String[]{"namest", "nameend"};
    }

    @Override
    public AuthorNode getTableElementForDeletion(AuthorNode element) {
        AuthorNode tableElement = null;
        if (this.isActuallyTableAndNotTgroup(element)) {
            tableElement = element;
        } else {
            while (element.getParent() != null) {
                if (!this.isActuallyTableAndNotTgroup(element.getParent())) continue;
                tableElement = element.getParent();
                break;
            }
        }
        return tableElement;
    }

    protected boolean isActuallyTableAndNotTgroup(AuthorNode node) {
        AuthorElement element;
        return node instanceof AuthorElement && ("table".equals((element = (AuthorElement)node).getLocalName()) || "informaltable".equals(element.getLocalName()));
    }

    public void limitRowSpan(AuthorDocumentFragment[] rowFragments) {
        int nuOfRows = rowFragments.length;
        for (int i = 0; i < nuOfRows; ++i) {
            AuthorDocumentFragment rowFragment = rowFragments[i];
            int maxRowSpanValue = nuOfRows - (i + 1);
            this.limitRowSpanInRowDocumentFragment(rowFragment, maxRowSpanValue);
        }
    }

    private AuthorDocumentFragment limitRowSpanInRowDocumentFragment(AuthorDocumentFragment fragment, int maxRowSpanValue) {
        AuthorNode rowNode;
        List contentNodes = fragment.getContentNodes();
        if (contentNodes != null && !contentNodes.isEmpty() && this.isTableRow(rowNode = (AuthorNode)contentNodes.get(0))) {
            CALSDocumentTypeHelper.limitRowSpanInRowCells((AuthorParentNode)rowNode, maxRowSpanValue);
        }
        return fragment;
    }

    private static void limitRowSpanInRowCells(AuthorParentNode rowNode, int maxRowSpanValue) {
        List cells = rowNode.getContentNodes();
        CALSTableCellInfoProvider provider = new CALSTableCellInfoProvider();
        for (AuthorNode cell : cells) {
            AuthorElement cellElement;
            Integer rowSpan;
            if (!(cell instanceof AuthorElement) || (rowSpan = provider.getRowSpan(cellElement = (AuthorElement)cell)) == null || rowSpan <= maxRowSpanValue) continue;
            if (maxRowSpanValue > 0) {
                cellElement.setAttribute("morerows", new AttrValue(String.valueOf(maxRowSpanValue)));
                continue;
            }
            cellElement.removeAttribute("morerows");
        }
    }
}

