/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class SplitCellAboveBelowOperationBase
extends AbstractTableOperation {
    private static final String SPLIT_ABOVE = "Above";
    private static final String SPLIT_BELOW = "Below";
    private static final String ARGUMENT_NAME = "Split point";

    public SplitCellAboveBelowOperationBase(AuthorTableHelper tableHelper) {
        super(tableHelper);
    }

    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode nodeAtCaret = authorAccess.getDocumentController().getNodeAtOffset(caretOffset);
            AuthorElement cell = this.getElementAncestor(nodeAtCaret, 0);
            if (cell == null) {
                AuthorOperationException ex = new AuthorOperationException("The caret must be inside a table cell.");
                ex.setOperationRejectedOnPurpose(true);
                throw ex;
            }
            String argVal = (String)args.getArgumentValue(ARGUMENT_NAME);
            this.splitCell(cell, authorAccess, SPLIT_ABOVE.equals(argVal));
        }
        catch (BadLocationException e) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void splitCell(AuthorElement cell, AuthorAccess authorAccess, boolean above) throws AuthorOperationException, BadLocationException {
        int cellRowSpan;
        AuthorElement tableElem = this.getElementAncestor((AuthorNode)cell, 2);
        if (tableElem == null) throw new AuthorOperationException("The table cell must be inside a table element.");
        AuthorTableCellSpanProvider tableSupport = this.tableHelper.getTableCellSpanProvider(tableElem);
        Integer cellRowSpanInteger = tableSupport.getRowSpan(cell);
        int n = cellRowSpan = cellRowSpanInteger != null ? cellRowSpanInteger : 1;
        if (cellRowSpan <= 1) throw new AuthorOperationException("The cell you are trying to split does not span over multiple rows.");
        int[] location = authorAccess.getTableAccess().getTableCellIndex(cell);
        if (location == null) throw new AuthorOperationException("Invalid table. Could not determine the location of the cell.");
        if (!above) {
            int insertionOffset = this.findCellInsertionOffset(authorAccess, tableElem, location[0] + cellRowSpan - 1, location[1]);
            if (insertionOffset == -1) throw new AuthorOperationException("Could not determine the location where the split will occur.");
            AuthorDocumentFragment emptyCellFragment = this.createEmptyCell(authorAccess, cell, this.getIgnoredAttributes());
            AuthorDocumentController controller = authorAccess.getDocumentController();
            controller.insertFragment(insertionOffset, emptyCellFragment);
            authorAccess.getEditorAccess().setCaretPosition(insertionOffset + 1);
            this.tableHelper.updateTableRowSpan(authorAccess, cell, cellRowSpan - 1);
            return;
        } else {
            int insertionOffset = this.findCellInsertionOffset(authorAccess, tableElem, location[0] + 1, location[1]);
            if (insertionOffset == -1) throw new AuthorOperationException("Could not determine the location where the split will occur.");
            AuthorDocumentController controller = authorAccess.getDocumentController();
            this.tableHelper.updateTableRowSpan(authorAccess, cell, cellRowSpan - 1);
            AuthorDocumentFragment contentFragment = controller.createDocumentFragment((AuthorNode)cell, true);
            controller.insertFragment(insertionOffset, contentFragment);
            SplitCellAboveBelowOperationBase.clearCell(authorAccess, cell, this.getIgnoredAttributes());
            authorAccess.getEditorAccess().setCaretPosition(cell.getStartOffset() + 1);
        }
    }

    private static void clearCell(AuthorAccess authorAccess, AuthorElement cellElem, String[] removedAttributes) {
        AuthorDocumentController controller = authorAccess.getDocumentController();
        for (int i = 0; i < removedAttributes.length; ++i) {
            controller.removeAttribute(removedAttributes[i], cellElem);
        }
        if (cellElem.getStartOffset() + 1 < cellElem.getEndOffset()) {
            controller.delete(cellElem.getStartOffset() + 1, cellElem.getEndOffset() - 1);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ARGUMENT_NAME, 3, "The location relative to the source cell for the newly split cell.", new String[]{SPLIT_ABOVE, SPLIT_BELOW}, SPLIT_ABOVE)};
    }

    public String getDescription() {
        return "This operation splits the content of a table cell that spans over multiple rows.";
    }

    protected abstract String[] getIgnoredAttributes();
}

