/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.sort.CriterionInformation;
import ro.sync.ecss.extensions.commons.sort.KeysController;

@API(type=APIType.NOT_EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class CriterionPanel {
    private JCheckBox keyCheckbox;
    private JComboBox keyCombo;
    private JComboBox typeCombo;
    private JComboBox orderCombo;
    private boolean addCheckbox;
    private final List<CriterionInformation> allCriteria;

    public CriterionPanel(Container parent, GridBagConstraints constr, List<CriterionInformation> criterionInformation, CriterionInformation selectedItem, final AuthorResourceBundle authorResourceBundle, final KeysController keysController, List<CriterionInformation> allCriteria) {
        this.allCriteria = allCriteria;
        this.addCheckbox = allCriteria.size() > 1;
        constr.gridx = 0;
        ++constr.gridy;
        constr.fill = 0;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(0, 0, 7, 7);
        if (this.addCheckbox) {
            this.keyCheckbox = new JCheckBox();
            parent.add((Component)this.keyCheckbox, constr);
            ++constr.gridx;
            this.keyCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CriterionPanel.this.changeControlsState();
                }
            });
        }
        constr.fill = 2;
        constr.weightx = 0.33;
        this.keyCombo = new JComboBox();
        this.keyCombo.setToolTipText(authorResourceBundle.getMessage("Select_key_column_tooltip"));
        for (int i = 0; i < criterionInformation.size(); ++i) {
            CriterionInformation criterionInfo = criterionInformation.get(i);
            this.keyCombo.addItem(criterionInfo.getDisplayName());
        }
        if (this.keyCombo.getPreferredSize().width < 75) {
            this.keyCombo.setPreferredSize(new Dimension(75, this.keyCombo.getPreferredSize().height));
            this.keyCombo.setMinimumSize(new Dimension(75, this.keyCombo.getPreferredSize().height));
        } else if (this.keyCombo.getPreferredSize().width > 150) {
            this.keyCombo.setPreferredSize(new Dimension(150, this.keyCombo.getPreferredSize().height));
            this.keyCombo.setMaximumSize(new Dimension(150, this.keyCombo.getPreferredSize().height));
        }
        this.keyCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentSel = (String)CriterionPanel.this.keyCombo.getSelectedItem();
                if (currentSel != null) {
                    keysController.selectionChanged(currentSel, null);
                }
            }
        });
        if (selectedItem != null) {
            this.keyCombo.setSelectedItem(selectedItem.getDisplayName());
        } else {
            this.keyCombo.setSelectedItem(criterionInformation.get(0).getDisplayName());
        }
        parent.add((Component)this.keyCombo, constr);
        ++constr.gridx;
        this.typeCombo = new JComboBox();
        this.typeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, authorResourceBundle.getMessage((String)value), index, isSelected, cellHasFocus);
            }
        });
        this.typeCombo.setToolTipText(authorResourceBundle.getMessage("Select_type_combo_tooltip"));
        this.typeCombo.addItem(CriterionInformation.TYPE.TEXT.getName());
        this.typeCombo.addItem(CriterionInformation.TYPE.NUMERIC.getName());
        this.typeCombo.addItem(CriterionInformation.TYPE.DATE.getName());
        this.typeCombo.setSelectedIndex(0);
        parent.add((Component)this.typeCombo, constr);
        this.orderCombo = new JComboBox();
        this.orderCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, authorResourceBundle.getMessage((String)value), index, isSelected, cellHasFocus);
            }
        });
        this.orderCombo.addItem(CriterionInformation.ORDER.ASCENDING.getName());
        this.orderCombo.addItem(CriterionInformation.ORDER.DESCENDING.getName());
        this.orderCombo.setToolTipText(authorResourceBundle.getMessage("Select_order_combo_tooltip"));
        this.orderCombo.setSelectedIndex(0);
        ++constr.gridx;
        constr.insets = new Insets(0, 0, 7, 0);
        parent.add((Component)this.orderCombo, constr);
        this.changeControlsState();
    }

    public CriterionInformation getInformation() {
        CriterionInformation info = null;
        if (!this.addCheckbox || this.keyCheckbox.isSelected()) {
            int index = 0;
            if (this.keyCombo != null) {
                for (int i = 0; i < this.allCriteria.size(); ++i) {
                    if (!this.allCriteria.get(i).getDisplayName().equals(this.keyCombo.getSelectedItem())) continue;
                    index = i;
                    break;
                }
            }
            info = new CriterionInformation(index, (String)this.typeCombo.getSelectedItem(), (String)this.orderCombo.getSelectedItem(), this.keyCombo != null ? (String)this.keyCombo.getSelectedItem() : "Column 1");
        }
        return info;
    }

    public void enableSortcriterion() {
        this.keyCheckbox.setSelected(true);
        this.changeControlsState();
    }

    public JComboBox getKeyCombo() {
        return this.keyCombo;
    }

    private void changeControlsState() {
        this.keyCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
        this.typeCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
        this.orderCombo.setEnabled(this.keyCheckbox == null || this.keyCheckbox.isSelected());
    }
}

