/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.xerces.parsers.XMLParser;
import org.apache.xerces.util.SecurityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@SkipObfuscate(classes=SkipLevel.PUBLIC, fields=SkipLevel.NONE, methods=SkipLevel.PUBLIC)
public final class SecureXMLReader {
    private static final Logger b = LoggerFactory.getLogger((String)SecureXMLReader.class.getName());

    private SecureXMLReader() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    private static void b(XMLReader xMLReader) {
        block4: {
            try {
                xMLReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                if (xMLReader instanceof XMLParser) break block4;
                b.warn("Cannot secure XML reader", (Throwable)sAXException);
            }
        }
        try {
            SecurityManager securityManager = new SecurityManager();
            xMLReader.setProperty("http://apache.org/xml/properties/security-manager", securityManager);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            b.warn("Cannot set expansion limit", (Throwable)sAXException);
        }
    }

    public static void parse(XMLReader xMLReader, String string) throws IOException, SAXException {
        SecureXMLReader.b(xMLReader);
        xMLReader.parse(string);
    }

    public static void parse(XMLReader xMLReader, InputStream inputStream) throws IOException, SAXException {
        SecureXMLReader.parse(xMLReader, new InputSource(inputStream));
    }

    public static void parse(XMLReader xMLReader, Reader reader) throws IOException, SAXException {
        SecureXMLReader.parse(xMLReader, new InputSource(reader));
    }

    public static void parse(XMLReader xMLReader, InputSource inputSource) throws IOException, SAXException {
        SecureXMLReader.b(xMLReader);
        xMLReader.parse(inputSource);
    }
}

