/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ui.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableList;
import ro.sync.ui.table.TableColumnInfo;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class TableColumnModelInfo<TCInfo extends TableColumnInfo>
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)TableColumnModelInfo.class.getName());
    protected SerializableList<TCInfo> colInfos = new SerializableList();

    public TableColumnModelInfo() {
    }

    public TableColumnModelInfo(List<TCInfo> list) {
        if (list != null) {
            this.colInfos.addAll(list);
        }
    }

    public TableColumnModelInfo(TCInfo[] TCInfoArray) {
        if (TCInfoArray != null) {
            for (int i2 = 0; i2 < TCInfoArray.length; ++i2) {
                this.colInfos.add(TCInfoArray[i2]);
            }
        }
    }

    public List<TCInfo> getColumnsInfo() {
        return this.colInfos;
    }

    public TCInfo getColumnInfo(int n2) {
        TableColumnInfo tableColumnInfo = null;
        for (TableColumnInfo tableColumnInfo2 : this.colInfos) {
            if (tableColumnInfo2.getModelIndex() != n2) continue;
            tableColumnInfo = tableColumnInfo2;
            break;
        }
        return (TCInfo)tableColumnInfo;
    }

    public int getViewIndex(TCInfo TCInfo) {
        return this.colInfos.indexOf(TCInfo);
    }

    @Override
    public Object clone() {
        TableColumnModelInfo tableColumnModelInfo = null;
        try {
            tableColumnModelInfo = (TableColumnModelInfo)super.clone();
            SerializableList<Object> serializableList = null;
            if (this.colInfos != null) {
                serializableList = new SerializableList<Object>(this.colInfos.size());
                for (Object e2 : this.colInfos) {
                    if (e2 instanceof PersistentObject) {
                        serializableList.add(((PersistentObject)e2).clone());
                        continue;
                    }
                    serializableList.add(e2);
                }
            }
            tableColumnModelInfo.colInfos = serializableList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return tableColumnModelInfo;
    }

    public void removeColumnInfo(int n2) {
        Iterator iterator = this.colInfos.iterator();
        while (iterator.hasNext()) {
            TableColumnInfo tableColumnInfo = (TableColumnInfo)iterator.next();
            if (tableColumnInfo.getModelIndex() != n2) continue;
            iterator.remove();
        }
    }

    public void removeColumnsInfo(List<Integer> list) {
        if (list != null) {
            for (Integer n2 : list) {
                this.removeColumnInfo(n2);
            }
        }
    }

    public void moveColumn(int n2, int n3) {
        TableColumnInfo tableColumnInfo = (TableColumnInfo)this.colInfos.get(n2);
        if (n2 < n3) {
            this.colInfos.add(n3 + 1, tableColumnInfo);
            this.colInfos.remove(n2);
        } else {
            this.colInfos.add(n3, tableColumnInfo);
            this.colInfos.remove(n2 + 1);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.colInfos != null) {
            for (Object e2 : this.colInfos) {
                stringBuilder.append(e2).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.colInfos == null || this.colInfos.isEmpty()) {
            throw new InvalidPersistentObjException("Invalid table column model info, there are no columns info.");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    public int getColumnsWidth() {
        int n2 = 0;
        if (this.colInfos != null) {
            for (TableColumnInfo tableColumnInfo : this.colInfos) {
                n2 += tableColumnInfo.getWidth();
            }
        }
        return n2;
    }

    public List<Integer> getHiddenColumnsIndices() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumnInfo tableColumnInfo : this.colInfos) {
            int n2 = tableColumnInfo.getModelIndex();
            if (!this.isColumnHidden(n2)) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    public boolean isColumnHidden(int n2) {
        return ((TableColumnInfo)this.getColumnInfo(n2)).isHidden();
    }
}

