/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.DocumentTypeAdvancedCustomRuleMatcher;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
public abstract class JSONAndYAMLRuleMatcherBase
extends DocumentTypeAdvancedCustomRuleMatcher {
    private static final Logger apy = LoggerFactory.getLogger((String)JSONAndYAMLRuleMatcherBase.class.getName());
    private static final List<String> cpy = List.of("JSON", "YAML");
    private final String bpy;
    private final String[] zoy;

    protected JSONAndYAMLRuleMatcherBase(String string, String[] stringArray) {
        this.bpy = string;
        this.zoy = stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(String string, String string2, String string3, String string4, Attributes attributes, Reader reader) {
        try {
            String string5 = attributes.getValue("topProperties");
            if (!cpy.contains(string3)) return false;
            if (string5 == null) return false;
            if (!string5.contains(this.bpy)) return false;
            String string6 = IOUtil.read((Reader)reader).toString();
            String string7 = "<" + this.bpy + ">";
            int n2 = string6.indexOf(string7);
            int n3 = string6.indexOf("</" + this.bpy + ">");
            if (n2 == -1) return false;
            if (n3 == -1) return false;
            String string8 = string6.substring(n2 + string7.length(), n3);
            if (string8 == null) return false;
            if (!Arrays.stream(this.zoy).anyMatch(string8::startsWith)) return false;
            return true;
        }
        catch (IOException iOException) {
            apy.error((Object)iOException, (Throwable)iOException);
        }
        return false;
    }
}

