/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.fsv.sharepoint.webservice.lists;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.namespace.QName;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.fsv.sharepoint.webservice.lists.ListProperty;

@XmlAccessorType(value=XmlAccessType.FIELD)
@SkipObfuscate(fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE, classes=SkipLevel.PRIVATE)
public class BasicListInfo {
    @XmlAttribute(name="Title", namespace="")
    private final String title;
    @XmlAttribute(name="ID", namespace="")
    private final String id;
    @XmlAttribute(name="Description", namespace="")
    private final String description;
    @XmlAttribute(name="RootFolder", namespace="")
    private final String rootFolder;
    @XmlAnyAttribute
    private final Map<QName, String> properties = new HashMap<QName, String>();

    public BasicListInfo() {
        this.title = null;
        this.id = null;
        this.description = null;
        this.rootFolder = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ListInfo [title=");
        stringBuilder.append(this.title);
        stringBuilder.append(", id=");
        stringBuilder.append(this.id);
        stringBuilder.append(", description=");
        stringBuilder.append(this.description);
        stringBuilder.append(",\nproperties=[\n");
        Set<QName> set = this.properties.keySet();
        for (QName qName : set) {
            stringBuilder.append("      - " + qName.getLocalPart() + " = " + this.properties.get(qName));
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String getProperty(ListProperty listProperty) {
        return this.properties.get(listProperty.qname);
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.getProperty(ListProperty.HIDDEN));
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public Map<QName, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        n3 = 31 * n3 + (this.rootFolder == null ? 0 : this.rootFolder.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BasicListInfo basicListInfo = (BasicListInfo)object;
        if (this.id == null ? basicListInfo.id != null : !this.id.equals(basicListInfo.id)) {
            return false;
        }
        return !(this.rootFolder == null ? basicListInfo.rootFolder != null : !this.rootFolder.equals(basicListInfo.rootFolder));
    }
}

