/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.serialize.state;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class BreakLineElement
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)BreakLineElement.class.getName());
    public static final int NO_BREAK = 0;
    public static final int BREAK_BEFORE = 1;
    public static final int BREAK_AFTER = 2;
    private String elementExpression;
    private int breakPolicy = 0;

    public BreakLineElement() {
    }

    public BreakLineElement(String string, int n2) {
        this.elementExpression = string;
        this.breakPolicy = n2;
    }

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.elementExpression == null) {
            throw new InvalidPersistentObjException("No element name was provided");
        }
    }

    public String getElementExpression() {
        return this.elementExpression;
    }

    private boolean isBreakBefore() {
        return (this.breakPolicy & 1) != 0;
    }

    private boolean isBreakAfter() {
        return (this.breakPolicy & 2) != 0;
    }

    public int getBreakPolicy() {
        return this.breakPolicy;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
            return null;
        }
    }

    public String toString() {
        return this.elementExpression + " before? " + this.isBreakBefore() + " after " + this.isBreakAfter();
    }

    public void setElementExpression(String string) {
        this.elementExpression = string;
    }

    public void setBreakPolicy(int n2) {
        this.breakPolicy = n2;
    }
}

