/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Crypto;
import ro.sync.options.InvalidPersistentObjException;
import ro.sync.options.PersistentObject;
import ro.sync.options.SerializableList;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class UserPreferredURLs
implements PersistentObject {
    private static final Logger logger = LoggerFactory.getLogger((String)UserPreferredURLs.class.getName());
    private SerializableList keys = new SerializableList();
    private SerializableList urlLists = new SerializableList();
    private static int MAX_URLS_IN_LIST = 10;

    @Override
    public void checkValid() throws InvalidPersistentObjException {
        if (this.keys == null || this.urlLists == null) {
            throw new InvalidPersistentObjException("Fields are null " + this.keys + ":" + this.urlLists);
        }
        if (this.keys.size() != this.urlLists.size()) {
            throw new InvalidPersistentObjException("Fields sizes are not consistent " + this.keys.size() + ":" + this.urlLists.size());
        }
    }

    public void addURL(String string, String string2) {
        string = Crypto.crypt((String)string);
        boolean bl = false;
        if (this.keys == null || this.urlLists == null) {
            this.keys = new SerializableList();
            this.urlLists = new SerializableList();
        }
        for (int i2 = 0; i2 < this.keys.size(); ++i2) {
            if (!string2.equals(this.keys.get(i2))) continue;
            SerializableList<String> serializableList = (SerializableList<String>)this.urlLists.get(i2);
            if (serializableList == null) {
                serializableList = new SerializableList<String>();
                this.urlLists.set(i2, serializableList);
            } else if (serializableList.size() >= MAX_URLS_IN_LIST) {
                serializableList.remove(serializableList.size() - 1);
            }
            bl = true;
            serializableList.add(0, string);
            break;
        }
        if (!bl) {
            this.keys.add(string2);
            SerializableList<String> serializableList = new SerializableList<String>(1);
            serializableList.add(string);
            this.urlLists.add(serializableList);
        }
    }

    public void removeURL(String string, String string2) {
        string = Crypto.crypt((String)string);
        if (this.keys != null && this.urlLists != null) {
            for (int i2 = 0; i2 < this.keys.size(); ++i2) {
                if (!string2.equals(this.keys.get(i2))) continue;
                SerializableList serializableList = (SerializableList)this.urlLists.get(i2);
                if (serializableList == null || !serializableList.contains(string)) break;
                serializableList.remove(string);
                break;
            }
        }
    }

    public void clearURLs(String string) {
        if (this.keys != null && this.urlLists != null) {
            for (int i2 = 0; i2 < this.keys.size(); ++i2) {
                if (!string.equals(this.keys.get(i2))) continue;
                SerializableList serializableList = (SerializableList)this.urlLists.get(i2);
                if (serializableList == null) break;
                serializableList.clear();
                break;
            }
        }
    }

    public String[] getURLs(String string) {
        String[] stringArray = new String[]{};
        if (this.keys != null) {
            for (int i2 = 0; i2 < this.keys.size(); ++i2) {
                SerializableList serializableList;
                if (!string.equals(this.keys.get(i2)) || (serializableList = (SerializableList)this.urlLists.get(i2)) == null) continue;
                String[] stringArray2 = serializableList.toArray(new String[0]);
                SerializableList<String> serializableList2 = new SerializableList<String>(stringArray2.length);
                for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                    String string2 = Crypto.decrypt((String)stringArray2[i3]);
                    if (string2 == null) continue;
                    serializableList2.add(string2);
                }
                stringArray = serializableList2.toArray(new String[0]);
                break;
            }
        }
        return stringArray;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        UserPreferredURLs userPreferredURLs = null;
        try {
            userPreferredURLs = (UserPreferredURLs)super.clone();
            if (this.keys != null) {
                userPreferredURLs.keys = (SerializableList)this.keys.clone();
            }
            if (this.urlLists != null) {
                userPreferredURLs.urlLists = (SerializableList)this.urlLists.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error((Object)cloneNotSupportedException, (Throwable)cloneNotSupportedException);
        }
        return userPreferredURLs;
    }
}

