/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.webapp.plugin;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.extensions.api.webapp.plugin.ServletPluginExtension;
import ro.sync.ecss.extensions.api.webapp.plugin.WebappServletPluginExtension;
import ro.sync.ecss.webapp.plugin.b.b.d;
import ro.sync.exml.options.Options;
import ro.sync.exml.plugin.PluginDescriptor;
import ro.sync.exml.plugin.PluginManager;

@SkipObfuscate
public class WebappPluginsServletDispatcher
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)WebappPluginsServletDispatcher.class.getName());
    private Map<String, WebappServletPluginExtension> webappPluginServlets;

    public static void init(ServletContext servletContext) {
        String string = servletContext.getRealPath("/");
        if (string != null) {
            String string2 = new File(string, "WEB-INF/lib/").getAbsolutePath();
            System.setProperty("com.oxygenxml.editor.lib.dir", string2);
        }
    }

    public void init() throws ServletException {
        PluginManager pluginManager = PluginManager.getInstance();
        List<PluginDescriptor> list = pluginManager.getPluginDescriptors();
        this.webappPluginServlets = new HashMap<String, WebappServletPluginExtension>();
        for (PluginDescriptor pluginDescriptor : list) {
            if (pluginDescriptor.isDisabledFromFile()) continue;
            for (PluginDescriptor.PluginExtensionDescription pluginExtensionDescription : pluginDescriptor.getExtensions("WebappServlet")) {
                String string;
                WebappServletPluginExtension webappServletPluginExtension;
                if (pluginExtensionDescription.k instanceof WebappServletPluginExtension) {
                    logger.debug("The '{}' plugin uses deprecated WebappServletPluginExtension extension, see {}", (Object)pluginExtensionDescription.b, pluginExtensionDescription.k.getClass());
                    webappServletPluginExtension = (WebappServletPluginExtension)pluginExtensionDescription.k;
                } else {
                    webappServletPluginExtension = new d((ServletPluginExtension)pluginExtensionDescription.k);
                }
                if ((string = WebappPluginsServletDispatcher.adjustPath(webappServletPluginExtension.getPath())) == null || string.isEmpty()) continue;
                WebappServletPluginExtension webappServletPluginExtension2 = this.webappPluginServlets.get(string);
                if (webappServletPluginExtension2 != null) {
                    logger.warn("More thant one plugin servlet are mapped to the path : '{}' \n   Overriding the first one.", (Object)string);
                }
                logger.debug("registering webapp plugin servlet with path :{}", (Object)string);
                this.webappPluginServlets.put(string, webappServletPluginExtension);
                try {
                    webappServletPluginExtension.init(this.getServletConfig());
                }
                catch (ServletException servletException) {
                    throw servletException;
                }
                catch (Throwable throwable) {
                    System.out.println("Ignored Servlet plugin exception : :" + throwable.getMessage());
                    throwable.printStackTrace();
                }
            }
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.webappPluginServlets::size;
        logger.debug("Registered {} webapp plugin servlets.", supplierArray);
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getPathInfo();
        String string2 = WebappPluginsServletDispatcher.adjustPath(string);
        WebappServletPluginExtension webappServletPluginExtension = this.webappPluginServlets.get(string2);
        if (webappServletPluginExtension != null) {
            Object object;
            if (webappServletPluginExtension.requiresAuthorization()) {
                object = (Boolean)httpServletRequest.getSession().getAttribute("com.oxygenxml.webapp.isAdmin");
                if (!WebappPluginsServletDispatcher.isAdminPageEnabled()) {
                    httpServletResponse.setStatus(404);
                    return;
                }
                if (!Boolean.TRUE.equals(object)) {
                    httpServletResponse.setStatus(401);
                    return;
                }
                httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                httpServletResponse.setHeader("Pragma", "no-cache");
                httpServletResponse.setDateHeader("Expires", 0L);
            }
            object = httpServletRequest.getMethod();
            boolean bl = webappServletPluginExtension instanceof d;
            if (bl && httpServletRequest.getHeader("X-Requested-With") == null && !"GET".equals(object) && !"PROPFIND".equals(object)) {
                String string3 = httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "");
                logger.error((String)object + " request denied by CSRF security to " + string3 + ". For more information, see: https://www.oxygenxml.com/doc/ug-waCustom/topics/wa-csrf.html");
                httpServletResponse.setStatus(400);
                return;
            }
            webappServletPluginExtension.service(httpServletRequest, httpServletResponse);
        } else {
            httpServletResponse.setStatus(404);
            if (!string2.isEmpty()) {
                logger.warn("No plugin defined for path : '{}', taken from request path: '{}'", (Object)string2, (Object)string);
            }
        }
    }

    private static boolean isAdminPageEnabled() {
        boolean bl = Options.getInstance().getBooleanProperty("ADMIN_PAGE_IS_DISABLED");
        boolean bl2 = Boolean.parseBoolean(System.getenv("ADMIN_PAGE_IS_DISABLED"));
        return !bl && !bl2;
    }

    private static String adjustPath(String string) {
        if (string != null && !string.isEmpty()) {
            string = string.charAt(0) == '/' ? string.substring(1) : string;
            string = string.split("/")[0].trim();
        }
        return string;
    }
}

