/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.support;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.WidthRepresentation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CALSColSpec {
    private int colNumber;
    private String colName;
    private WidthRepresentation colWidth;
    private final boolean colNumberSpecified;
    private final int indexInDocument;
    private String align;
    private Boolean colSep;
    private Boolean rowSep;

    public Boolean getColSep() {
        return this.colSep;
    }

    public Boolean getRowSep() {
        return this.rowSep;
    }

    public CALSColSpec(int n2, int n3, boolean bl, String string, String string2, Boolean bl2, Boolean bl3) {
        this.indexInDocument = n2;
        this.colNumber = n3;
        this.colNumberSpecified = bl;
        this.colName = string;
        if (string2 != null) {
            this.colWidth = new WidthRepresentation(string2, false);
        }
        this.colSep = bl2;
        this.rowSep = bl3;
    }

    public CALSColSpec(int n2, int n3, boolean bl, String string, WidthRepresentation widthRepresentation) {
        this.indexInDocument = n2;
        this.colNumber = n3;
        this.colNumberSpecified = bl;
        this.colName = string;
        this.colWidth = widthRepresentation;
    }

    public boolean isColNumberSpecified() {
        return this.colNumberSpecified;
    }

    public int getIndexInDocument() {
        return this.indexInDocument;
    }

    public int getColumnNumber() {
        return this.colNumber;
    }

    public String getColumnName() {
        return this.colName;
    }

    public WidthRepresentation getColWidth() {
        return this.colWidth;
    }

    public String toString() {
        String string = this.colWidth != null ? " width: " + this.colWidth : "";
        return this.getColumnName() + " at index: " + this.getColumnNumber() + string;
    }

    public String createXMLFragment(String string) {
        StringBuilder stringBuilder = new StringBuilder("<colspec");
        if (this.colNumber > 0) {
            stringBuilder.append(" colnum=\"").append(this.colNumber).append('\"');
        }
        CALSColSpec.appendAttrWithValue(stringBuilder, "colname", this.colName, true);
        if (this.colWidth != null) {
            String string2 = this.colWidth.getWidthRepresentation();
            CALSColSpec.appendAttrWithValue(stringBuilder, "colwidth", string2, true);
        }
        CALSColSpec.appendAttrWithValue(stringBuilder, "xmlns", string, false);
        stringBuilder.append("/>");
        return stringBuilder.toString();
    }

    private static void appendAttrWithValue(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (string2 != null && (bl || !string2.isEmpty())) {
            stringBuilder.append(' ').append(string).append("=\"").append(string2).append('\"');
        }
    }

    public void setColWidth(WidthRepresentation widthRepresentation) {
        this.colWidth = widthRepresentation;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String string) {
        this.align = string;
        if (this.colWidth != null) {
            this.colWidth.setAlign(string);
        }
    }
}

