/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.table.properties.TableHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class TableOperationsUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)TableOperationsUtil.class.getName());

    private TableOperationsUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String createCellXMLFragment(AuthorAccess authorAccess, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, String string, int n2, String string2, AuthorTableHelper authorTableHelper, String ... stringArray) throws AuthorOperationException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (authorDocumentFragmentArray.length > n2) {
            AuthorNode authorNode;
            Object object2;
            object = authorDocumentFragmentArray[n2];
            if (bl && (object2 = ((AuthorDocumentFragment)object).getContentNodes()).size() == 1 && (authorNode = (AuthorNode)object2.get(0)) instanceof AuthorElement) {
                AuthorElement authorElement = (AuthorElement)authorNode;
                int n3 = authorElement.getAttributesCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    AttrValue attrValue;
                    String string3 = authorElement.getAttributeAtIndex(i2);
                    if (string3 == null || string3.startsWith("xmlns") || TableOperationsUtil.isIgnoredAttribute(string3, authorTableHelper) || !(attrValue = authorElement.getAttribute(string3)).isSpecified()) continue;
                    String string4 = attrValue.getRawValue();
                    stringBuilder.append(" " + string3 + "=\"" + string4 + "\"");
                }
            }
            if ((object2 = TableOperationsUtil.getContentFromFragment(authorAccess, bl, (AuthorDocumentFragment)object)) != null) {
                stringBuilder2.append((String)object2);
            }
        }
        object = new StringBuilder("<");
        ((StringBuilder)object).append(string);
        if (string2 != null) {
            ((StringBuilder)object).append(" xmlns=\"" + string2 + "\"");
        }
        if (stringArray != null) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                ((StringBuilder)object).append(" ").append(stringArray[i3]);
            }
        }
        ((StringBuilder)object).append(stringBuilder.toString());
        String string5 = stringBuilder2.toString();
        if (string5.length() == 0) {
            ((StringBuilder)object).append("/>");
        } else {
            ((StringBuilder)object).append(">");
            ((StringBuilder)object).append(string5);
            ((StringBuilder)object).append("</").append(string).append(">");
        }
        return ((StringBuilder)object).toString();
    }

    public static boolean isIgnoredAttribute(String string, AuthorTableHelper authorTableHelper) {
        int n2;
        boolean bl = false;
        String[] stringArray = authorTableHelper.getIgnoredColumnAttributes();
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!string.equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
        }
        if (!bl && (stringArray = authorTableHelper.getIgnoredRowAttributes()) != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!string.equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String getContentFromFragment(AuthorAccess authorAccess, boolean bl, AuthorDocumentFragment authorDocumentFragment) {
        String string = null;
        try {
            if (bl) {
                AuthorDocumentFragment authorDocumentFragment2 = authorAccess.getDocumentController().unwrapDocumentFragment(authorDocumentFragment);
                if (authorDocumentFragment2 != null) {
                    string = authorAccess.getDocumentController().serializeFragmentToXML(authorDocumentFragment2);
                }
            } else {
                string = authorAccess.getDocumentController().serializeFragmentToXML(authorDocumentFragment);
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return string;
    }

    public static boolean nodeHasProperties(AuthorNode authorNode, String string, String string2) {
        boolean bl = false;
        bl = string2 == null || "".equals(string2) ? authorNode.getNamespace() == null || "".equals(authorNode.getNamespace()) : string2.equals(authorNode.getNamespace());
        if (bl) {
            String string3 = authorNode.getName();
            int n2 = string3.indexOf(58);
            if (n2 > 0) {
                string3 = string3.substring(n2);
            }
            bl = string3.equals(string);
        }
        return bl;
    }

    public static AuthorElement getTableElementContainingOffset(int n2, AuthorAccess authorAccess, String ... stringArray) {
        AuthorElement authorElement;
        block4: {
            authorElement = null;
            try {
                AuthorNode authorNode;
                if (stringArray == null || stringArray.length <= 0) break block4;
                AuthorElement authorElement2 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
                if (authorNode == null || authorNode.getStartOffset() <= authorElement2.getStartOffset() || authorNode.getEndOffset() >= authorElement2.getEndOffset()) break block4;
                for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode != authorElement2; authorNode = authorNode.getParent()) {
                    String string;
                    AuthorElement authorElement3;
                    AttrValue attrValue;
                    if (!(authorNode instanceof AuthorElement) || (attrValue = (authorElement3 = (AuthorElement)authorNode).getAttribute("class")) == null || (string = attrValue.getRawValue()) == null) continue;
                    for (String string2 : stringArray) {
                        if (!string.contains(string2)) continue;
                        authorElement = authorElement3;
                        break block4;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                logger.warn((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return authorElement;
    }

    public static AuthorElement getTableElementContainingOffset(int n2, String string, AuthorAccess authorAccess, String ... stringArray) {
        AuthorElement authorElement;
        block4: {
            authorElement = null;
            try {
                AuthorNode authorNode;
                if (stringArray == null || stringArray.length <= 0) break block4;
                AuthorElement authorElement2 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
                if (authorNode == null || authorNode.getStartOffset() <= authorElement2.getStartOffset() || authorNode.getEndOffset() >= authorElement2.getEndOffset()) break block4;
                for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2); authorNode != authorElement2; authorNode = authorNode.getParent()) {
                    if (!(authorNode instanceof AuthorElement)) continue;
                    for (String string2 : stringArray) {
                        if (!TableOperationsUtil.nodeHasProperties(authorNode, string2, string)) continue;
                        authorElement = (AuthorElement)authorNode;
                        break block4;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                logger.warn((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return authorElement;
    }

    public static boolean isChoiceTableAllowed(AuthorAccess authorAccess) {
        boolean bl = false;
        try {
            AuthorElement authorElement;
            Object object;
            Object object2;
            int n2 = authorAccess.getEditorAccess().getCaretOffset();
            AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
            WhatElementsCanGoHereContext whatElementsCanGoHereContext = authorSchemaManager.createWhatElementsCanGoHereContext(n2);
            if (whatElementsCanGoHereContext != null && (object2 = authorSchemaManager.whatElementsCanGoHere(whatElementsCanGoHereContext)) != null) {
                block2: for (int i2 = 0; i2 < object2.size(); ++i2) {
                    object = (CIElement)object2.get(i2);
                    List<CIAttribute> list = object.getAttributesWithDefaultValues();
                    if (list == null) continue;
                    for (int i3 = 0; i3 < list.size(); ++i3) {
                        CIAttribute cIAttribute = list.get(i3);
                        String string = cIAttribute.getDefaultValue();
                        if (!"class".equals(cIAttribute.getName()) || string == null || !string.contains(" task/choicetable ")) continue;
                        bl = true;
                        break block2;
                    }
                }
            }
            if (!bl && (object2 = authorAccess.getDocumentController().getNodeAtOffset(n2)) instanceof AuthorElement && (object = (authorElement = (AuthorElement)object2).getAttribute("class")) != null && ((AttrValue)object).getValue() != null && (((AttrValue)object).getValue().contains(" task/step ") || ((AttrValue)object).getValue().contains("task/cmd"))) {
                bl = true;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.warn((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }

    public static boolean areOtherTablesThanChoicetableAllowed(AuthorAccess authorAccess) {
        boolean bl;
        block4: {
            bl = false;
            try {
                List<CIElement> list;
                int n2 = authorAccess.getEditorAccess().getCaretOffset();
                AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
                WhatElementsCanGoHereContext whatElementsCanGoHereContext = authorSchemaManager.createWhatElementsCanGoHereContext(n2);
                if (whatElementsCanGoHereContext == null || (list = authorSchemaManager.whatElementsCanGoHere(whatElementsCanGoHereContext)) == null) break block4;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    CIElement cIElement = list.get(i2);
                    List<CIAttribute> list2 = cIElement.getAttributesWithDefaultValues();
                    if (list2 == null) continue;
                    for (int i3 = 0; i3 < list2.size(); ++i3) {
                        CIAttribute cIAttribute = list2.get(i3);
                        String string = cIAttribute.getDefaultValue();
                        if (!"class".equals(cIAttribute.getName()) || string == null || !string.contains(" topic/table ") && (!string.contains(" topic/simpletable ") || string.contains(" task/choicetable "))) continue;
                        bl = true;
                        break block4;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                logger.warn((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return bl;
    }

    public static boolean isPropertiesTableGlobalElement(AuthorAccess authorAccess) {
        boolean bl = false;
        AuthorSchemaManager authorSchemaManager = authorAccess.getDocumentController().getAuthorSchemaManager();
        List<CIElement> list = authorSchemaManager.getGlobalElements();
        if (list != null) {
            block0: for (int i2 = 0; i2 < list.size(); ++i2) {
                CIElement cIElement = list.get(i2);
                List<CIAttribute> list2 = cIElement.getAttributesWithDefaultValues();
                if (list2 == null) continue;
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    CIAttribute cIAttribute = list2.get(i3);
                    String string = cIAttribute.getDefaultValue();
                    if (!"class".equals(cIAttribute.getName()) || string == null || !string.contains(" reference/properties ")) continue;
                    bl = true;
                    break block0;
                }
            }
        }
        return bl;
    }

    public static List<AuthorElement> getTableElementsOfTypeFromSelection(AuthorAccess authorAccess, int n2, TableHelper tableHelper, AuthorElement authorElement) {
        List<ContentInterval> list = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        if (list != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                int n3 = list.get(i2).getStartOffset();
                int n4 = list.get(i2).getEndOffset();
                if ((authorElement.getStartOffset() > n3 || n3 > authorElement.getEndOffset()) && (authorElement.getStartOffset() > n4 || n4 > authorElement.getEndOffset())) continue;
                arrayList.add(new Integer[]{n3, n4});
            }
        }
        return TableOperationsUtil.getTableElementsOfType(authorAccess, arrayList, n2, tableHelper);
    }

    public static List<AuthorElement> getTableElementsOfType(AuthorAccess authorAccess, List<Integer[]> list, int n2, TableHelper tableHelper) {
        ArrayList<AuthorElement> arrayList = new ArrayList<AuthorElement>();
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Integer[] integerArray = list.get(i2);
                int n3 = integerArray[0];
                int n4 = integerArray[1];
                List<Object> list2 = null;
                if (n3 != n4) {
                    list2 = authorAccess.getDocumentController().getNodesToSelect(n3, n4);
                } else {
                    list2 = new ArrayList<AuthorNode>();
                    list2.add(authorAccess.getDocumentController().getNodeAtOffset(n3));
                }
                for (int i3 = 0; i3 < list2.size(); ++i3) {
                    AuthorNode authorNode = (AuthorNode)list2.get(i3);
                    if (!(authorNode instanceof AuthorElement)) continue;
                    TableOperationsUtil.computeElementsList(arrayList, (AuthorElement)authorNode, n3, n4 != -1 ? n4 : n3, n2, false, tableHelper);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            logger.debug(badLocationException.getMessage(), (Throwable)badLocationException);
        }
        return arrayList;
    }

    public static void computeElementsList(List<AuthorElement> list, AuthorElement authorElement, int n2, int n3, int n4, boolean bl, TableHelper tableHelper) {
        int n5;
        AuthorNode authorNode;
        Object object;
        if (tableHelper.isNodeOfType(authorElement, n4) && !list.contains(authorElement)) {
            list.add(authorElement);
        } else if (TableOperationsUtil.getElementAncestor(authorElement, n4, tableHelper) != null) {
            object = TableOperationsUtil.getElementAncestor(authorElement, n4, tableHelper);
            if (!list.contains(object)) {
                list.add((AuthorElement)object);
            }
        } else if (n4 != 5) {
            object = new ArrayList();
            TableOperationsUtil.getChildElements(authorElement, n4, (List<AuthorElement>)object, tableHelper);
            for (int i2 = 0; i2 < object.size(); ++i2) {
                boolean bl2;
                authorNode = (AuthorElement)object.get(i2);
                int n6 = authorNode.getStartOffset();
                n5 = authorNode.getEndOffset();
                boolean bl3 = n2 >= n6 && n2 <= n5 || n3 > n6 && n3 <= n5 || n6 >= n2 && n6 < n3 || n5 >= n2 && n5 < n3;
                boolean bl4 = bl2 = n2 == n3 || !bl && bl3 || bl && n6 >= n2 && n5 <= n3;
                if (!bl2 || list.contains(authorNode)) continue;
                list.add((AuthorElement)authorNode);
            }
        }
        if (n4 == 5) {
            for (int i3 = 0; i3 < list.size(); ++i3) {
                AuthorElement authorElement2 = list.get(i3);
                authorNode = authorElement2.getParent();
                if (authorNode instanceof AuthorElement && tableHelper.isTable((AuthorElement)authorNode) && !list.contains(authorNode)) {
                    list.add((AuthorElement)authorNode);
                }
                List<AuthorNode> list2 = authorElement.getContentNodes();
                for (n5 = 0; n5 < list2.size(); ++n5) {
                    AuthorNode authorNode2 = list2.get(n5);
                    if (!(authorNode2 instanceof AuthorElement) || !tableHelper.isTable((AuthorElement)authorNode2) || !tableHelper.isTableGroup((AuthorElement)authorNode2) || list.contains(authorNode2)) continue;
                    list.add((AuthorElement)authorNode2);
                }
            }
        }
    }

    public static AuthorElement getElementAncestor(AuthorNode authorNode, int n2, TableHelper tableHelper) {
        AuthorElement authorElement = null;
        while (authorNode instanceof AuthorElement) {
            if (tableHelper.isNodeOfType((AuthorElement)authorNode, n2)) {
                authorElement = (AuthorElement)authorNode;
                break;
            }
            authorNode = authorNode.getParent();
        }
        return authorElement;
    }

    public static void getChildElements(AuthorElement authorElement, int n2, List<AuthorElement> list, TableHelper tableHelper) {
        if (tableHelper.isNodeOfType(authorElement, n2)) {
            list.add(authorElement);
        } else {
            List<AuthorNode> list2 = authorElement.getContentNodes();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                AuthorNode authorNode = list2.get(i2);
                if (authorNode.getType() != 0) continue;
                TableOperationsUtil.getChildElements((AuthorElement)authorNode, n2, list, tableHelper);
            }
        }
    }

    public static Map<AuthorElement, Set<Integer>> getCellIndexes(List<AuthorElement> list, AuthorAccess authorAccess, TableHelper tableHelper, boolean bl) {
        HashMap<AuthorElement, Set<Integer>> hashMap = new HashMap<AuthorElement, Set<Integer>>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            AuthorElement authorElement = TableOperationsUtil.getElementAncestor(list.get(i2), bl ? 4 : 5, tableHelper);
            HashSet<Integer> hashSet = (HashSet<Integer>)hashMap.get(authorElement);
            if (hashSet == null) {
                hashSet = new HashSet<Integer>();
            }
            if (bl) {
                int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(list.get(i2));
                for (int i3 = 0; nArray != null && i3 < nArray.length; ++i3) {
                    hashSet.add(nArray[i3] + 1);
                }
            } else {
                hashSet.add(authorAccess.getTableAccess().getTableCellIndex(list.get(i2))[1]);
            }
            hashMap.put(authorElement, hashSet);
        }
        return hashMap;
    }

    public static TableHelper createTableHelper(final AuthorTableHelper authorTableHelper) {
        return new TableHelper(){

            @Override
            public boolean isTableGroup(AuthorElement authorElement) {
                return false;
            }

            @Override
            public boolean isTable(AuthorElement authorElement) {
                return authorTableHelper.isTable(authorElement);
            }

            @Override
            public boolean isNodeOfType(AuthorElement authorElement, int n2) {
                boolean bl = false;
                switch (n2) {
                    case 0: {
                        bl = authorTableHelper.isTableRow(authorElement);
                        break;
                    }
                    case 5: {
                        bl = authorTableHelper.isTable(authorElement);
                        break;
                    }
                    case 6: {
                        bl = authorTableHelper.isTableCell(authorElement);
                    }
                }
                return bl;
            }
        };
    }

    public static void placeCaretInFirstCell(AuthorAccess authorAccess, TableInfo tableInfo, AuthorDocumentController authorDocumentController, SchemaAwareHandlerResult schemaAwareHandlerResult) {
        Integer n2;
        if (schemaAwareHandlerResult != null && tableInfo.getTitle() == null && (n2 = (Integer)schemaAwareHandlerResult.getResult("result.id.handle.insert.fragment.offset")) != null) {
            try {
                AuthorElement authorElement;
                AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n2 + 1);
                if (authorNode instanceof AuthorElement && (authorElement = TableOperationsUtil.getFirstCell((AuthorElement)authorNode, authorAccess.getEditorAccess())) != null) {
                    authorAccess.getEditorAccess().setCaretPosition(authorElement.getStartOffset() + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                logger.debug(badLocationException.getMessage(), (Throwable)badLocationException);
            }
        }
    }

    private static AuthorElement getFirstCell(AuthorElement authorElement, AuthorEditorAccess authorEditorAccess) {
        AuthorElement authorElement2 = null;
        List<AuthorNode> list = authorElement.getContentNodes();
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AuthorNode authorNode = list.get(i2);
                if (authorNode.getType() != 0) continue;
                AuthorElement authorElement3 = (AuthorElement)authorNode;
                Styles styles = authorEditorAccess.getStyles(authorElement3);
                if ("table-cell".equals(styles.getDisplay())) {
                    authorElement2 = authorElement3;
                } else {
                    AuthorElement authorElement4 = TableOperationsUtil.getFirstCell(authorElement3, authorEditorAccess);
                    if (authorElement4 != null) {
                        authorElement2 = authorElement4;
                    }
                }
                if (authorElement2 != null) break;
            }
        }
        return authorElement2;
    }

    public static void removeInvalidColNamesFromCALSTableCells(AuthorAccess authorAccess, AuthorElement authorElement, List<AuthorElement> list) {
        if (list != null && !list.isEmpty()) {
            CALSTableCellInfoProvider cALSTableCellInfoProvider = new CALSTableCellInfoProvider(false);
            cALSTableCellInfoProvider.init(authorElement);
            Set<CALSColSpec> set = cALSTableCellInfoProvider.getColSpecs();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                AuthorElement authorElement2 = list.get(i2);
                String[] stringArray = new String[]{"colname", "namest", "nameend"};
                HashSet<String> hashSet = new HashSet<String>();
                Iterator<CALSColSpec> iterator = set.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next().getColumnName());
                }
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    boolean bl;
                    AttrValue attrValue = authorElement2.getAttribute(stringArray[i3]);
                    if (attrValue == null || (bl = hashSet.contains(attrValue.getValue()))) continue;
                    authorAccess.getDocumentController().removeAttribute(stringArray[i3], authorElement2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleColumnSpecAttributeChange(AuthorAccess authorAccess, AuthorTableHelper authorTableHelper, AuthorElement authorElement, String string, AttrValue attrValue) {
        boolean bl = false;
        AttrValue attrValue2 = authorElement.getAttribute(string);
        if (attrValue2 != null && attrValue2.isSpecified()) {
            String string2 = attrValue2.getValue();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("colname");
            arrayList.add("namest");
            arrayList.add("nameend");
            if (arrayList.contains(string)) {
                AuthorNode authorNode = null;
                for (AuthorNode authorNode2 = authorElement; authorNode2 != null; authorNode2 = authorNode2.getParent()) {
                    if (!authorAccess.getEditorAccess().getStyles(authorNode2).isTable()) continue;
                    if (authorNode2.getType() != 0) break;
                    authorNode = authorNode2;
                    break;
                }
                HashSet<String> hashSet = new HashSet<String>();
                if (authorNode != null) {
                    Object object;
                    Object object2;
                    AuthorNode authorNode3;
                    int n2;
                    ArrayList<AuthorElement> arrayList2 = new ArrayList<AuthorElement>();
                    List<AuthorNode> list = authorNode.getContentNodes();
                    if (list != null && !list.isEmpty()) {
                        for (n2 = 0; n2 < list.size(); ++n2) {
                            authorNode3 = list.get(n2);
                            if (authorNode3.getType() != 0) continue;
                            AuthorElement authorElement2 = (AuthorElement)authorNode3;
                            if (authorTableHelper.isColspec(authorElement2)) {
                                arrayList2.add(authorElement2);
                                object2 = authorElement2.getAttribute("colname");
                                if (object2 == null || !((AttrValue)object2).isSpecified()) continue;
                                hashSet.add(((AttrValue)object2).getValue());
                                continue;
                            }
                            if (authorTableHelper.isTableRow(authorElement2)) {
                                TableOperationsUtil.iterateCells(authorTableHelper, arrayList2, authorElement2);
                                continue;
                            }
                            object2 = authorAccess.getEditorAccess().getStyles(authorElement2);
                            if (!((Styles)object2).isTableHeaderGroup() && !((Styles)object2).isTableRowGroup() || (object = authorElement2.getContentNodes()) == null) continue;
                            for (int i2 = 0; i2 < object.size(); ++i2) {
                                AuthorNode authorNode4 = (AuthorNode)object.get(i2);
                                if (!authorTableHelper.isTableRow(authorNode4) || authorNode4.getType() != 0) continue;
                                TableOperationsUtil.iterateCells(authorTableHelper, arrayList2, (AuthorElement)authorNode4);
                            }
                        }
                    }
                    if (!arrayList2.isEmpty() && arrayList2.contains(authorElement) && !hashSet.contains(attrValue.getValue())) {
                        bl = true;
                        try {
                            authorAccess.getDocumentController().beginCompoundEdit();
                            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                                authorNode3 = (AuthorElement)arrayList2.get(n2);
                                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                                    object2 = (String)arrayList.get(i3);
                                    object = authorNode3.getAttribute((String)object2);
                                    if (object == null || !((AttrValue)object).isSpecified() || !string2.equals(((AttrValue)object).getValue())) continue;
                                    authorAccess.getDocumentController().setAttribute((String)object2, attrValue, (AuthorElement)authorNode3);
                                }
                            }
                        }
                        finally {
                            authorAccess.getDocumentController().endCompoundEdit();
                        }
                    }
                }
            }
        }
        return bl;
    }

    private static void iterateCells(AuthorTableHelper authorTableHelper, List<AuthorElement> list, AuthorElement authorElement) {
        List<AuthorNode> list2 = authorElement.getContentNodes();
        if (list2 != null) {
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                AuthorNode authorNode = list2.get(i2);
                if (!authorTableHelper.isTableCell(authorNode) || authorNode.getType() != 0) continue;
                list.add((AuthorElement)authorNode);
            }
        }
    }
}

