/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.access.AuthorTableAccess;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.SplitCellAboveBelowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class JoinOperationBase
extends AbstractTableOperation {
    public static final String CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE = "Please place the cursor inside the table before invoking the Join operation.";
    public static final String SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE = "Select at least two adjacent cells before invoking the Join operation.";
    public static final String RECTANGULAR_SELECTIONS_ERROR_MESSAGE = "Select a rectangular section of the table before invoking the Join operation.";
    private static final String ROW_COL_SEPARATOR = "-";

    public JoinOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doOperationInternal(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        try {
            List<AuthorElement> list;
            if (!authorAccess.getEditorAccess().hasSelection()) {
                AuthorOperationException authorOperationException = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            AuthorElement authorElement = this.getElementAncestor(authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()), 2);
            if (authorElement == null) {
                AuthorOperationException authorOperationException = new AuthorOperationException(CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            List<ContentInterval> list2 = authorAccess.getEditorAccess().getAuthorSelectionModel().getSelectionIntervals();
            ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
            if (list2 != null && !list2.isEmpty()) {
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    int n2 = list2.get(i2).getStartOffset();
                    int n3 = list2.get(i2).getEndOffset();
                    if ((authorElement.getStartOffset() > n2 || n2 > authorElement.getEndOffset()) && (authorElement.getStartOffset() > n3 || n3 > authorElement.getEndOffset())) continue;
                    arrayList.add(new Integer[]{n2, n3});
                }
            }
            if ((list = TableOperationsUtil.getTableElementsOfType(authorAccess, arrayList, 6, TableOperationsUtil.createTableHelper(this.tableHelper))) != null && list.size() > 1) {
                this.joinCells(authorAccess, authorElement, list);
                return;
            }
            AuthorOperationException authorOperationException = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
        catch (BadLocationException badLocationException) {
            AuthorOperationException authorOperationException = new AuthorOperationException(CURSOR_OUTSIDE_THE_TABLE_ERROR_MESSAGE, badLocationException);
            authorOperationException.setOperationRejectedOnPurpose(true);
            throw authorOperationException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinCells(AuthorAccess authorAccess, AuthorElement authorElement, List<AuthorElement> list) throws AuthorOperationException, BadLocationException {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        HashMap<String, AuthorNode> hashMap = new HashMap<String, AuthorNode>();
        AuthorTableAccess authorTableAccess = authorAccess.getTableAccess();
        for (AuthorElement authorElement2 : list) {
            object = authorTableAccess.getTableRowSpanIndices(authorElement2);
            int[] nArray = authorTableAccess.getTableColSpanIndices(authorElement2);
            n5 = object[0];
            int n6 = object[1];
            int n7 = nArray[0];
            int n8 = nArray[1];
            for (int i2 = n5; i2 <= n6; ++i2) {
                for (int i3 = n7; i3 <= n8; ++i3) {
                    hashMap.put(i2 + ROW_COL_SEPARATOR + i3, authorElement2);
                }
            }
        }
        int n9 = authorTableAccess.getTableNumberOfColumns(authorElement);
        int n10 = authorTableAccess.getTableRowCount(authorElement);
        object = new ArrayList();
        for (int i4 = 0; i4 < n10; ++i4) {
            for (n5 = 0; n5 < n9; ++n5) {
                int[] nArray = new int[]{i4, n5};
                String string = nArray[0] + ROW_COL_SEPARATOR + nArray[1];
                AuthorNode authorNode = (AuthorNode)hashMap.remove(string);
                if (authorNode == null) continue;
                HashMap<String, AuthorNode> hashMap2 = new HashMap<String, AuthorNode>();
                JoinGroupInformation joinGroupInformation = new JoinGroupInformation();
                joinGroupInformation.startRow = i4;
                joinGroupInformation.startColumn = n5;
                joinGroupInformation.endRow = i4;
                joinGroupInformation.endColumn = n5;
                joinGroupInformation.groupMap = hashMap2;
                this.populateJoinGroupStartingFrom(joinGroupInformation, authorNode, string, hashMap);
                if (hashMap2.size() <= 1) continue;
                boolean bl = true;
                block8: for (n4 = joinGroupInformation.startRow; n4 <= joinGroupInformation.endRow; ++n4) {
                    for (n3 = joinGroupInformation.startColumn; n3 <= joinGroupInformation.endColumn; ++n3) {
                        if (hashMap2.containsKey(n4 + ROW_COL_SEPARATOR + n3)) continue;
                        bl = false;
                        continue block8;
                    }
                }
                if (bl) {
                    object.add(joinGroupInformation);
                    continue;
                }
                AuthorOperationException authorOperationException = new AuthorOperationException(RECTANGULAR_SELECTIONS_ERROR_MESSAGE);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
        }
        AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
        ArrayList<AuthorElement> arrayList = null;
        Position position = null;
        Position position2 = null;
        try {
            int n11;
            authorAccess.getDocumentController().disableLayoutUpdate();
            if (!authorTableCellSpanProvider.hasColumnSpecifications(authorElement) && authorAccess.getWorkspaceAccess().showConfirmDialog("Column specifications", "Join cells operation requires column specifications. Do you want to generate them?", new String[]{"Yes", "No"}, new int[]{1, 0}) == 1) {
                this.generateColumnSpecifications(authorAccess, authorTableCellSpanProvider, authorElement);
            }
            if ((n11 = object.size()) == 0) {
                AuthorOperationException authorOperationException = new AuthorOperationException(SELECT_AT_LEAST_TWO_ADJACENT_CELLS_ERROR_MESSAGE);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            for (n2 = n11 - 1; n2 >= 0; --n2) {
                int n12;
                int n13;
                JoinGroupInformation joinGroupInformation = (JoinGroupInformation)object.get(n2);
                Map<String, AuthorNode> map = joinGroupInformation.groupMap;
                n4 = joinGroupInformation.startRow;
                n3 = joinGroupInformation.startColumn;
                AuthorNode authorNode = map.get(n4 + ROW_COL_SEPARATOR + n3);
                AuthorNode authorNode2 = map.get(joinGroupInformation.startRow + ROW_COL_SEPARATOR + joinGroupInformation.endColumn);
                if (!(authorNode instanceof AuthorElement) || !(authorNode2 instanceof AuthorElement)) continue;
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, (AuthorElement)authorNode);
                this.tableHelper.checkTableColSpanIsDefined(authorAccess, authorTableCellSpanProvider, (AuthorElement)authorNode2);
                this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, (AuthorElement)authorNode, n3 + 1, joinGroupInformation.endColumn + 1);
                this.tableHelper.updateTableRowSpan(authorAccess, (AuthorElement)authorNode, joinGroupInformation.endRow - joinGroupInformation.startRow + 1);
                for (n13 = joinGroupInformation.startRow; n13 <= joinGroupInformation.endRow; ++n13) {
                    for (n12 = joinGroupInformation.startColumn; n12 <= joinGroupInformation.endColumn; ++n12) {
                        AuthorNode authorNode3 = map.get(n13 + ROW_COL_SEPARATOR + n12);
                        if (!(authorNode3 instanceof AuthorElement) || authorNode3 == authorNode) continue;
                        AuthorElement authorElement3 = (AuthorElement)authorNode3;
                        AuthorDocumentFragment authorDocumentFragment = null;
                        if (authorElement3.getEndOffset() - authorElement3.getStartOffset() > 1) {
                            authorDocumentFragment = authorAccess.getDocumentController().createDocumentFragment(authorElement3.getStartOffset() + 1, authorElement3.getEndOffset() - 1);
                        }
                        AuthorNode authorNode4 = authorElement3.getParent();
                        authorAccess.getDocumentController().deleteNode(authorElement3);
                        if (authorNode4 instanceof AuthorElement && authorNode4.getStartOffset() + 1 == authorNode4.getEndOffset()) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<AuthorElement>(1);
                            }
                            arrayList.add((AuthorElement)authorNode4);
                        }
                        if (authorDocumentFragment == null) continue;
                        authorAccess.getDocumentController().insertFragment(authorNode.getEndOffset(), authorDocumentFragment);
                    }
                }
                n13 = authorNode.getStartOffset();
                n12 = authorNode.getEndOffset();
                authorAccess.getEditorAccess().select(n13, n12 + 1);
                position = authorAccess.getDocumentController().createPositionInContent(n13);
                position2 = authorAccess.getDocumentController().createPositionInContent(n12 + 1);
            }
        }
        finally {
            authorAccess.getDocumentController().enableLayoutUpdate(authorElement);
        }
        if (arrayList != null) {
            DeleteRowOperationBase deleteRowOperationBase = new DeleteRowOperationBase(this.tableHelper){

                @Override
                protected SplitCellAboveBelowOperationBase createSplitCellOperation() {
                    return null;
                }
            };
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                AuthorElement authorElement4 = (AuthorElement)arrayList.get(n2);
                deleteRowOperationBase.performDeleteRows(authorAccess, authorElement4.getStartOffset(), authorElement4.getEndOffset() + 1);
            }
            if (position != null && position2 != null) {
                authorAccess.getEditorAccess().select(position.getOffset(), position2.getOffset());
            }
        }
    }

    private void populateJoinGroupStartingFrom(JoinGroupInformation joinGroupInformation, AuthorNode authorNode, String string, Map<String, AuthorNode> map) throws AuthorOperationException {
        joinGroupInformation.groupMap.put(string, authorNode);
        int n2 = string.indexOf(ROW_COL_SEPARATOR);
        try {
            int n3;
            String string2;
            AuthorNode authorNode2;
            int n4;
            String string3;
            AuthorNode authorNode3;
            int n5 = NumberParserUtil.parseInt((String)string.substring(0, n2));
            int n6 = NumberParserUtil.parseInt((String)string.substring(n2 + 1, string.length()));
            if (n6 > 0 && (authorNode3 = map.remove(string3 = n5 + ROW_COL_SEPARATOR + (n4 = n6 - 1))) != null) {
                AuthorOperationException authorOperationException = new AuthorOperationException(RECTANGULAR_SELECTIONS_ERROR_MESSAGE);
                authorOperationException.setOperationRejectedOnPurpose(true);
                throw authorOperationException;
            }
            n4 = n5 + 1;
            string3 = n4 + ROW_COL_SEPARATOR + n6;
            authorNode3 = map.remove(string3);
            if (authorNode3 != null) {
                joinGroupInformation.endRow = Math.max(joinGroupInformation.endRow, n4);
                this.populateJoinGroupStartingFrom(joinGroupInformation, authorNode3, string3, map);
            }
            if ((authorNode2 = map.remove(string2 = n5 + ROW_COL_SEPARATOR + (n3 = n6 + 1))) != null) {
                joinGroupInformation.endColumn = Math.max(joinGroupInformation.endColumn, n3);
                this.populateJoinGroupStartingFrom(joinGroupInformation, authorNode2, string2, map);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "Join the content of the selected cells.";
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    protected abstract void generateColumnSpecifications(AuthorAccess var1, AuthorTableCellSpanProvider var2, AuthorElement var3) throws AuthorOperationException;

    private static class JoinGroupInformation {
        private int startRow = -1;
        private int endRow = -1;
        private int startColumn = -1;
        private int endColumn = -1;
        private Map<String, AuthorNode> groupMap = new HashMap<String, AuthorNode>();

        private JoinGroupInformation() {
        }
    }
}

