/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.content.TextContentIterator;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.webapp.WebappRestSafe;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
@WebappRestSafe
public class CountWordsOperation
implements AuthorOperation {
    private static final Logger logger = LoggerFactory.getLogger((String)CountWordsOperation.class.getName());
    private static final int WORD_STATE = 0;
    private static final int WHITESPACE_STATE = 1;

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object;
        AuthorResourceBundle authorResourceBundle = authorAccess.getAuthorResourceBundle();
        String string = authorResourceBundle.getMessage("Regular_content");
        String string2 = authorResourceBundle.getMessage("Filtered_content");
        String string3 = authorResourceBundle.getMessage("Read_only_content");
        String string4 = authorResourceBundle.getMessage("Words");
        String string5 = authorResourceBundle.getMessage("Characters");
        String string6 = authorResourceBundle.getMessage("characters_no_spaces");
        String string7 = authorResourceBundle.getMessage("Total");
        int n2 = 0;
        int n3 = authorAccess.getDocumentController().getAuthorDocumentNode().getEndOffset();
        if (authorAccess.getEditorAccess().hasSelection()) {
            n2 = authorAccess.getEditorAccess().getSelectionStart();
            n3 = authorAccess.getEditorAccess().getSelectionEnd() - 1;
        }
        TextContentIterator textContentIterator = authorAccess.getDocumentController().getTextContentIterator(n2, n3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        boolean bl = true;
        while (textContentIterator.hasNext()) {
            object = textContentIterator.next();
            if (!object.inVisibleContent()) continue;
            int n13 = object.getEditableState();
            if (n13 != 2) {
                CharSequence charSequence = object.getText();
                int n14 = charSequence.length();
                int n15 = 0;
                int n16 = 0;
                boolean bl2 = false;
                boolean bl3 = true;
                for (int i2 = 0; i2 < n14; ++i2) {
                    char c2 = charSequence.charAt(i2);
                    if (!Character.isWhitespace(c2)) {
                        if (bl3) {
                            bl3 = false;
                            ++n16;
                        }
                        ++n15;
                        if (i2 != 0) continue;
                        bl2 = true;
                        continue;
                    }
                    if (bl3) continue;
                    bl3 = true;
                }
                if (bl2 && !bl && !CountWordsOperation.isWordStart(authorAccess, object.getTextStartOffset())) {
                    --n16;
                }
                if (n13 == 0) {
                    n5 += n15;
                    n4 += n16;
                    n6 += n14;
                } else if (n13 == 1) {
                    n11 += n15;
                    n10 += n16;
                    n12 += n14;
                } else {
                    n8 += n15;
                    n7 += n16;
                    n9 += n14;
                }
            }
            bl = false;
        }
        object = new StringBuilder();
        if (n7 == 0 && n10 == 0) {
            ((StringBuilder)object).append(string4 + ": ");
            ((StringBuilder)object).append(n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string5 + ": ");
            ((StringBuilder)object).append(n6);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string6 + ": ");
            ((StringBuilder)object).append(n5);
        } else {
            String string8 = "     ";
            ((StringBuilder)object).append(string + ":");
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string4 + ": ");
            ((StringBuilder)object).append(n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string5 + ": ");
            ((StringBuilder)object).append(n6);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string6 + ": ");
            ((StringBuilder)object).append(n5);
            if (n10 > 0) {
                ((StringBuilder)object).append("\n\n");
                ((StringBuilder)object).append(string2 + ":");
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string4 + ": ");
                ((StringBuilder)object).append(n10);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string5 + ": ");
                ((StringBuilder)object).append(n12);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string6 + ": ");
                ((StringBuilder)object).append(n11);
            }
            if (n7 > 0) {
                ((StringBuilder)object).append("\n\n");
                ((StringBuilder)object).append(string3 + ":");
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string4 + ": ");
                ((StringBuilder)object).append(n7);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string5 + ": ");
                ((StringBuilder)object).append(n9);
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(string8);
                ((StringBuilder)object).append(string6 + ": ");
                ((StringBuilder)object).append(n8);
            }
            ((StringBuilder)object).append("\n\n");
            ((StringBuilder)object).append(string7 + ":");
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string4 + ": ");
            ((StringBuilder)object).append(n7 + n10 + n4);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string5 + ": ");
            ((StringBuilder)object).append(n6 + n9 + n12);
            ((StringBuilder)object).append("\n");
            ((StringBuilder)object).append(string8);
            ((StringBuilder)object).append(string6 + ": ");
            ((StringBuilder)object).append(n8 + n11 + n5);
        }
        authorAccess.getWorkspaceAccess().showInformationMessage(((StringBuilder)object).toString());
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return null;
    }

    @Override
    public String getDescription() {
        return "Count words either in the whole document or in the selection.";
    }

    private static boolean isWordStart(AuthorAccess authorAccess, int n2) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        boolean bl = false;
        try {
            CharSequence charSequence = authorDocumentController.getContentCharSequence();
            --n2;
            while (n2 > 1) {
                char c2 = charSequence.charAt(n2);
                if (c2 == '\u0000') {
                    OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n2);
                    AuthorNode authorNode = offsetInformation.getNodeForMarkerOffset();
                    Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
                    if (!styles.isInline()) {
                        bl = true;
                        break;
                    }
                } else {
                    bl = Character.isWhitespace(c2);
                    break;
                }
                --n2;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

