/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.access.AuthorEditorAccess;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.exml.view.graphics.Rectangle;
import ro.sync.exml.workspace.api.Platform;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public final class MoveCaretUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)MoveCaretUtil.class.getName());

    private MoveCaretUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static boolean hasImposedEditorVariableCaretOffset(String string) {
        return string.contains("<?UNIQUE_CARET_MARKER_FOR_AUTHOR?>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveCaretToImposedEditorVariableOffset(AuthorAccess authorAccess, int n2) {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        AuthorNode authorNode = MoveCaretUtil.detectCaretPI(authorDocumentController, n2);
        if (authorNode != null) {
            Rectangle rectangle;
            int n3 = authorNode.getStartOffset();
            AuthorReviewController authorReviewController = authorAccess.getReviewController();
            boolean bl = authorReviewController.isTrackingChanges();
            if (bl) {
                authorReviewController.toggleTrackChanges();
            }
            try {
                authorDocumentController.deleteNode(authorNode);
            }
            finally {
                if (bl) {
                    authorReviewController.toggleTrackChanges();
                }
            }
            AuthorEditorAccess authorEditorAccess = authorAccess.getEditorAccess();
            authorEditorAccess.setCaretPosition(n3);
            if (authorAccess.getWorkspaceAccess().getPlatform() != Platform.WEBAPP && (rectangle = authorEditorAccess.modelToViewRectangle(authorEditorAccess.getCaretOffset())) != null && rectangle.y > 100) {
                rectangle.y -= 100;
                authorEditorAccess.scrollToRectangle(rectangle);
            }
        }
    }

    private static AuthorNode detectCaretPI(AuthorDocumentController authorDocumentController, int n2) {
        try {
            return MoveCaretUtil.detectCaretPI(authorDocumentController.getNodeAtOffset(n2));
        }
        catch (BadLocationException badLocationException) {
            logger.warn((Object)badLocationException, (Throwable)badLocationException);
            return null;
        }
    }

    private static AuthorNode detectCaretPI(AuthorNode authorNode) throws BadLocationException {
        AuthorNode authorNode2 = null;
        if (authorNode.getType() == 5 && authorNode.getTextContent().equals("UNIQUE_CARET_MARKER_FOR_AUTHOR")) {
            authorNode2 = authorNode;
        }
        if (authorNode instanceof AuthorParentNode) {
            List<AuthorNode> list = ((AuthorParentNode)authorNode).getContentNodes();
            Iterator<AuthorNode> iterator = list.iterator();
            while (iterator.hasNext()) {
                AuthorNode authorNode3 = MoveCaretUtil.detectCaretPI(iterator.next());
                if (authorNode3 == null) continue;
                authorNode2 = authorNode3;
                break;
            }
        }
        return authorNode2;
    }
}

