/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import javax.xml.namespace.QName;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ChangeAttributeOperation
implements AuthorOperation {
    static final String ARGUMENT_ATTRIBUTE_NAME = "name";
    static final String ARGUMENT_ATTRIBUTE_NAMESPACE = "namespace";
    static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    static final String ARGUMENT_VALUE = "value";
    private static final String ARGUMENT_EDIT_ATTRIBUTE = "editAttribute";
    private static final String ARGUMENT_REMOVE_IF_EMPTY_VALUE = "removeIfEmpty";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[6];

    public ChangeAttributeOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the element whose attribute will be changed.\nNote: If it is not defined then the element at the caret position will be used.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAME, 0, "The attribute local name.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ATTRIBUTE_NAMESPACE, 0, "The attribute namespace. Leave it empty for no namespace.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_VALUE, 0, "The attribute value. Set it empty to remove the attribute.");
        this.arguments[4] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_REMOVE_IF_EMPTY_VALUE, 3, "True means that the attribute should be removed if an empty value is provided. The default behavior is to remove it.", new String[]{"true", "false"}, "true");
        this.arguments[5] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_EDIT_ATTRIBUTE, 3, "If an in-place editor exists for this attribute, it will automatically activate the in-pace editor and it will start editing.", new String[]{"true", "false"}, "true");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object;
        Object object2;
        AuthorElement authorElement;
        Object object3 = argumentsMap.getArgumentValue(ARGUMENT_VALUE);
        Object object4 = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        Object object5 = argumentsMap.getArgumentValue(ARGUMENT_ATTRIBUTE_NAME);
        Object object6 = argumentsMap.getArgumentValue(ARGUMENT_ATTRIBUTE_NAMESPACE);
        if (!(object5 instanceof String)) throw new IllegalArgumentException("The argument \"name\" was not defined!");
        if (object4 instanceof String && !((String)object4).isEmpty()) {
            AuthorNode[] authorNodeArray = authorAccess.getDocumentController().findNodesByXPath((String)object4, true, true, true);
            if (authorNodeArray.length <= 0 || !(authorNodeArray[0] instanceof AuthorElement)) throw new AuthorOperationException("The element XPath location does not identify an element: " + object4);
            authorElement = (AuthorElement)authorNodeArray[0];
        } else {
            void var8_10;
            Object var8_8 = null;
            try {
                AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset());
            }
            catch (BadLocationException badLocationException) {
                throw new AuthorOperationException("Cannot identify the current element", badLocationException);
            }
            while (var8_10 != null && !(var8_10 instanceof AuthorElement)) {
                AuthorNode authorNode = var8_10.getParent();
            }
            if (!(var8_10 instanceof AuthorElement)) throw new AuthorOperationException("You need to have the carret inside an element.");
            authorElement = (AuthorElement)var8_10;
        }
        String string = ((String)object5).trim();
        String string2 = null;
        if (object6 instanceof String) {
            string2 = ((String)object6).trim();
        }
        if ((object2 = argumentsMap.getArgumentValue(ARGUMENT_REMOVE_IF_EMPTY_VALUE)) == null) {
            object2 = "true";
        }
        if ((object = argumentsMap.getArgumentValue(ARGUMENT_EDIT_ATTRIBUTE)) == null) {
            object = "true";
        }
        boolean bl = "true".equals(object);
        String string3 = CommonsOperationsUtil.setAttributeValue(authorAccess.getDocumentController(), authorElement, new QName(string2, string, ""), (String)object3, "true".equals(object2));
        if (object3 == null || "".equals(object3) && "true".equals(object2) || !bl) return;
        authorAccess.getEditorAccess().editAttribute(authorElement, string3);
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    @Override
    public String getDescription() {
        return "Add/change/remove an attribute of an element.";
    }
}

