/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.dita;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;

@API(type=APIType.INTERNAL, src=SourceType.PRIVATE)
public abstract class ElementSizeInfo {
    public static final String DEFAULT_SIZE_UNIT = "[px]";
    public static final String[] SIZE_UNITS = new String[]{"[px]", "pc", "pt", "px", "in", "cm", "mm", "em"};
    public static final Map<String, String> UNITS_DESCRIPTION = new HashMap<String, String>();
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    protected final Map<String, String> properties = new LinkedHashMap<String, String>();

    public ElementSizeInfo(String string, String string2) {
        this.properties.put(string, string2);
    }

    public ElementSizeInfo(String string, String string2, String string3, String string4) {
        if (string != null && string.length() > 0) {
            if (string2 == null) {
                string2 = "";
            }
            this.properties.put(WIDTH, string + string2);
        }
        if (string3 != null && string3.length() > 0) {
            if (string4 == null) {
                string4 = "";
            }
            this.properties.put(HEIGHT, string3 + string4);
        }
    }

    public String getValue(String string) {
        return this.properties.get(string);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = this.properties.keySet();
        for (String string : set) {
            stringBuilder.append(string).append(": ").append(this.properties.get(string));
        }
        return stringBuilder.toString();
    }

    static {
        UNITS_DESCRIPTION.put(DEFAULT_SIZE_UNIT, "Default (pixels)");
        UNITS_DESCRIPTION.put("pc", "picas");
        UNITS_DESCRIPTION.put("pt", "points");
        UNITS_DESCRIPTION.put("px", "pixels");
        UNITS_DESCRIPTION.put("in", "inches");
        UNITS_DESCRIPTION.put("cm", "centimeters");
        UNITS_DESCRIPTION.put("mm", "millimeters");
        UNITS_DESCRIPTION.put("em", "ems");
    }
}

